#!/usr/bin/python

from setuptools import find_packages
from setuptools import setup

PYTHON_SCRIPTS = [
    'phablet-click-test-setup',
    'phablet-demo-setup',
    'phablet-dev-bootstrap',
    'phablet-flash',
    'phablet-config'
]

SH_SCRIPTS = [
    'bileto',
    'citrain',
    'phablet-network',
    'phablet-screenshot',
    'phablet-test-run',
    'click-buddy',
    'phablet-bootchart',
    'phablet-shell',
]

DATA_FILES = [
    ('/usr/share/phabletutils/', ['shell-adb-common.sh', ]),
]

if __name__ == "__main__":
    setup(
        name='phablet-tools',
        version='0.1',
        description='Scripts to deploy Ubuntu on mobile devices',
        author='Sergio Schvezov',
        author_email='sergio.schvezov@canonical.com',
        license='GPLv3',
        packages=find_packages(exclude=("tests",)),
        scripts=PYTHON_SCRIPTS + SH_SCRIPTS,
        data_files=DATA_FILES,
        test_suite='tests',
    )
