/***********************************************************************************************************************************
Crypto Common
***********************************************************************************************************************************/
#include <openssl/conf.h>
#include <openssl/evp.h>
#include <openssl/err.h>

#include "common/debug.h"
#include "common/log.h"
#include "crypto/crypto.h"

/***********************************************************************************************************************************
Flag to indicate if OpenSSL has already been initialized
***********************************************************************************************************************************/
static bool cryptoInitDone = false;

/***********************************************************************************************************************************
Initialize ciphers
***********************************************************************************************************************************/
void
cryptoInit()
{
    FUNCTION_DEBUG_VOID(logLevelTrace);

    if (!cryptoInitDone)
    {
        ERR_load_crypto_strings();
        OpenSSL_add_all_algorithms();

        cryptoInitDone = true;
    }

    FUNCTION_DEBUG_RESULT_VOID();
}

/***********************************************************************************************************************************
Have the ciphers been initialized?
***********************************************************************************************************************************/
bool
cryptoIsInit()
{
    FUNCTION_TEST_VOID();
    FUNCTION_TEST_RESULT(BOOL, cryptoInitDone);
}
