#
# Copyright (c) 2001-2006 Hewlett-Packard Development Company, L.P.
# Contributed by Stephane Eranian <eranian@hpl.hp.com>
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License as
# published by the Free Software Foundation; either version 2 of the
# License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
# General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA
# 02111-1307 USA
#

#
# This file defines the global compilation settings.
# It is included by every Makefile
#
#
ARCH := $(shell uname -m)
ifeq (i686,$(findstring i686,$(ARCH)))
override ARCH=ia32
endif
ifeq (i586,$(findstring i586,$(ARCH)))
override ARCH=ia32
endif
ifeq (i486,$(findstring i486,$(ARCH)))
override ARCH=ia32
endif
ifeq (i386,$(findstring i386,$(ARCH)))
override ARCH=ia32
endif

#
# Where should things go in the end. This follows GNU conventions of 
# destdir, prefix and the rest
#
install_prefix=/usr/local
PREFIX=$(install_prefix)
BINDIR=$(PREFIX)/bin
MANDIR=$(PREFIX)/share/man
DATADIR=$(PREFIX)/share/pfmon

#
# The root directory where to find the perfmon header files and the library (libpfm-3.0).
# Must be an absolute path.
#
PFMROOTDIR ?=/usr/local
PFMLIBDIR=$(PFMROOTDIR)/lib
PFMINCDIR=$(PFMROOTDIR)/include

# Where to find libelf
# pfmon needs libelf either from the old libelf package or from elfutils-devel
# elfutils-devel has libelf.h in /usr/include, whereas the old libelf has it
# in /usr/include/libelf. To make sure we can compile, we always add the
# include path to /usr/include/libelf. This is extraneous if using elfutils but
# harmless
#
ELFLIBDIR ?= /usr/lib
ELFINCDIR ?= /usr/include/libelf

#
# PMU support for pfmon
#
ifeq ($(ARCH),ia64)
CONFIG_PFMON_GEN_IA64=y
CONFIG_PFMON_ITANIUM=y
CONFIG_PFMON_ITANIUM2=y
CONFIG_PFMON_MONTECITO=y
endif

ifeq ($(ARCH),x86_64)
CONFIG_PFMON_GEN_IA32=y
CONFIG_PFMON_AMD64=y
CONFIG_PFMON_PENTIUM4=y
CONFIG_PFMON_CORE=y
endif

ifeq ($(ARCH),ia32)
CONFIG_PFMON_I386_P6=y
CONFIG_PFMON_GEN_IA32=y
CONFIG_PFMON_AMD64=y
CONFIG_PFMON_PENTIUM4=y
CONFIG_PFMON_CORE=y
endif

ifeq ($(ARCH),mips64)
CONFIG_PFMON_GEN_MIPS64=y
endif

#
# pfmon debugging option
# 
# CONFIG_PFMON_DEBUG: enables extraneous debug print
# CONFIG_PFMON_LIBUNWIND: if you have libunwind installed, 
# then you can enable this option for call stack on segv
# CONFIG_PFMON_DEMANGLE: to enable C++/Java symbol demangling
# with --resolve-address option (you need libiberty)
#
CONFIG_PFMON_DEBUG=y
CONFIG_PFMON_DEMANGLE=y

#ifeq ($(ARCH),ia64)
#CONFIG_PFMON_LIBUNWIND=y
#else
#CONFIG_PFMON_LIBUNWIND=n
#endif

#
# optimization settings
#
OPTIM= -O2

#
# linker specific flags
#
# Caution: linking static will cause warnings in pfmon_conf.c due
# to the use of getpwuid() which requires pam; a dynamically loaded library.
# This should work as long as the program is run on the system it was compiled
# from or on a system with the same dynamic loader version
#
# 
#LDFLAGS=-static

#
# you shouldn't have to touch anything beyond this point
#

#
# The entire package can be compiled using 
# the Intel Itanium Compiler
#
#CC=icc -Wall
CC=gcc
PFMINCDIR=$(PFMROOTDIR)/include
PFMLIBDIR=$(PFMROOTDIR)/lib
DBG=-g -Wall -Werror
CFLAGS=$(OPTIM) $(DBG) -D_REENTRANT -I$(PFMINCDIR)
MKDEP=makedepend
LIBS=
INSTALL=install

ifeq ($(ARCH),ia64)
CFLAGS += -DCONFIG_PFMON_IA64
endif

ifeq ($(ARCH),x86_64)
CFLAGS += -DCONFIG_PFMON_AMD_X86_64
endif

ifeq ($(CONFIG_PFMON_DEBUG),y)
CFLAGS += -DPFMON_DEBUG
endif
