#
# Copyright (c) 2001-2006 Hewlett-Packard Development Company, L.P.
# Contributed by Stephane Eranian <eranian@hpl.hp.com>
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License as
# published by the Free Software Foundation; either version 2 of the
# License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
# General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA
# 02111-1307 USA
#

#
# This file defines the global compilation settings.
# It is included by every Makefile
#
#
ARCH     = $(shell uname -m | sed s,i[3456789]86,ia32,)

#
# Where should things go in the end. the package will put things in lib and
# bin under this base.
#
# DESTDIR : the root directory used to install the binaries into
# DESTROOT: the root directory once package is installed
#
# Both directories are different when source is built for inclusion into
# a package because typically a fake root is used
#
DESTDIR=/usr/local
DESTROOT=/usr/local

#
# The root directory where to find the perfmon header files and the library (libpfm-3.0).
# Must be an absolute path.
#
# pfmon will look into $(PFMROOTDIR)/include and $(PFMROOTDIR)/lib
#
#PFMROOTDIR=/home/eranian/nueh/libpfm-3.2
PFMROOTDIR=/usr/local

#
# PMU support for pfmon
#
ifeq ($(ARCH),ia64)
CONFIG_PFMON_GEN_IA64=y
CONFIG_PFMON_ITANIUM=y
CONFIG_PFMON_ITANIUM2=y
CONFIG_PFMON_MONTECITO=y
endif

ifeq ($(ARCH),x86_64)
CONFIG_PFMON_AMD_X86_64=y
endif

ifeq ($(ARCH),ia32)
CONFIG_PFMON_I386_P6=y
CONFIG_PFMON_GEN_IA32=y
CONFIG_PFMON_AMD_X86_64=y
endif

#
# pfmon debugging option
# 
# CONFIG_PFMON_DEBUG: enables extraneous debug print
# CONFIG_PFMON_LIBUNWIND: if you have libunwind installed, 
# then you can enable this option for call stack on segv
# CONFIG_PFMON_DEMANGLE: to enable C++/Java symbol demangling
# with --resolve-address option (you need libiberty)
#
CONFIG_PFMON_DEBUG=y
CONFIG_PFMON_DEMANGLE=y

ifeq ($(ARCH),ia64)
CONFIG_PFMON_LIBUNWIND=y
else
CONFIG_PFMON_LIBUNWIND=n
endif

#
# optimization settings
#
OPTIM= -O2

#
# linker specific flags
#
# Caution: linking static will cause warnings in pfmon_conf.c due
# to the use of getpwuid() which requires pam; a dynamically loaded library.
# This should work as long as the program is run on the system it was compiled
# from or on a system with the same dynamic loader version
#
# 
LDFLAGS=-static

#
# you shouldn't have to touch anything beyond this point
#

#
# The entire package can be compiled using 
# ecc the Intel Itanium Compiler (beta 6.0)
#
#CC=icc -Wall
CC=gcc -Wall -Werror

CFLAGS=$(OPTIM) -g  -D_REENTRANT
MKDEP=makedepend

LIBS=
INSTALL=install

PFMINCDIR=$(PFMROOTDIR)/include
PFMLIBDIR=$(PFMROOTDIR)/lib

ifeq ($(ARCH),ia64)
CFLAGS += -DCONFIG_PFMON_IA64
endif

ifeq ($(ARCH),x86_64)
CFLAGS += -DCONFIG_PFMON_AMD_X86_64
endif

ifeq ($(CONFIG_PFMON_DEBUG),y)
CFLAGS += -DPFMON_DEBUG
endif
