/*
   Copyright (C) 2003, 2005, 2006 MySQL AB
    All rights reserved. Use is subject to license terms.

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; version 2 of the License.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301  USA
*/

#ifndef TUX_SIZE_ALT_REQ_H
#define TUX_SIZE_ALT_REQ_H

#include "SignalData.hpp"

class TuxSizeAltReq  {
  /**
   * Sender(s)
   */
  friend class ClusterConfiguration;

  /**
   * Receiver(s)
   */
  friend class Dbtux;
private:
  /**
   * Indexes in theData
   */
  STATIC_CONST( IND_BLOCK_REF           = 0 );
  STATIC_CONST( IND_INDEX               = 1 );
  STATIC_CONST( IND_FRAGMENT            = 2 );
  STATIC_CONST( IND_ATTRIBUTE           = 3 );
  STATIC_CONST( IND_SCAN                = 4 );

  /**
   * Use the index definitions to use the signal data
   */
  UintR theData[4];
};

#endif
