#!/usr/bin/env python
# Written by Owen Williams
# using pieces from Straw
# see LICENSE for license information

import urlparse
import threading
from threading import RLock
import sys,os, os.path
import urllib
import time
import random

import gtk
import gnome.ui
import gtk.glade
import gobject
import pango
#import gtkmozembed
import gtkhtml2
import pycurl
import gettext
import gconf

import ptvDB
import MediaManager
import Player
import SimpleImageCache
import UpdateTasksManager
import utils

import AddFeedDialog
import PreferencesDialog
import RenameFeedDialog


#_DEBUG=0
CANCEL=0
PAUSE=1

GUI = UpdateTasksManager.GUI
DB = UpdateTasksManager.DB

ALL=0
UNVIEWED=1
UNVIEWED_TEXT=2
DOWNLOADED=3
NONE=4

download_errors={}

gettext.install('penguintv', '/usr/share/locale', unicode=1)

class FeedList:
	def __init__(self, widget_tree, app, db):
		self.scrolled_window = widget_tree.get_widget('scrolledwindow2')
		self.va = self.scrolled_window.get_vadjustment()
		self._widget = widget_tree.get_widget('feedlistview')
		self.entry_list_widget = widget_tree.get_widget('entrylistview')
		self._app = app
		self.feedlist = gtk.ListStore(str, str, int, int, str, str, int, bool) #title, markuptitle, feed_id, index, stock_id, readinfo, flag, visible
		self.feed_filter = self.feedlist.filter_new()
		self.feed_filter.set_visible_column(7)
		self.db = db
		self.last_selected=None
		self.last_feed=None
		self.filter_setting=ALL
		self.selecting_misfiltered=False
		
		#build list view
		self._widget.set_model(self.feed_filter)
		renderer = gtk.CellRendererText()
		icon_renderer = gtk.CellRendererPixbuf()
		self.feed_column = gtk.TreeViewColumn('Feeds')
		self.feed_column.set_resizable(True)
		self.feed_column.pack_start(icon_renderer, False)
		self.feed_column.pack_start(renderer, True)
		self.feed_column.set_attributes(renderer, markup=1)
		self.feed_column.set_attributes(icon_renderer, stock_id=4)
		self._widget.append_column(self.feed_column)
			
		renderer = gtk.CellRendererText()
		column = gtk.TreeViewColumn('Articles')
		column.set_resizable(True)
		column.pack_start(renderer, True)
		column.set_attributes(renderer, markup=5)		
		self._widget.append_column(column)
		
		#renderer = gtk.CellRendererText()
		#column = gtk.TreeViewColumn('Downloaded')
		#column.set_resizable(True)
		#column.pack_start(renderer, True)
		#column.set_attributes(renderer, markup=4)		
		#self._widget.append_column(column)
		
		self._widget.columns_autosize()
		
		#signals
		self._widget.get_selection().connect("changed", self.item_selection_changed)
			
	#def get_column_width(self):
	#	return self.feed_column.get_width()
		
	def resize_columns(self):
		self._widget.columns_autosize()
		
	#def set_column_width(self, width):
		#self.feed_column.set_property('width',width)  #not allowed!
		#this doesn't work
	#	self.feed_column.set_min_width(width)
#		self.feed_column.set_max_width(width)
#		self.feed_column.set_min_width(-1)
	#	self.feed_column.set_min_width(-1)
		
	def set_filter(self, new_filter):
		self.filter_setting = new_filter
		self.do_filter()
	
	def do_filter(self,index=-1):
		if index == -1:
			selected,index = self.get_selected()	
			
		i=-1
		for feed in self.feedlist:
			i=i+1
			flag = feed[6]
			passed_filter = False
			if self.filter_setting == NONE:
				pass
			elif self.filter_setting == UNVIEWED:
				if flag & ptvDB.F_UNVIEWED == ptvDB.F_UNVIEWED:
					passed_filter = True
			elif self.filter_setting == UNVIEWED_TEXT:
				if flag & ptvDB.F_UNVIEWED == ptvDB.F_UNVIEWED and flag & ptvDB.F_MEDIA == 0:
					passed_filter = True
			elif self.filter_setting == DOWNLOADED:
				if flag & ptvDB.F_DOWNLOADED == ptvDB.F_DOWNLOADED:
					passed_filter = True
			else:
				passed_filter = True
			if passed_filter == False and i == index and self.filter_setting != NONE:  #if this is the selected feed, we have to add it, but note that it should go away ASAP  # except with NONE
				passed_filter = True
				self.selecting_misfiltered=True		
			feed[7] = passed_filter

		if self.filter_setting == NONE:
			self._app.display_feed(-1)
			self.last_selected = None
			self.selecting_misfiltered=False
		self.feed_filter.refilter()
			
	def populate_feeds(self):
		db_feedlist = self.db.get_feedlist()
		selection = self._widget.get_selection()
		selected,index = self.get_selected()
		self.feedlist.clear()
		
		i=-1
		downloaded=0
				
		for feed_id,title in db_feedlist:
			i=i+1
			unviewed=0
			entrylist = self.db.get_entrylist(feed_id)
			unviewed = self.db.get_unread_count(feed_id)
			flag = self.db.get_important_flag(feed_id)
			m_title = self.get_markedup_title(title,flag) 
			m_readinfo = self.get_markedup_title("("+str(unviewed)+"/"+str(len(entrylist))+")", flag)
			icon = self.get_icon(flag)			
			self.feedlist.append([title, m_title, feed_id, i, icon, m_readinfo, flag, True]) #assume visible
		
		
		if selected:
			index = self.find_index_of_item(selected)
			#print "selecting: "+str(index)
			selection.select_path((index,))
			if index<0:
				self.va.set_value(self.va.lower)
			#	selection.select_path((0,))
		self.do_filter(index)		
			
		return False #in case this was called by the timeout below
		
	def get_icon(self, flag):
		if flag & ptvDB.F_ERROR == ptvDB.F_ERROR:
			return 'gtk-dialog-error'
		if flag & ptvDB.F_DOWNLOADING == ptvDB.F_DOWNLOADING:
			return 'gtk-execute'
		if flag & ptvDB.F_DOWNLOADED == ptvDB.F_DOWNLOADED:
			return 'gtk-harddisk'
		else:
			return 'gnome-stock-blank'
	
	def get_markedup_title(self, title, flag):
		if not title:
			return "Please wait..."
		if flag & ptvDB.F_UNVIEWED == ptvDB.F_UNVIEWED:
				title="<b>"+utils.my_quote(title)+"</b>"
		return title
		
	def update_feed_list(self, feed_id=None):  #returns True if this is the already-displayed feed
		#print "updating feed: "+str(feed_id)
		if feed_id is None:
			if self.last_feed is None:
				return
			feed_id = self.last_feed
		updated=0
		unviewed=0
		downloaded=0
	 	for feed in self.feedlist:
	 		if feed[2] == feed_id:
	 			updated=1
				entrylist = self.db.get_entrylist(feed_id)
				if entrylist:
					for entry in entrylist:
						flag = self.db.get_entry_flags(entry[0])
						if flag & ptvDB.F_UNVIEWED == ptvDB.F_UNVIEWED:
							unviewed=unviewed+1
						if flag & ptvDB.F_DOWNLOADED == ptvDB.F_DOWNLOADED:
							downloaded=1
	 			flag = self.pick_important_flag(feed_id)
	 			feed[1] = self.get_markedup_title(feed[0],flag)
	 			feed[5] = self.get_markedup_title("("+str(unviewed)+"/"+str(len(entrylist))+")",flag)
	 			feed[4] = self.get_icon(flag)
	 			feed[6] = flag	 			
	 	#print "updated: "+str(updated)+" filter: "+str(self.filter_setting)+" unviewed: "+str(unviewed)+" downloaded: "+str(downloaded)
	 	if self.filter_setting == UNVIEWED or self.filter_setting == UNVIEWED_TEXT:
	 		if updated==1 and unviewed==0:
				self.do_filter()
	 	if self.filter_setting == DOWNLOADED:
	 		if updated==1 and downloaded==0:
		 		self.do_filter()
# we know always repopulate since it's faster
		if feed_id == self.last_feed:
			return True
		
	def pick_important_flag(self, feed_id):
		"""go through entries and pull out most important flag"""
		entries = self.db.get_entrylist(feed_id)
		entry_count = len(entries)
		important_flag = 0
		media_exists = 0
		flag_list = []
		for entry in entries:
			try:
				flag = self.db.get_entry_flags(entry[0])
				if flag & ptvDB.F_DOWNLOADED == ptvDB.F_DOWNLOADED:
					media_exists=1
			except:
				flag = 0
			flag_list.append(flag)
		if len(flag_list)==0:
			return 0
		flag_list.sort()
		best_flag = flag_list[-1]
		if best_flag & ptvDB.F_DOWNLOADED == 0 and media_exists==1: #if there is an unread text-only entry, but all viewed media,
																													#we need a special case (mixing flags from different entries)
			return best_flag + ptvDB.F_DOWNLOADED
		else:
			return best_flag
			
	def item_selection_changed(self, selection):
		item,index = self.get_selected(selection)
		#print item
		self.last_feed=item
		if item:
			if index == self.last_selected:
				self._app.display_feed(item)
			else:
				self.last_selected = index
				self._app.display_feed(item, -2)
				if self.selecting_misfiltered == True and item!=None:
					self.selecting_misfiltered = False
					gobject.timeout_add(250, self.populate_feeds) #update in just a bit so people can see the change
		
			
	def get_selected(self, selection=None):
		if selection==None:
			s = self._widget.get_selection().get_selected()
		else:
			s = selection.get_selected()
		if s:
			model, iter = s
			if iter is None:
				return (None,0)
			path = model.get_path(iter)
			index = path[0]
			return (model[index][2],model[index][3])
		else:
			return (None,0)
			
	def find_index_of_item(self, feed_id):
		i=0
		for feed in self.feedlist:
			if feed[2] == feed_id:
				return i
			i=i+1
		return -1

			
class EntryList:
	def __init__(self, widget, app, db):
		self._widget = widget
		self._app = app
		self.entrylist = gtk.ListStore(str, str, int, int, str) #title, markeduptitle, entry_id, index, icon
		self.db = db
		self.feed_id=None
		self.last_entry=None
		
		#build list view
		self._widget.set_model(self.entrylist)
		icon_renderer = gtk.CellRendererPixbuf()
		renderer = gtk.CellRendererText()
		column = gtk.TreeViewColumn('Entries')
		column.pack_start(icon_renderer, False)
		column.pack_start(renderer, True)
		column.set_attributes(icon_renderer, stock_id=4)
		column.set_attributes(renderer, markup=1)
		self._widget.columns_autosize()
		self._widget.append_column(column)
		
		#signals
		self._widget.get_selection().connect("changed", self.item_selection_changed)
		#future self._widget.connect("row-activated", self.on_row_activated)
		
	def populate_entries(self, args):#feed_id, index=-1):
		feed_id = args[0]
		index = args[1]
		self.feed_id = feed_id
		db_entrylist = self.db.get_entrylist(feed_id)
		selection = self._widget.get_selection()
		if index==-1:
			#print "saving current selection"
			selected,index = self.get_selected()
		self.entrylist.clear()
		
		i=-1
		for entry_id,title,date,new in db_entrylist:
			i=i+1	
			flag = self.db.get_entry_flags(entry_id)
			icon = self.get_icon(flag)
			markeduptitle = self.get_markedup_title(title, flag)
			self.entrylist.append([title, markeduptitle, entry_id, i, icon])
		if index>=0:
			selection.select_path((self.find_index_of_item(selected),))
		self._widget.columns_autosize()
		
	def get_icon(self, flag):
		#print "flag: "+str(flag)
		if flag & ptvDB.F_ERROR == ptvDB.F_ERROR:
			return 'gtk-dialog-error'
		if flag & ptvDB.F_DOWNLOADING == ptvDB.F_DOWNLOADING:
			return 'gtk-execute'
		if flag & ptvDB.F_DOWNLOADED == ptvDB.F_DOWNLOADED:
			return 'gtk-harddisk'
		else:
			return 'gnome-stock-blank'
	
	def get_markedup_title(self, title, flag):
		#if entry_id==407:
		#print "INTERESTING:" +title+" "+str(flag)
		#if flag & ptvDB.F_ERROR == ptvDB.F_ERROR:
		#	title="<b><i>"+title+"</i></b>"
		#	return title
		#if flag & ptvDB.F_DOWNLOADING == ptvDB.F_DOWNLOADING:
		#	title="<i>"+title+"</i>"
		if flag & ptvDB.F_UNVIEWED == ptvDB.F_UNVIEWED:
			title="<b>"+title+"</b>"
		if flag & ptvDB.F_MEDIA == ptvDB.F_MEDIA:
			title="<span color='Blue'>"+title+"</span>"
		#print "title: "+title
		return title
		
	def update_entry_list(self, entry_id=None):
		if entry_id is None:
			if self.last_entry is None:
				return
			entry_id = self.last_entry
		for entry in self.entrylist:
			if entry[2] == entry_id:
				flag = self.db.get_entry_flags(entry_id)
	 			entry[1] = self.get_markedup_title(entry[0],flag)
	 			entry[4] = self.get_icon(flag) 
	 	#always update the selected entry, just in case
	 	#this means the app updates the feeds and entries, but the 
	 	#entry list knows best when it comes to entries
		selection = self._widget.get_selection()
		selected,index = self.get_selected(selection)
		if selected:
			self._app.display_entry(selected, 0) #don't change read-state on this display, so if someone just marked this unread, it won't change right back 
		if entry_id == self.last_entry:
			return True
			
	def item_selection_changed(self, selection):
		selected,index = self.get_selected(selection) #then do something with it
		self.last_entry = selected
		#print "selected item: "+str(selected) #CONVENIENT
		if selected:
			self._app.display_entry(selected)
		else:
			self._app.display_entry(None)
			
	def get_selected(self, selection=None):
		if selection==None:
			s = self._widget.get_selection().get_selected()
		else:	
			s = selection.get_selected()
		if s:
			model, iter = s
			if iter is None:
				return (None,0)
			path = model.get_path(iter)
			index = path[0]
			return (model[index][2],model[index][3])
		else:
			return (None,0)
			
	def clear_entries(self):
		self.entrylist.clear()
		
	def find_index_of_item(self, entry_id):
		i=0
		for entry in self.entrylist:
			if entry[2] == entry_id:
				return i
			i=i+1
		return -1
		
class ItemView:
	def __init__(self, widget_tree, app):
		self._app = app
		scrolled_window = widget_tree.get_widget('html_scrolled_window')
		##G##
		htmlview = gtkhtml2.View()
		self._document = gtkhtml2.Document()
		self._document.connect("link-clicked", self.link_clicked)
		htmlview.connect("on_url", self.on_url)
		self._document.connect("request-url", self.request_url)
		htmlview.get_vadjustment().set_value(0)
		htmlview.get_hadjustment().set_value(0)
		scrolled_window.set_hadjustment(htmlview.get_hadjustment())
		scrolled_window.set_vadjustment(htmlview.get_vadjustment())
		self._document.clear()
		htmlview.set_document(self._document)
		scrolled_window.add(htmlview)
		self._htmlview = htmlview
		##GG##
		##M##
		#self.moz = gtkmozembed.MozEmbed()
		#self.moz.connect("open-uri", self.moz_link_clicked)
		#self.moz.load_url("about:blank")
		#self.moz.get_location()
		#scrolled_window.add_with_viewport(self.moz)
		##M##
		scrolled_window.show_all()
		self._scrolled_window = scrolled_window
		
		self.current_entry={}
		self.currently_blank=False
		self.current_scroll_v = scrolled_window.get_vadjustment().get_value()
		self.current_scroll_h = scrolled_window.get_hadjustment().get_value()
		self.updater_timer=0
		self.image_cache = SimpleImageCache.SimpleImageCache()
		
	def on_url(self, view, url):
		if url == None:
			url = ""
		#if len(url):
		#    url = straw.main.get_visible_feed().complete_url(url)
		#straw.main_window.display_status_message(url)
		self._app.display_status_message(url)
		return

	def link_clicked(self, document, link):
		link = link.strip()
		self._app.activate_link(link)
        #link = straw.main.get_visible_feed().complete_url(link)
        #gnome.url_show(link)
		return
		
	def moz_link_clicked(self, mozembed, uri):
		#WAIT:  gtkmozembed is returning the wrong type -- coming out as a pointer, should be string
		#wait for fixes
		print str(uri)
		#link = link.strip()
		#self._app.activate_link(link)
        #link = straw.main.get_visible_feed().complete_url(link)
        #gnome.url_show(link)
		return True

	def request_url(self, document, url, stream):
		try:
			self._app.set_wait_cursor(True)
			#self.image_cache.get_image(self.current_entry['entry_id'], url, stream)
			stream.write(self.image_cache.get_image(url))
			stream.close()
			self._app.set_wait_cursor(False)
		except Exception, ex:
			self._app.set_wait_cursor(False)
			stream.close()
			raise
	
	def update_progress(self, args):#(item, progress)):
		item,progress,message=args
		try:
			if len(self.current_entry) ==0:
				return
		except:
			return
		if item['entry_id'] != self.current_entry['entry_id'] or self.currently_blank==True:
			#print "update_progress: not current item"
			return
			
		for medium in self.current_entry['media']:
			if medium['media_id'] == item['media_id']:
				medium['progress']=progress
				medium['progress_message']=message
		if self.updater_timer==0:
			#print "setting up timer"
			self.updater_timer=1
			self.updater_entry_id = item['entry_id']
			gobject.timeout_add(2000, self.update_display)
    		
	def update_display(self):
		try:
			if self.updater_entry_id != self.current_entry['entry_id'] or self.currently_blank == True:
				#print "changed items, cancelling timer (by returning false)"
				self.updater_timer=0
				self.updater_entry_id=-1
				return False
		except:
			self.updater_timer=0
			return False
		for medium in self.current_entry['media']:
			if medium.has_key('download_status'):
				if medium['download_status']==1:
					try:							
						if medium['progress']>=100:
							self.updater_timer=0
							self.updater_entry_id=-1
							continue
					except:
						continue	
					#if anything is not 100% and is downloading, we redraw and return
					self.display_item(self.current_entry)
					return True
		#nothing was < 100% and downloading
		self.updater_timer=0
		self.updater_entry_id=-1
		return False
		
	def get_scroll_vals(self):
		return (va.get_value(), ha.get_value())
		
	def set_scroll_vals(self, info):
		va.set_value(info[0])
		ha.get_value(info[1])
			  		
	def display_item(self, item=None):
		va = self._scrolled_window.get_vadjustment()
		ha = self._scrolled_window.get_hadjustment()
		rescroll=0
		
		#when a feed is refreshed, the item selection changes from an entry,
		#to blank, and to the entry again.  We used to lose scroll position because of this.
		#Now, scroll position is saved when a blank entry is displayed, and if the next
		#entry is the same id as before the blank, we restore those old values.
		#we have a bool to figure out if the current page is blank, in which case we shouldn't
		#save its scroll values.
		if item:
			try:
				if item['entry_id'] == self.current_entry['entry_id']:
					if self.currently_blank == False:
						self.current_scroll_v = va.get_value()
						self.current_scroll_h = ha.get_value()
					rescroll=1
			except:
				pass
			#elif len(self.current_entry)!=0:
			#	self.image_cache.quit_entry(self.current_entry['entry_id'])
			#	self._document.close_stream()
			self.current_entry = item	
			self.currently_blank = False
		else:
			self.currently_blank = True
			self.current_scroll_v = va.get_value()
			self.current_scroll_h = ha.get_value()	
		
		##G##
		self._document.clear()
		self._document.open_stream("text/html")
		##/G##
		##M##
		#self.moz.open_stream("http://ywwg.com","text/html")
		##/M##
		enc = None
		#FIXME: how to get gnome defaul font styles for moz?
		if item is not None:
			html = (
            """<html><head>
            <meta http-equiv="Content-Type" content="text/html; charset=utf-8">
            <style type="text/css">
            q { font-style: italic;}
            blockquote { display: block; font-style: italic; }
            .stitle {background-color:transparent;font-size:small;font-weight:bold;}
            .sdate {font-size:small}
            .content {padding-left:10px;margin-top:10px;}
            .media {background-color:#EEEEEE; border-color:#000000; border-width:2px; border-style: solid; padding:5px; margin:5px; }
            </style>
            <title>title</title></head><body>""" +
                self.htmlify_item(item) +
                "</body></html>")
		else:
			#html="""<html><body background="http://mit.edu/sts/images/zakim-web.gif"></body></html>"""
			html="""<html><body></body></html>"""
		
		html = html.encode('utf-8')
		##G##
		self._document.write_stream(html)
		self._document.close_stream()
		##/G##
		##M##
		#self.moz.append_data(html, long(len(html)))
		#self.moz.close_stream()
		##/M##
		
		if rescroll==1:
			va.set_value(self.current_scroll_v)
			ha.set_value(self.current_scroll_h)
			#self.current_scroll_v=-1
			#self.current_scroll_h=-1
		else:
			va.set_value(va.lower)
			ha.set_value(ha.lower)
        #if item.source is not None:
        #    self._source_name_label.set_text(item.source['text'])
        #    self._source_url_label.set_text(item.source['url'])
        #    self._source_display_frame.show()
        #else:
        #    self._source_display_frame.hide()
#		print "new current entry is: "+str(self.current_entry)
		return

	def display_empty_feed(self):#, feed):
		self._document.clear()
		self._document.open_stream("text/html")
		self._document.write_stream("<html></html>")
		self._document.close_stream()
		self.scrolled_window.hide()
		return

	def htmlify_item(self, item):
		ret = []
		if item.has_key('title'):
			ret.append('<div class="stitle">%s</div>' % item['title'])
		if item.has_key('creator'):
			if item['creator']!="":
				ret.append('<p>By %s</p>' % (item['creator'],))			
       # if item.pub_date is not None:
       #     ret.append('<div class="sdate">%s</div>' %
       #     str(item.pub_date.localtime().strftime('%a, %d %b %H:%M:%S')))
		
		if item.has_key('media'):
			ret.append('<div class="media">')
			for medium in item['media']:
				if medium['download_status']==0:     #not downloaded
					ret.append('<p><a href="download:%s">Download</a> <a href="downloadqueue:%s">Download And Play</a> (%s)</p>' % (medium['media_id'],medium['media_id'],utils.format_size(medium['size'])))
				elif medium['download_status'] == 1: #downloading
					if medium.has_key('progress_message'): #downloading and we have a custom message
						ret.append('<p><i>%s</i> <a href="cancel:%s">Stop</a> <a href="Pause:%s">Pause</a></p>' % (medium['progress_message'], medium['media_id'], medium['media_id']))
					elif medium.has_key('progress'):       #no custom message, but we have a progress value
						ret.append('<p><i>Downloading %d%% of %s...</i> <a href="cancel:%s">Stop</a> <a href="Pause:%s">Pause</a></p>' % (medium['progress'], utils.format_size(medium['size']), medium['media_id'], medium['media_id']))
					else:                                  #no progress value to report
						ret.append('<p><i>Downloading %s...</i> <a href="cancel:%s">Stop</a> <a href="Pause:%s">Pause</a></p>' % (utils.format_size(medium['size']), medium['media_id'], medium['media_id']))
				elif medium['download_status'] == 2: #downloaded
					filename = medium['file'][medium['file'].rfind("/")+1:]

					if utils.is_known_media(medium['file']):
						if os.path.isdir(medium['file']) and medium['file'][-1]!='/':
							medium['file']=medium['file']+'/'
						ret.append('<p><a href="play:%s">Play</a> <a href="download:%s">Re-Download</a> <a href="delete:%s">Delete</a> <br/>(<a href="reveal://%s">%s</a>: %s)</p>' % (medium['media_id'], medium['media_id'], medium['media_id'], medium['file'],filename,utils.format_size(medium['size'])))
					elif os.path.isdir(medium['file']):
						ret.append('<p><a href="file://%s">Open Folder</a> <a href="download:%s">Re-Download</a> <a href="delete:%s">Delete</a></p>' % (medium['file'], medium['media_id'], medium['media_id']))
					else:
						ret.append('<p><a href="file://%s">Open File</a> <a href="download:%s">Re-Download</a> <a href="delete:%s">Delete</a> <br/> (<a href="reveal://%s">%s</a>: %s)</p>' % (medium['file'], medium['media_id'], medium['media_id'], medium['file'], filename, utils.format_size(medium['size'])))
				elif medium['download_status'] == 3: #resumable
					ret.append('<p><a href="resume:%s">Resume</a> <a href="download:%s">Re-Download</a> <a href="delete:%s">Delete</a>(%s)</p>' % (medium['media_id'],medium['media_id'],medium['media_id'],utils.format_size(medium['size'])))	
				elif medium['download_status'] == -1: #error
					print "errors: "+str(download_errors)
					if download_errors.has_key(medium['media_id']):
						error_msg = download_errors[medium['media_id']]
					else:
						error_msg = "There was an error downloading the file."
					ret.append('<p>%s: %s  <a href="download:%s">Retry</a> <a href="resume:%s">Try Resume</a> <a href="clear:%s">Cancel</a>(%s)</p>' % (medium['url'][medium['url'].rfind('/')+1:], error_msg, medium['media_id'],medium['media_id'],medium['media_id'],utils.format_size(medium['size'])))
			ret.append('</div>')
		ret.append('<div class="content">')
		if item.has_key('description'):
			ret.append('<br/>%s ' % item['description'])
		ret.append('</div>')
		
	#	        except:
#		        	print "trouble creating entry"
		
       # if item.fm_license is not None:
       #     ret.append('<p>%s: %s</p>' % (_("Software license"),
       #                                   item.fm_license))
       # if item.fm_changes is not None:
       #     ret.append('<p>%s: %s</p>' % (_("Changes"), item.fm_changes))
       # ret.append("<p>")
       # if item.license_urls is not None:
       #     for l in item.license_urls:
       #         ret.append('<a href="%s">%s</a> ' % (l, _("License")))
       # ret.append('</p><p>')
       # if item.publication_name is not None:
       #     ret.append('%s: %s ' % (_("Publication"),
       #                             item.publication_name))
       #     if item.publication_volume is not None:
       #         ret.append('%s' % item.publication_volume)
       #         if item.publication_number is not None:
       #             ret.append('(%s)' % item.publication_number)
       #     if item.publication_section is not None:
       #         ret.append(' %s' % item.publication_section)
       #     if item.publication_starting_page is not None:
       #         ret.append(', %s %s' % (_("Page"),
       #                                 item.publication_starting_page))
       #     ret.append('</p><p>')
		if item.has_key('link'):
			ret.append('<br/><a href="%s">Full Entry...</a><br />' % item['link'])
       # if item.guid is not None and is_url(item.guid):
       #     ret.append('<a href="%s">%s &gt;&gt;</a>' %
       #                (item.guid, _("Permanent link")))
		ret.append('</p>')
		return "".join(ret)

	def scroll_down(self):
		va = self._scrolled_window.get_vadjustment()
		old_value = va.get_value()
		new_value = old_value + va.page_increment
		limit = va.upper - va.page_size
		if new_value > limit:
			new_value = limit
		va.set_value(new_value)
		return new_value > old_value
		

class PenguinTVApp:
	COLUMN_TITLE = 0
	COLUMN_ITEM = 1
	COLUMN_BOLD = 2
	COLUMN_STICKY_FLAG = 3

	def __init__(self):
		#if _DEBUG:
		#	self.glade_prefix="/home/owen/src/penguintv/glade"
		#else:
		try:
			self.glade_prefix = utils.GetPrefix()+"/share/penguintv"
			os.stat(self.glade_prefix+"/penguintv.glade")
		except:
			try:
				self.glade_prefix = utils.GetPrefix()+"/share"
				os.stat(self.glade_prefix+"/penguintv.glade")
			except:
				print "error finding glade file."
				sys.exit()
		self.widgetTree   = None
		self.db = ptvDB.ptvDB(self._polling_callback)
		self.firstrun = self.db.maybe_initialize_db()
		self.mediamanager = MediaManager.MediaManager(self._progress_callback, self._finished_callback)
		self.player = Player.Player()
	 	self._status_messages = []
		self._updater_db = None
		self.download_task_ops=[]
		self.db.clean_media_status()
		self.poll_tasks=0
		self.polling_frequency=12*60*60*1000
		self.bt_settings = {}
		self.exiting=0
		
		self.updater = UpdateTasksManager.UpdateTasksManager()
		self._db_updater = self.DBUpdaterThread(self.updater, self._polling_callback)
		self._db_updater.start()
		self.updater_thread_db = None
		while self.updater_thread_db==None:
			#this may race, so be patient 
			self.updater_thread_db = self._db_updater.get_db()
			time.sleep(.1)
			
	def set_wait_cursor(self, wait=True):
		if wait:
			c = gtk.gdk.Cursor(gtk.gdk.WATCH)
			self.app_window.window.set_cursor(c)
		else:
			self.app_window.window.set_cursor(None)
		
		
	def Show(self):
		self.widgetTree = gtk.glade.XML(self.glade_prefix+'/penguintv.glade', "app1") #MAGIC
		self._feed_list_view = FeedList(self.widgetTree,self, self.db)
		self._entry_list_view = EntryList(self.widgetTree.get_widget('entrylistview'),self, self.db)
		self._entry_view = ItemView(self.widgetTree, self)
		for key in dir(self.__class__): #python insaneness
			if key[:3] == 'on_':
				self.widgetTree.signal_connect(key, getattr(self, key))
				
		#some widgets
		self.feed_pane = self.widgetTree.get_widget('feed_pane')
		self.feedlist = self.widgetTree.get_widget('feedlistview')
		self.entry_pane = self.widgetTree.get_widget('entry_pane')
		self.app_window = self.widgetTree.get_widget('app1')
		try:
			self.app_window.set_icon_from_file(utils.GetPrefix()+"/share/pixmaps/penguintvicon.png")
		except:
			self.app_window.set_icon_from_file(utils.GetPrefix()+"/share/penguintvicon.png") #in case the install is still in the source dirs
		self._status_view = self.widgetTree.get_widget("appbar")
		self.disk_usage_widget = self.widgetTree.get_widget('disk_usage')
		self.filter_combo_widget = self.widgetTree.get_widget('filter_combo')
		self.filter_combo_widget.set_active(ALL)		
		#set up separator between toolbar buttons and free space indicator
		vseparator = self.widgetTree.get_widget('vseparator1')
		vseparator_toolitem = self.widgetTree.get_widget('toolitem1')
		vseparator_toolitem.set_expand(True)
		vseparator.set_draw(False)
			
		
		
		#windows
		self.window_add_feed = AddFeedDialog.AddFeedDialog(gtk.glade.XML(self.glade_prefix+'/penguintv.glade', "window_add_feed"),self) #MAGIC
		self.window_add_feed.hide()
		self.window_preferences = PreferencesDialog.PreferencesDialog(gtk.glade.XML(self.glade_prefix+'/penguintv.glade', "window_preferences"),self) #MAGIC
		self.window_preferences.hide()
		self.window_rename_feed = RenameFeedDialog.RenameFeedDialog(gtk.glade.XML(self.glade_prefix+'/penguintv.glade', "window_rename_feed"),self) #MAGIC
		self.window_rename_feed.hide()
		self.about_box_widgets = gtk.glade.XML(self.glade_prefix+'/penguintv.glade', "aboutdialog1")
		self.about_box = self.about_box_widgets.get_widget('aboutdialog1')
		try:
			self.about_box.set_version(utils.VERSION)
		except:
			pass #fc3 workaround (doesn't have aboutbox class)
		self.about_box.hide()
		
		#gconf
		self.conf =  gconf.client_get_default()
		self.conf.add_dir('/apps/penguintv',gconf.CLIENT_PRELOAD_NONE)
		self.conf.notify_add('/apps/penguintv/auto_resume',self.set_auto_resume)
		self.conf.notify_add('/apps/penguintv/bt_max_port',self.set_bt_maxport)
		self.conf.notify_add('/apps/penguintv/bt_min_port',self.set_bt_minport)
		self.conf.notify_add('/apps/penguintv/ul_limit',self.set_bt_ullimit)
		self.conf.notify_add('/apps/penguintv/feed_refresh_frequency',self.set_polling_frequency)
		self.conf.notify_add('/apps/penguintv/player_cmdline',self.set_player_cmdline)
		self.load_settings()
		
		#dnd
		self.TARGET_TYPE_TEXT = 80
		self.TARGET_TYPE_URL = 81
		drop_types = [ ('text/x-moz-url',0,self.TARGET_TYPE_URL),
									 ('text/unicode',0,self.TARGET_TYPE_TEXT),
									 ('text/plain',0,self.TARGET_TYPE_TEXT)]
		self.feedlist.drag_dest_set(gtk.DEST_DEFAULT_ALL, drop_types, gtk.gdk.ACTION_COPY)
		
		#updaters
		gobject.timeout_add(100, self._gui_updater)
		self.updater.queue_task(GUI, self._feed_list_view.populate_feeds) #no, because when we set the filter it populates
		#yes, because that has changed.
		if self.autoresume:
			self.updater.queue_task(GUI, self.resume_resumable)
		self.update_disk_usage()
		
		if self.firstrun:
			try:
				glade_prefix = utils.GetPrefix()+"/share/penguintv"
				os.stat(glade_prefix+"/defaultsubs.opml")
			except:
				try:				
					glade_prefix = utils.GetPrefix()+"/share"
					os.stat(glade_prefix+"/defaultsubs.opml")
				except:
					print "ptvdb: error finding default subscription file."
					sys.exit()
			f = open(glade_prefix+"/defaultsubs.opml", "r")
			self.display_status_message("Polling feeds for the first time...")
			task_id = self.updater.queue_task(DB, self.updater_thread_db.import_OPML,f)
			task_id2 = self.updater.queue_task(GUI, self._feed_list_view.populate_feeds,None, task_id)
			self.updater.queue_task(GUI, self.display_status_message, "Feeds Polled", task_id2)
		

	def load_settings(self):
		x = self.conf.get_int('/apps/penguintv/app_window_position_x')
		y = self.conf.get_int('/apps/penguintv/app_window_position_y')
		if x is None:
			x=40
		if y is None:
			y=40
		self.app_window.move(x,y)
		self.app_window.resize(self.conf.get_int('/apps/penguintv/app_window_size_x'),self.conf.get_int('/apps/penguintv/app_window_size_y'))
		val = self.conf.get_int('/apps/penguintv/feed_pane_position')
		if val is None:
			val=150
		self.feed_pane.set_position(val)
		val = self.conf.get_int('/apps/penguintv/entry_pane_position')
		if val is None:
			val=150
		self.entry_pane.set_position(val)
			
		val = self.conf.get_int('/apps/penguintv/feed_refresh_frequency')
		if val is None:
			val=60
		self.polling_frequency = val*60*1000
		
		gobject.timeout_add(self.polling_frequency,self.do_poll_multiple, self.polling_frequency)
		self.window_preferences.set_feed_refresh_frequency(self.polling_frequency/(60*1000))
		
		val = self.conf.get_string('/apps/penguintv/player_cmdline')
		if val is None:
			val="totem --enqueue"
		self.player.cmdline = val
		self.window_preferences.set_player_cmdline(val)
			
		val = self.conf.get_int('/apps/penguintv/bt_min_port')
		if val is None:
			val=6881
		self.bt_settings['min_port']=val
		val = self.conf.get_int('/apps/penguintv/bt_max_port')
		if val is None:
			val=6999
		self.bt_settings['max_port']=val
		val = self.conf.get_int('/apps/penguintv/bt_ul_limit')
		if val is None:
			val=0
		self.bt_settings['ul_limit']=val
		self.window_preferences.set_bt_settings(self.bt_settings)
		self.mediamanager.set_bt_settings(self.bt_settings)
		
		val = self.conf.get_bool('/apps/penguintv/auto_resume')
		if val is None:
			val=True
		self.autoresume = val
		self.window_preferences.set_auto_resume(val)
			
	def save_settings(self):
		self.conf.set_int('/apps/penguintv/feed_pane_position',self.feed_pane.get_position())
		self.conf.set_int('/apps/penguintv/entry_pane_position',self.entry_pane.get_position())
		x,y=self.app_window.get_position()
		self.conf.set_int('/apps/penguintv/app_window_position_x',x)
		self.conf.set_int('/apps/penguintv/app_window_position_y',y)
		x,y=self.app_window.get_size()
		self.conf.set_int('/apps/penguintv/app_window_size_x',x)
		self.conf.set_int('/apps/penguintv/app_window_size_y',y)
		
		self.conf.set_int('/apps/penguintv/feed_refresh_frequency',self.polling_frequency/(60*1000))
		self.conf.set_string('/apps/penguintv/player_cmdline',self.player.cmdline)
		self.conf.set_int('/apps/penguintv/bt_max_port',self.bt_settings['max_port'])
		self.conf.set_int('/apps/penguintv/bt_min_port',self.bt_settings['min_port'])
		self.conf.set_int('/apps/penguintv/bt_ul_limit',self.bt_settings['ul_limit'])
		self.conf.set_bool('/apps/penguintv/auto_resume',self.autoresume)
	
	def resume_resumable(self):
		feeds = self.db.get_feedlist()
		for feed in feeds:
			entrylist = self.db.get_entrylist(feed[0])
			found=0
			for entry in entrylist:
				media = self.db.get_entry_media(entry[0])
				try:
					for medium in media:
						if medium['download_status']==3: 
							print "resuming "+str(medium['file'])
							self.mediamanager.download(medium['media_id'], False, True) #resume please
							#self.db.set_media_viewed(medium['media_id'],False)
				except:
					pass
		self.updater.queue_task(GUI,self._feed_list_view.populate_feeds, None)
		
	def do_quit(self):
		#save and shut down all our threads
		self.exiting=1
		self.save_settings()
		self.mediamanager.finish()
		self.db.finish()
		self._db_updater.goAway()
		gtk.main_quit()
		
	def do_poll_multiple(self, was_setup=None, override=0):
		if was_setup:
			if was_setup!=self.polling_frequency:
				return False
		self.poll_tasks = len(self.db.get_feedlist())
		self.display_status_message("Polling Feeds...")
		task_id = self.updater.queue_task(DB, self.updater_thread_db.poll_multiple, override)
		self.updater.queue_task(GUI, self.display_status_message, "Feeds Updated", task_id, False) #waitfor, and don't clear the flag
		self.updater.queue_task(GUI, self.update_disk_usage, None, task_id, False) #because this is also waiting
		self.updater.queue_task(GUI, self._feed_list_view.populate_feeds, None, task_id)
		if was_setup:
			return True
	
	def __getitem__(self, key):
		return self.widgets.get_widget(key)
		
	def display_feed(self, feed_id, selected_entry=-1):
		self.updater.queue_task(GUI, self._entry_list_view.populate_entries,(feed_id,selected_entry))
		
	def display_entry(self, entry_id, set_read=1):
		if entry_id is not None:
			item = self.db.get_entry(entry_id)
			media = self.db.get_entry_media(entry_id)
			read = self.db.get_entry_read(entry_id)
		else:
			self.updater.queue_task(GUI, self._entry_view.display_item,None)
			return
			
		if media:
			item['media']=media
		else:
			if read==0 and set_read==1:
				self.db.set_entry_read(entry_id,1)
				self.updater.queue_task(GUI, self._entry_list_view.update_entry_list,entry_id)
				self.updater.queue_task(GUI, self._feed_list_view.update_feed_list,item['feed_id'])
		self.updater.queue_task(GUI, self._entry_view.display_item,item)
	
	def activate_link(self, link):
		parsed_url = urlparse.urlparse(link)
		action=parsed_url[0]
		http_arguments=parsed_url[4]
		try:
			item=int(parsed_url[2])
		except:
			pass
		if action == "download":
			self.mediamanager.download(item)
			media = self.db.get_media(item)
			#self.db.set_media_viewed(item,False)
			self.updater.queue_task(GUI, self.update_feed_list, None)
			self.updater.queue_task(GUI, self.update_entry_list, None)
		elif action=="resume":
			self.mediamanager.download(item, False, True) #resume please
			media = self.db.get_media(item)
			self.db.set_media_viewed(item,False)
			self.updater.queue_task(GUI, self.update_feed_list, None)
			self.updater.queue_task(GUI, self.update_entry_list, None)
		elif action=="play":
			media = self.db.get_media(item)
			self.db.set_entry_read(media['entry_id'],True)
			self.db.set_media_viewed(item,True)
			if utils.is_known_media(media['file']):
				self.player.play(media['file'])
			else:
				gnome.url_show(media['file'])
			self.updater.queue_task(GUI, self.update_feed_list, None)
			self.updater.queue_task(GUI, self.update_entry_list, None)
		elif action=="downloadqueue":
			self.mediamanager.download(item, True)
			self.updater.queue_task(GUI, self.update_feed_list, None)
			self.updater.queue_task(GUI, self.update_entry_list, None)
		elif action=="queue":
			print parsed_url		
		elif action=="cancel":
			self.download_task_ops.append((CANCEL,item))
		elif action=="pause":
			self.download_task_ops.append((PAUSE, item))
		elif action=="clear":
			newitem={}
			newitem['media_id']=item
			newitem['entry_id']=self.db.get_entryid_for_media(newitem['media_id'])
			self.updater.queue_task(GUI, self.do_cancel_download, newitem)
			self.updater.queue_task(GUI, self.update_feed_list, None)
			self.updater.queue_task(GUI, self.update_entry_list, None)
		elif action=="delete":
			self.updater.queue_task(GUI, self.delete_media, item)
			self.updater.queue_task(GUI, self.update_feed_list, None)
			self.updater.queue_task(GUI, self.update_entry_list, None)
		elif action=="reveal":
			gnome.url_show("file:"+os.path.split(urllib.quote(parsed_url[1]+parsed_url[2]))[0])
	#except:
	#		pass
		elif action=="http":
			gnome.url_show(parsed_url[0]+"://"+urllib.quote(parsed_url[1]+parsed_url[2])+"?"+http_arguments)
		elif action=="file":
			print parsed_url[0]+"://"+urllib.quote(parsed_url[1]+parsed_url[2])
			gnome.url_show(parsed_url[0]+"://"+urllib.quote(parsed_url[1]+parsed_url[2]))
			#self.db.set_media_viewed(item,False)
			#self.updater.queue_task(GUI, self.update_feed_list, None)
			#self.updater.queue_task(GUI, self.update_entry_list, None)
			
	def set_bt_maxport(self, client, *args, **kwargs):
		maxport = client.get_int('/apps/penguintv/bt_max_port')
		self.bt_settings['max_port']=maxport
		self.window_preferences.set_bt_settings(self.bt_settings)
		
	def set_bt_minport(self, client, *args, **kwargs):
		minport = client.get_int('/apps/penguintv/bt_min_port')
		self.bt_settings['min_port']=minport
		self.window_preferences.set_bt_settings(self.bt_settings)
		
	def set_bt_ullimit(self, client, *args, **kwargs):
		ullimit = client.get_int('/apps/penguintv/bt_ul_limit')
		self.bt_settings['ul_limit']=ullimit
		self.window_preferences.set_bt_settings(self.bt_settings)
			
	#def set_bt_settings(self, btsettings):
	#	self.bt_settings = btsettings
	#	self.mediamanager.set_bt_settings(self.bt_settings)
			
	def set_polling_frequency(self, client, *args, **kwargs):
		freq = client.get_int('/apps/penguintv/feed_refresh_frequency')
		if self.polling_frequency != freq*60*1000:
			self.polling_frequency = freq*60*1000	
			gobject.timeout_add(self.polling_frequency,self.do_poll_multiple, self.polling_frequency)
			self.window_preferences.set_feed_refresh_frequency(freq)
			
	def get_player_cmdline(self):
		return self.player.cmdline
	
	def set_player_cmdline(self, client, *args, **kwargs):
		cmdline = self.conf.get_string('/apps/penguintv/player_cmdline')
		self.window_preferences.set_player_cmdline(cmdline)
		self.player.cmdline=cmdline
			
	def add_feed(self, url):
		self.display_status_message("Try to poll feed...")
		if self.db.insertURL(url) == ptvDB.NOFEED:
			self.display_status_message("Error adding feed")
			dialog = gtk.MessageDialog(type=gtk.MESSAGE_ERROR,
		                           flags=gtk.DIALOG_MODAL, 
		                           buttons=gtk.BUTTONS_CLOSE,
		                           message_format="There was an error adding the feed "+str(url))
			dialog.run()
			dialog.destroy()
		else:
			self.display_status_message("Feed Added")
			self.updater.queue_task(GUI,self._feed_list_view.populate_feeds, None)
		
	def delete_entry_media(self, entry_id):
		medialist = self.db.get_entry_media(entry_id)
		if medialist:
			for medium in medialist:
				if medium['download_status']==2:
					self.updater.queue_task(DB, self.updater_thread_db.set_media_viewed, medium['media_id'])
					self.delete_media(medium['media_id'])
					self.mediamanager.generate_playlist()
		
	def delete_media(self, media_id):
		self.db.delete_media(media_id)
		self.mediamanager.generate_playlist()
		self.db.set_media_viewed(media_id,True)
		self.update_disk_usage()
		
	def delete_feed_media(self, feed_id):
		entrylist = self.db.get_entrylist(feed_id)
		if entrylist:
			for entry in entrylist:
				self.delete_entry_media(entry[0])
				self.mediamanager.generate_playlist()
				self.update_disk_usage()
				self.updater.queue_task(GUI, self.update_entry_list,entry[0])
		self.updater.queue_task(GUI, self.update_feed_list,feed_id)
		
	def do_cancel_download(self, data):
		self.db.set_media_download_status(data['media_id'],0)
		self.delete_media(data['media_id'])
		
	def do_pause_download(self, data):
		self.db.set_media_download_status(data['media_id'],3)
		self.db.set_media_viewed(data['media_id'],0)
		self.db.set_entry_read(data['entry_id'],0)
		#self.delete_media(media_id)
		
	def download_finished(self, data):
		self.update_disk_usage()
		if data[1]==0: #failure
			if data[2][0] == 42:
				pass
			else:
				#self.delete_media(data[0]['media_id'])
				self.db.set_media_download_status(data[0]['media_id'],-1) #-1=error
				download_errors[data[0]['media_id']]=data[0]['errormsg']
				print "here we go: "+str(download_errors)
		else: #if success...
			media = data[0]
			if os.stat(media['file'])[6] < int(data[0]['size']/2) and os.path.isfile(media['file']): #don't check dirs
				download_errors[media['media_id']]="expected at least half of reported size "+ str(media['size'])+" but the file is "+str(os.stat(media['file'])[6])+" bytes."
				self.delete_media(media['media_id'])
				self.db.set_media_download_status(media['media_id'],-1) #-1=error
			else:
				if data[1]==2: #this means play, not success. fucking magic
					self.db.set_media_viewed(data[0]['media_id'],True)
					self.db.set_entry_read(data[0]['entry_id'],True)
					self.updater.queue_task(GUI,self.player.play,data[0]['file'])
				else:
					self.db.set_entry_read(data[0]['entry_id'],False)
					self.db.set_media_viewed(data[0]['media_id'],False)
				self.db.set_media_download_status(data[0]['media_id'],2)		
		try:
			feed_id = self.db.get_entry(data[0]['entry_id'])['feed_id']
			self.updater.queue_task(GUI,self.update_entry_list, data[0]['entry_id'])
			self.updater.queue_task(GUI,self.update_feed_list, feed_id)
		except ptvDB.NoEntry:
			self.updater.queue_task(GUI,self._feed_list_view.populate_feeds, None)
			self.updater.queue_task(GUI,self._feed_list_view.resize_columns,None)
		
	def rename_feed(self, feed_id, name):
		if len(name)==0:
			self.db.set_feed_name(feed_id, None) #gets the title the feed came with
		else:
			self.db.set_feed_name(feed_id, name)
		self.updater.queue_task(GUI,self._feed_list_view.populate_feeds, None)
		self.updater.queue_task(GUI,self._feed_list_view.resize_columns,None)		
		
	def set_auto_resume(self, client, *args, **kwargs):
		autoresume = client.get_bool('/apps/penguintv/auto_resume')
		self.window_preferences.set_auto_resume(autoresume)	
		self.autoresume = autoresume

	def update_feed_list(self, feed_id=None):
		self._feed_list_view.update_feed_list(feed_id) #for now, just update this ONLY
		
	def update_entry_list(self, entry_id=None):
		self._entry_list_view.update_entry_list(entry_id)			
		
	def update_disk_usage(self):
		size = self.mediamanager.get_disk_usage()
		self.disk_usage_widget.set_text(utils.format_size(size))
		
	def on_about_activate(self,event):
		try:
			self.about_box.run()
		except:
			pass #fc3 workaround
		
	def on_about_close(self, event):
		self.about_box.hide()
		
	def on_app1_delete_event(self,event,data):
		self.do_quit()
		
	def on_app1_destroy_event(self,event,data):
		self.do_quit()
		
	def on_add_feed_activate(self, event):
		self.on_feed_add_clicked(event)

	def on_download_entry_activate(self, event):
		entry = self._entry_list_view.get_selected()[0]
		if entry:
			self.mediamanager.download_entry(entry)
			self.updater.queue_task(GUI, self.update_entry_list, None)
			self.updater.queue_task(GUI, self.update_feed_list,None)
			
	def on_download_unviewed_activate(self, event):
		feeds = self.db.get_feedlist()
		download_list=self.db.get_media_for_download()
		total_size=0
		if len(download_list)==0:
			dialog = gtk.Dialog(title="No Unviewed Media", parent=None, flags=gtk.DIALOG_MODAL, buttons=(gtk.STOCK_OK, gtk.RESPONSE_ACCEPT))
			label = gtk.Label("There is no unviewed media to download.")
			dialog.vbox.pack_start(label, True, True, 0)
			label.show()
			response = dialog.run()
			dialog.hide()
			del dialog
			return
		for d in download_list:
			total_size=total_size+int(d[1])
		if total_size>100000000: #100 megs
			dialog = gtk.Dialog(title="Large Download", parent=None, flags=gtk.DIALOG_MODAL, buttons=(gtk.STOCK_CANCEL, gtk.RESPONSE_REJECT, gtk.STOCK_OK, gtk.RESPONSE_ACCEPT))
			label = gtk.Label("If PenguinTV downloads all of the unviewed media, \nit will take "+utils.format_size(total_size)+". Do you wish to continue?")
			dialog.vbox.pack_start(label, True, True, 0)
			label.show()
			response = dialog.run()
			dialog.hide()
			del dialog
			if response != gtk.RESPONSE_ACCEPT:
				return
		for d in download_list:
			self.mediamanager.download(d[0])
		self.updater.queue_task(GUI,self._feed_list_view.populate_feeds, None)
			
	def on_download_unviewed_clicked(self,event):
		self.on_download_unviewed_activate(event)
			
	def on_delete_entry_media_activate(self,event):
		selected,index = self._entry_list_view.get_selected()
		if selected:
			self.delete_entry_media(selected)
			self.updater.queue_task(GUI,self.update_entry_list,None)
			self.updater.queue_task(GUI,self.update_feed_list,None)
			self.update_disk_usage()
			
	def on_delete_feed_media_activate(self,event):
		selected,index = self._feed_list_view.get_selected()
		if selected:
			self.delete_feed_media(selected)
			
	def on_export_opml_activate(self, event):
		dialog = gtk.FileChooserDialog('Select OPML...',None, action=gtk.FILE_CHOOSER_ACTION_SAVE,
                                  buttons=(gtk.STOCK_CANCEL,gtk.RESPONSE_CANCEL,gtk.STOCK_SAVE,gtk.RESPONSE_OK))
		dialog.set_default_response(gtk.RESPONSE_OK)

		filter = gtk.FileFilter()
		filter.set_name("OPML files")
		filter.add_pattern("*.opml")
		dialog.add_filter(filter)

		filter = gtk.FileFilter()
		filter.set_name("All files")
		filter.add_pattern("*")
		dialog.add_filter(filter)        
		
		dialog.set_current_name('mySubscriptions.opml')                      
    		
		response = dialog.run()
		if response == gtk.RESPONSE_OK:
			try:
				f = open(dialog.get_filename(), "w")
				self.display_status_message("Exporting Feeds...")
				task_id = self.updater.queue_task(DB, self.updater_thread_db.export_OPML, f)
				task_id2 = self.updater.queue_task(GUI, self._feed_list_view.populate_feeds, None, task_id)
				self.updater.queue_task(GUI,self.display_status_message, " ", task_id2)
			except:
				pass
		elif response == gtk.RESPONSE_CANCEL:
			#print 'Closed, no files selected'
			pass
		dialog.destroy()
		
	def on_feed_add_clicked(self,event):
		self.window_add_feed.show() #not modal / blocking
		
	def on_feed_remove_clicked(self,event): 
		dialog = gtk.Dialog(title="Really Delete Feed?", parent=None, flags=gtk.DIALOG_MODAL, buttons=(gtk.STOCK_CANCEL, gtk.RESPONSE_REJECT, gtk.STOCK_OK, gtk.RESPONSE_ACCEPT))
		label = gtk.Label("Are you sure you want to delete this feed?")
		dialog.vbox.pack_start(label, True, True, 0)
		label.show()
		response = dialog.run()
		dialog.hide()
		del dialog
		if response == gtk.RESPONSE_ACCEPT:
			selected,index = self._feed_list_view.get_selected()
			#select entries and get all the media ids, and tell them all to cancel
			#in case they are downloading
			try:
				for entry_id,title,date,new in self.db.get_entrylist(selected):
					try:
						for medium in self.db.get_entry_media(entry_id):
							self.download_task_ops.append((CANCEL,medium['media_id']))
					except: #keep trying
						pass
			except:
				pass
			self.db.delete_feed(selected)
			self.updater.queue_task(GUI,self._feed_list_view.populate_feeds, None)
			self.updater.queue_task(GUI, self.update_disk_usage)
			self.updater.queue_task(GUI,self._feed_list_view.resize_columns,None)
			self._entry_list_view.clear_entries()
			
	def on_feedlistview_drag_data_received(self, widget, context, x, y, selection, targetType, time):
		if targetType == self.TARGET_TYPE_TEXT:
			url = ""
			for c in selection.data:
				if c != "\0":  #for some reason ever other character is a null.  what gives?
					url = url+c
			self.add_feed(url)
		elif targetType == self.TARGET_TYPE_URL:
			url = ""
			for c in selection.data[0:selection.data.find('\n')]:
				if c != '\0':
					url = url+c
			self.add_feed(url)
	
	def on_feeds_poll_clicked(self,event):
		self.set_wait_cursor()
		self.do_poll_multiple()
		self.set_wait_cursor(False)
		
	def on_filter_combo_changed(self, event):
		self._feed_list_view.set_filter(self.filter_combo_widget.get_active())
		
	def on_import_opml_activate(self, event):
		dialog = gtk.FileChooserDialog('Select OPML...',None, action=gtk.FILE_CHOOSER_ACTION_OPEN,
                                  buttons=(gtk.STOCK_CANCEL,gtk.RESPONSE_CANCEL,gtk.STOCK_OPEN,gtk.RESPONSE_OK))
		dialog.set_default_response(gtk.RESPONSE_OK)
    
		filter = gtk.FileFilter()
		filter.set_name("OPML files")
		filter.add_pattern("*.opml")
		dialog.add_filter(filter)
		
		filter = gtk.FileFilter()
		filter.set_name("All files")
		filter.add_pattern("*")
		dialog.add_filter(filter)
		
		response = dialog.run()
		if response == gtk.RESPONSE_OK:
			try:
				f = open(dialog.get_filename(), "r")
				self.display_status_message("Importing Feeds, please wait...")
				task_id = self.updater.queue_task(DB, self.updater_thread_db.import_OPML,f)
				task_id2 = self.updater.queue_task(GUI,self._feed_list_view.populate_feeds, None, task_id)
				self.updater.queue_task(GUI,self.display_status_message, " ", task_id2)
			except:
				pass
		elif response == gtk.RESPONSE_CANCEL:
			print 'Closed, no files selected'
		dialog.destroy()		
			
	def on_mark_entry_as_viewed_activate(self,event):
		entry = self._entry_list_view.get_selected()[0]
		if entry:
			media = self.db.get_entry_media(entry)
			if media:
				for medium in media:
					self.db.set_media_viewed(medium['media_id'],True)
			self.db.set_entry_read(entry,True)
			self.updater.queue_task(GUI, self.update_entry_list, None)
			self.updater.queue_task(GUI, self.update_feed_list, None)

	def on_mark_entry_as_unviewed_activate(self,event):
		entry = self._entry_list_view.get_selected()[0]
		if entry:
			media = self.db.get_entry_media(entry)
			self.db.set_entry_read(entry, 0)
			if media:
				for medium in media:
					self.db.set_media_viewed(medium['media_id'],False)
				self.updater.queue_task(GUI,self.update_entry_list,None)
			else:
				self.db.set_entry_read(entry, 0)
				self.updater.queue_task(GUI,self.update_entry_list,None)
			self.updater.queue_task(GUI,self.update_feed_list,None)
	
	def on_mark_feed_as_viewed_activate(self,event):
		feed = self._feed_list_view.get_selected()[0]
		if feed:
			entrylist = self.db.get_entrylist(feed)
			for entry in entrylist:
				media = self.db.get_entry_media(entry[0])
				if media:
					for medium in media:
						self.db.set_media_viewed(medium['media_id'],True)
						if medium['download_status']==-1:
							self.db.set_media_download_status(medium['media_id'],0)
				self.db.set_entry_read(entry[0],1)
				self.updater.queue_task(GUI, self.update_entry_list, entry[0])
			self.updater.queue_task(GUI,self.update_feed_list, feed)
 
 	def on_play_entry_activate(self, event):
		entry = self._entry_list_view.get_selected()[0]
		if entry:
			media = self.db.get_entry_media(entry)
			self.db.set_entry_read(entry, True)
			filelist=[]
			if media:
				for medium in media:
					filelist.append(medium['file'])
					self.db.set_media_viewed(medium['media_id'],True)
		self.player.play(filelist)
		self.updater.queue_task(GUI, self.update_feed_list, None)
		self.updater.queue_task(GUI, self.update_entry_list, None)
				
	def on_play_unviewed_activate(self, event):
		playlist = self.db.get_unplayed_media_set_viewed()
		playlist.reverse()
		self.player.play(playlist)
		self.updater.queue_task(GUI,self._feed_list_view.populate_feeds, None)
	
	def on_play_unviewed_clicked(self, event):
		self.on_play_unviewed_activate(event)
		
	def on_preferences_activate(self, event):
		self.window_preferences.show()
		
	def on_quit2_activate(self,event):
		self.do_quit() #make the program quit, dumbass
		
	def on_refresh_activate(self, event):
		selected,index = self._feed_list_view.get_selected()
		task_id = self.updater.queue_task(DB,self.updater_thread_db.poll_feed,selected)
		self.updater.queue_task(GUI,self._feed_list_view.populate_feeds,None, task_id)
		
	def on_refresh_feeds_activate(self, event):
		self.on_feeds_poll_clicked(event)
		
	def on_remove_feed_activate(self, event):
		self.on_feed_remove_clicked(event)		
		
	def on_rename_feed_activate(self, event):
		selected,index = self._feed_list_view.get_selected()
		self.window_rename_feed.set_feed_id(selected)
		self.window_rename_feed.set_feed_name(self.db.get_feed_title(selected))
		self.window_rename_feed.show()	
			
	def on_resume_all_activate(self, event):
		self.resume_resumable()
		
	def on_show_downloads_activate(self, event):
		self.mediamanager.generate_playlist()
		self.mediamanager.show_downloads()
		
	def _add_feed_callback(self, url, result):
		if result == ptvDB.NOFEED:
			self.updater.queue_task(GUI, self.add_feed_error, url)
		else:
			self.updater.queue_task(GUI, self._feed_list_view.populate_feeds, None)
	
	def _progress_callback(self,data):
		cancel_this = self.download_task_ops.count((CANCEL,data[0]['media_id']))
		while self.download_task_ops.count((CANCEL, data[0]['media_id'])):  #could be multiple copies of same click
			self.download_task_ops.remove((CANCEL, data[0]['media_id']))
			
		pause_this = self.download_task_ops.count((PAUSE,data[0]['media_id']))
		while self.download_task_ops.count((PAUSE, data[0]['media_id'])):
			self.download_task_ops.remove((PAUSE, data[0]['media_id']))
			
		if cancel_this>0 or self.exiting==1:
			self.updater.queue_task(GUI,self.do_cancel_download,data[0], None, True, 1)
			#self.do_cancel_download(data[0])
			return 1
		elif pause_this>0:
			self.updater.queue_task(GUI,self.do_pause_download,data[0], None, True, 1)
			#self.do_cancel_download(data[0])
			return 1
		#print "update callback"
		self.updater.queue_task(GUI,self._entry_view.update_progress,data)

	def _finished_callback(self,data):
		self.mediamanager.update_playlist(data[0])
		self.updater.queue_task(GUI,self.download_finished, data)
		
	def _polling_callback(self, data):
		selected_feed = self._feed_list_view.get_selected()[0]
		self.updater.queue_task(GUI, self._feed_list_view.update_feed_list, data[0])
		if selected_feed is not None:
			if selected_feed == data[0]:
				self.updater.queue_task(GUI, self._entry_list_view.populate_entries, (selected_feed, -1))
			
	class DBUpdaterThread(threading.Thread):
	
		def __init__(self, updater, polling_callback=None):
			threading.Thread.__init__(self)
			self.__isDying = False
			self.db = None
			self.updater = updater
			self.threadSleepTime = 0.1
			if polling_callback is None:
				self.polling_callback = self._polling_callback
			else:
				self.polling_callback = polling_callback
			
			
		def _polling_callback(self, data):
			pass
	        
		def run(self):
	
			""" Until told to quit, retrieve the next task and execute
				it, calling the callback if any.  """
				
			if self.db == None:
				self.db = ptvDB.ptvDB(self.polling_callback)
				
			skipped = 0
			while self.__isDying == False:
				while self.updater.task_count(DB)>0:
					var = self.updater.peek_task(DB, skipped)
					func, args, task_id, waitfor, clear_completed = var#self.updater.peek_task(DB)
					
					if waitfor:
						if self.updater.is_completed(waitfor): #don't pop if false
							if args:
								self.db.func(args)
							else:
								self.db.func()
							self.updater.set_completed(task_id)
							if clear_completed:
								self.updater.clear_completed(waitfor)
							self.updater.pop_task(DB, skipped)
						else:
							skipped = skipped+1
					else:
						if args:
							func(args)
						else:
							func()
						self.updater.set_completed(task_id)
						self.updater.pop_task(DB, skipped)
				time.sleep(self.threadSleepTime)
						
		def get_db(self):
			return self.db
	
		def goAway(self):
	
			""" Exit the run loop next time through."""
	        
			self.__isDying = True
		
	def _gui_updater(self):
		skipped=0
		while self.updater.task_count(GUI) > 0 and self.updater.task_count(GUI) != skipped:
			var = self.updater.peek_task(GUI, skipped)
			func, args, task_id, waitfor, clear_completed =  var
			if waitfor:
				if self.updater.is_completed(waitfor): #don't pop if false
					if args:
						func(args)
					else:
						func()
					self.updater.set_completed(task_id)
					if clear_completed:
						self.updater.clear_completed(waitfor)
					self.updater.pop_task(GUI, skipped)
				else:
					skipped = skipped+1
			else:
				if args:
					func(args)
				else:
					func()
				self.updater.set_completed(task_id)
				self.updater.pop_task(GUI, skipped)
		return True
		
	def _display_status_messages(self):
		ql = len(self._status_messages)
		if ql:
			m = self._status_messages.pop(0)
			if len(m):
				self._status_view.set_status(m)
			else:
				self._status_view.set_status("")				
			if ql > 1:
				 gobject.timeout_add(300, self._display_status_messages)
				
	def display_status_message(self, m):
		ql = len(self._status_messages)
		self._status_messages.append(m)
		if not ql:
			gobject.timeout_add(300, self._display_status_messages)
		
def main():
	gnome.init("PenguinTV", utils.VERSION)
	app = PenguinTVApp()    # Instancing of the GUI
	app.Show() 
	gtk.threads_init()
	gtk.main() 
        
if __name__ == '__main__': # Here starts the dynamic part of the program 
	gnome.init("PenguinTV", utils.VERSION)
	app = PenguinTVApp()    # Instancing of the GUI
	app.Show() 
	gtk.threads_init()
	gtk.main()    
	
	

