# Written by Owen Williams
# see LICENSE for license information

import penguintv


class AddFeedDialog:
	def __init__(self,xml,app):
		self.xml = xml
		self._app = app
		self._window = xml.get_widget("window_add_feed")
		for key in dir(self.__class__):
			if key[:3] == 'on_':
				self.xml.signal_connect(key, getattr(self,key))
		self.feed_url_widget = self.xml.get_widget("feed_url")
				
	def show(self):

		self._window.show()
		
	def hide(self):
		self.feed_url_widget.set_text("")
		self._window.hide()
				
	def on_button_ok_clicked(self,event):
		self._app.add_feed(self.feed_url_widget.get_text())
		self.hide()
	
	def on_button_cancel_clicked(self,event):
		print "cancel"
		self.hide()
