/***********************************************************************
 *
 * Copyright (C) 2010-2011 Innocent De Marchi <tangram.peces@gmail.com>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 ***********************************************************************/
#include <QtCore>
#include <QtGui>

#include "tauler.h"
#include "fitxa.h"
#include "frmprincipal.h"
#include "moviment.h"
#include "rellotge.h"
#include "funcions.h"
#include "constants.h"

/****************************************
*
*15/12/10: S'ha canviat el sceneJoc: ara, cada
* vegada que es canvia la modalitat de joc,
* es crea un sceneJoc. D'aquesta manera, el joc
* queda sempre ben dimensionat.
*****************************************/


const double distanciaEntreFitxes = 1.2;

extern int jocResolt;

Tauler::Tauler(  QUndoStack *movimentsUndoStack , Rellotge *rellotge,frmPrincipal *frmPrincipal,  QWidget* parent )
  : QGraphicsView(parent),
  p_movimentsUndoStack(movimentsUndoStack),
  p_rellotge(rellotge),
  p_frmPrinci(frmPrincipal)
{
        QGraphicsScene* sceneJoc = new QGraphicsScene(this);
        sceneJoc = new QGraphicsScene(this);
        setScene(sceneJoc);
        setRenderHints(QPainter::Antialiasing | QPainter::TextAntialiasing);
        setFrameStyle(QFrame::NoFrame);
        setHorizontalScrollBarPolicy(Qt::ScrollBarAlwaysOff);
        setVerticalScrollBarPolicy(Qt::ScrollBarAlwaysOff);
        setMinimumSize(QSize(300,300));

        comptadorFitxesJoc=0;
        //inicialment es juga
        p_estatDelJoc=joc;
}

/*
  Retorna l'estat de la fitxa amb les coordenades del paràmetre
  */
int Tauler::estatFitxaJoc( const  QPoint& coordenades) const {
    if (m_fitxes.contains(coordenades.x()*100+coordenades.y())){
       return   m_fitxes.value(coordenades.x()*100+coordenades.y())->estat();
           }
   else return -1;
}

void Tauler::marcaMovimentsFitxa(QList<QPoint> movimentsFitxa){
    for (int i=0; i<movimentsFitxa.size();++i){
          m_fitxes.value(movimentsFitxa.at(i).x()*100+movimentsFitxa.at(i).y())->setEstat(3);
    }
}

 //Canvia l'estat de les fitxes per tal de marcar un moviment
void Tauler::marcaMoviment (QString moviment){
    QStringList moviments=moviment.split(" ");
    m_fitxes.value(moviments.value(0).toInt())->setEstat(2);
    m_fitxes.value(moviments.value(2).toInt())->setEstat(3);
}
/*
  Elimina els buits marcats com a final d'un moviment anterior
  */
void Tauler::eliminaMarquesMoviments(const  QPoint& coordenades){
    QHashIterator <int, Fitxa*> i(m_fitxes);
    while (i.hasNext()) {
        i.next();
        if (i.value()->estat()==3){
            i.value()->setEstat(0);
        }
        if(  (i.value()->estat()==2) && !(i.key()==(coordenades.x()*100+coordenades.y())) ){
            i.value()->setEstat(1);
        }
    }
}


void Tauler::ferMoviment (int fitxaInicial, int fitxaBotada, int fitxaFinal){
       Moviment* nouMoviment = new Moviment(fitxaInicial,fitxaBotada,fitxaFinal,p_tipusMoviment,this);
       p_movimentsUndoStack->push(nouMoviment);
       p_frmPrinci->iniciSolucioAction->setEnabled(p_movimentsUndoStack->canUndo());
       if(p_estatDelJoc==joc){
           p_frmPrinci->mostraMissatge(3);}
         //  p_frmPrinci->statusBar()->showMessage(missatgeNumeroMoviments());;}
       marcaFinalDeJoc(p_tipusMoviment);
}

void Tauler::marcaFinalDeJoc(int direccioMoviment){
    if( jocFinalitzat()){
        QHashIterator <int, Fitxa*> i(m_fitxes);
        int numFitxes=0, ordFitxa=0;
        jocResolt=1;
        p_rellotge->aturaRellotge();
        if(p_estatDelJoc==joc){
            p_frmPrinci->mostraMissatge(0);}
        //es posen les fitxes en color vermell
        while (i.hasNext()) {
              i.next();
              if (i.value()->estat()==1){
                  i.value()->setEstat(5);
                  numFitxes++;
                  ordFitxa=i.key();
              }          
    }

        //En les modalitats "inverses" no queda només una fitxa
        if ( (numFitxes==1) && (direccioMoviment != 2)){
          m_fitxes.value(ordFitxa)->setEstat(4);
          p_frmPrinci->mostraMissatge(1);
          jocResolt=2;
          p_rellotge->aturaRellotge();
          if(p_estatDelJoc==joc){
              controlaRecords();
              p_frmPrinci->desaSolucions1();
              p_frmPrinci->veureSolucionsSlot();}
        }

        if (  (numFitxes==numeroDeMovimentsJoc()+1) && (direccioMoviment == 2)){
          i.toFront();
          while (i.hasNext()) {
              i.next();
              if (i.value()->estat()==5){
                  i.value()->setEstat(4);
              }
          }
          p_frmPrinci->mostraMissatge(1);
          jocResolt=2;
          p_rellotge->aturaRellotge();
          if(p_estatDelJoc==joc){
              controlaRecords();
              p_frmPrinci->desaSolucions1();
              p_frmPrinci->veureSolucionsSlot();}
        }
      setInteractive(false);
    }
}

/*
  Comprova, desprès de cada moviment, si el joc s'ha acabat
  */
bool Tauler::jocFinalitzat(){
   QHashIterator <int, Fitxa*> i(m_fitxes);
   bool finalitzat=true;
   while (i.hasNext()) {
        i.next();
        if (i.value()->estat()==1){
           if ( i.value()->esPotMoure()){finalitzat=false;}
        }
    }
 return finalitzat;
}

void Tauler::controlaRecords(){
    QSettings records;
    QString record=records.value(QString("%1/record").arg(p_modalitatJocActual),QString("100:00:00")).toString();
    if (p_rellotge->retornaTemps(1)< record){
        QSettings().setValue(QString("%1/record").arg(p_modalitatJocActual), p_rellotge->retornaTemps(1));
        //missatge nou record personal
        p_frmPrinci->mostraMissatge(2);
     //   QMessageBox::information(this,tr("Nova marca personal"),
       //                          tr("Heu establert un nou record personal en aquesta modalitat de joc"));
    }
}

/*
Carrega les fitxes de la modalitat de joc passada per paràmetre
  */
void Tauler::joc_CarregaJoc( QString p_tipusJoc, QString p_filesColumnes, QString p_estatFitxes){
    scene()->clear();
    QGraphicsScene* sceneJoc1 = new QGraphicsScene(this);
     setScene(sceneJoc1);
    //sceneJoc->clear();
    p_rellotge->aturaRellotge();
    p_rellotge->estableixTemps(QString("00:00:00"));
    comptadorFitxesJoc=0;
    p_estatDelJoc=joc;


    QStringList  tipusJoc = p_tipusJoc.split(" ");
    p_modalitatJocActual=tipusJoc.value(0);
    QStringList  filesColumnes= p_filesColumnes.split(" ");
    QStringList  estatFitxes = p_estatFitxes.split(" ");
    p_tipusMoviment=tipusJoc.value(1).toInt();
    p_numFitxesAillades=tipusJoc.value(2).toInt();
    p_numMoviments=tipusJoc.value(3).toInt();
    if (p_tipusMoviment==2){p_estatFitxaMitjana=0;}
    else {p_estatFitxaMitjana=1;}

    int files, columnes;
    files= filesColumnes.value(0).toInt();
    columnes=filesColumnes.value(1).toInt();
    m_fitxes.clear();
    if (columnes>0){
        for(int j=0 ; j<files;++j){
              for(int i=0 ; i<columnes;++i){
                   if(estatFitxes.value(j*columnes+i).toInt()>-1){
                      QPoint coord(j,i); //fila i columna
                       Fitxa *fitxa= new Fitxa(this);
                       fitxa->setCoordenades(coord);
                       fitxa->setEstat(estatFitxes.value(j*columnes+i).toInt());
                       fitxa->setTipusMoviment(tipusJoc.value(1).toInt());
                       fitxa->setPos(fitxa->coordenades().y()*distanciaEntreFitxes*30,
                                             fitxa->coordenades().x()*distanciaEntreFitxes*30);
                       m_fitxes.insert(coord.x()*100+coord.y(),fitxa);
                       scene()->addItem(fitxa);
                       if (fitxa->estat()==1) {++comptadorFitxesJoc;}
                   }//if estatFitxes
               } //for columnes
           }//for files
 }
    else { //Solitaris de tipus triangular
    int contador=0;
    for(int j=0 ; j<files;++j){
               for(int i=0; i<j;++i){
                       QPoint coord(j-1,i); //fila i columna
                       Fitxa *fitxa= new Fitxa(this);
                       fitxa->setEstat(estatFitxes.value(contador).toInt());
                       fitxa->setTipusMoviment(tipusJoc.value(1).toInt());
                       fitxa->setCoordenades(coord);
                       fitxa->setPos( fitxa->coordenades().y()*distanciaEntreFitxes*30-15*1.2*j,
                                             fitxa->coordenades().x()*distanciaEntreFitxes*30+4*j);
                    //   fitxa->setPos( fitxa->coordenades().y()*distanciaEntreFitxes*30-15*1.2*j,
                     //                        fitxa->coordenades().x()*distanciaEntreFitxes*30);
                     //  qDebug("fitxa %d,%d",fitxa->pos().x(),fitxa->pos().y());
                       m_fitxes.insert(coord.x()*100+coord.y(),fitxa);
                       scene()->addItem(fitxa);
                       if (fitxa->estat()==1) {++comptadorFitxesJoc;}
                       ++contador;
               } //for columnes
           }//for files
    }
p_movimentsUndoStack->clear();
setInteractive(true);
//Això per a què s'ajusti a la finestra
fitInView(sceneRect(), Qt::KeepAspectRatio);
//  QVector<QVector<int> > matriuJoc(7,QVector<int>(7));
}


 void Tauler::resizeEvent(QResizeEvent* event) {
        fitInView(sceneRect(), Qt::KeepAspectRatio);
        QGraphicsView::resizeEvent(event);
}

 /*
   Per a cada fitxa del joc, calcula els moviments possibles
   i els posa en el QList movimentsPossibles de cada fitxa
   */
 void Tauler::solucionaJocActual_CalculaMovimentsPosibles(){
      //Per a cada fitxa del joc, calcula els possibles moviments
     //i es desen a la QList fitxa.movimentsPossibles
     QHashIterator <int, Fitxa*> iterator_fitxes(m_fitxes);
     while (iterator_fitxes.hasNext()) {
        iterator_fitxes.next();
        iterator_fitxes.value()->calculaMovimentsPosiblesFitxa();
     }
 }

 QStringList Tauler::solucionaJocActual_CarregaMovimentsArbre(QStringList movimentsFets, QString darrerMoviment){

    QHashIterator <int, Fitxa*> iterator_fitxes(m_fitxes);
    QStringList itemsArbre; //tots els moviments possibles
    QStringList itemsArbre1;//moviments que enllaçan amb l'anterior
    QStringList itemsArbre2;//moviments per preferència
    QStringList itemsArbre3;//moviments per preferència que enllaçan amb l'anterior
    QStringList itemsArbre4;//moviments per nivell d'aïllament de les fitxes
    QStringList itemsArbre5;//moviments pel número de moviments posteriors
    QStringList itemsArbre6;//moviments pel número de moviments posteriors

  //  solucionaJocActual_FitxesAillades();
    int numeroMovimentsInicialsAtzar=3;
    int preferenciaMenor=200;
    int aillamentMajor=0;
      while (iterator_fitxes.hasNext()) {
        iterator_fitxes.next();

        int index_fitxaInicial=iterator_fitxes.value()->coordenades().x()*100+iterator_fitxes.value()->coordenades().y();
        //només comprovam les fitxes actives
       if ( m_fitxes.value(index_fitxaInicial)->estat()==1){
        int movimentsPosibles=0;
        for(int j=0 ; j<iterator_fitxes.value()->movimentsPossibles.count();++j){
            int index_fitxaBotada=iterator_fitxes.value()->movimentsPossibles.at(j).x();
            int index_fitxaFinal=iterator_fitxes.value()->movimentsPossibles.at(j).y();
            if (   (m_fitxes.value(index_fitxaBotada)->estat()==p_estatFitxaMitjana) &&
                (m_fitxes.value(index_fitxaFinal)->estat()==0) ){
                QString moviment=QString("%1 %2 %3").arg(
                        index_fitxaInicial).arg(
                        index_fitxaBotada).arg(
                        index_fitxaFinal);
                //ës possible aquest moviment
              if ( (movimentsFets.indexOf(QString("%1 %2").arg(p_movimentsUndoStack->index()+1).
                                                 arg(moviment))==-1) && (solucionaJocActual_CalculaMovimentsPosteriors(moviment)) ){
                itemsArbre.append(moviment);
                if (p_movimentsUndoStack->index()>numeroMovimentsInicialsAtzar+10){return itemsArbre;}
                ++movimentsPosibles;
                }
               }
           } //for
         if (movimentsPosibles>0){
          //   m_fitxes.value(index_fitxaInicial)->setPreferenciaMoure(movimentsPosibles);
             preferenciaMenor=qMin(preferenciaMenor,m_fitxes.value(index_fitxaInicial)->preferenciaMoure());
             aillamentMajor=qMax(aillamentMajor,m_fitxes.value(index_fitxaInicial)->nivellAillament());
         }
        }//if inicial estat==1
      }
      //Miram quins moviments maximitzen el número de moviments posteriors
      itemsArbre5=solucionaJocActual_CalculaNumeroMovimentsPosteriors(itemsArbre);

      //MIram si és possible enllaçar algun dels moviments amb el darrerMoviment
     QStringList fitxesDarrerMoviment=QStringList(darrerMoviment.split(" "));
     if (fitxesDarrerMoviment.count()>0){
   //  QString fitxaFinalDarrerMoviment=fitxesDarrerMoviment.value(fitxesDarrerMoviment.count()-1);
     for(int j=0 ; j<itemsArbre.count();++j){
         QStringList fitxesMovimentArbre=QStringList(itemsArbre.value(j).split(" "));
         //final actual i inicial anterior
         if (   ( fitxesMovimentArbre.value(2).contains(fitxesDarrerMoviment.value(0)) ) ||
         //final actual i mitjana anterior
             ( fitxesMovimentArbre.value(2).contains(fitxesDarrerMoviment.value(1)))   ||
         //mitjana actual i final anterior
             ( fitxesMovimentArbre.value(1).contains(fitxesDarrerMoviment.value(2)))  ||
         //inicial actual i final anterior
             ( fitxesMovimentArbre.value(0).contains(fitxesDarrerMoviment.value(2)))  ){
             itemsArbre1.append(itemsArbre.value(j));
           //  if (p_movimentsUndoStack->index()>numeroMovimentsInicialsAtzar ){return itemsArbre1;}

             if (m_fitxes.value(fitxesMovimentArbre.value(0).toInt())->preferenciaMoure()==preferenciaMenor ){
                itemsArbre3.prepend(itemsArbre.value(j));
              //  if (p_movimentsUndoStack->index()>numeroMovimentsInicialsAtzar ){return itemsArbre3;}
               }
         }
         if (m_fitxes.value(fitxesMovimentArbre.value(0).toInt())->preferenciaMoure()==preferenciaMenor ){
            itemsArbre2.prepend(itemsArbre.value(j));
           // if (p_movimentsUndoStack->index()>numeroMovimentsInicialsAtzar ){return itemsArbre2;}
          }

         if (m_fitxes.value(fitxesMovimentArbre.value(0).toInt())->preferenciaMoure()==aillamentMajor ){
            itemsArbre4.prepend(itemsArbre.value(j));
          //  if (p_movimentsUndoStack->index()>numeroMovimentsInicialsAtzar ){return itemsArbre4;}
          }
       }//for
    }// if fitxesDarrerMoviment.count()

//return itemsArbre
for(int j=0 ; j<itemsArbre5.count();++j){
    int repeticio=0;
    if (itemsArbre1.contains(itemsArbre5.value(j))) {++repeticio;}
    if (itemsArbre2.contains(itemsArbre5.value(j))) {++repeticio;}
    if (itemsArbre3.contains(itemsArbre5.value(j))) {++repeticio;}
    if (itemsArbre4.contains(itemsArbre5.value(j))) {++repeticio;}
    if (repeticio>2){itemsArbre6.append(itemsArbre5.value(j));}
}

      // moviments que cumpleixen més de 3 requisits
      if (itemsArbre6.count()>0){return itemsArbre6;}
      else if (itemsArbre3.count()>0){return itemsArbre3;}
      //Maximitzar el número de moviments
      else  if (itemsArbre5.count()>0){return itemsArbre5;}
      // nomès enllaçar moviment
      else  if (itemsArbre1.count()>0){return itemsArbre1;}
      // preferència en el moviment
      else if (itemsArbre2.count()>0){return itemsArbre2;}
      else return itemsArbre;
  }

 /*
   Per a cada un dels moviments passats, calcula el nombre de moviments posibles
   després de fer els moviments passats.
   Retorna la clau del Has de la fitxa amb més moviments
   */
 QStringList Tauler::solucionaJocActual_CalculaNumeroMovimentsPosteriors(QStringList movimentsPosibles){
     int maxNumMoviments=0;
     int numeroMoviments=0;
     QStringList llistaMovimentsMaxims;
     for(int j=0 ; j<movimentsPosibles.count();++j){
         //Primer "simulam" el moviment
         QStringList moviment=QStringList(movimentsPosibles.value(j).split(" "));
         if (p_tipusMoviment != 2){
             m_fitxes.value(moviment.value(0).toInt())->setEstat(0);
             m_fitxes.value(moviment.value(1).toInt())->setEstat(0);
             m_fitxes.value(moviment.value(2).toInt())->setEstat(1);
             //Ara calculam el número de moviments possibles amb aquesta situació
             numeroMoviments=solucionaJocActual_MovimentsPosiblesActuals();
             if (numeroMoviments>maxNumMoviments){
                 // numeroMovimentMaxim=j;
                 maxNumMoviments=numeroMoviments;
                 llistaMovimentsMaxims.append(movimentsPosibles.value(j));
             }
             //desfem el moviment
             m_fitxes.value(moviment.value(0).toInt())->setEstat(1);
             m_fitxes.value(moviment.value(1).toInt())->setEstat(1);
             m_fitxes.value(moviment.value(2).toInt())->setEstat(0);
         }//if p_tipusMoviment != 2
         else {
             m_fitxes.value(moviment.value(0).toInt())->setEstat(0);
             m_fitxes.value(moviment.value(1).toInt())->setEstat(1);
             m_fitxes.value(moviment.value(2).toInt())->setEstat(1);
             //Ara calculam el número de moviments possibles amb aquesta situació
             numeroMoviments=solucionaJocActual_MovimentsPosiblesActuals();
             if (numeroMoviments>maxNumMoviments){
                 // numeroMovimentMaxim=j;
                 maxNumMoviments=numeroMoviments;
                 llistaMovimentsMaxims.append(movimentsPosibles.value(j));
             }
             //desfem el moviment
             m_fitxes.value(moviment.value(0).toInt())->setEstat(1);
             m_fitxes.value(moviment.value(1).toInt())->setEstat(0);
             m_fitxes.value(moviment.value(2).toInt())->setEstat(0);
         }//else p_tipusMoviment != 2
     }//for
  return llistaMovimentsMaxims;
 }

 /*
   Per el moviment passat per paràmetre, comprova si hi ha
   moviments posteriors
   */
 bool Tauler::solucionaJocActual_CalculaMovimentsPosteriors(QString moviment){
         int numeroMoviments=0;
         //Primer "simulam" el moviment
         QStringList fitxes=QStringList(moviment.split(" "));
      if (p_tipusMoviment != 2){
         m_fitxes.value(fitxes.value(0).toInt())->setEstat(0);
         m_fitxes.value(fitxes.value(1).toInt())->setEstat(0);
         m_fitxes.value(fitxes.value(2).toInt())->setEstat(1);
         //Ara calculam el número de moviments possibles amb aquesta situació
         numeroMoviments=solucionaJocActual_MovimentsPosiblesActuals();
         //desfem el moviment
         m_fitxes.value(fitxes.value(0).toInt())->setEstat(1);
         m_fitxes.value(fitxes.value(1).toInt())->setEstat(1);
         m_fitxes.value(fitxes.value(2).toInt())->setEstat(0);}
      else {
         m_fitxes.value(fitxes.value(0).toInt())->setEstat(0);
         m_fitxes.value(fitxes.value(1).toInt())->setEstat(1);
         m_fitxes.value(fitxes.value(2).toInt())->setEstat(1);
         //Ara calculam el número de moviments possibles amb aquesta situació
         numeroMoviments=solucionaJocActual_MovimentsPosiblesActuals();
         //desfem el moviment
         m_fitxes.value(fitxes.value(0).toInt())->setEstat(1);
         m_fitxes.value(fitxes.value(1).toInt())->setEstat(0);
         m_fitxes.value(fitxes.value(2).toInt())->setEstat(0);}
 return numeroMoviments>0;
 }

 int Tauler::solucionaJocActual_MovimentsPosiblesActuals(){ 
    QHashIterator <int, Fitxa*> iterator_fitxes(m_fitxes);
    QStringList itemsArbre; //tots els moviments possibles

    int movimentsPosibles=0;
    int numeroFitxesActives=0;
      while (iterator_fitxes.hasNext()) {
          iterator_fitxes.next();
        int index_fitxaInicial=iterator_fitxes.value()->coordenades().x()*100+iterator_fitxes.value()->coordenades().y();
        //només comprovam les fitxes actives
       if ( m_fitxes.value(index_fitxaInicial)->estat()==1){
        ++numeroFitxesActives;
        for(int j=0 ; j<iterator_fitxes.value()->movimentsPossibles.count();++j){
            int index_fitxaBotada=iterator_fitxes.value()->movimentsPossibles.at(j).x();
            int index_fitxaFinal=iterator_fitxes.value()->movimentsPossibles.at(j).y();
            if (   (m_fitxes.value(index_fitxaBotada)->estat()==p_estatFitxaMitjana) &&
                (m_fitxes.value(index_fitxaFinal)->estat()==0) ){
                ++movimentsPosibles;                
               }
           } //for
        }//if inicial estat==1
      }

 //Comprovam si estem al final del joc
  //    qDebug("numeroDeMovimentsJoc()+1= %d",numeroDeMovimentsJoc()+1);
 if( (numeroFitxesActives==1) &&  (p_tipusMoviment != 2) ){movimentsPosibles=1;}
 else if ( (numeroFitxesActives==numeroDeMovimentsJoc()+1) ){movimentsPosibles=1;}
  return movimentsPosibles;
 }

 /*
   Comprova si hi ha alguna fitxa "aïllada"
   o sigui fitxes en estat 1 que no tenen cap moviment
   que es pugui fer efectiu o be cap moviment en què
   la fitxa mitjancera pugui passar a estat 1 desprès d'un moviment
   */
 bool Tauler::solucionaJocActual_FitxesAillades(){

     int nivellAillamentFitxes=0;
     int numeroFitxesAillades=0;
     QHashIterator <int, Fitxa*> iterator_fitxes(m_fitxes);
     QString moviments;
     while ( iterator_fitxes.hasNext() ){
        iterator_fitxes.next();
        int index_fitxaInicial=iterator_fitxes.value()->coordenades().x()*100+iterator_fitxes.value()->coordenades().y();
        moviments.clear();
        //Només poden estar "aïllades" les fitxes actives
        //Tampoc pot estar aïllada una fitxa que és la mitjana d'un moviment posible
        if( (m_fitxes.value(index_fitxaInicial)->estat()==1) &&
            ( !(movimentPosibleFitxaMitjana(index_fitxaInicial))  )  ){
        for(int j=0 ; j<iterator_fitxes.value()->movimentsPossibles.count();++j){
            int index_fitxaBotada=iterator_fitxes.value()->movimentsPossibles.at(j).x();
            //fitxa activa amb fitxa mitjana en estat que permet el bot
            if (  (m_fitxes.value(index_fitxaInicial)->estat()==1) &&
                  (m_fitxes.value(index_fitxaBotada)->estat()==p_estatFitxaMitjana)  ){
                moviments.append("1"); break;}
            if (  (m_fitxes.value(index_fitxaInicial)->estat()==1) &&
                (m_fitxes.value(index_fitxaBotada)->estat() != p_estatFitxaMitjana)  ){
                //Cal mirar si la fitxa botada es el final d'un moviment possible
                if ( (! movimentPosibleFitxaFinal(index_fitxaBotada)) ){
                       moviments.append("0");
                }
                else {moviments.append("1"); break;}
            }
          }

        if ( !(moviments.contains("1"))  ){
            m_fitxes.value(index_fitxaInicial)->setFixaAillada(true);
            if (m_fitxes.value(index_fitxaInicial)->nivellAillament()==1){
                numeroFitxesAillades=numeroFitxesAillades+1;}
        }
        else m_fitxes.value(index_fitxaInicial)->setFixaAillada(false);
      }
     else m_fitxes.value(index_fitxaInicial)->setFixaAillada(false);

    nivellAillamentFitxes=nivellAillamentFitxes+m_fitxes.value(index_fitxaInicial)->nivellAillament();
    }
return  (numeroFitxesAillades>p_numFitxesAillades);
 }

 /*
   Comprova si hi ha algun moviment posible que tengui com a fitxa final
   la fitxa passada per paràmetre
   */
 bool Tauler::movimentPosibleFitxaFinal(int fitxaMijana){
  bool resultat=false;
 QHashIterator <int, Fitxa*> iterator_fitxes(m_fitxes);

      while (iterator_fitxes.hasNext() && (! resultat) ) {
        iterator_fitxes.next();
        int index_fitxaInicial=iterator_fitxes.value()->coordenades().x()*100+iterator_fitxes.value()->coordenades().y();
        for(int j=0 ; j<iterator_fitxes.value()->movimentsPossibles.count();++j){
             if  (resultat){break;}
            int index_fitxaBotada=iterator_fitxes.value()->movimentsPossibles.at(j).x();
            int index_fitxaFinal=iterator_fitxes.value()->movimentsPossibles.at(j).y();
            if (  (m_fitxes.value(index_fitxaInicial)->estat()==1) &&
                (m_fitxes.value(index_fitxaBotada)->estat()==p_estatFitxaMitjana) &&
                ( index_fitxaFinal==fitxaMijana) ){
                resultat=true;
               }
            //miram si la fitxa botada és el final d'un moviment posible
            else if (  (m_fitxes.value(index_fitxaInicial)->estat()==1) &&
                !(m_fitxes.value(index_fitxaBotada)->estat()==p_estatFitxaMitjana) &&
                ( index_fitxaFinal==fitxaMijana) ){
                 if (movimentPosibleFitxaFinal1(index_fitxaBotada) ) {
                resultat=true;}
               }
            }
        }
  return resultat;
 }

 bool Tauler::movimentPosibleFitxaFinal1(int fitxaMijana){
  bool resultat=false;
  QHashIterator <int, Fitxa*> iterator_fitxes(m_fitxes);

      while (iterator_fitxes.hasNext() && (! resultat) ) {
        iterator_fitxes.next();
        int index_fitxaInicial=iterator_fitxes.value()->coordenades().x()*100+iterator_fitxes.value()->coordenades().y();
        for(int j=0 ; j<iterator_fitxes.value()->movimentsPossibles.count();++j){
             if  (resultat){break;}
            int index_fitxaBotada=iterator_fitxes.value()->movimentsPossibles.at(j).x();
            int index_fitxaFinal=iterator_fitxes.value()->movimentsPossibles.at(j).y();
            if (  (m_fitxes.value(index_fitxaInicial)->estat()==1) &&
                (m_fitxes.value(index_fitxaBotada)->estat()==p_estatFitxaMitjana) &&
                ( index_fitxaFinal==fitxaMijana) ){
                resultat=true;
               }
            }
        }
  return resultat;
 }


 /*
   Comprova si hi ha algun moviment possible que tengui la fitxa
   passada per paràmetre com a fitxa botada
   */
 bool Tauler::movimentPosibleFitxaMitjana(int fitxaMitjana){
     bool resultat=false;
     QHashIterator <int, Fitxa*> iterator_fitxes(m_fitxes);

      while (iterator_fitxes.hasNext() && (! resultat)) {
        iterator_fitxes.next();
        int index_fitxaInicial=iterator_fitxes.value()->coordenades().x()*100+iterator_fitxes.value()->coordenades().y();
        for(int j=0 ; j<iterator_fitxes.value()->movimentsPossibles.count();++j){
            if  (resultat){break;}
            int index_fitxaBotada=iterator_fitxes.value()->movimentsPossibles.at(j).x();
            //int index_fitxaFinal=iterator_fitxes.value()->movimentsPossibles.at(j).y();
            if (  (m_fitxes.value(index_fitxaInicial)->estat()==1) &&
                (m_fitxes.value(index_fitxaBotada)->estat()==p_estatFitxaMitjana) &&
                ( index_fitxaBotada==fitxaMitjana) ){
                resultat=true;
               }
            }
        }
  return resultat;
 }

 /*
   No es da servir
   Determina si la posició central

 bool Tauler::movimentFitxaCentral(){
     //QPoint(3,3);
     bool resultat=false;
     int fitxaCentral=303;
     QHashIterator <int, Fitxa*> iterator_fitxes(m_fitxes);
      while (iterator_fitxes.hasNext() && !resultat ) {
        iterator_fitxes.next();
        int index_fitxaInicial=iterator_fitxes.value()->coordenades().x()*100+iterator_fitxes.value()->coordenades().y();
        for(int j=0 ; j<iterator_fitxes.value()->movimentsPossibles.count();++j){            
            int index_fitxaBotada=iterator_fitxes.value()->movimentsPossibles.at(j).x();
            if (  (m_fitxes.value(index_fitxaInicial)->estat()==1) &&
                (m_fitxes.value(index_fitxaBotada)->estat()==p_estatFitxaMitjana) &&
                fitxaCentral==iterator_fitxes.value()->movimentsPossibles.at(j).y() ){
             //   qDebug("fitxa central SI");
                resultat= true;
               }
            }
        }
// qDebug("fitxa central NO");
return resultat;
 }
 */

 void Tauler::eliminaFitxesVermelles(){
    QHashIterator <int, Fitxa*> i(m_fitxes);
    while (i.hasNext()) {
        i.next();
        if (i.value()->estat()==5){
            i.value()->setEstat(1);
        }
     }
}

 QString Tauler::configuracioActual(bool comptarFitxes){
     QHashIterator <int, Fitxa*> i(m_fitxes);
     QString configuracioActual;
     if (comptarFitxes){comptadorFitxesJoc=0;}
        while (i.hasNext()) {
              i.next();
              configuracioActual.append(QString("%1").arg((i.value()->estat())));
              if ( (comptarFitxes) && (i.value()->estat()==1) ){++comptadorFitxesJoc;}
          }
return configuracioActual;
 }

 //Carrega la configuració passada
 void Tauler::carregaConfiguracio(QString configuracio){
     QHashIterator <int, Fitxa*> i(m_fitxes);
     int contador=0;
     while (i.hasNext()) {
              i.next();
              QString valor=configuracio.at(contador);
              i.value()->setEstat(valor.toInt());
              contador ++;
          }
 }

 /*
Canvia l'estat de les fitxes a l'atzar
Es fa servir quan el joc està en pausa
*/
void Tauler::estatFitxesAtzar(){
    qsrand(QTime::currentTime().msec());
     QHashIterator <int, Fitxa*> i(m_fitxes);
     while (i.hasNext()) {
              i.next();
              i.value()->setEstat(qrand() % 5);
          }
 }

 /*
   Retorna el número de moviments que cal fer en el joc
   */
 int Tauler::numeroDeMovimentsJoc(){
     if (p_tipusMoviment !=2){return comptadorFitxesJoc-1;}
     else {
        return m_fitxes.count() - comptadorFitxesJoc-1;
     }
 }

 /*
   Retorna el missatge del número de moviments realitzats i el total
   No es fa servir

 QString Tauler::missatgeNumeroMoviments(){
    return QString(tr("Moviment %1 de %2 ")).arg(p_movimentsUndoStack->index()).arg(numeroDeMovimentsJoc());
 }
 */

 void Tauler::setEstatDelJoc(EstatsDelJoc valor){
     if(p_estatDelJoc != valor){
      p_estatDelJoc=valor;
    }
 }
