/*
  pdb2dhl, pdb2epk:  Convert PDB files to dihedral angle/ECEPPAK input file format
  Copyright (C) 2002  Farokh Jamalyaria

  This program is free software; you can redistribute it and/or
  modify it under the terms of the GNU General Public License
  as published by the Free Software Foundation; either version 2
  of the License, or (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

  Author's contact information:
  Farokh Jamalyaria, farokhj@yahoo.com
  9 Commons Lobby G222
  College Station, TX 77840
*/

/* An instance of this class would be used to handle one 'ATOM' line
   of a PDB file.

   Note: The current implementation of the class does not read some fields
   of an 'ATOM' line. Instead, it assigns default values to them. I have left
   variable placeholders and empty/commented-out functions for anyone who
   wishes to read/manipulate all fields of an 'ATOM' line.  The unread fields
   are irrelevant to this application.
*/

#ifndef PDB_LINE_H
#define PDB_LINE_H

#include <iostream>
#include <fstream>
#include <iomanip>
#include <cstdlib>
#include <cstring>
#include <cstdio>
#include "Format.h"

const int PDB_LINE_SIZE=86;
const int BL_ARRAY_SIZE=7;

class Pdb_line{
public:
  Pdb_line();

  ~Pdb_line();

  /*
    char* get_header() const;
    int get_atnum() const;
  */
  char* get_atname() const;
  char get_altloc() const;  
  char* get_resname() const;
  /*char get_chainid() const; */
  int get_resnum() const;
  /*char get_icode() const; */
  double get_x() const;
  double get_y() const;
  double get_z() const;
  /*
    double get_occup() const;
    double get_bfac() const;
    int get_bl_count(int) const;
    char* get_segid() const; 
    char* get_element() const;
    int get_charge() const; 
  */

  /*
    void set_header(char*);
    void set_atnum(int);
  */
  void set_atname(char*);
  void set_altloc(char);
  void set_resname(char*);
  /*void set_chainid(char); */
  void set_resnum(int);
  /*void set_icode(char); */
  void set_x(double);
  void set_y(double);
  void set_z(double);
  /*
    void set_occup(double);
    void set_bfac(double);
    void set_bl_count(int, int);
    void set_segid(char*);
    void set_element(char*);
    void set_charge(int);
  */

  bool read_file(ifstream&, char*);
  void write_pdb_file(ofstream&);
  void extract_str(char*,char*,int,int,int,int,bool);
  /*
    void make_blanks(int);
    void set_pos_bl_count(char, double);
    void chp_blnk(int);
  */
  static int fline_to_str(ifstream&, char*, int);

  /*Pdb_line& operator=(Pdb_line&); */

private:
  static Format gen3;                   // Allows writing to 3 digits past decimal.
  static Format gen2;                   // Allows writing to 2 digits past decimal.

  int* bl_count;                        // Keeps track of padding for fields that need it.
  /*
    char* header;
    int atnum;
  */
  char* atname;
  char altloc;
  char* resname;
  /*char chainid; */
  int resnum;
  /*char icode; */
  double x,y,z;
  /*
    double occup,bfac;

    char* new_pos_str;                  // Holds char* representation of a double.
    char* blanks;                       // Holds necessary padding for 1 field at a time.

    char* segid;
    char* element;
    int charge;
  */
};

#endif
