/*
  pdb2dhl, pdb2epk:  Convert PDB files to dihedral angle/ECEPPAK input file format
  Copyright (C) 2002  Farokh Jamalyaria

  This program is free software; you can redistribute it and/or
  modify it under the terms of the GNU General Public License
  as published by the Free Software Foundation; either version 2
  of the License, or (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

  Author's contact information:
  Farokh Jamalyaria, farokhj@yahoo.com
  9 Commons Lobby G222
  College Station, TX 77840
*/

#ifndef PDB_DHL2_H
#define PDB_DHL2_H

#include "Pdb_line.h"
#include<map>

/* chiA.cpp's function prototypes */

void chi_ala(Pdb_line* memfile,
	     map<string, int>& m,
	     double* chi,
	     int* chicnt,
	     double* x, double* y, double* z);

void chi_gly(int* chicnt);

void chi_val(Pdb_line* memfile,
	     map<string, int>& m,
	     double* chi,
	     int* chicnt,
	     double* x, double* y, double* z);

void chi_trp(Pdb_line* memfile,
	     map<string, int>& m,
	     double* chi,
	     int* chicnt,
	     double* x, double* y, double* z);

void chi_ser(Pdb_line* memfile,
	     map<string, int>& m,
	     double* chi,
	     int* chicnt,
	     double* x, double* y, double* z);

void chi_thr(Pdb_line* memfile,
	     map<string, int>& m,
	     double* chi,
	     int* chicnt,
	     double* x, double* y, double* z);

void chi_lys(Pdb_line* memfile,
	     map<string, int>& m,
	     double* chi,
	     int* chicnt,
	     double* x, double* y, double* z);

void chi_leu(Pdb_line* memfile,
	     map<string, int>& m,
	     double* chi,
	     int* chicnt,
	     double* x, double* y, double* z);

void chi_ile(Pdb_line* memfile,
	     map<string, int>& m,
	     double* chi,
	     int* chicnt,
	     double* x, double* y, double* z);

/* Now for chiB.cpp's function prototypes */

void chi_asn(Pdb_line* memfile,
	     map<string, int>& m,
	     double* chi,
	     int* chicnt,
	     double* x, double* y, double* z);

void chi_gln(Pdb_line* memfile,
	     map<string, int>& m,
	     double* chi,
	     int* chicnt,
	     double* x, double* y, double* z);

void chi_arg(Pdb_line* memfile,
	     map<string, int>& m,
	     double* chi,
	     int* chicnt,
	     double* x, double* y, double* z);

void chi_met(Pdb_line* memfile,
	     map<string, int>& m,
	     double* chi,
	     int* chicnt,
	     double* x, double* y, double* z);

void chi_pro(int* chicnt);

void chi_phe(Pdb_line* memfile,
	     map<string, int>& m,
	     double* chi,
	     int* chicnt,
	     double* x, double* y, double* z);

void chi_tyr(Pdb_line* memfile,
	     map<string, int>& m,
	     double* chi,
	     int* chicnt,
	     double* x, double* y, double* z);

void chi_cys(Pdb_line* memfile,
	     map<string, int>& m,
	     double* chi,
	     int* chicnt,
	     double* x, double* y, double* z);

void chi_his(Pdb_line* memfile,
	     map<string, int>& m,
	     double* chi,
	     int* chicnt,
	     double* x, double* y, double* z);

void chi_asp(Pdb_line* memfile,
	     map<string, int>& m,
	     double* chi,
	     int* chicnt,
	     double* x, double* y, double* z);

void chi_glu(Pdb_line* memfile,
	     map<string, int>& m,
	     double* chi,
	     int* chicnt,
	     double* x, double* y, double* z);

/* ppo_endgrp.cpp's prototypes: */

void NnoH(Pdb_line* memfile,
	  map<string, int>& m0, map<string, int>& m1, map<string, int>& m2,
	  double* ppo,
	  double* x, double* y, double* z);

void NH3(Pdb_line* memfile,
	 map<string, int>& m0, map<string, int>& m1, map<string, int>& m2,
	 double* ppo,
	 double* x, double* y, double* z);

void COOH(Pdb_line* memfile,
	  map<string, int>& m0, map<string, int>& m1, map<string, int>& m2,
	  double* ppo,
	  double* x, double* y, double* z);

#endif
