# Changes of Note

- PDAL now requires at least version 2.2 of GDAL.
- Pipelines can optionally be specified as an array of stages (without an encapsulating "pipeline" object).
- The location of installed cmake files has been changed to match the cmake convention.
- `filters.delaunay` now uses the delaunator library instead of geogram.
- PDAL no longer depends on the GEOS library. However, some polygon functions will not work if PDAL isn't built with a version of the GDAL library that has GEOS support.
- PDAL now uses the standard cmake script to locate the necessary GDAL files when building.
- `readers.sbet` now reads angles as degrees rather than radians. (#2354)
- The `tindex` command now requires one of the subcommands `create` or `merge`.  It no longer accepts the `merge` option, which has been replaced by the `merge` subcommand.
- The argument for the function `PipelineManager::executeStream` is now of type `StreamPointTable&` instead of `FixedPointTable&`.

# Enhancements

- All readers now accept the `default_srs` and `override_srs` options.  `override_srs` is an alias for the existing `spatialreference` option.  `default_srs` applies only if no spatial reference exists in the source file. (#2194, #2195)
- Added some dimension detection capability to `readers.pts`. (#2317)
- Hardened API use of LASzip in `writers.las` for points with data format 6 and above and set the extended_point_type variable. (#2320, #2329)
-
# Changes of Note

- PDAL now requires at least version 2.2 of GDAL.
- Pipelines can optionally be specified as an array of stages (without an encapsulating "pipeline" object).
- The location of installed cmake files has been changed to match the cmake convention.
- `filters.delaunay` now uses the delaunator library instead of geogram.
- PDAL no longer depends on the GEOS library. However, some polygon functions will not work if PDAL isn't built with a version of the GDAL library that has GEOS support.
- PDAL now uses the standard cmake script to locate the necessary GDAL files when building.
- `readers.sbet` now reads angles as degrees rather than radians. (#2354)
- The `tindex` command now requires one of the subcommands `create` or `merge`.  It no longer accepts the `merge` option, which has been replaced by the `merge` subcommand.
- The argument for the function `PipelineManager::executeStream` is now of type `StreamPointTable&` instead of `FixedPointTable&`.

# Enhancements

- All readers now accept the `default_srs` and `override_srs` options.  `override_srs` is an alias for the existing `spatialreference` option.  `default_srs` applies only if no spatial reference exists in the source file. (#2194, #2195)
- Added some dimension detection capability to `readers.pts`. (#2317)
- The build system now has enhanced conflict detection of mixed python 2/3 installations.  Make sure that you have header files/libraries/interpreter/numpy support for either python 2 or python 3.
- Hardened API use of LASzip in `writers.las` for points with data format 6 and above and set the extended_point_type variable. (#2320, #2329)
- Support the `libgeotiff` path suffix when searching for the geotiff library with cmake.
- Added a `resolution` option to `readers.ept` to limit the number of points read. (#2331)
- `readers.rxp` now supports stream mode.
- Added the `invert` option to `filters.head` and `filters.tail`.
- Added support for subcommands in kernels. (#2293)

# New stages

- `filters.mongo` - Filtering of points using the mongo expression language.
- `readers.tiledb` - Reads points from the tileDB database.
- `writers.tiledb` - Writes points to the tileDB database.
- `writers.ept_addon` - Adds sidecar data to an existing EPT dataset.

# Deprecated stages

- `filters.kdistance` - Replaced by `filters.nndistance`.  `filters.kdistance` will be removed in the next PDAL release.
- `filters.mongus` - Replaces by `filters.pmf` and `filters.smrf`

# Bug fixes

- The tindex command now uses sufficient precision when using the `fast_boundary` option (#2271)
- `filters.smrf` and `filters.pmf` now process all points if the `NumberOfReturns` or `ReturnNumber` dimension is missing.  This fixes a regression introduced with PDAL 1.8. (#2275)
- The density command is now found by pdal.  This fixes a regression introduced with PDAL 1.8. (#2378)
- The `scale=auto` and `offset=auto` options now work with `writers.bpf` in stream mode. (#1983)
- Pipelines with diamond shapes now properly re-execute ancestor stages.  This fixes a regression introduced with PDAL 1.8. (#2290)
- `filters.crop` now uses the correct logic when the `outside` option is used in standard mode. (#2305)
- A bug in `writers.gdal` with streaming mode that caused an improper location shift in some instances has been fixed. (#2292)
- Added an explicit dependency on the arbiter library for curl.  This fixes build issues on some Unix platforms. (#1822)
- Fixed a bug in `filters.icp` introduced by a change in PCL (see: https://github.com/PointCloudLibrary/pcl/issues/2724) that improperly removed a function call. (#2319)
- `readers.tindex` now provides a default of "EPSG:4326" for the `filter_srs` option.  (#2316)
- Points in buffer corners are now properly placed in tiles in `filters.splitter`. (#2372)
- Fixed reference counting in `filters.python` that might have caused a crash in some circumstances.
- Generalized the python library re-loaded by PDAL when being used as a python extension.  This is only relevant on some Unix distributions.
- Support the `libgeotiff` path suffix when searching for the geotiff library with cmake.
- Added a `resolution` option to `readers.ept` to limit the number of points read. (#2331)
- `readers.rxp` now supports stream mode.
- Added the `invert` option to `filters.head` and `filters.tail`.
- Added support for subcommands in kernels. (#2293)
- Fixed a bug in `writers.gdal` that might access invalid memory in some situations. (#2448)

# New stages

- `filters.mongo` - Filtering of points using the mongo expression language.
- `readers.tiledb` - Reads points from the tileDB database.
- `writers.tiledb` - Writes points to the tileDB database.
- `writers.ept_addon` - Adds sidecar data to an existing EPT dataset.

# Deprecated stages

- `filters.kdistance` - Replaced by `filters.nndistance`.  `filters.kdistance` will be removed in the next PDAL release.
- `filters.mongus` - Replaces by `filters.pmf` and `filters.smrf`

# Bug fixes

- The tindex command now uses sufficient precision when using the `fast_boundary` option (#2271)
- `filters.smrf` and `filters.pmf` now process all points if the `NumberOfReturns` or `ReturnNumber` dimension is missing.  This fixes a regression introduced with PDAL 1.8. (#2275)
- The density command is now found by pdal.  This fixes a regression introduced with PDAL 1.8. (#2378)
- The `scale=auto` and `offset=auto` options now work with `writers.bpf` in stream mode. (#1983)
- Pipelines with diamond shapes now properly re-execute ancestor stages.  This fixes a regression introduced with PDAL 1.8. (#2290)
- `filters.crop` now uses the correct logic when the `outside` option is used in standard mode. (#2305)
- A bug in `writers.gdal` with streaming mode that caused an improper location shift in some instances has been fixed. (#2292)
- Added an explicit dependency on the arbiter library for curl.  This fixes build issues on some Unix platforms. (#1822)
- Fixed a bug in `filters.icp` introduced by a change in PCL (see: https://github.com/PointCloudLibrary/pcl/issues/2724) that improperly removed a function call. (#2319)
- `readers.tindex` now provides a default of "EPSG:4326" for the `filter_srs` option.  (#2316)
- Points in buffer corners are now properly placed in tiles in `filters.splitter`. (#2372)
- Fixed reference counting in `filters.python` that might have caused a crash in some circumstances.
- Generalized the python library re-loaded by PDAL when being used as a python extension.  This is only relevant on some Unix distributions.
