# Changes of Note
- GeoTIFF is now required to compile PDAL
- `--scale` and `--offset` kernel options are no longer supported. Specify using stage-specific options as needed.
- The `--validate` option of the `pdal pipeline` command now invokes the preparation portion of the pipeline to force validation of options.
- The `--verbose` option to `pdal` now accepts log level names ("Error", "Warning", "Info", "Debug", "Debug1", "Debug2", "Debug3", "Debug4" and "Debug5") in addition to the corresponding numeric values (0 - 8).

# Enhancements

## New filters
- [`filters.colorinterp`](http://pdal.io/stages/filters.colorinterp.html) - Ramp RGB colors based on a specified dimension. By @hobu
- [`filters.mad`](http://pdal.io/stages/filters.mad.html) - Filter outliers in a given dimension by computing Median Absolute Deviation (MAD). By @chambbj
- [`filters.lof`](http://pdal.io/stages/filters.lof.html) -Filters outliers by Local Outlier Factor (LOF). By @chambbj
- [`filters.estimaterank`](http://pdal.io/stages/filters.estimaterank.html) - Estimate rank of each neighborhood of k-nearest neighbors. By @chambbj
- [`filters.eigenvalues`](http://pdal.io/stages/filters.eigenvalues.html) - Compute pointwise Eigenvalues. By @chambbj
- [`filters.iqr`](http://pdal/io/stages/filters.iqr.html) - Filter outliers in a given dimension by computing Interquartile Range (IQR). By @chambbj
- [`filters.kdistance`](http://pdal.io/stages/filters.kdistance.html) - Compute pointwise K-distance. By @chambbj
- [`filters.radialdensity`](http://pdal.io/stages/filters.radialdensity.html) - Compute pointwise radial density. By @chambbj
- [`filters.outlier`](http://pdal.io/stages/filters.outlier.html) - Radius and statistical outliers. By @chambbj

## New writers
- [`writers.gdal`](http://pdal.io/stages/writers.gdal.html) - [points2grid](http://github.com/crrel/points2grid) replacement. By @abellgithub

## New kernels
- [`kernels.hausdorff`](http://pdal.io/apps/hausdorff.html) - Compute [Hausdorff distance](https://en.wikipedia.org/wiki/Hausdorff_distance) between two point clouds. By @chambbj

## Improvements
- [Filename globbing](http://man7.org/linux/man-pages/man7/glob.7.html) is now supported in the JSON pipeline specification of reader input files.  Note that tilde expansion is NOT supported.
- Source tree reorganization https://lists.osgeo.org/pipermail/pdal/2016-December/001099.html
- CMake updates to utilize `target_include_directory` and `target_link_libraries`.
- JSON output for `pdal --showjson --drivers` and `pdal --showjson --options` to support application builders being able to fetch active lists of stages, kernels, and options. https://github.com/PDAL/PDAL/issues/1315
- Stacktrace logging to stderr on Unix systems https://github.com/PDAL/PDAL/pull/1329
- Geometry ingestion enhancements now support using [GeoJSON](http://geojson.org) or WKT in pipeline options https://github.com/PDAL/PDAL/pull/1339.
- Significant Python extension refactor https://github.com/PDAL/PDAL/pull/1367 including ability to fetch data schema, log, and pipeline information. Common utility classes to support the Python extension were refactored in support of the Java extension.
- Java extension by [Azavea](https://www.azavea.com/) to support using PDAL in [Spark](http://spark.apache.org/) and friends. https://github.com/PDAL/PDAL/pull/1371
- [`kernels.density`](http://pdal.io/stages/kernels.density.html) - Density kernel now supports writing into an existing OGR datasource https://github.com/PDAL/PDAL/pull/1396
- [`readers.greyhound`](http://pdal.io/stages/readers.greyhound.html) - Greyhound reader refactor.
  - Multi-threaded read support
  - Server-side filtering pass-through
- [`writers.derivative`](http://pdal.io/stages/writers.derivative.html) - Derivative writer refactor.
  - `slope_d8`
  - `slope_fd`
  - `aspect_d8`
  - `aspect_fd`
  - `contour_curvature`
  - `profile_curvature`
  - `tangential_curvature`
  - `hillshade`
  - `total_curvature`
  - Output to any GDAL-writable format https://github.com/PDAL/PDAL/issues/1146
- [`filters.crop`](http://pdal.io/stages/filters.crop.html) - Radial cropping https://github.com/PDAL/PDAL/issues/1387
- [`filters.stats`](http://pdal.io/stages/filters.stats.html) - Optional per-dimension median and MAD computation
- Support was added for the recently added cartesian coordinate in BPF files.
- [`writers.p2g`](http://pdal.io/stages/writers.p2g.html) now uses the InCoreInterp method of the points2grid code.  This uses more memory but runs faster and doesn't crash.
- The application now provides better error feedback on command-line errors by indicating the invoked kernel when an error is detected.
- PDAL now searches by default in the following locations for plugins: `"." "./lib", "../lib", "./bin", "../bin"`. Use `PDAL_DRIVER_PATH` to explicitly override the plugin search location.
- Vector-based command-line arguments now accept default values in the API.
- JSON parsing errors of pipeline files now provide more detailed messages.
- Writers now add output filenames to metadata.
- Stage names provided as input to other stages in pipelines can now be specified as strings or arrays of strings.  The previous version required single input stage names to be placed in an array.
- Added `--smooth` option to [`filters.hexbin`](http://pdal.io/stages/filters.hexbin.html) to allow user control of boundary smoothing.

## Bug fixes
- Well-known text provided as a spatial reference isn't interpreted by GDAL unless necessary.
- [`filters.hexbin`](http://pdal.io/stages/filters.hexbin.html) now returns `MULTIPOLYGON EMPTY` when it is unable to compute a boundary.
- Reading a not a number (nan) value from a text file now works properly.
- The `--compression` option for [`writers.pcd`](http://pdal.io/stages/writers.pcd.html) has been fixed so that the writer actually compresses as requested.
- The stage manager (and hence, pipelines) now properly recognizes the text reader as [`readers.text`](http://pdal.io/stages/readers.text.html).
- [`readers.text`](http://pdal.io/stages/readers.text.html) now detects the case when a dimension has been specified more than once in an input file.
- Fixed a problem where [`filters.splitter`](http://pdal.io/stages/filters.splitter.html) could create cells larger than requested about the X and Y axes.
- [`writers.nitf`](http://pdal.io/stages/writers.nitf.html) now errors if it attempts to write an FTITLE field that exceeds the allowable length.
- If PDAL is build with LAZperf but without LASzip, the program now properly defaults to using LAZperf.
- Fixed a problem where [`filters.sort`](http://pdal.io/stages/filters.sort.html) could fail to properly order points depending on the implementation of the C++ sort algorithm.
- Fixed a problem in pgpostgres readers and writers where a failure in a query could lead to a crash.

