//SCAD

module line_segment_r(length, width, thickness, x, y, a, bd, c1, c2) {
	translate([x,y,0]) rotate ([0,0,a]) union() {
		if (bd) {cube ([length, width,thickness],true);}
		if (c2) {translate([length/2.,0,0]) cylinder(h=thickness, r=width/2,center=true,$fn=30);}
		if (c1) { translate([-length/2.,0,0]) cylinder(h=thickness, r=width/2,center=true,$fn=30);}
	}
}

module line_segment(length, width, thickness, x, y, a) {
	translate([x,y,0]) rotate ([0,0,a]) {
		cube ([length, width,thickness],true);
	}
}

// START_OF_LAYER: topsilk
module layer_topsilk_body (offset) {
translate ([0, 0, offset]) union () {
	line_segment_r(0.762000,0.177800,0.037500,1.270000,-1.270000,90.000000,1,1,1);
	line_segment_r(0.310046,0.177800,0.037500,1.358900,-0.762000,-124.992020,1,1,1);
	line_segment_r(0.279400,0.177800,0.037500,1.587500,-0.635000,180.000000,1,1,1);
	line_segment_r(0.310046,0.177800,0.037500,1.816100,-0.762000,124.992020,1,1,1);
	line_segment_r(0.762000,0.177800,0.037500,1.905000,-1.270000,90.000000,1,1,1);
	line_segment_r(0.635000,0.177800,0.037500,1.587500,-1.143000,180.000000,1,1,1);
	line_segment_r(0.287368,0.177800,0.037500,2.311401,-0.736600,-135.000000,1,1,1);
	line_segment_r(1.016000,0.177800,0.037500,2.413001,-1.143000,90.000000,1,1,1);
	line_segment_r(0.381000,0.177800,0.037500,2.400301,-1.651000,180.000000,1,1,1);
	line_segment_r(0.076200,0.177800,0.037500,1.270000,-5.143500,90.000000,1,1,1);
	line_segment_r(0.031005,0.177800,0.037500,1.278890,-5.092700,-124.992020,1,1,1);
	line_segment_r(0.027940,0.177800,0.037500,1.301750,-5.080000,180.000000,1,1,1);
	line_segment_r(0.031005,0.177800,0.037500,1.324610,-5.092700,124.992020,1,1,1);
	line_segment_r(0.076200,0.177800,0.037500,1.333500,-5.143500,90.000000,1,1,1);
	line_segment_r(0.063500,0.177800,0.037500,1.301750,-5.130800,180.000000,1,1,1);
	line_segment_r(0.017961,0.177800,0.037500,1.370330,-5.086350,-135.000000,1,1,1);
	line_segment_r(0.038100,0.177800,0.037500,1.395730,-5.080000,180.000000,1,1,1);
	line_segment_r(0.017961,0.177800,0.037500,1.421130,-5.086350,135.000000,1,1,1);
	line_segment_r(0.025400,0.177800,0.037500,1.427480,-5.105400,90.000000,1,1,1);
	line_segment_r(0.089803,0.177800,0.037500,1.395730,-5.149850,-135.000000,1,1,1);
	line_segment_r(0.063500,0.177800,0.037500,1.395730,-5.181600,180.000000,1,1,1);
	line_segment_r(2.438400,0.325120,0.037500,1.270000,-9.652000,90.000000,1,1,1);
	line_segment_r(0.992149,0.325120,0.037500,1.554480,-8.026400,-124.992020,1,1,1);
	line_segment_r(0.894080,0.325120,0.037500,2.286000,-7.620000,180.000000,1,1,1);
	line_segment_r(0.992149,0.325120,0.037500,3.017520,-8.026400,124.992020,1,1,1);
	line_segment_r(2.438400,0.325120,0.037500,3.302000,-9.652000,90.000000,1,1,1);
	line_segment_r(2.032000,0.325120,0.037500,2.286000,-9.245600,180.000000,1,1,1);
	line_segment_r(0.574736,0.325120,0.037500,4.480563,-7.823200,-135.000000,1,1,1);
	line_segment_r(0.812800,0.325120,0.037500,5.090163,-7.620000,180.000000,1,1,1);
	line_segment_r(0.574736,0.325120,0.037500,5.699763,-7.823200,135.000000,1,1,1);
	line_segment_r(0.574736,0.325120,0.037500,5.699763,-10.668000,-135.000000,1,1,1);
	line_segment_r(0.812800,0.325120,0.037500,5.090163,-10.871200,180.000000,1,1,1);
	line_segment_r(0.574736,0.325120,0.037500,4.480563,-10.668000,135.000000,1,1,1);
	line_segment_r(0.812800,0.325120,0.037500,5.090163,-9.083040,180.000000,1,1,1);
	line_segment_r(0.650240,0.325120,0.037500,5.902963,-8.351520,90.000000,1,1,1);
	line_segment_r(0.975360,0.325120,0.037500,5.902963,-9.977120,90.000000,1,1,1);
	line_segment_r(0.574736,0.325120,0.037500,5.699763,-9.286240,-45.000000,1,1,1);
	line_segment_r(0.574736,0.325120,0.037500,5.699763,-8.879840,45.000000,1,1,1);
}
}


// END_OF_LAYER layer_topsilk

// START_OF_LAYER: bottomsilk
module layer_bottomsilk_body (offset) {
translate ([0, 0, offset]) union () {
}
}


// END_OF_LAYER layer_bottomsilk

module board_outline () {
	polygon([[0,0],[0,-12.700000],[12.700000,-12.700000],[12.700000,0]],
[[0,1,2,3]]);
}

module all_holes() {
	plating=0.017500;
	union () {
		for (i = layer_pdrill_list) {
			translate([i[1][0],i[1][1],0]) cylinder(r=i[0]+2*plating, h=1.770000, center=true, $fn=30);
		}
		for (i = layer_udrill_list) {
			translate([i[1][0],i[1][1],0]) cylinder(r=i[0], h=1.770000, center=true, $fn=30);
		}
	}
}

module board_body() {
	translate ([0, 0, -0.800000]) linear_extrude(height=1.600000) board_outline();}

/***************************************************/
/*                                                 */
/* Components                                      */
/*                                                 */
/***************************************************/
module all_components() {
}

/***************************************************/
/*                                                 */
/* Final board assembly                            */
/* Here is the complete board built from           */
/* pre-generated modules                           */
/*                                                 */
/***************************************************/
		color ([1, 1, 1])
			layer_topsilk_body(0.818750);

		color ([1, 1, 1])
			layer_bottomsilk_body(-0.818750);

		color ([0.44, 0.44, 0])
			difference() {
				board_body();
				all_holes();
			}

		all_components();
// END_OF_BOARD
