Summary:	Parallel implementation of bzip2
Name:		pbzip2
Version:	0.9.2
Release:	1
Vendor:		Jeff Gilchrist <pbzip2@compression.ca>
URL:		http://www.compression.ca/pbzip2/
License:	BSD
Packager:	Bryan Stillwell <bryan@bokeoa.com>
Group:		Applications/File
BuildRoot:	%{_tmppath}/%{name}-%{version}-%{release}-root
BuildRequires:	tar, gzip, make, gcc-c++, bzip2-devel
Requires:	glibc, libstdc++, libgcc, bzip2-libs
Source0:	http://www.compression.ca/pbzip2/%{name}-%{version}.tar.gz

%description
PBZIP2 is a parallel implementation of the bzip2 block-sorting file
compressor that uses pthreads and achieves near-linear speedup on SMP
machines.


%prep
[ "%{buildroot}" != "/" ] && [ -d %{buildroot} ] && rm -rf %{buildroot}
%setup -q


%build
make


%install
install -D -m755 %{name} %{buildroot}%{_prefix}/bin/%{name}


%clean
[ "%{buildroot}" != "/" ] && [ -d %{buildroot} ] && rm -rf %{buildroot}


%files
%defattr(-, root, root)
%doc LICENSE.txt README.txt
%attr(0755,root,root) %{_prefix}/bin/%{name}


%changelog
* Sat Mar 12 2005 Jeff Gilchrist <pbzip2@compression.ca>
- Created workaround for a major pthreads problem (on Linux at least) that would cause segfaults and missed signals in the pthreads, Increased size of BZIP2 header match from 56 bits to 72 bits for more accurate detection, Modified some buffers to use the vector class for easier memory management and to eliminate one read pass of the input data for decompression so should be slightly faster, Now checks if input file exists before checking if output file already exists (when not using -f), Now checks to ensure input is regular file and not a directory before processing, Now deletes input file only if output file exists and is greater than 0 bytes (-k will always preserve input file), Now checks input file for bzip2 header before trying to decompress file, Minor code cleanup
* Sat Jan 29 2005 Jeff Gilchrist <pbzip2@compression.ca>
- Fixed bug: -c switch now implies -k so input file is not deleted when data is output to stdout
* Sun Jan 24 2005 Jeff Gilchrist <pbzip2@compression.ca>
- Added -c switch for data output to stdout, Added -t switch to test integrity of compressed data, Added autodetection for # of CPUs on supported platforms and made detected value default # CPUs to use, Fixed bug where pbzip2 processed 0 byte files, Tried to make program exit codes the same as bzip2
* Sun Jan 9 2005 Jeff Gilchrist <pbzip2@compression.ca>
- Added support to maintain file metadata, added signal handling to cleanup partial files, added support to process multiple files
* Mon Nov 30 2004 Jeff Gilchrist <pbzip2@compression.ca>
- Added support for large (2GB+) files, added version info, made command line input more like bzip2, now checks if file is already .bz2 first
* Sat Nov 27 2004 Jeff Gilchrist <pbzip2@compression.ca>
- Fix pthread bug, now works on OSF1, code cleanup
* Thu Oct 28 2004 Bryan Stillwell <bryan@bokeoa.com>
- Initial packaging
