#include <arpa/inet.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <netdb.h>
#include <stdlib.h>
#include <stdio.h>
#include <string.h>

int main(int ac, char**av) {
	int i;
	struct addrinfo *res, *rp;
	struct addrinfo hints;
	char host[NI_MAXHOST];
	char serv[NI_MAXSERV];
	int e;

	memset(&hints, 0, sizeof(struct addrinfo));
	hints.ai_family = AF_UNSPEC;
	hints.ai_socktype = SOCK_STREAM;
	for(i=1;i<ac;i++) {
		res=NULL;
		if((e=getaddrinfo(av[i], 0, &hints, &res))) {
			printf("Error on %s: %s\n", av[i], gai_strerror(e));
		} else {
			for(rp=res; rp != NULL; rp = rp->ai_next) {
				getnameinfo(rp->ai_addr, rp->ai_addrlen, host, NI_MAXHOST, serv, NI_MAXSERV, NI_NUMERICHOST);
				printf("%s\n", host);
			}
		}
		if(res)freeaddrinfo(res);
	}
	return 0;
}
