# Copyright (C) 2001-2009, Parrot Foundation.
# $Id: signal.pm 47318 2010-06-03 01:36:45Z jkeenan $

=head1 NAME

config/auto/signal.pm - Signals

=head1 DESCRIPTION

Determines some signal stuff.

=cut

package auto::signal;

use strict;
use warnings;

use base qw(Parrot::Configure::Step);

use Parrot::Configure::Utils ':auto';


sub _init {
    my $self = shift;
    my %data;
    $data{description} = q{Determine some signal stuff};
    $data{result}      = q{};
    return \%data;
}

sub runstep {
    my ( $self, $conf ) = @_;

    $conf->data->set(
        has___sighandler_t => undef,
        has_sigatomic_t    => undef,
        has_sigaction      => undef,
        has_setitimer      => undef
    );

    $conf->cc_gen('config/auto/signal/test1_c.in');
    eval { $conf->cc_build(); };
    unless ( $@ || $conf->cc_run() !~ /ok/ ) {
        _handle__sighandler_t($conf);
    }
    $conf->cc_clean();

    $conf->cc_gen('config/auto/signal/test2_c.in');
    eval { $conf->cc_build(); };
    unless ( $@ || $conf->cc_run() !~ /ok/ ) {
        _handle_sigaction($conf);
    }
    $conf->cc_clean();

    $conf->cc_gen('config/auto/signal/test_itimer_c.in');
    eval { $conf->cc_build(); };
    unless ( $@ || $conf->cc_run() !~ /ok/ ) {
        _handle_setitimer($conf);
    }
    $conf->cc_clean();

    # now generate signal constants
    my $signalpasm = "runtime/parrot/include/signal.pasm";
    _print_signalpasm($conf, $signalpasm);

    return 1;
}

sub _handle__sighandler_t {
    my ($conf) = @_;
    $conf->data->set( has___sighandler_t => 'define' );
    $conf->debug(" (__sighandler_t)");
    return 1;
}

sub _handle_sigaction {
    my ($conf) = @_;
    $conf->data->set( has_sigaction => 'define' );
    $conf->debug(" (sigaction)");
    return 1;
}

sub _handle_setitimer {
    my ($conf) = @_;
    $conf->data->set(
        has_setitimer    => 'define',
        has_sig_atomic_t => 'define',
    );
    $conf->debug(" (setitimer) ");
    return 1;
}

sub _print_signalpasm {
    my ($conf, $signalpasm) = @_;
    open my $O, ">", $signalpasm
        or die "Cant write $signalpasm";
    print {$O} <<"EOF";
# DO NOT EDIT THIS FILE.
#
# This file is generated automatically by config/auto/signal.pm
#
# Any changes made here will be lost.
#
EOF
    my ( $i, $name );
    $i = 0;
    foreach $name ( split( ' ', $conf->data->get('sig_name_provisional') ) ) {
        print {$O} ".macro_const SIG$name\t$i\n" if $i;
        $i++;
    }
    close $O;
}

1;

# Local Variables:
#   mode: cperl
#   cperl-indent-level: 4
#   fill-column: 100
# End:
# vim: expandtab shiftwidth=4:
