/*****************************************************************************
*
* Copyright (c) 2000 - 2010, Lawrence Livermore National Security, LLC
* Produced at the Lawrence Livermore National Laboratory
* LLNL-CODE-400124
* All rights reserved.
*
* This file is  part of VisIt. For  details, see https://visit.llnl.gov/.  The
* full copyright notice is contained in the file COPYRIGHT located at the root
* of the VisIt distribution or at http://www.llnl.gov/visit/copyright.html.
*
* Redistribution  and  use  in  source  and  binary  forms,  with  or  without
* modification, are permitted provided that the following conditions are met:
*
*  - Redistributions of  source code must  retain the above  copyright notice,
*    this list of conditions and the disclaimer below.
*  - Redistributions in binary form must reproduce the above copyright notice,
*    this  list of  conditions  and  the  disclaimer (as noted below)  in  the
*    documentation and/or other materials provided with the distribution.
*  - Neither the name of  the LLNS/LLNL nor the names of  its contributors may
*    be used to endorse or promote products derived from this software without
*    specific prior written permission.
*
* THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT  HOLDERS AND CONTRIBUTORS "AS IS"
* AND ANY EXPRESS OR  IMPLIED WARRANTIES, INCLUDING,  BUT NOT  LIMITED TO, THE
* IMPLIED WARRANTIES OF MERCHANTABILITY AND  FITNESS FOR A PARTICULAR  PURPOSE
* ARE  DISCLAIMED. IN  NO EVENT  SHALL LAWRENCE  LIVERMORE NATIONAL  SECURITY,
* LLC, THE  U.S.  DEPARTMENT OF  ENERGY  OR  CONTRIBUTORS BE  LIABLE  FOR  ANY
* DIRECT,  INDIRECT,   INCIDENTAL,   SPECIAL,   EXEMPLARY,  OR   CONSEQUENTIAL
* DAMAGES (INCLUDING, BUT NOT  LIMITED TO, PROCUREMENT OF  SUBSTITUTE GOODS OR
* SERVICES; LOSS OF  USE, DATA, OR PROFITS; OR  BUSINESS INTERRUPTION) HOWEVER
* CAUSED  AND  ON  ANY  THEORY  OF  LIABILITY,  WHETHER  IN  CONTRACT,  STRICT
* LIABILITY, OR TORT  (INCLUDING NEGLIGENCE OR OTHERWISE)  ARISING IN ANY  WAY
* OUT OF THE  USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
* DAMAGE.
*
*****************************************************************************/

#include <EngineList.h>
#include <DataNode.h>

// Type map format string
const char *EngineList::TypeMapFormatString = "s*i*i*i*s*";

// ****************************************************************************
// Method: EngineList::EngineList
//
// Purpose: 
//   Constructor for the EngineList class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

EngineList::EngineList() : 
    AttributeSubject(EngineList::TypeMapFormatString)
{
}

// ****************************************************************************
// Method: EngineList::EngineList
//
// Purpose: 
//   Copy constructor for the EngineList class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

EngineList::EngineList(const EngineList &obj) : 
    AttributeSubject(EngineList::TypeMapFormatString)
{
    engines = obj.engines;
    numProcessors = obj.numProcessors;
    numNodes = obj.numNodes;
    loadBalancing = obj.loadBalancing;
    simulationName = obj.simulationName;

    SelectAll();
}

// ****************************************************************************
// Method: EngineList::~EngineList
//
// Purpose: 
//   Destructor for the EngineList class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

EngineList::~EngineList()
{
    // nothing here
}

// ****************************************************************************
// Method: EngineList::operator = 
//
// Purpose: 
//   Assignment operator for the EngineList class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

EngineList& 
EngineList::operator = (const EngineList &obj)
{
    if (this == &obj) return *this;
    engines = obj.engines;
    numProcessors = obj.numProcessors;
    numNodes = obj.numNodes;
    loadBalancing = obj.loadBalancing;
    simulationName = obj.simulationName;

    SelectAll();
    return *this;
}

// ****************************************************************************
// Method: EngineList::operator == 
//
// Purpose: 
//   Comparison operator == for the EngineList class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

bool
EngineList::operator == (const EngineList &obj) const
{
    // Create the return value
    return ((engines == obj.engines) &&
            (numProcessors == obj.numProcessors) &&
            (numNodes == obj.numNodes) &&
            (loadBalancing == obj.loadBalancing) &&
            (simulationName == obj.simulationName));
}

// ****************************************************************************
// Method: EngineList::operator != 
//
// Purpose: 
//   Comparison operator != for the EngineList class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

bool
EngineList::operator != (const EngineList &obj) const
{
    return !(this->operator == (obj));
}

// ****************************************************************************
// Method: EngineList::TypeName
//
// Purpose: 
//   Type name method for the EngineList class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

const std::string
EngineList::TypeName() const
{
    return "EngineList";
}

// ****************************************************************************
// Method: EngineList::CopyAttributes
//
// Purpose: 
//   CopyAttributes method for the EngineList class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

bool
EngineList::CopyAttributes(const AttributeGroup *atts)
{
    if(TypeName() != atts->TypeName())
        return false;

    // Call assignment operator.
    const EngineList *tmp = (const EngineList *)atts;
    *this = *tmp;

    return true;
}

// ****************************************************************************
// Method: EngineList::CreateCompatible
//
// Purpose: 
//   CreateCompatible method for the EngineList class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

AttributeSubject *
EngineList::CreateCompatible(const std::string &tname) const
{
    AttributeSubject *retval = 0;
    if(TypeName() == tname)
        retval = new EngineList(*this);
    // Other cases could go here too. 

    return retval;
}

// ****************************************************************************
// Method: EngineList::NewInstance
//
// Purpose: 
//   NewInstance method for the EngineList class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

AttributeSubject *
EngineList::NewInstance(bool copy) const
{
    AttributeSubject *retval = 0;
    if(copy)
        retval = new EngineList(*this);
    else
        retval = new EngineList;

    return retval;
}

// ****************************************************************************
// Method: EngineList::SelectAll
//
// Purpose: 
//   Selects all attributes.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

void
EngineList::SelectAll()
{
    Select(ID_engines,        (void *)&engines);
    Select(ID_numProcessors,  (void *)&numProcessors);
    Select(ID_numNodes,       (void *)&numNodes);
    Select(ID_loadBalancing,  (void *)&loadBalancing);
    Select(ID_simulationName, (void *)&simulationName);
}

///////////////////////////////////////////////////////////////////////////////
// Persistence methods
///////////////////////////////////////////////////////////////////////////////

// ****************************************************************************
// Method: EngineList::CreateNode
//
// Purpose: 
//   This method creates a DataNode representation of the object so it can be saved to a config file.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

bool
EngineList::CreateNode(DataNode *parentNode, bool completeSave, bool forceAdd)
{
    if(parentNode == 0)
        return false;

    EngineList defaultObject;
    bool addToParent = false;
    // Create a node for EngineList.
    DataNode *node = new DataNode("EngineList");

    if(completeSave || !FieldsEqual(ID_engines, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("engines", engines));
    }

    if(completeSave || !FieldsEqual(ID_numProcessors, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("numProcessors", numProcessors));
    }

    if(completeSave || !FieldsEqual(ID_numNodes, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("numNodes", numNodes));
    }

    if(completeSave || !FieldsEqual(ID_loadBalancing, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("loadBalancing", loadBalancing));
    }

    if(completeSave || !FieldsEqual(ID_simulationName, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("simulationName", simulationName));
    }


    // Add the node to the parent node.
    if(addToParent || forceAdd)
        parentNode->AddNode(node);
    else
        delete node;

    return (addToParent || forceAdd);
}

// ****************************************************************************
// Method: EngineList::SetFromNode
//
// Purpose: 
//   This method sets attributes in this object from values in a DataNode representation of the object.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

void
EngineList::SetFromNode(DataNode *parentNode)
{
    if(parentNode == 0)
        return;

    DataNode *searchNode = parentNode->GetNode("EngineList");
    if(searchNode == 0)
        return;

    DataNode *node;
    if((node = searchNode->GetNode("engines")) != 0)
        SetEngines(node->AsStringVector());
    if((node = searchNode->GetNode("numProcessors")) != 0)
        SetNumProcessors(node->AsIntVector());
    if((node = searchNode->GetNode("numNodes")) != 0)
        SetNumNodes(node->AsIntVector());
    if((node = searchNode->GetNode("loadBalancing")) != 0)
        SetLoadBalancing(node->AsIntVector());
    if((node = searchNode->GetNode("simulationName")) != 0)
        SetSimulationName(node->AsStringVector());
}

///////////////////////////////////////////////////////////////////////////////
// Set property methods
///////////////////////////////////////////////////////////////////////////////

void
EngineList::SetEngines(const stringVector &engines_)
{
    engines = engines_;
    Select(ID_engines, (void *)&engines);
}

void
EngineList::SetNumProcessors(const intVector &numProcessors_)
{
    numProcessors = numProcessors_;
    Select(ID_numProcessors, (void *)&numProcessors);
}

void
EngineList::SetNumNodes(const intVector &numNodes_)
{
    numNodes = numNodes_;
    Select(ID_numNodes, (void *)&numNodes);
}

void
EngineList::SetLoadBalancing(const intVector &loadBalancing_)
{
    loadBalancing = loadBalancing_;
    Select(ID_loadBalancing, (void *)&loadBalancing);
}

void
EngineList::SetSimulationName(const stringVector &simulationName_)
{
    simulationName = simulationName_;
    Select(ID_simulationName, (void *)&simulationName);
}

///////////////////////////////////////////////////////////////////////////////
// Get property methods
///////////////////////////////////////////////////////////////////////////////

const stringVector &
EngineList::GetEngines() const
{
    return engines;
}

stringVector &
EngineList::GetEngines()
{
    return engines;
}

const intVector &
EngineList::GetNumProcessors() const
{
    return numProcessors;
}

intVector &
EngineList::GetNumProcessors()
{
    return numProcessors;
}

const intVector &
EngineList::GetNumNodes() const
{
    return numNodes;
}

intVector &
EngineList::GetNumNodes()
{
    return numNodes;
}

const intVector &
EngineList::GetLoadBalancing() const
{
    return loadBalancing;
}

intVector &
EngineList::GetLoadBalancing()
{
    return loadBalancing;
}

const stringVector &
EngineList::GetSimulationName() const
{
    return simulationName;
}

stringVector &
EngineList::GetSimulationName()
{
    return simulationName;
}

///////////////////////////////////////////////////////////////////////////////
// Select property methods
///////////////////////////////////////////////////////////////////////////////

void
EngineList::SelectEngines()
{
    Select(ID_engines, (void *)&engines);
}

void
EngineList::SelectNumProcessors()
{
    Select(ID_numProcessors, (void *)&numProcessors);
}

void
EngineList::SelectNumNodes()
{
    Select(ID_numNodes, (void *)&numNodes);
}

void
EngineList::SelectLoadBalancing()
{
    Select(ID_loadBalancing, (void *)&loadBalancing);
}

void
EngineList::SelectSimulationName()
{
    Select(ID_simulationName, (void *)&simulationName);
}

///////////////////////////////////////////////////////////////////////////////
// Keyframing methods
///////////////////////////////////////////////////////////////////////////////

// ****************************************************************************
// Method: EngineList::GetFieldName
//
// Purpose: 
//   This method returns the name of a field given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

std::string
EngineList::GetFieldName(int index) const
{
    switch (index)
    {
    case ID_engines:        return "engines";
    case ID_numProcessors:  return "numProcessors";
    case ID_numNodes:       return "numNodes";
    case ID_loadBalancing:  return "loadBalancing";
    case ID_simulationName: return "simulationName";
    default:  return "invalid index";
    }
}

// ****************************************************************************
// Method: EngineList::GetFieldType
//
// Purpose: 
//   This method returns the type of a field given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

AttributeGroup::FieldType
EngineList::GetFieldType(int index) const
{
    switch (index)
    {
    case ID_engines:        return FieldType_stringVector;
    case ID_numProcessors:  return FieldType_intVector;
    case ID_numNodes:       return FieldType_intVector;
    case ID_loadBalancing:  return FieldType_intVector;
    case ID_simulationName: return FieldType_stringVector;
    default:  return FieldType_unknown;
    }
}

// ****************************************************************************
// Method: EngineList::GetFieldTypeName
//
// Purpose: 
//   This method returns the name of a field type given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

std::string
EngineList::GetFieldTypeName(int index) const
{
    switch (index)
    {
    case ID_engines:        return "stringVector";
    case ID_numProcessors:  return "intVector";
    case ID_numNodes:       return "intVector";
    case ID_loadBalancing:  return "intVector";
    case ID_simulationName: return "stringVector";
    default:  return "invalid index";
    }
}

// ****************************************************************************
// Method: EngineList::FieldsEqual
//
// Purpose: 
//   This method compares two fields and return true if they are equal.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

bool
EngineList::FieldsEqual(int index_, const AttributeGroup *rhs) const
{
    const EngineList &obj = *((const EngineList*)rhs);
    bool retval = false;
    switch (index_)
    {
    case ID_engines:
        {  // new scope
        retval = (engines == obj.engines);
        }
        break;
    case ID_numProcessors:
        {  // new scope
        retval = (numProcessors == obj.numProcessors);
        }
        break;
    case ID_numNodes:
        {  // new scope
        retval = (numNodes == obj.numNodes);
        }
        break;
    case ID_loadBalancing:
        {  // new scope
        retval = (loadBalancing == obj.loadBalancing);
        }
        break;
    case ID_simulationName:
        {  // new scope
        retval = (simulationName == obj.simulationName);
        }
        break;
    default: retval = false;
    }

    return retval;
}

///////////////////////////////////////////////////////////////////////////////
// User-defined methods.
///////////////////////////////////////////////////////////////////////////////

