/*
 * Copyright (c) 2014 Google Inc. All rights reserved
 * Contributed by Stephane Eranian <eranian@gmail.com>
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies
 * of the Software, and to permit persons to whom the Software is furnished to do so,
 * subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED,
 * INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
 * PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT
 * HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF
 * CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE
 * OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 *
 * This file is part of libpfm, a performance monitoring support library for
 * applications on Linux.
 *
 * PMU: hswep_unc_pcu (Intel Haswell-EP PCU uncore)
 */

static const intel_x86_umask_t hswep_unc_p_power_state_occupancy[]={
  { .uname = "CORES_C0",
    .udesc  = "Counts number of cores in C0",
    .ucode  = 0x4000,
    .uflags = INTEL_X86_NCOMBO,
  },
  { .uname = "CORES_C3",
    .udesc  = "Counts number of cores in C3",
    .ucode  = 0x8000,
    .uflags = INTEL_X86_NCOMBO,
  },
  { .uname = "CORES_C6",
    .udesc  = "Counts number of cores in C6",
    .ucode  = 0xc000,
    .uflags = INTEL_X86_NCOMBO,
  },
};

static const intel_x86_umask_t hswep_unc_p_occupancy_counters[]={
  { .uname = "C0",
    .udesc  = "Counts number of cores in C0",
    .ucode  = 0x0100,
    .uflags = INTEL_X86_NCOMBO,
  },
  { .uname = "C3",
    .udesc  = "Counts number of cores in C3",
    .ucode  = 0x0200,
    .uflags = INTEL_X86_NCOMBO,
  },
  { .uname = "C6",
    .udesc  = "Counts number of cores in C6",
    .ucode  = 0x0300,
    .uflags = INTEL_X86_NCOMBO,
  },
};

static const intel_x86_entry_t intel_hswep_unc_p_pe[]={
  { .name   = "UNC_P_CLOCKTICKS",
    .desc   = "PCU Uncore clockticks",
    .modmsk = HSWEP_UNC_PCU_ATTRS,
    .cntmsk = 0xf,
    .code = 0x00,
  },
  { .name = "UNC_P_CORE0_TRANSITION_CYCLES",
    .desc = "Core 0 C State Transition Cycles",
    .code = 0x60,
    .cntmsk = 0xf,
    .modmsk = HSWEP_UNC_PCU_ATTRS,
  },
  { .name = "UNC_P_CORE1_TRANSITION_CYCLES",
    .desc = "Core 1 C State Transition Cycles",
    .code = 0x61,
    .cntmsk = 0xf,
    .modmsk = HSWEP_UNC_PCU_ATTRS,
  },
  { .name = "UNC_P_CORE2_TRANSITION_CYCLES",
    .desc = "Core 2 C State Transition Cycles",
    .code = 0x62,
    .cntmsk = 0xf,
    .modmsk = HSWEP_UNC_PCU_ATTRS,
  },
  { .name = "UNC_P_CORE3_TRANSITION_CYCLES",
    .desc = "Core 3 C State Transition Cycles",
    .code = 0x63,
    .cntmsk = 0xf,
    .modmsk = HSWEP_UNC_PCU_ATTRS,
  },
  { .name = "UNC_P_CORE4_TRANSITION_CYCLES",
    .desc = "Core 4 C State Transition Cycles",
    .code = 0x64,
    .cntmsk = 0xf,
    .modmsk = HSWEP_UNC_PCU_ATTRS,
  },
  { .name = "UNC_P_CORE5_TRANSITION_CYCLES",
    .desc = "Core 5 C State Transition Cycles",
    .code = 0x65,
    .cntmsk = 0xf,
    .modmsk = HSWEP_UNC_PCU_ATTRS,
  },
  { .name = "UNC_P_CORE6_TRANSITION_CYCLES",
    .desc = "Core 6 C State Transition Cycles",
    .code = 0x66,
    .cntmsk = 0xf,
    .modmsk = HSWEP_UNC_PCU_ATTRS,
  },
  { .name = "UNC_P_CORE7_TRANSITION_CYCLES",
    .desc = "Core 7 C State Transition Cycles",
    .code = 0x67,
    .cntmsk = 0xf,
    .modmsk = HSWEP_UNC_PCU_ATTRS,
  },
  { .name = "UNC_P_CORE8_TRANSITION_CYCLES",
    .desc = "Core 8 C State Transition Cycles",
    .code = 0x68,
    .cntmsk = 0xf,
    .modmsk = HSWEP_UNC_PCU_ATTRS,
  },
  { .name = "UNC_P_CORE9_TRANSITION_CYCLES",
    .desc = "Core 9 C State Transition Cycles",
    .code = 0x69,
    .cntmsk = 0xf,
    .modmsk = HSWEP_UNC_PCU_ATTRS,
  },
  { .name = "UNC_P_CORE10_TRANSITION_CYCLES",
    .desc = "Core 10 C State Transition Cycles",
    .code = 0x6a,
    .cntmsk = 0xf,
    .modmsk = HSWEP_UNC_PCU_ATTRS,
  },
  { .name = "UNC_P_CORE11_TRANSITION_CYCLES",
    .desc = "Core 11 C State Transition Cycles",
    .code = 0x6b,
    .cntmsk = 0xf,
    .modmsk = HSWEP_UNC_PCU_ATTRS,
  },
  { .name = "UNC_P_CORE12_TRANSITION_CYCLES",
    .desc = "Core 12 C State Transition Cycles",
    .code = 0x6c,
    .cntmsk = 0xf,
    .modmsk = HSWEP_UNC_PCU_ATTRS,
  },
  { .name = "UNC_P_CORE13_TRANSITION_CYCLES",
    .desc = "Core 13 C State Transition Cycles",
    .code = 0x6d,
    .cntmsk = 0xf,
    .modmsk = HSWEP_UNC_PCU_ATTRS,
  },
  { .name = "UNC_P_CORE14_TRANSITION_CYCLES",
    .desc = "Core 14 C State Transition Cycles",
    .code = 0x6e,
    .cntmsk = 0xf,
    .modmsk = HSWEP_UNC_PCU_ATTRS,
  },
  { .name = "UNC_P_CORE15_TRANSITION_CYCLES",
    .desc = "Core 15 C State Transition Cycles",
    .code = 0x6f,
    .cntmsk = 0xf,
    .modmsk = HSWEP_UNC_PCU_ATTRS,
  },
  { .name = "UNC_P_CORE16_TRANSITION_CYCLES",
    .desc = "Core 16 C State Transition Cycles",
    .code = 0x70,
    .cntmsk = 0xf,
    .modmsk = HSWEP_UNC_PCU_ATTRS,
  },
  { .name = "UNC_P_CORE17_TRANSITION_CYCLES",
    .desc = "Core 17 C State Transition Cycles",
    .code = 0x71,
    .cntmsk = 0xf,
    .modmsk = HSWEP_UNC_PCU_ATTRS,
  },
  { .name = "UNC_P_DEMOTIONS_CORE0",
    .desc = "Core 0 C State Demotions",
    .code = 0x30,
    .cntmsk = 0xf,
    .modmsk = HSWEP_UNC_PCU_ATTRS,
  },
  { .name = "UNC_P_DEMOTIONS_CORE1",
    .desc = "Core 1 C State Demotions",
    .code = 0x31,
    .cntmsk = 0xf,
    .modmsk = HSWEP_UNC_PCU_ATTRS,
  },
  { .name = "UNC_P_DEMOTIONS_CORE2",
    .desc = "Core 2 C State Demotions",
    .code = 0x32,
    .cntmsk = 0xf,
    .modmsk = HSWEP_UNC_PCU_ATTRS,
  },
  { .name = "UNC_P_DEMOTIONS_CORE3",
    .desc = "Core 3 C State Demotions",
    .code = 0x33,
    .cntmsk = 0xf,
    .modmsk = HSWEP_UNC_PCU_ATTRS,
  },
  { .name = "UNC_P_DEMOTIONS_CORE4",
    .desc = "Core 4 C State Demotions",
    .code = 0x34,
    .cntmsk = 0xf,
    .modmsk = HSWEP_UNC_PCU_ATTRS,
  },
  { .name = "UNC_P_DEMOTIONS_CORE5",
    .desc = "Core 5 C State Demotions",
    .code = 0x35,
    .cntmsk = 0xf,
    .modmsk = HSWEP_UNC_PCU_ATTRS,
  },
  { .name = "UNC_P_DEMOTIONS_CORE6",
    .desc = "Core 6 C State Demotions",
    .code = 0x36,
    .cntmsk = 0xf,
    .modmsk = HSWEP_UNC_PCU_ATTRS,
  },
  { .name = "UNC_P_DEMOTIONS_CORE7",
    .desc = "Core 7 C State Demotions",
    .code = 0x37,
    .cntmsk = 0xf,
    .modmsk = HSWEP_UNC_PCU_ATTRS,
  },
  { .name = "UNC_P_DEMOTIONS_CORE8",
    .desc = "Core 8 C State Demotions",
    .code = 0x38,
    .cntmsk = 0xf,
    .modmsk = HSWEP_UNC_PCU_ATTRS,
  },
  { .name = "UNC_P_DEMOTIONS_CORE9",
    .desc = "Core 9 C State Demotions",
    .code = 0x39,
    .cntmsk = 0xf,
    .modmsk = HSWEP_UNC_PCU_ATTRS,
  },
  { .name = "UNC_P_DEMOTIONS_CORE10",
    .desc = "Core 10 C State Demotions",
    .code = 0x3a,
    .cntmsk = 0xf,
    .modmsk = HSWEP_UNC_PCU_ATTRS,
  },
  { .name = "UNC_P_DEMOTIONS_CORE11",
    .desc = "Core 11 C State Demotions",
    .code = 0x3b,
    .cntmsk = 0xf,
    .modmsk = HSWEP_UNC_PCU_ATTRS,
  },
  { .name = "UNC_P_DEMOTIONS_CORE12",
    .desc = "Core 12 C State Demotions",
    .code = 0x3c,
    .cntmsk = 0xf,
    .modmsk = HSWEP_UNC_PCU_ATTRS,
  },
  { .name = "UNC_P_DEMOTIONS_CORE13",
    .desc = "Core 13 C State Demotions",
    .code = 0x3d,
    .cntmsk = 0xf,
    .modmsk = HSWEP_UNC_PCU_ATTRS,
  },
  { .name = "UNC_P_DEMOTIONS_CORE14",
    .desc = "Core 14 C State Demotions",
    .code = 0x3e,
    .cntmsk = 0xf,
    .modmsk = HSWEP_UNC_PCU_ATTRS,
  },
  { .name = "UNC_P_DEMOTIONS_CORE15",
    .desc = "Core 15 C State Demotions",
    .code = 0x3f,
    .cntmsk = 0xf,
    .modmsk = HSWEP_UNC_PCU_ATTRS,
  },
  { .name = "UNC_P_DEMOTIONS_CORE16",
    .desc = "Core 16 C State Demotions",
    .code = 0x40,
    .cntmsk = 0xf,
    .modmsk = HSWEP_UNC_PCU_ATTRS,
  },
  { .name = "UNC_P_DEMOTIONS_CORE17",
    .desc = "Core 17 C State Demotions",
    .code = 0x41,
    .cntmsk = 0xf,
    .modmsk = HSWEP_UNC_PCU_ATTRS,
  },
  { .name = "UNC_P_FREQ_BAND0_CYCLES",
    .desc = "Frequency Residency",
    .code = 0xb,
    .cntmsk = 0xf,
    .flags = INTEL_X86_NO_AUTOENCODE,
    .modmsk = HSWEP_UNC_PCU_BAND_ATTRS,
    .modmsk_req = _SNBEP_UNC_ATTR_FF,
  },
  { .name = "UNC_P_FREQ_BAND1_CYCLES",
    .desc = "Frequency Residency",
    .code = 0xc,
    .cntmsk = 0xf,
    .flags = INTEL_X86_NO_AUTOENCODE,
    .modmsk = HSWEP_UNC_PCU_BAND_ATTRS,
    .modmsk_req = _SNBEP_UNC_ATTR_FF,
  },
  { .name = "UNC_P_FREQ_BAND2_CYCLES",
    .desc = "Frequency Residency",
    .code = 0xd,
    .cntmsk = 0xf,
    .flags = INTEL_X86_NO_AUTOENCODE,
    .modmsk = HSWEP_UNC_PCU_BAND_ATTRS,
    .modmsk_req = _SNBEP_UNC_ATTR_FF,
  },
  { .name = "UNC_P_FREQ_BAND3_CYCLES",
    .desc = "Frequency Residency",
    .code = 0xe,
    .cntmsk = 0xf,
    .flags = INTEL_X86_NO_AUTOENCODE,
    .modmsk = HSWEP_UNC_PCU_BAND_ATTRS,
    .modmsk_req = _SNBEP_UNC_ATTR_FF,
  },
  { .name = "UNC_P_FREQ_MAX_LIMIT_THERMAL_CYCLES",
    .desc = "Thermal Strongest Upper Limit Cycles",
    .code = 0x4,
    .cntmsk = 0xf,
    .modmsk = HSWEP_UNC_PCU_ATTRS,
  },
  { .name = "UNC_P_FREQ_MAX_OS_CYCLES",
    .desc = "OS Strongest Upper Limit Cycles",
    .code = 0x6,
    .cntmsk = 0xf,
    .modmsk = HSWEP_UNC_PCU_ATTRS,
  },
  { .name = "UNC_P_FREQ_MAX_POWER_CYCLES",
    .desc = "Power Strongest Upper Limit Cycles",
    .code = 0x5,
    .cntmsk = 0xf,
    .modmsk = HSWEP_UNC_PCU_ATTRS,
  },
  { .name = "UNC_P_FREQ_MIN_IO_P_CYCLES",
    .desc = "IO P Limit Strongest Lower Limit Cycles",
    .code = 0x73,
    .cntmsk = 0xf,
    .modmsk = HSWEP_UNC_PCU_ATTRS,
  },
  { .name = "UNC_P_FREQ_TRANS_CYCLES",
    .desc = "Cycles spent changing Frequency",
    .code = 0x74,
    .cntmsk = 0xf,
    .modmsk = HSWEP_UNC_PCU_ATTRS,
  },
  { .name = "UNC_P_PKG_RESIDENCY_C0_CYCLES",
    .desc = "Package C State residency - C0",
    .code = 0x2a,
    .cntmsk = 0xf,
    .modmsk = HSWEP_UNC_PCU_ATTRS,
  },
  { .name = "UNC_P_PKG_RESIDENCY_C1E_CYCLES",
    .desc = "Package C State residency - C1E",
    .code = 0x4e,
    .cntmsk = 0xf,
    .modmsk = HSWEP_UNC_PCU_ATTRS,
  },
  { .name = "UNC_P_PKG_RESIDENCY_C2E_CYCLES",
    .desc = "Package C State residency - C2E",
    .code = 0x2b,
    .cntmsk = 0xf,
    .modmsk = HSWEP_UNC_PCU_ATTRS,
  },
  { .name = "UNC_P_PKG_RESIDENCY_C3_CYCLES",
    .desc = "Package C State residency - C3",
    .code = 0x2c,
    .cntmsk = 0xf,
    .modmsk = HSWEP_UNC_PCU_ATTRS,
  },
  { .name = "UNC_P_PKG_RESIDENCY_C6_CYCLES",
    .desc = "Package C State residency - C6",
    .code = 0x2d,
    .cntmsk = 0xf,
    .modmsk = HSWEP_UNC_PCU_ATTRS,
  },
  { .name = "UNC_P_PKG_RESIDENCY_C7_CYCLES",
    .desc = "Package C State residency - C7",
    .code = 0x2e,
    .cntmsk = 0xf,
    .modmsk = HSWEP_UNC_PCU_ATTRS,
  },
  { .name = "UNC_P_MEMORY_PHASE_SHEDDING_CYCLES",
    .desc = "Memory Phase Shedding Cycles",
    .code = 0x2f,
    .cntmsk = 0xf,
    .modmsk = HSWEP_UNC_PCU_ATTRS,
  },
  { .name = "UNC_P_POWER_STATE_OCCUPANCY",
    .desc = "Number of cores in C0",
    .code = 0x80,
    .cntmsk = 0xf,
    .ngrp = 1,
    .modmsk = HSWEP_UNC_PCU_ATTRS,
    .numasks = LIBPFM_ARRAY_SIZE(hswep_unc_p_power_state_occupancy),
    .umasks  = hswep_unc_p_power_state_occupancy
  },
  { .name = "UNC_P_PROCHOT_EXTERNAL_CYCLES",
    .desc = "External Prochot",
    .code = 0xa,
    .cntmsk = 0xf,
    .modmsk = HSWEP_UNC_PCU_ATTRS,
  },
  { .name = "UNC_P_PROCHOT_INTERNAL_CYCLES",
    .desc = "Internal Prochot",
    .code = 0x9,
    .cntmsk = 0xf,
    .modmsk = HSWEP_UNC_PCU_ATTRS,
  },
  { .name = "UNC_P_TOTAL_TRANSITION_CYCLES",
    .desc = "Total Core C State Transition Cycles",
    .code = 0x72,
    .cntmsk = 0xf,
    .modmsk = HSWEP_UNC_PCU_ATTRS,
  },
  { .name = "UNC_P_VR_HOT_CYCLES",
    .desc = "VR Hot",
    .code = 0x42,
    .cntmsk = 0xf,
    .modmsk = HSWEP_UNC_PCU_ATTRS,
  },
};
