#define DB_NAME "dbname=papayastats user=allenc"
//#define DB_NAME "dbname=papayastats host=penguin.lancs.ac.uk user=allenc"

#define WEIGHT_TABLE "weight"
#define GOLD_TABLE "gold"
#define EXP_TABLE "exp"
#define PRAC_TABLE "prac"
#define WAYPOINT_TABLE "waypoint"
#define STAT_TABLE "stat"
#define HP_TABLE "hp"
#define MANA_TABLE "mana"
#define MOVES_TABLE "moves"
#define RACE_TABLE "race"
#define CLASS_TABLE "class"

class PostgresQuery : public Plugin {

 public:

  PostgresQuery();
  ~PostgresQuery();

  int sendQuery(char *);
  void callback(Connection *, char *, void *);
  void groupCallback(Connection *, char *, void *);
  void onEvent(Event *, Connection *);
  void getInt(char *, regmatch_t *, int *, int);
  char * getUsername(Connection *);

 private:

  PgDatabase * connection;
  int checkConnection();
  int connect();

  void hp_match(char *, regmatch_t *, unsigned long, Connection *);
  void mana_match(char *, regmatch_t *, unsigned long, Connection *);
  void moves_match(char *, regmatch_t *, unsigned long, Connection *);
  void weight_match(char *, regmatch_t *, unsigned long, Connection *);
  void exp_match(char *, regmatch_t *, unsigned long, Connection *);
  void gold_match(char *, regmatch_t *, unsigned long, Connection *);
  void waypoint_match(char *, regmatch_t *, unsigned long, Connection *);
  void stat_match(char *, char *, regmatch_t *, unsigned long, Connection *);
  void name_match(char *, regmatch_t *);

  void getInts(char *, regmatch_t *, int *, int *);
  void getInts2(char *, regmatch_t *, int *, int *);
  
  void init_triggers();
  void cleanup_triggers();
  void init_regex();
  void cleanup_regex();

  regex_t str_regex;
  regex_t int_regex;
  regex_t wis_regex;
  regex_t dex_regex;
  regex_t con_regex;
  regex_t name_regex;

  regex_t weight_regex;
  regex_t exp_regex;
  regex_t gold_regex;
  regex_t waypoint_regex;
  regex_t class_regex;

  Trigger * exp_gain;
  Trigger * waypoint_gain;
  Trigger * quest_gain;

  Trigger * flee_loss;
  Trigger * flee_fail_loss;
  Trigger * recall_loss;
  Trigger * recall_fail_loss;
  Trigger * energy_drain_loss;
  Trigger * death_loss;

  Trigger * stat_gain;
  Trigger * stat_gain_no_prac;
  Trigger * stat_loss;
  Trigger * stat_loss_prac;

  Trigger * reconnected;
  Trigger * connected;
  
  char * username;

};
