#include <string.h>
#include <stdlib.h>
#include <ctype.h>
#include <sys/types.h>

#include "Win32PluginAPI.cpp"
#include "GrepFilter.h"

static GrepFilter * gf;

extern "C" G_MODULE_EXPORT void plugin_init(plugin_address_table_t * pat) {
	plugin_address_table_init(pat);
    gf = new GrepFilter();
}

extern "C" G_MODULE_EXPORT void plugin_cleanup(void) {
  delete gf;
}

#define MAJOR "1"
#define MINOR "1"

extern "C" G_MODULE_EXPORT char * plugin_query_name() {
  return "GrepFilter";
}

extern "C" G_MODULE_EXPORT char * plugin_query_description() {
  return _("Allows searching of results from a command to return only lines containing the search string.");
}

extern "C" G_MODULE_EXPORT char * plugin_query_major() {
  return MAJOR;
}

extern "C" G_MODULE_EXPORT char * plugin_query_minor() {
  return MINOR;
}

void GrepCallbackPtr(Connection * conn, char * buf, void * data) {

	if (!buf)
		free(data); // Last call of the callback.

	if (!buf || !data)
	    return;

	// Append this stuff to the VT if the data is in the string.
	if (strstr(buf, (char *)data))
		vt_append(connection_get_vt(conn), buf);

}

GrepFilter::GrepFilter() {
  version = 1.0;
  name = strdup("Grep Filter");

  register_plugin(this, VERSION);
  plugin_handler_add_input_filter(get_plugin_handler(), this);
}

GrepFilter::~GrepFilter() {
	unregister_plugin(this);
}

void GrepFilter::input(Connection * c, char * in) {

  char * buf = strdup(in);
  char * pc;
  char * look = buf;

  char command[16384];
  char * filter;
  char * filter_args;

  
  if (!turf_protocol_is_supported(c)) {
    free(buf);
    return;
  }

  while (1) {
    pc = strchr(look, '|');
    if (!pc) {
      free(buf);
      return;
    }
    
    if (*(pc-1) == '\\') {
      look = pc + 1;
      continue;
    }

    strncpy(command, buf, pc - buf);
    command[pc-buf] = '\0';

    filter = pc + 1;

    // Found a filter.  Check what type it is and handle it.
    while (*filter == ' ')
      filter++;

    // Attempt to locate the start of the filter arguments.
    filter_args = filter;
    while (!isspace(*filter_args))
      filter_args++;

    // Mark the end of the filter name.
    *filter_args = '\0';

    // Skip over the NUL.
    filter_args++;

    // Locate the first non-space character in the arguments.
    while (isspace(*filter_args))
      filter_args++;

    if (!strcasecmp(filter, "grep")) {

	  turf_protocol_add_command(c, command, (void *)GrepCallbackPtr, (gpointer)strdup(filter_args));
      // @@ Add to the echo if echo is set.
      free(buf);
      in[0] = '\0';
      return;
    }

    free(buf);
    return;
  }
}

char * GrepFilter::getDescription() {
  return "Execute a command and return only the lines containing specified text.";
}
