#include <string.h>
#include <stdlib.h>

#include "Room.h"

Room::Room(int i) {
  name = NULL;
  description = NULL;
  vnum = 0;
  setID(i);
  
  for (int i = 0; i < MAX_EXITS; i++)
    exits[i] = new Exit();

}

Room::~Room() {
  free(name);
  free(description);

  for (int i = 0; i < MAX_EXITS; i++)
    delete exits[i];
}

Room::Room(int i, int v, char * n, char * d) {
  name = NULL;
  description = NULL;

  setID(i);
  setVnum(v);
  setName(n);
  setDescription(d);
};

void Room::setID(int i) {
  id = i;
}

void Room::setVnum(int v) {
  vnum = v;
}

void Room::setName(char * n) {
  free(name);
  name = strdup(n);
}

void Room::setDescription(char * d) {
  free(d);
  description = strdup(d);
}

int Room::getID() {
  return id;
}

int Room::getVnum() {
  return vnum;
}

char * Room::getName() {
  return name;
}

char * Room::getDescription() {
  return description;
}

int Room::getX() {
  return x; 
}

int Room::getY() {
  return y;
}

int Room::getZ() {
  return z;
}

void Room::setLocation(int a, int b, int c) {
  x = a;
  y = b;
  z = c;
}

void Room::printRoom() {

  printf("Room ID %d (%d, %d, %d)\n", id, x, y, z);
  printf("\tVnum: %d.\n", vnum);
  printf("\tName: %s\n", name);
  printf("\tDesc: %s\n", description);

}

void Room::exportRoom(FILE * fp) {

  int radius = 250;
  int multiplier = 1000;

  for (int i = 0; i < MAX_EXITS; i++) {

    Exit * exit = exits[i];
    if (exit && exit->to) {
    // Draw a line from this location to the next location.
      fprintf(fp, "2 2 0 1 0 7 60 0 -1 0.000 0 0 -1 0 0 2\n");
      fprintf(fp, "\t%d %d %d %d\n",
	      (x + 10) * multiplier,
	      (y + 10) * multiplier,
	      (exit->to->getX() + 10) * multiplier,
	      (exit->to->getY() + 10) * multiplier
	      );
      
    }
  }

  fprintf(fp, "2 2 0 1 0 11 50 0 20 0.000 0 0 -1 0 0 5\n");
  fprintf(fp, "\t%d %d %d %d %d %d %d %d %d %d\n",
	  (x + 10) * multiplier - radius,
	  (y + 10) * multiplier - radius,
	  (x + 10) * multiplier + radius,
	  (y + 10) * multiplier - radius,
	  (x + 10) * multiplier + radius,
	  (y + 10) * multiplier + radius,
	  (x + 10) * multiplier - radius,
	  (y + 10) * multiplier + radius,
	  (x + 10) * multiplier - radius,
	  (y + 10) * multiplier - radius
	  );
}

/**
 * formatString might look something like:
 *
 * %n\n
 * [Exits: %e]\n
 * %s
 *
 * or maybe:
 * %n [%v]\n
 * [Exits: %E]\n
 * %s
 */

void Room::parseOutput(char * formatString, char * input) {

  int name_index = 0;
  int vnum_index = 0;
  int desc_index = 0;
  int exit_index = 0;
  int EXIT_index = 0;
  
  char buf[1024];

  if (strlen(input) == 0)
    return;

  char * fmt = (char *)malloc(strlen(formatString) * 2);
  memcpy(fmt, formatString, strlen(formatString) + 1);
  char * pc = fmt;

  int index = 1;

  // Find any %whatever codes and replace them with appropriate text and
  // set indexes as appropriate.

  replaceString(fmt, '.', "\\.");
  replaceString(fmt, '(', "\\(");
  replaceString(fmt, ')', "\\)");
  replaceString(fmt, '[', "\\[");
  replaceString(fmt, ']', "\\]");

  while (pc && *pc != '\0') {

    if (*pc == '%') {
      char * next = pc+1;
      if (*next != '\0') {

	switch (*next) {
	case 'n':
	  name_index = index;
	  break;

	case 'v':
	  vnum_index = index;
	  break;

	case 'd':
	  desc_index = index;
	  break;

	case 'e':
	  exit_index = index;
	  break;

	case 'E':
	  EXIT_index = index;
	  break;

	default:
	  printf("Unrecognised format code: %c.\n", *next);
	}

	// Make room for the (.*) matcher.
	memmove(pc+4, pc+2, strlen(pc+2)+1);
	memcpy(pc, "(.*)", 4);

	index++;
	pc+=4;
	continue;
      }
    }
    pc++;
  }

  regmatch_t match[10];
  regex_t regexp;

  printf("Format: %s\n", fmt);
  //  printf("Data  : %s\n", input); 

  regcomp(&regexp, fmt, REG_ICASE|REG_EXTENDED);
  if (regexec(&regexp, input, index, match, 0) == REG_NOMATCH) {
    printf("Incorrect room format.\n");
    regfree(&regexp);
    free(fmt);
    return;
  }

  if (vnum_index) {
    int length = match[vnum_index].rm_eo - match[vnum_index].rm_so;
    memcpy(buf, input + match[vnum_index].rm_so, length);
    buf[length] = '\0';
    setVnum(atoi(buf));
  }

  if (name_index) {
    getString(match, input, name_index, buf);
    setName(buf);
  }

  if (desc_index) {
    getString(match, input, desc_index, buf);
    setDescription(buf);
  }

  if (exit_index) {
    getString(match, input, exit_index, buf);
    // @@ Set exits.
  }

  if (EXIT_index) {
    getString(match, input, EXIT_index, buf);
    // @@ Set exits.
  }

  regfree(&regexp);
  free(fmt);
}

void Room::getString(regmatch_t * match, char * input, int index, char * buf) {
    int length = match[index].rm_eo - match[index].rm_so;
    memcpy(buf, input + match[index].rm_so, length);
    buf[length] = '\0';
}

void Room::replaceString(char * str, char c, char * rep) {
  // Replace all instances of 'c' with 'rep'.
  // This isn't as easy as it looks as 'str' may not be large enough!

  char * curr = str;
  char * pc;

  // abc?abc
  // abc(.)abc

  while ((pc = strchr(curr, c))) {
    memmove(pc + strlen(rep),pc + 1, strlen(pc+1) + 1);
    memcpy(pc, rep, strlen(rep));
    curr = pc + strlen(rep);
  }
}
