#ifndef INCLUDE_LOGINWIZARDPLUGIN_H
#define INCLUDE_LOGINWIZARDPLUGIN_H

#include "papaya/Plugin.h"

#include <glade/glade.h>
#include <list>
#include <algorithm>

struct loginData {
  char * username;
  char * password;
  char * usernameString;
  char * passwordString;
  GladeXML * xml;
  Connection * connection;
};

class LoginWizardPlugin : public Plugin {

 public:
  LoginWizardPlugin();
  ~LoginWizardPlugin();

  void input(Connection *, char *);
  void output(Connection *, char *);
  void prompt(Connection *, char *);
  // void clientMessage(Connection *, char *);
  void onEvent(Event *, Connection *);

  void okClicked(gpointer);
  void cancelClicked(gpointer);

  struct loginData * find_data(Connection *);
  void add_data(struct loginData *);
  void remove_data(struct loginData *);

 private:

  typedef std::list<struct loginData *> LoginDataList;
  std::list<struct loginData *> loginList;

};

#endif // INCLUDE_LOGINWIZARDPLUGIN_H
