#include <string.h>
#include <stdlib.h>
#include "MUD.h"

extern Prefs * globalPreferences;

MUD::MUD() {

  name = NULL;
  hostname = NULL;
  port = 0;
  login = NULL;
  login_trigger = NULL;
  password = NULL;
  password_trigger = NULL;
  preferences = NULL;

  setName("");
  setHostname("");
  setPort(4000);
  setLoginName("");
  setLoginTrigger("");
  setPassword("");
  setPasswordTrigger("");

  refcount = 0;

}

MUD::MUD(char * n, char * hn, int p, char * l, char * lt, char * pw, char * pwt) {

  name = NULL;
  hostname = NULL;
  port = 0;
  login = NULL;
  login_trigger = NULL;
  password = NULL;
  password_trigger = NULL;

  refcount = 0;

  setName(n);
  setHostname(hn);
  setPort(p);
  setLoginName(l);
  setLoginTrigger(lt);
  setPassword(pw);
  setPasswordTrigger(pwt);

  // Find and load the preferences for this MUD.
}

void MUD::initPrefs(bool ownPrefs) {
  own_prefs = ownPrefs;

  if (ownPrefs)
    preferences = new Prefs(this);
  else
    preferences = NULL;
}

MUD::~MUD() {

  if (name)
    free(name);

  if (hostname)
    free(hostname);

  if (login)
    free(login);

  if (login_trigger)
    free(login_trigger);

  if (password)
    free(password);

  if (password_trigger)
    free(password_trigger);

  if (preferences)
    delete preferences;

}

void MUD::setName(char * n) {
  if (name)
    free(name);

  name = strdup(n);
}

char * MUD::getName() {
  return name;
}

void MUD::setHostname(char * n) {
  if (hostname)
    free(hostname);

  hostname = strdup(n);
}

char * MUD::getHostname() {
  return hostname;
}

void MUD::setPort(int p) {
  port = p;
}

int MUD::getPort() {
  return port;
}

void MUD::setLoginName(char * n) {
  if (login)
    free (login);

  if (!strcmp(n, "<EMPTY>"))
    login = strdup("");
  else
    login = strdup(n);
}

char * MUD::getLoginName() {
  return login;
}

void MUD::setLoginTrigger(char * n) {
  if (login_trigger)
    free(login_trigger);

  if (!strcmp(n, "<EMPTY>"))
    login_trigger = strdup("");
  else
    login_trigger = strdup(n);
}

char * MUD::getLoginTrigger() {
  return login_trigger;
}

void MUD::setPassword(char * n) {
  if (password)
    free(password);

  if (!strcmp(n, "<EMPTY>"))
    password = strdup("");
  else
    password = strdup(n);
}

char * MUD::getPassword() {
  return password;
}

void MUD::setPasswordTrigger(char * n) {
  if (password_trigger)
    free(password_trigger);

  if (!strcmp(n, "<EMPTY>"))
    password_trigger = strdup("");
  else
    password_trigger = strdup(n);
}

char * MUD::getPasswordTrigger() {
  return password_trigger;
}

bool MUD::getOwnPrefs() {
  return own_prefs;
}

Prefs * MUD::getPreferences() {
  return preferences;
}

void MUD::setPreferences(Prefs * p) {
  if (p)
    own_prefs = true;
  else
    own_prefs = false;
  preferences = p;
}

void MUD::incrRefCount(bool handler) {
  refcount++;
  if (handler)
    mudlist = true;
}

void MUD::decrRefCount(bool handler) {
  refcount--;
  if (handler)
    mudlist = false;
}

int MUD::getRefCount() {
  return refcount;
}

bool MUD::getDeleted() {
  return !mudlist;
}
