#include <stdio.h> // sprintf
#include <string.h> // strcat, strdup, memmove
#include <stdlib.h>
#include <assert.h>
#include "Buffer.h"

#include "mudclient.h"

Buffer::Buffer()
    : body(NULL), length(0), max_len(0)
{
}

Buffer::~Buffer()
{
    if (body)
	free(body);
}

void Buffer::reset()
{
    length = 0;
}

char *Buffer::prepare_space(int size)
{
    int old_len = max_len;

    if (!max_len)
	max_len = 1024;

    while (max_len < length + size)
	max_len *= 2;
	
    if (old_len != max_len)
	body = (char*)realloc(body, max_len);

    return body + length;
}

void Buffer::consume_space(int size)
{
    assert(length + size <= max_len);
    length += size;
}

void Buffer::append(Buffer &b)
{
    append(b.getText(), b.getLength());
}

/**
 * append function for nul terminated strings.
 */

void Buffer::append(char * s)
{
    append(s, strlen(s));
}

void Buffer::append(char * s, int l)
{
    char *dest = prepare_space(l);
    memcpy(dest, s, l);
    dest[l] = 0;
    consume_space(l);
}

char * Buffer::getText()
{
    return body;
}

int Buffer::getLength()
{
    return length;
}

void Buffer::trim()
{
    int old_len = max_len;
    while (max_len > 1024 && max_len / 4 >= length)
	max_len /= 2;

    if (old_len != max_len)
	body = (char*)realloc(body, max_len);
}

void Buffer::strip(int count)
{
    if (count > length)
	count = length;
    
    length -= count;
    if (length)
	memmove(body, body+count, length);

    trim();
}

void Buffer::swap(Buffer &other)
{
    int tmp_len = other.length;
    int tmp_max = other.max_len;
    char *tmp_body = other.body;

    other.length = length;
    other.max_len = max_len;
    other.body = body;

    length = tmp_len;
    max_len = tmp_max;
    body = tmp_body;
}

void Buffer::transfer_to(Buffer &other)
{
    if (other.length)
	other.append(*this);
    else
	swap(other);
	
    reset();
}

void Buffer::discard_end(int len)
{
    if (len > length)
	len = length;

    length -= len;
}
