/**
 * This file contains the code required to open a browser Window showing
 * a specified URL on multiple platforms.
 */

#ifdef WIN32
#include <windows.h>
#endif

#include <stdlib.h>
#include <string.h>

#include "mudclient.h"

#include "Prefs.h"
#include "Message.h"

extern Prefs * globalPreferences;

#ifndef WIN32

char ** build_command(char * buf, int * cmd_len) {

  char * pc = strtok(buf, " ");
  char ** cmd;

  *cmd_len = 0;

  if (!pc) {
    return NULL;
  }

  // Assume no more than 100 tokens.
  cmd = (char **)malloc(100);
  cmd[(*cmd_len)++] = strdup(pc);

  while ((pc = strtok(NULL, " "))) {
    cmd[(*cmd_len)++] = strdup(pc);
  }

  cmd[(*cmd_len)] = NULL;

  return cmd;
}

void unix_browser_open(char * url) {

  char command_line[16384];

  // Compose the command line for opening the browser.
  char * browser = globalPreferences->getPreference("Browser");


  char * u = strstr(browser, "%s");
  if (!u) {
    sprintf(command_line, _("'%s' is an invalid browser string."), browser);
    new Message("Error", command_line, true);
    return;
  }

  sprintf(command_line, browser, url);

  // Create an array from the command.
  int cmd_len = 0;
  char ** cmd = build_command(command_line, &cmd_len);

  // fork and exec the browser
  int pid = fork();
  if (pid == 0) { // This is the child.
    execvp((const char *)cmd[0], cmd);
    perror("execvp");
    abort();
    return;
  }

  // This is the parent process.
  return;
}
#endif

#ifdef WIN32
void windows_browser_open(char * url) {	
	ShellExecute((HWND)0, NULL, url, NULL, NULL, SW_SHOWNORMAL);
}
#endif

// Entry function for opening browsers.
void browser_open(char * url) {
#ifdef WIN32
  windows_browser_open(url);
#else
  unix_browser_open(url);
#endif
}

