#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <sys/types.h>
#include <sys/stat.h>
#ifndef WIN32
#include <unistd.h>
#endif
#include <string.h>
#include <stdio.h>

#include "papaya/system.h"
#include <gdk/gdkkeysyms.h>
#include "mudclient.h"
#include "authors.h"
#include "About.h"

#include <gmodule.h>

extern "C" G_MODULE_EXPORT gint on_credits_close_button_clicked(GtkWidget * button, gpointer data) {
  About * about = (About *)data;
  GtkWidget * widget = glade_xml_get_widget(about->xml, "credits_dialog");
  gtk_widget_hide(widget);
  return 1;
}

extern "C" G_MODULE_EXPORT gint on_about_credits_button_clicked(GtkWidget * button, gpointer data) {
  About * about = (About *)data;
  GtkWidget * widget = glade_xml_get_widget(about->xml, "credits_dialog");
  gtk_widget_show(widget);
  return 1;
}

extern "C" G_MODULE_EXPORT gint on_about_ok_button_clicked(GtkWidget * button, gpointer data) {
  About * about = (About *)data;
  GtkWidget * widget = glade_xml_get_widget(about->xml, "about_dialog");
  gtk_widget_show(widget);
  delete about;
  return 1;
}

extern "C" G_MODULE_EXPORT gint on_credits_dialog_delete_event(GtkWidget * window, GdkEvent * event, gpointer data) {
  About * about = (About *)data;
  GtkWidget * widget = glade_xml_get_widget(about->xml, "credits_dialog");
  gtk_widget_hide(widget);
  return 1;
}

extern "C" G_MODULE_EXPORT gint on_about_dialog_delete_event(GtkWidget * window, GdkEvent * event, gpointer data) {
  About * about = (About *)data;
  GtkWidget * widget = glade_xml_get_widget(about->xml, "about_dialog");
  gtk_widget_show(widget);
  delete about;
  return 1;
}

About::About() {
  char buf[1024];
  
  snprintf(buf, 1024, "%s/share/papaya/about.glade", getPrefix());

  xml = glade_xml_new(buf, NULL, NULL);
  if (!xml) {
    printf (_("Critical Error: File '%s' not found.\n"), buf);
    abort();
  }

  // Connect up the signals, with this as the data object.
  glade_xml_signal_connect_data(xml, "on_credits_close_button_clicked", GTK_SIGNAL_FUNC(on_credits_close_button_clicked), this);
  glade_xml_signal_connect_data(xml, "on_about_ok_button_clicked", GTK_SIGNAL_FUNC(on_about_ok_button_clicked), this);
  glade_xml_signal_connect_data(xml, "on_about_credits_button_clicked", GTK_SIGNAL_FUNC(on_about_credits_button_clicked), this);
  glade_xml_signal_connect_data(xml, "on_credits_dialog_delete_event", GTK_SIGNAL_FUNC(on_credits_dialog_delete_event), this);
  glade_xml_signal_connect_data(xml, "on_about_dialog_delete_event", GTK_SIGNAL_FUNC(on_about_dialog_delete_event), this);

  // Populate the text view with the correct text.
  GtkWidget * text_view = glade_xml_get_widget(xml, "credits_textview");
  GtkTextBuffer * buffer = gtk_text_view_get_buffer(GTK_TEXT_VIEW(text_view));
  GtkTextIter start, end;
  gtk_text_buffer_get_bounds(buffer, &start, &end);
  gtk_text_buffer_delete(buffer, &start, &end);
  gtk_text_buffer_insert(buffer, &start, COPYRIGHT, -1);

  // Display the about window - defaults to not visible.
  GtkWidget * about_window = glade_xml_get_widget(xml, "about_dialog");
  gtk_widget_show(about_window);
}

About::~About() {

  // Ensure that the widgets are destroyed too.
  gtk_widget_destroy(glade_xml_get_widget(xml, "about_dialog"));
  gtk_widget_destroy(glade_xml_get_widget(xml, "credits_dialog"));
		     
  // Free the GladeXML object.
  g_object_unref(xml);
  xml = NULL;
}
