#ifndef TELNET_H
#define TELNET_H

// Poor man's namespace
class Telnet {
  public:
    typedef enum {
	IAC   = 255,
	DONT  = 254,
	DO    = 253,
	WONT  = 252,
	WILL  = 251,
	SB    = 250,
	GA    = 249,
	EL    = 248,
	EC    = 247,
	AYT   = 246,
	AO    = 245,
	IP    = 244,
	BREAK = 243,
	DM    = 242,
	NOP   = 241,
	SE    = 240,
	EOR   = 239,	
	ABORT = 238,
	SUSP  = 237,
	xEOF  = 236,
	EOL   = 200,      // used internally
	BOGUS_EOR = 25,
	BAD_COMMAND = -1
    } command_t;

    typedef enum {
	BINARY = 0,
	ECHO   = 1,
	RCP    = 2,
	SGA    = 3,
	NAMS   = 4,
	STATUS = 5,
	TM     = 6,
	RCTE   = 7,
	NAOL   = 8,
	NAOP   = 9,
	NAOCRD = 10,
	NAOHTS = 11,
	NAOHTD = 12,
	NAOFFD = 13,
	NAOVTS = 14,
	NAOVTD = 15,
	NAOLFD = 16,
	XASCII = 17,
	LOGOUT = 18,
	BM     = 19,
	DET    = 20,
	SUPDUP = 21,
	SUPDUPOUTPUT = 22,
	SNDLOC = 23,
	TTYPE  = 24,
	OPT_EOR = 25,
	TUID   = 26,
	OUTMRK = 27,
	TTYLOC = 28,
	OPT_3270REGIME = 29,
	X3PAD  = 30,
	NAWS   = 31,
	TSPEED = 32,
	LFLOW  = 33,
	LINEMODE       = 34,
	XDISPLOC       = 35,
	OLD_ENVIRON    = 36,
	AUTHENTICATION = 37,
	ENCRYPT        = 38,
	NEW_ENVIRON    = 39,
	COMPRESS       = 85,
	COMPRESS2      = 86,
	MSP            = 90,
	MXP            = 91,
	TURF_HTTPD     = 200,
	EXOPL          = 255,
	BAD_OPTION     = -1
    } option_t;

    static const char *option_name(option_t opt);
    static option_t option_value(const char *name);

    static const char *command_name(command_t opt);
    static command_t command_value(const char *name);
};

#ifdef ZLIB
// MCCP v2.1 options

class MCCP {
  public:
    enum {
	OFFER_VERSIONS = 0,
	ACCEPT_VERSION = 1
    } command_t;

    enum {
	VERSION_NONE = 0,
	VERSION_2_1 = 1
    } version_t;
};
#endif
    
#endif
