// Tell emacs this is really -*- C++ -*-
#ifndef INCLUDE_SOCKET_H
#define INCLUDE_SOCKET_H

#include "Buffer.h"
#include "FilterHandler.h"
#include "Telnet.h"

#ifdef WIN32
#  ifndef IPV4
#    define IPV4
#  endif
#endif

class Connection;
class Socket {    
 public:
    Socket(Connection *);
    Socket(Connection *, int, int, int);
    virtual ~Socket();
    
    virtual int create(char *, int); // Connects socket to the given host/port
    int dispose();
    int flush();
    int write(Buffer &);
    int write(char *s);
    virtual int write(char *, int);
    int read(int, char *);
    int readLine(int, char *);
    int internal_read();
    int sanitise(char *, int);
    
    virtual int connected();
    int compression();
    bool echo();

  bool getTelnetOption(Telnet::option_t);
    
    Buffer * getOutbuf(void);
    int fd;
    
    void getStats(int *, int *, int *, int *);
    
    virtual int getCookie();
    virtual int restart(char *, int);
    
    FilterHandler inputFilters;
    FilterHandler outputFilters;

protected:
    // The connection that holds this socket
    Connection * conn;
    
#ifdef IPV4
    int resolveAddress(char * host, struct sockaddr_in * ip4);
#else
    int resolveAddress(char * host, struct sockaddr_in * ip4, struct sockaddr_in6 * ip6);
#endif
    
    int stats_written;
    int stats_read_raw;
    int stats_read_filtered;
  time_t stats_connected;
    bool is_connected;
    
private:

    Buffer outbuf;
    Buffer inbuf;
    int tries;
};

#endif

