#ifndef FONT_CHOOSER_H
#define FONT_CHOOSER_H

#include <gtk/gtk.h>

class FontChooser {
  typedef void (*ChangeCallback)(FontChooser *, void *);

  friend gboolean font_chooser_open(GtkButton * button, gpointer data);
  friend gboolean font_chooser_ok(GtkButton * button, gpointer data);
  friend gboolean font_chooser_cancel(GtkButton * button, gpointer data);
  friend gboolean font_chooser_wm_close(GtkWidget * widget, GdkEvent * event,
                                        gpointer data);
  friend void font_chooser_destroy(gpointer font_chooser);

  public:

    FontChooser(char * font_string);
    FontChooser(char * font_string, ChangeCallback cb, gpointer data);
    ~FontChooser();
    GtkWidget * getUI();
    char * getFont();
    void setFont(char *);
    void setSensitive(bool);

  private:

    GtkWidget * preview;
    GtkWidget * button;
    GtkWidget * ui;
    GtkWidget * chooser;
    char * font_descriptor;
    ChangeCallback callback;
    gpointer callback_data;

    void init(char * font_string);
    void updatePreview();
};

#endif
