/*
**  MimeMultipart.h
**
**  Copyright (c) 2001, 2002
**
**  Author: Ludovic Marcotte <ludovic@Sophos.ca>
**
**  This library is free software; you can redistribute it and/or
**  modify it under the terms of the GNU Lesser General Public
**  License as published by the Free Software Foundation; either
**  version 2.1 of the License, or (at your option) any later version.
**  
**  This library is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
**  Lesser General Public License for more details.
**  
**  You should have received a copy of the GNU Lesser General Public
**  License along with this library; if not, write to the Free Software
**  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
*/

#ifndef _Pantomime_H_MimeMultipart
#define _Pantomime_H_MimeMultipart

#import <Foundation/NSArray.h>
#import <Foundation/NSObject.h>

@class Part;

@interface MimeMultipart : NSObject
{
  NSMutableArray *array;
}

- (id) init;

- (void) addBodyPart: (Part *) thePart;     // Add a new body part to the multipart

- (void) removeBodyPart: (Part *) thePart;  // Remove a body part from the multipart
 
- (int) count;                              // Return the number of Part objects

- (Part *) bodyPartAtIndex: (int) theIndex; // Get the Part corresponding to this index

@end

#endif // _Pantomime_H_MimeMultipart 
