#! /usr/bin/env python

# Panflute
# Copyright (C) 2009 Paul Kuliniewicz <paul@kuliniewicz.org>
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2, or (at your option)
# any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02111-1301, USA.

"""
Utility routines for handling URLs.
"""

from __future__ import absolute_import

import urllib


def make_url (path):
    """
    Convert a local path into a properly-formed URL.  If the path is already
    a URL (file:// or otherwise), do nothing.
    """

    if path.startswith ("/"):
        # pathname2url chokes on non-8-bit characters
        return "file://{0}".format (urllib.pathname2url (path.encode ("utf-8")))
    else:
        return path
