.TH Pandoc "" "July 17, 2006" "Test Suite"
.PP
This is a set of tests for pandoc.
Most of them are adapted from John Gruber's markdown test suite.
.PP
   *   *   *   *   *
.SH Headers
.SS Level 2 with an embedded link (/url)
.SS Level 3 with \f[I]emphasis\f[]
.SS Level 4
.SS Level 5
.SH Level 1
.SS Level 2 with \f[I]emphasis\f[]
.SS Level 3
.PP
with no blank line
.SS Level 2
.PP
with no blank line
.PP
   *   *   *   *   *
.SH Paragraphs
.PP
Here's a regular paragraph.
.PP
In Markdown 1.0.0 and earlier.
Version 8.
This line turns into a list item.
Because a hard-wrapped line in the middle of a paragraph looked like a list
item.
.PP
Here's one with a bullet.
* criminey.
.PP
There should be a hard line break
.PD 0
.P
.PD
here.
.PP
   *   *   *   *   *
.SH Block Quotes
.PP
E-mail style:
.RS
.PP
This is a block quote.
It is pretty short.
.RE
.RS
.PP
Code in a block quote:
.IP
.nf
\f[C]
sub\ status\ {
\ \ \ \ print\ "working";
}
\f[]
.fi
.PP
A list:
.IP "1." 3
item one
.IP "2." 3
item two
.PP
Nested block quotes:
.RS
.PP
nested
.RE
.RS
.PP
nested
.RE
.RE
.PP
This should not be a block quote: 2 > 1.
.PP
And a following paragraph.
.PP
   *   *   *   *   *
.SH Code Blocks
.PP
Code:
.IP
.nf
\f[C]
----\ (should\ be\ four\ hyphens)

sub\ status\ {
\ \ \ \ print\ "working";
}

this\ code\ block\ is\ indented\ by\ one\ tab
\f[]
.fi
.PP
And:
.IP
.nf
\f[C]
\ \ \ \ this\ code\ block\ is\ indented\ by\ two\ tabs

These\ should\ not\ be\ escaped:\ \ \\$\ \\\\\ \\>\ \\[\ \\{
\f[]
.fi
.PP
   *   *   *   *   *
.SH Lists
.SS Unordered
.PP
Asterisks tight:
.IP \[bu] 2
asterisk 1
.IP \[bu] 2
asterisk 2
.IP \[bu] 2
asterisk 3
.PP
Asterisks loose:
.IP \[bu] 2
asterisk 1
.IP \[bu] 2
asterisk 2
.IP \[bu] 2
asterisk 3
.PP
Pluses tight:
.IP \[bu] 2
Plus 1
.IP \[bu] 2
Plus 2
.IP \[bu] 2
Plus 3
.PP
Pluses loose:
.IP \[bu] 2
Plus 1
.IP \[bu] 2
Plus 2
.IP \[bu] 2
Plus 3
.PP
Minuses tight:
.IP \[bu] 2
Minus 1
.IP \[bu] 2
Minus 2
.IP \[bu] 2
Minus 3
.PP
Minuses loose:
.IP \[bu] 2
Minus 1
.IP \[bu] 2
Minus 2
.IP \[bu] 2
Minus 3
.SS Ordered
.PP
Tight:
.IP "1." 3
First
.IP "2." 3
Second
.IP "3." 3
Third
.PP
and:
.IP "1." 3
One
.IP "2." 3
Two
.IP "3." 3
Three
.PP
Loose using tabs:
.IP "1." 3
First
.IP "2." 3
Second
.IP "3." 3
Third
.PP
and using spaces:
.IP "1." 3
One
.IP "2." 3
Two
.IP "3." 3
Three
.PP
Multiple paragraphs:
.IP "1." 3
Item 1, graf one.
.RS 4
.PP
Item 1.
graf two.
The quick brown fox jumped over the lazy dog's back.
.RE
.IP "2." 3
Item 2.
.IP "3." 3
Item 3.
.SS Nested
.IP \[bu] 2
Tab
.RS 2
.IP \[bu] 2
Tab
.RS 2
.IP \[bu] 2
Tab
.RE
.RE
.PP
Here's another:
.IP "1." 3
First
.IP "2." 3
Second:
.RS 4
.IP \[bu] 2
Fee
.IP \[bu] 2
Fie
.IP \[bu] 2
Foe
.RE
.IP "3." 3
Third
.PP
Same thing but with paragraphs:
.IP "1." 3
First
.IP "2." 3
Second:
.RS 4
.IP \[bu] 2
Fee
.IP \[bu] 2
Fie
.IP \[bu] 2
Foe
.RE
.IP "3." 3
Third
.SS Tabs and spaces
.IP \[bu] 2
this is a list item indented with tabs
.IP \[bu] 2
this is a list item indented with spaces
.RS 2
.IP \[bu] 2
this is an example list item indented with tabs
.IP \[bu] 2
this is an example list item indented with spaces
.RE
.SS Fancy list markers
.IP "(2)" 4
begins with 2
.IP "(3)" 4
and now 3
.RS 4
.PP
with a continuation
.IP "iv." 4
sublist with roman numerals, starting with 4
.IP " v." 4
more items
.RS 4
.IP "(A)" 4
a subsublist
.IP "(B)" 4
a subsublist
.RE
.RE
.PP
Nesting:
.IP "A." 3
Upper Alpha
.RS 4
.IP "I." 3
Upper Roman.
.RS 4
.IP "(6)" 4
Decimal start with 6
.RS 4
.IP "c)" 3
Lower alpha with paren
.RE
.RE
.RE
.PP
Autonumbering:
.IP "1." 3
Autonumber.
.IP "2." 3
More.
.RS 4
.IP "1." 3
Nested.
.RE
.PP
Should not be a list item:
.PP
M.A.\ 2007
.PP
B.
Williams
.PP
   *   *   *   *   *
.SH Definition Lists
.PP
Tight using spaces:
.TP
.B apple
red fruit
.RS
.RE
.TP
.B orange
orange fruit
.RS
.RE
.TP
.B banana
yellow fruit
.RS
.RE
.PP
Tight using tabs:
.TP
.B apple
red fruit
.RS
.RE
.TP
.B orange
orange fruit
.RS
.RE
.TP
.B banana
yellow fruit
.RS
.RE
.PP
Loose:
.TP
.B apple
red fruit
.RS
.RE
.TP
.B orange
orange fruit
.RS
.RE
.TP
.B banana
yellow fruit
.RS
.RE
.PP
Multiple blocks with italics:
.TP
.B \f[I]apple\f[]
red fruit
.RS
.PP
contains seeds, crisp, pleasant to taste
.RE
.TP
.B \f[I]orange\f[]
orange fruit
.RS
.IP
.nf
\f[C]
{\ orange\ code\ block\ }
\f[]
.fi
.RS
.PP
orange block quote
.RE
.RE
.PP
Multiple definitions, tight:
.TP
.B apple
red fruit
.RS
.RE
computer
.RS
.RE
.TP
.B orange
orange fruit
.RS
.RE
bank
.RS
.RE
.PP
Multiple definitions, loose:
.TP
.B apple
red fruit
.RS
.RE
computer
.RS
.RE
.TP
.B orange
orange fruit
.RS
.RE
bank
.RS
.RE
.PP
Blank line after term, indented marker, alternate markers:
.TP
.B apple
red fruit
.RS
.RE
computer
.RS
.RE
.TP
.B orange
orange fruit
.RS
.IP "1." 3
sublist
.IP "2." 3
sublist
.RE
.SH HTML Blocks
.PP
Simple block on one line:
foo
.PP
And nested without indentation:
foo
bar
.PP
Interpreted markdown in a table:
This is \f[I]emphasized\f[]
And this is \f[B]strong\f[]
.PP
Here's a simple block:
foo
.PP
This should be a code block, though:
.IP
.nf
\f[C]
<div>
\ \ \ \ foo
</div>
\f[]
.fi
.PP
As should this:
.IP
.nf
\f[C]
<div>foo</div>
\f[]
.fi
.PP
Now, nested:
foo
.PP
This should just be an HTML comment:
.PP
Multiline:
.PP
Code block:
.IP
.nf
\f[C]
<!--\ Comment\ -->
\f[]
.fi
.PP
Just plain comment, with trailing spaces on the line:
.PP
Code:
.IP
.nf
\f[C]
<hr\ />
\f[]
.fi
.PP
Hr's:
.PP
   *   *   *   *   *
.SH Inline Markup
.PP
This is \f[I]emphasized\f[], and so \f[I]is this\f[].
.PP
This is \f[B]strong\f[], and so \f[B]is this\f[].
.PP
An \f[I]emphasized link (/url)\f[].
.PP
\f[B]\f[I]This is strong and em.\f[]\f[]
.PP
So is \f[B]\f[I]this\f[]\f[] word.
.PP
\f[B]\f[I]This is strong and em.\f[]\f[]
.PP
So is \f[B]\f[I]this\f[]\f[] word.
.PP
This is code: \f[C]>\f[], \f[C]$\f[], \f[C]\\\f[], \f[C]\\$\f[],
\f[C]<html>\f[].
.PP
[STRIKEOUT:This is \f[I]strikeout\f[].]
.PP
Superscripts: a^bc^d a^\f[I]hello\f[]^ a^hello\ there^.
.PP
Subscripts: H~2~O, H~23~O, H~many\ of\ them~O.
.PP
These should not be superscripts or subscripts, because of the unescaped
spaces: a^b c^d, a~b c~d.
.PP
   *   *   *   *   *
.SH Smart quotes, ellipses, dashes
.PP
\[lq]Hello,\[rq] said the spider.
\[lq]`Shelob' is my name.\[rq]
.PP
`A', `B', and `C' are letters.
.PP
`Oak,' `elm,' and `beech' are names of trees.
So is `pine.'
.PP
`He said, \[lq]I want to go.\[rq]' Were you alive in the 70's?
.PP
Here is some quoted `\f[C]code\f[]' and a \[lq]quoted
link (http://example.com/?foo=1&bar=2)\[rq].
.PP
Some dashes: one\[em]two \[em] three\[em]four \[em] five.
.PP
Dashes between numbers: 5\[en]7, 255\[en]66, 1987\[en]1999.
.PP
Ellipses\&...and\&...and\&....
.PP
   *   *   *   *   *
.SH LaTeX
.IP \[bu] 2
.IP \[bu] 2
2 + 2 = 4
.IP \[bu] 2
\f[I]x\f[] ∈ \f[I]y\f[]
.IP \[bu] 2
α ∧ ω
.IP \[bu] 2
223
.IP \[bu] 2
\f[I]p\f[]-Tree
.IP \[bu] 2
Here's some display math:
.RS
$\\frac{d}{dx}f(x)=\\lim_{h\\to 0}\\frac{f(x+h)-f(x)}{h}$
.RE
.IP \[bu] 2
Here's one that has a line break in it: α + ω × \f[I]x\f[]^2^.
.PP
These shouldn't be math:
.IP \[bu] 2
To get the famous equation, write \f[C]$e\ =\ mc^2$\f[].
.IP \[bu] 2
$22,000 is a \f[I]lot\f[] of money.
So is $34,000.
(It worked if \[lq]lot\[rq] is emphasized.)
.IP \[bu] 2
Shoes ($20) and socks ($5).
.IP \[bu] 2
Escaped \f[C]$\f[]: $73 \f[I]this should be emphasized\f[] 23$.
.PP
Here's a LaTeX table:
.PP
   *   *   *   *   *
.SH Special Characters
.PP
Here is some unicode:
.IP \[bu] 2
I hat: Î
.IP \[bu] 2
o umlaut: ö
.IP \[bu] 2
section: §
.IP \[bu] 2
set membership: ∈
.IP \[bu] 2
copyright: ©
.PP
AT&T has an ampersand in their name.
.PP
AT&T is another way to write it.
.PP
This & that.
.PP
4 < 5.
.PP
6 > 5.
.PP
Backslash: \\
.PP
Backtick: `
.PP
Asterisk: *
.PP
Underscore: _
.PP
Left brace: {
.PP
Right brace: }
.PP
Left bracket: [
.PP
Right bracket: ]
.PP
Left paren: (
.PP
Right paren: )
.PP
Greater-than: >
.PP
Hash: #
.PP
Period: .
.PP
Bang: !
.PP
Plus: +
.PP
Minus: -
.PP
   *   *   *   *   *
.SH Links
.SS Explicit
.PP
Just a URL (/url/).
.PP
URL and title (/url/).
.PP
URL and title (/url/).
.PP
URL and title (/url/).
.PP
URL and title (/url/)
.PP
URL and title (/url/)
.PP
with_underscore (/url/with_underscore)
.PP
Email link (mailto:nobody@nowhere.net)
.PP
Empty ().
.SS Reference
.PP
Foo bar (/url/).
.PP
Foo bar (/url/).
.PP
Foo bar (/url/).
.PP
With embedded [brackets] (/url/).
.PP
b (/url/) by itself should be a link.
.PP
Indented once (/url).
.PP
Indented twice (/url).
.PP
Indented thrice (/url).
.PP
This should [not][] be a link.
.IP
.nf
\f[C]
[not]:\ /url
\f[]
.fi
.PP
Foo bar (/url/).
.PP
Foo biz (/url/).
.SS With ampersands
.PP
Here's a link with an ampersand in the URL (http://example.com/?foo=1&bar=2).
.PP
Here's a link with an amersand in the link text: AT&T (http://att.com/).
.PP
Here's an inline link (/script?foo=1&bar=2).
.PP
Here's an inline link in pointy braces (/script?foo=1&bar=2).
.SS Autolinks
.PP
With an ampersand: <http://example.com/?foo=1&bar=2>
.IP \[bu] 2
In a list?
.IP \[bu] 2
<http://example.com/>
.IP \[bu] 2
It should.
.PP
An e-mail address: <nobody@nowhere.net>
.RS
.PP
Blockquoted: <http://example.com/>
.RE
.PP
Auto-links should not occur here: \f[C]<http://example.com/>\f[]
.IP
.nf
\f[C]
or\ here:\ <http://example.com/>
\f[]
.fi
.PP
   *   *   *   *   *
.SH Images
.PP
From \[lq]Voyage dans la Lune\[rq] by Georges Melies (1902):
.PP
[IMAGE: lalune (lalune.jpg)]
.PP
Here is a movie [IMAGE: movie (movie.jpg)] icon.
.PP
   *   *   *   *   *
.SH Footnotes
.PP
Here is a footnote reference,[1] and another.[2] This should \f[I]not\f[] be a
footnote reference, because it contains a space.[^my note] Here is an inline
note.[3]
.RS
.PP
Notes can go in quotes.[4]
.RE
.IP "1." 3
And in list items.[5]
.PP
This paragraph should not be part of the note, as it is not indented.
.SH NOTES
.SS [1]
.PP
Here is the footnote.
It can go anywhere after the footnote reference.
It need not be placed at the end of the document.
.SS [2]
.PP
Here's the long note.
This one contains multiple blocks.
.PP
Subsequent blocks are indented to show that they belong to the footnote (as
with list items).
.IP
.nf
\f[C]
\ \ {\ <code>\ }
\f[]
.fi
.PP
If you want, you can indent every line, but you can also be lazy and just
indent the first line of each block.
.SS [3]
.PP
This is \f[I]easier\f[] to type.
Inline notes may contain links (http://google.com) and \f[C]]\f[] verbatim
characters, as well as [bracketed text].
.SS [4]
.PP
In quote.
.SS [5]
.PP
In list.
.SH AUTHORS
John MacFarlane; Anonymous.
