# Citing and logo

## Citing pandas

If you use _pandas_ for a scientific publication, we would appreciate citations to one of the following papers:

- [Data structures for statistical computing in python](http://conference.scipy.org/proceedings/scipy2010/pdfs/mckinney.pdf),
   McKinney, Proceedings of the 9th Python in Science Conference, Volume 445, 2010.

        @inproceedings{mckinney2010data,
            title={Data structures for statistical computing in python},
            author={Wes McKinney},
            booktitle={Proceedings of the 9th Python in Science Conference},
            volume={445},
            pages={51--56},
            year={2010},
            organization={Austin, TX}
        }


- [pandas: a foundational Python library for data analysis and statistics](https://www.scribd.com/document/71048089/pandas-a-Foundational-Python-Library-for-Data-Analysis-and-Statistics),
  McKinney, Python for High Performance and Scientific Computing, Volume 14, 2011.

        @article{mckinney2011pandas,
            title={pandas: a foundational Python library for data analysis and statistics},
            author={Wes McKinney},
            journal={Python for High Performance and Scientific Computing},
            volume={14},
            year={2011}
        }

## Brand and logo

When using the project name _pandas_, please use it in lower case, even at the beginning of a sentence.

The official logos of _pandas_ are:

### Primary logo

<table class="table logo">
    <tr>
        <td>
            <img alt="" src="{{ base_url }}/static/img/pandas.svg"/>
        </td>
        <td style="background-color: #150458">
            <img alt="" src="{{ base_url }}/static/img/pandas_white.svg"/>
        </td>
    </tr>
</table>

### Secondary logo

<table class="table logo">
    <tr>
        <td>
            <img alt="" src="{{ base_url }}/static/img/pandas_secondary.svg"/>
        </td>
        <td style="background-color: #150458">
            <img alt="" src="{{ base_url }}/static/img/pandas_secondary_white.svg"/>
        </td>
    </tr>
</table>

### Logo mark

<table class="table logo">
    <tr>
        <td>
            <img alt="" src="{{ base_url }}/static/img/pandas_mark.svg"/>
        </td>
        <td style="background-color: #150458">
            <img alt="" src="{{ base_url }}/static/img/pandas_mark_white.svg"/>
        </td>
    </tr>
</table>

### Logo usage

The pandas logo is available in full color and white accent.
The full color logo should only appear against white backgrounds.
The white accent logo should go against contrasting color background.

When using the logo, please follow the next directives:

- Primary logo should never be seen under 1 inch in size for printing and 72px for web
- The secondary logo should never be seen under 0.75 inch in size for printing and 55px for web
- Leave enough margin around the logo (leave the height of the logo in the top, bottom and both sides)
- Do not distort the logo by changing its proportions
- Do not place text or other elements on top of the logo

### Colors

<table class="table">
    <tr>
        <td style="text-align: center;">
            <svg xmlns="http://www.w3.org/2000/svg" width="100" height="100">
                <circle cx="50" cy="50" r="50" fill="#150458"/>
            </svg>
            <br/>
            <b style="color: #150458;">Blue</b><br/>
            RGB: R21 G4 B88<br/>
            HEX: #150458
        </td>
        <td style="text-align: center;">
            <svg xmlns="http://www.w3.org/2000/svg" width="100" height="100">
                <circle cx="50" cy="50" r="50" fill="#ffca00"/>
            </svg>
            <br/>
            <b style="color: #150458;">Yellow</b><br/>
            RGB: R255 G202 B0<br/>
            HEX: #FFCA00
        </td>
        <td style="text-align: center;">
            <svg xmlns="http://www.w3.org/2000/svg" width="100" height="100">
                <circle cx="50" cy="50" r="50" fill="#e70488"/>
            </svg>
            <br/>
            <b style="color: #150458;">Pink</b><br/>
            RGB: R231 G4 B136<br/>
            HEX: #E70488
        </td>
    </tr>
</table>
