/***************************************************************************
 *   Copyright (C) 2008 Felix Lemke <lemke.felix@ages-skripte.org>
 *   Copyright (C) 2008 Stefan Majewsky <majewsky@gmx.net>
 *
 *   This program is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU General Public
 *   License as published by the Free Software Foundation; either
 *   version 2 of the License, or (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 ***************************************************************************/

#ifndef PALAPELI_MAINWINDOW_H
#define PALAPELI_MAINWINDOW_H

#include <KXmlGuiWindow>

namespace Palapeli
{

	class MainWindowPrivate;

	class MainWindow : public KXmlGuiWindow
	{
		Q_OBJECT
		public:
			MainWindow(QWidget* parent = 0);
			~MainWindow();
		public Q_SLOTS:
			void reportPuzzleProgress(int pieceCount, int partCount, const QString& caption = QString());
			void flushPuzzleProgress();

			void gameNameWasChanged(const QString& name);
			void changeInteractionMode(bool allowGameInteraction);
		protected:
			virtual void closeEvent(QCloseEvent* event);
		private:
			MainWindowPrivate* const p;
	};

}

#endif //PALAPELI_MAINWINDOW_H
