/* pal
 *
 * Copyright (C) 2004, Scott Kuhl
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

#include <stdio.h>
#include <readline/readline.h>

#include "main.h"
#include "output.h"
#include "event.h"
#include "rl.h"
#include "add.h"
#include "del.h"
#include "input.h"



gchar* pal_edit_desc(gchar* text)
{
    char* desc = text;

    pal_output_fg(BRIGHT, GREEN, "> ");
    g_print(_("What is the new description of this event?\n"));

    do{
	if(desc != NULL)
	{
	    pal_rl_default_text = desc;
	    rl_pre_input_hook = (rl_hook_func_t*) pal_rl_default_text_fn;
	}

	desc = pal_rl_get_line(_("Description: "));
	rl_pre_input_hook = NULL;
    }
    while(!pal_rl_get_y_n(_("Is this description correct? [y/n]: ")));

    return desc;
}

void pal_edit_menu(PalEvent* event, GDate* d)
{
    pal_output_fg(BRIGHT, GREEN, "> ");
    g_print(_("Editing the event:\n"));
    pal_output_event(event, d, -1);
    g_print("\n");

    while(1)
    {
	gchar* s;
	pal_output_attr(BRIGHT, " 1 ");
	g_print("- %s\n", _("Edit the event date (how often it happens, start date, end date)."));
	pal_output_attr(BRIGHT, " 2 ");
	g_print("- %s\n", _("Edit the event description."));

	s = pal_rl_get_line(_("Select action [1--2]: "));
	g_print("\n");

	if(g_ascii_strcasecmp(s, "1")==0)
	{
	    g_free(event->date_string);
	    event->date_string = pal_add_get_date_recur();
	}
	else if(g_ascii_strcasecmp(s, "2")==0)
	{
	    gchar* new_text = pal_edit_desc(event->text);
	    g_free(event->text);
	    event->text = new_text;
	}
	else
	    continue;

	break;

    }

}



void pal_edit_event()
{
    PalEvent* event_orig = NULL;
    PalEvent* event_new = NULL;
    GDate* event_date = NULL;

    pal_output_fg(BRIGHT, GREEN, "* * * ");
    pal_output_attr(BRIGHT, _("Edit an event"));
    pal_output_fg(BRIGHT, GREEN, " * * *\n");

    event_orig = pal_rl_get_event(&event_date, FALSE);
    event_new = pal_event_copy(event_orig);
    g_print("\n");
    pal_edit_menu(event_new, event_date);

    pal_del_write_file(event_orig);
    pal_add_write_file(event_orig->file_name, event_new->date_string, event_new->text);

    pal_event_free(event_new);
    g_date_free(event_date);

    pal_main_reload();

}
