//=======================================================================
// global.cc
//-----------------------------------------------------------------------
// This file is part of the package paco
// Copyright (C) 2004-2009 David Rosal
// For more information visit http://paco.sourceforge.net
//=======================================================================

#include "config.h"
#include "global.h"
#include <string>

using std::string;

// initialization of globals
namespace Paco
{
	int gExitStatus = EXIT_SUCCESS;
	Out gOut;
}


//
// Strip trailing and consecutive slashes from a path
//
inline static void clearPath(string& path)
{
    string::size_type p;
    while ((p = path.find("//")) != string::npos)
        path.erase(p, 1);
    if ((p = path.find_last_not_of("/")) != string::npos)
        path.erase(++p);
}


//
// Like libc's realpath(), but it only resolve symlinks in the partial
// directories of the path, thereby retaining symlinks as symlinks.
//
string Paco::realDir(string const& __path)
{
	string path(__path);
	clearPath(path);
	
	if (path[0] != '/') {
		char cwd[4096];
		path.insert(0, "/");
		path.insert(0, getcwd(cwd, sizeof(cwd)) ? cwd : ".");
	}

	string::size_type p = path.rfind('/');
	string base((p == string::npos) ? "" : path.substr(p + 1));
	string dir(path.substr(0, p));

	char real[4096];
	if (UNLIKELY(!::realpath(dir.c_str(), real)))
		return path;

	return real + string("/") + base;
}

