//=======================================================================
// treeview.h
//-----------------------------------------------------------------------
// This file is part of the package paco
// Copyright (C) 2004-2009 David Rosal
// For more information visit http://paco.sourceforge.net
//=======================================================================

#ifndef GPACO_TREE_VIEW_H
#define GPACO_TREE_VIEW_H

#include <gtkmm/treeview.h>


namespace Gtk
{
	class UIManager;
	class Action;
	class ActionGroup;
	class Menu;
}

namespace Gpaco
{

class TreeView : public Gtk::TreeView
{
	public:

	TreeView();
	virtual ~TreeView();
	
	void selectAll();
	void unselectAll();
	int countSelected();

	protected:

	virtual void writeLabel() const;

	typedef Gtk::TreeModel::iterator iterator;

	Gtk::Menu*							mpMenu;
	Glib::RefPtr<Gtk::UIManager>		mpUIManager;
	Glib::RefPtr<Gtk::ActionGroup>		mpActionGroup;
	Glib::RefPtr<Gtk::TreeSelection>	mpSelection;

};	// class TreeView

} // namespace Gpaco

#endif  // GPACO_TREE_VIEW_H
