#ifndef __DEBTAGSPLUGINCONTAINER_H_2004_06_23
#define __DEBTAGSPLUGINCONTAINER_H_2004_06_23

#include <string>

#include <qobject.h>
#include <qstring.h>


// Tagcoll
#include <apt-front/cache/entity/tag.h>
#include <apt-front/forward.h>

#include <baseplugincontainer.h>

using namespace std;
using namespace aptFront;

namespace Tagcoll
{
	template <class T1, class T2>
	class Collection;
	
	template <class T1, class T2>
	class Consumer;
}

namespace NApplication
{
	class RunCommand;
}

class DebtagsSettingsWidget;

namespace NPlugin
{

class DebtagsPlugin;
class RelatedPlugin;
class DebtagsActionPlugin;

/** @brief This class provides plugins using the debtags system.
  * 
  * It manages the shared data and offers the possibility to update the debtags database.
  *
  * @author Benjamin Mesing
  */
class DebtagsPluginContainer : public QObject, public BasePluginContainer 
{
	Q_OBJECT
	/** @brief This holds a list of the names of all the plugins offered by this 
	  * plugin container. 
	  *
	  * @see offeredPlugins() 
	  */
	vector<QString> _offeredPlugins;
	/** @brief This holds if the debtags operations are currently enabled. 
	  * 
	  * This will be set to false if the reading of the tag database failed. 
	  */
	bool _debtagsEnabled;

	/** Holds the debtags plugin created. */
	DebtagsPlugin* _pDebtagsPlugin;
	/** Holds the related plugin created. */
	RelatedPlugin* _pRelatedPlugin;
	/** Holds the action plugin created. */
	DebtagsActionPlugin* _pDebtagsActionPlugin;
	/** This pointer is used to run the <tt>debtags update</tt> command. */
	NApplication::RunCommand* _pCommand;
	/** @brief This holds the names of the facets that shall not be shown.
	  *
	  * This can be used to reduce the complexity for the user. 
	  */
	set<string> _hiddenFacets;
	/** @brief This holds a pointer to the settings widget currently active.
	  * 
	  * This pointer must not be deleted and should only be used in applySettings(). 
	  */
	DebtagsSettingsWidget* _pSettingsWidget;
public:
	/** Empty Constructor  */
	DebtagsPluginContainer();
	~DebtagsPluginContainer();
	/** @name PluginContainer Interface
	  *
	  * These functions implement the PluginContainer interface.
	  */
	//@{
	virtual bool init(IProvider* pProvider);
	/** @returns "debtagsplugin" */
	virtual string name() const {	return "debtagsplugin"; };
	virtual QString title() const	{ return tr("Debtags Plugins"); };
	/** @brief This returns a list with one entry which is the "Debtags Update" entry
	  *
	  * The QString specifies the menu the action should be added to, the action is
	  * a QAction which is connected to the operation to perform.\n
	  * The default implementation returns an empty vector.
	  */
	vector< pair<QString, QAction*> > actions();
	virtual QWidget* getSettingsWidget(QWidget* pParent);
	virtual void applySettings();
	//@}
	
	/** @name BasePluginContainer Overloads
	  *
	  * These functions implement saving and loading of the container settings
	  * as described in BasePluginContainer.
	  */
	//@{
	virtual QDomElement loadContainerSettings(const QDomElement source);
	virtual void saveContainerSettings(NXml::XmlData& outData, QDomElement parent) const;
	//@}
	
	/** @brief Returns the #_debtagsEnabled property. */
	bool debtagsEnabled()	{ return _debtagsEnabled; };
	/** @brief Returns the facets which are currently in use.
	  *
	  * It gets them from the Debtags::Vocabulary and shows only those which
	  * are not hidden.
	  * @see #_hiddenFacets
	  */
	const Tagcoll::OpSet<cache::entity::Facet> facets() const;
	/** @brief Returns a pointer to the the tag collection currently available. 
	  *
	  * Every item (package) appears only ones in the collection. 
	  */
	Tagcoll::Collection<cache::entity::Package, cache::entity::Tag>*
		collection() const;
protected slots:
	/** @brief Launches the debtags update command. */
	void onDebtagsUpdate();
	/** @brief This function will be called if the update finished. 
	  *
	  * It will update the debtags database used. 
	  */
	void onDebtagsUpdateFinished();
protected:
	/** @brief This sets the debtags operations to be enabled/ disabled 
	  *
	  * If set to false all widgets will be disabled, else they will be enabled.
	  * @see #_debtagsEnabled 
	  */
	void setDebtagsEnabled(bool enabled);
	/** @brief Loads the latest debtags database and informs the plugins about the changing of the
	  * database.
	  * 
	  * Behaves sound when loading fails (informing plugins about set to zero).
	  */
	void updateDebtags();
	/** @brief This loads the vocabulary data and filling the #_facets set. 
	  *
	  * The contained plugins will be informed that the debtags data has changed.
	  * If loading fails #_facets will be left empty. 
	  * @param informPlugins if true the plugins will be informed about changing of
	  * the debtags data, set to false if they will be informed on another way
	  */
	void updateVocabulary(bool informPlugins = true);
};

}	// namespace NPlugin

#endif //	__DEBTAGSPLUGINCONTAINER_H_2004_06_23

