//
// C++ Interface: aptfrontpackagedb
//
// Description: 
//
//
// Author: Benjamin Mesing <bensmail@gmx.net>, (C) 2005
//
// Copyright: See COPYING file that comes with this distribution
//
//
#ifndef __NAPT_APTFRONTPACKAGEDB_H_2005_12_26
#define __NAPT_APTFRONTPACKAGEDB_H_2005_12_26

#include <ipackagedb.h>
#include <iaptsearch.h>

#include "aptfrontpackage.h"

namespace NPlugin
{
	class IProvider;
}

namespace NApt 
{

/**
@author Benjamin Mesing
*/
class AptFrontPackageDB : public IPackageDB, public IAptSearch
{
	/** @brief The provider instance offering the apt-front cache. */
	NPlugin::IProvider* _pProvider;
	/** @todo TODO currently we return a reference to the current package
	  * in getPackageRecord() -- which changes all the time
	  *
	  * Ensure a sane semantic here.
	  */
	mutable AptFrontPackage _currentPackage;
public:
	/** @brief Constructs a new apt-front database, using the apt-front cache of the provider.
	  *
	  * @param pProvider The provider instance offering the apt-front cache. 
	  */
	AptFrontPackageDB(NPlugin::IProvider* pProvider);
	~AptFrontPackageDB();
	/** @name IPackageDB Interface
	  * 
	  * Implementation of the IPackageDB
	  */
	//@{
	virtual const AptFrontPackage& getPackageRecord(const QString& pkg) const;
	virtual const AptFrontPackage& getPackageRecord(const string& package) const;
	virtual const QString getShortDescription(const string& package) const;
	virtual Package::InstalledState getState(const string& package) const;
	virtual void reloadPackageInformation(NUtil::IProgressObserver* pObserver);
	virtual int getDescriptionCount(const string& package, const QString& pattern, bool caseSensitive=false) const;
	virtual bool matchesName(const string& package, const QString& pattern, bool caseSensitive=false) const;
	//@}

	
	/** @name IAptSearch Interface
	  * 
	  * Implementation of the IAptSearch
	  */
	//@{
	virtual bool search(Tagcoll::OpSet<string>& result, const QStringList& includePatterns, 
		const QStringList& excludePatterns, bool searchDescr=true, bool caseSensitive=false) const;
	virtual bool search(Tagcoll::OpSet<string>& result, const QString& pattern, 
		bool searchDescr=true, bool caseSensitive=false) const;
	//@}

};

}

#endif	// 
