//
// C++ Interface: selectedfacetsmatcher
//
// Description: 
//
//
// Author: Benjamin Mesing <bensmail@gmx.net>, (C) 2004
//
// Copyright: See COPYING file that comes with this distribution
//
//
#ifndef __SELECTEDFACETSMATCHER_H_2004_09_01
#define __SELECTEDFACETSMATCHER_H_2004_09_01

#include <set>
#include <string>

#include <tagcoll/TagConsumer.h>

using namespace std;

namespace Debtags 
{
	class FacetSet;
}

namespace NDebtags 
{

/** @brief This class matches the given facets against the list of 
  * facet names used by this matcher.
  *
  * @author Benjamin Mesing
  */
class SelectedFacetsMatcher : public Tagcoll::FacetMatcher
{
	set<string> _facetNames;
public:
	/** @brief Constructs the matcher with the given set of facet names to match against. */
	SelectedFacetsMatcher(const set<string>& facetNames);
	/** @brief Constructs an empty matcher.
	  *
	  * Use addFacetName to add facet names to be matched against. */
	SelectedFacetsMatcher();
	virtual ~SelectedFacetsMatcher();
	/** @brief This adds a new facets to the facet names to be matched against.*/
	void addFacetName(string facetName)	{ _facetNames.insert(facetName); }
	/** @brief Returns if the facet is in the set of facetnames in this matcher.
	  *
	  * This has a complexity of O(log(n)) comparisions where n is the number 
	  * facet names of this matcher. */
	virtual bool match(const Tagcoll::Facet& facet) const throw ();
};

/** @brief This class matches the given facets against the list of 
  * facet names used by this matcher. A facet matches if it is not
  * hidden i.e. not in the #_hiddenFacetNames set.
  *
  * @author Benjamin Mesing
  */
class HiddenFacetsMatcher : public Tagcoll::FacetMatcher
{
	/** @brief Holds the facets that should not match. 
	  *
	  * All facets with names not in this list will match.
	  */
	set<string> _hiddenFacetNames;
public:
	/** @brief Constructs the matcher with the given set of facet names which should 
	  * not match. 
	  *
	  * @see #_hiddenFacetNames
	  */
	HiddenFacetsMatcher(const set<string>& hiddenFacetNames);
	/** @brief Constructs the matcher with the given set of facet names which should 
	  * not match. 
	  *
	  * @param hiddenFacets the facets that shall be hidden.
	  * @see #_hiddenFacetNames
	  */
	HiddenFacetsMatcher(const Tagcoll::FacetSet& hiddenFacets);
	/** @brief Constructs an empty matcher.
	  *
	  * Use addFacetName() to add facet names which should not match. 
	  */
	HiddenFacetsMatcher();
	~HiddenFacetsMatcher();
	/** @brief This adds a new facets to the facet names which should not match*/
	void addFacetName(string hiddenFacetName)	{ _hiddenFacetNames.insert(hiddenFacetName); }
	/** @brief Returns if the facet is not in the set of hidden facet names.
	  *
	  * This has a complexity of O(log(n)) comparisions where n is the number 
	  * facet names of this matcher. */
	virtual bool match(const Tagcoll::Facet& facet) const throw ();
};


};

#endif	// __SELECTEDFACETSMATCHER_H_2004_09_01
