
/*
 * Copyright (C) 2004-2005 Maximilian Schwerin
 *
 * This file is part of oxine a free media player.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 * $Id: utils.h 2606 2007-07-25 09:51:03Z mschwerin $
 *
 */

#include "types.h"

#include "utils_config.h"
#include "utils_files.h"
#include "utils_gui.h"
#include "utils_mrl.h"
#include "utils_playlist.h"

#include "codeset.h"
#include "xmlparser.h"

#ifndef HAVE_UTILS_H
#define HAVE_UTILS_H


/// Returns TRUE if s1 should be sorted after s2.
bool swap_strings (const char *s1, const char *s2);


/**
 * Replaces special characters with 'normal' character. The passed string is
 * changed and returned.
 */
char *replace_special_chars (char *str);


/**
 * Trims whitespace off the start and the end of a string. The passed string
 * is changed and returned.
 */
char *trim_whitespace (char *str);


/**
 * Converts a string to lowercase. The passed string is changed and returned.
 */
char *conv_lowercase (char *string);


/// Returns TRUE if <code>string</code> starts with <code>start</code>.
bool starts_with (const char *string, const char *start);


/**
 * Executes a shell command.
 *
 * @param command               The command to execute.
 * @param retval                The expected return value.
 *
 * @return                      If the value returned by <code>system</code>
 *                              equals the expected return value provided by
 *                              the caller TRUE is returned.
 */
bool execute_shell (const char *command, int retval);


/**
 * Escapes and recodes a string to be written to an XML file.
 *
 * @param str                   The original string.
 * @param xr                    The recoding datestructure.
 * @param quote_type            The type of quotes the string 
 *                              will be enclosed in.
 */
char *xml_escape (const char *str, recode_t * xr,
                  xml_escape_quote_t quote_type);


#endif /* HAVE_UTILS_H */
