
/*
 * Copyright (C) 2004-2005 Maximilian Schwerin
 *
 * This file is part of oxine a free media player.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 * $Id: menu_main.h 2324 2007-06-26 13:20:47Z mschwerin $
 *
 */

#ifndef HAVE_MAIN_MENU_H
#define HAVE_MAIN_MENU_H

#include "oxine.h"

void eject_cb (void *cb_data);
void execute_cb (void *cmd_p);
void shutdown_cb (void *cb_data);

void play_tv_cb (void *cb_data);
void play_dvb_cb (void *cb_data);
void play_v4l_cb (void *cb_data);
#ifdef HAVE_VDR
void play_vdr_cb (void *cb_data);
#endif
void play_mrl_cb (void *mrl_p);

void play_dvd_cb (void *device_p);
void play_vcd_cb (void *device_p);
void play_cdda_cb (void *device_p);

void show_menu_sub (void *menu_mrl_p);
void show_menu_main (void *cb_data);

void init_menu_main (void);
void free_menu_main (void);

#endif /* HAVE_MAIN_MENU_H */
