
/*
 * Copyright (C) 2002-2003 Stefan Holst
 * Copyright (C) 2004-2005 Maximilian Schwerin
 *
 * This file is part of oxine a free media player.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 * $Id: odk_plugin.h 1182 2006-09-22 07:53:33Z mschwerin $
 *
 */

#ifndef HAVE_ODK_PLUGIN_H
#define HAVE_ODK_PLUGIN_H
#ifdef __cplusplus
extern "C" {
#endif

#include "event.h"

typedef struct odk_window_s odk_window_t;

/*
 * plugin description
 */
typedef struct {
    const char *name;           /* short plugin name */
    const char *desc;           /* one line of plugin description */
    const char *driver;         /* video driver for this plugin, pass this to constructor! */

    odk_window_t *(*constructor) (xine_t * xine, const char *driver);
} window_plugin_desc_t;

typedef void (*odk_cb) (void *data, oxine_event_t * ev);

/*
 * The window base class
 *
 * The size and position do not have to be the same as the real output window.
 * This is used for underscanning. The real window can thus be larger than the
 * output.
 *
 * Xine should only be told about the output size and position.
 */
struct odk_window_s {
    xine_t *xine;
    xine_stream_t *stream;
    xine_audio_port_t *audio_port;
    xine_video_port_t *video_port;

    // The width and height of the area inside 
    // the output window we use for our output.
    int output_width;
    int output_height;

    // The top-left corner of our output area.
    int output_xpos;
    int output_ypos;

    int (*show) (odk_window_t * this);
    int (*hide) (odk_window_t * this);
    int (*displace) (odk_window_t * this, int x, int y, int w, int h);
    void (*event_loop) (odk_window_t * this);
    void (*stop_event_loop) (odk_window_t * this);
    int (*dispose) (odk_window_t * this);
    int (*fullscreen) (odk_window_t * this, int fullscreen);
    int (*is_fullscreen) (odk_window_t * this);
    void (*set_event_handler) (odk_window_t * this, odk_cb cb, void *data);
};

#ifdef __cplusplus
}
#endif
#endif /* HAVE_ODK_PLUGIN_H */
