
/*
 * Copyright (C) 2006 Maximilian Schwerin
 *
 * This file is part of oxine a free media player.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 * $Id: vdr.h 1278 2006-10-10 11:11:46Z mschwerin $
 *
 */

#ifndef HAVE_VDR_H
#define HAVE_VDR_H
#ifdef __cplusplus
extern "C" {
#endif

#include "types.h"
#include "filelist.h"

#ifdef HAVE_VDR

/* 
 * ***************************************************************************
 * Name:            vdr_recordings_read
 * Access:          public
 *
 * Description:     Reads the currently available VDR recordings into a
 *                  filelist.
 * ***************************************************************************
 */
bool vdr_recordings_read (filelist_t *filelist);

/* 
 * ***************************************************************************
 * Name:            vdr_play_recording
 * Access:          public
 *
 * Description:     Plays the specified recording.
 * ***************************************************************************
 */
bool vdr_play_recording (const char *mrl);

/* 
 * ***************************************************************************
 * Name:            vdr_remove_recording
 * Access:          public
 *
 * Description:     Removes the specified recording.
 * ***************************************************************************
 */
bool vdr_remove_recording (const char *mrl);

/* 
 * ***************************************************************************
 * Name:            vdr_config_register_all
 * Access:          public
 *
 * Description:     Register all configs.
 * ***************************************************************************
 */
void vdr_config_register_all (void);
#endif

#ifdef __cplusplus
}
#endif
#endif /* HAVE_VDR_H */
