
/*
 * Copyright (C) 2004-2005 Maximilian Schwerin
 *
 * This file is part of oxine a free media player.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 * $Id: dvd_menu.c 1555 2006-11-15 09:04:35Z mschwerin $
 *
 */
#include "config.h"

#include "gui_utils.h"
#include "odk.h"
#include "oxine.h"
#include "dvd_menu.h"

static void
dvd_menu (void *data, int menu)
{
    oxine_t *oxine = (oxine_t *) data;
    hide_user_interface (oxine);
    odk_xine_event_send (oxine->odk, true, menu);
}

void
dvd_menu1_cb (void *cb_data)
{
    dvd_menu (cb_data, XINE_EVENT_INPUT_MENU1);
}

void
dvd_menu2_cb (void *cb_data)
{
    dvd_menu (cb_data, XINE_EVENT_INPUT_MENU2);
}

void
dvd_menu3_cb (void *cb_data)
{
    dvd_menu (cb_data, XINE_EVENT_INPUT_MENU3);
}

void
dvd_menu4_cb (void *cb_data)
{
    dvd_menu (cb_data, XINE_EVENT_INPUT_MENU4);
}

void
dvd_menu5_cb (void *cb_data)
{
    dvd_menu (cb_data, XINE_EVENT_INPUT_MENU5);
}

void
dvd_menu6_cb (void *cb_data)
{
    dvd_menu (cb_data, XINE_EVENT_INPUT_MENU6);
}

void
dvd_menu7_cb (void *cb_data)
{
    dvd_menu (cb_data, XINE_EVENT_INPUT_MENU7);
}
