///////////////////////////////////////////////////////////////////////////////
//
//  Copyright (2008) Alexander Stukowski
//
//  This file is part of OVITO (Open Visualization Tool).
//
//  OVITO is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version.
//
//  OVITO is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program.  If not, see <http://www.gnu.org/licenses/>.
//
///////////////////////////////////////////////////////////////////////////////

#ifndef __STARTUP_SCRIPT_EXECUTOR_H
#define __STARTUP_SCRIPT_EXECUTOR_H

#include <scripting/Scripting.h>
#include <core/plugins/autostart/AutoStart.h>
#include "ScriptEngine.h"

namespace Scripting {

/**
 * \brief This auto start class executes the startup script on application startup.
 *
 * \author Alexander Stukowski
 */
class SCRIPTING_DLLEXPORT StartupScriptExecutor : public AutoStart
{
public:

	/// \brief Default constructor.
	StartupScriptExecutor(bool isLoading = false) : AutoStart() {}

	/// \brief Performs the class specific work on application startup.
	/// \param stage The current stage of application startup.
	///
	/// This method is called several time by the system on application startup.
	virtual void startEvent(InitializationStage stage);

private:
	Q_OBJECT
	DECLARE_PLUGIN_CLASS(StartupScriptExecutor)
};

};

#endif // __STARTUP_SCRIPT_EXECUTOR_H

