#!/bin/sh

if [ -z "$*" ]; then
	echo ERROR: This script is for internal use by the Makefile only
	echo If you are trying to install, please run "make install"
	exit 1
fi

UNAME=`uname -r`

INSTALL_PATH_2_4=/lib/modules/$UNAME/kernel/drivers/usb/
INSTALL_PATH_2_6=/lib/modules/$UNAME/kernel/drivers/usb/media/

MAJMIN=`echo $UNAME | cut -d . -f 1-2`

echo Detected $MAJMIN kernel

case "$MAJMIN" in
  2.4)
	INSTALL_PATH=$INSTALL_PATH_2_4
	;;
  2.6)
	INSTALL_PATH=$INSTALL_PATH_2_6
	;;
  *)
	echo ERROR: Kernel version not supported
	exit 1
esac

echo Creating install path:  $INSTALL_PATH
install -d $INSTALL_PATH

for MODULE in $* ; do
	echo Installing $MODULE to $INSTALL_PATH
	install $MODULE $INSTALL_PATH
done

echo Finding module dependencies
/sbin/depmod -ae

echo All done!
