# --
# Kernel/Language/pl.pm - provides Polish language translation
# Copyright (C) 2003-2010 Tomasz Melissa <janek at rumianek.com>
# Copyright (C) 2009 Artur Skalski <skal.ar at wp.pl>
# --
# $Id: pl.pm,v 1.105.2.3 2011/09/07 21:01:29 en Exp $
# --
# This software comes with ABSOLUTELY NO WARRANTY. For details, see
# the enclosed file COPYING for license information (AGPL). If you
# did not receive this file, see http://www.gnu.org/licenses/agpl.txt.
# --

package Kernel::Language::pl;

use strict;
use warnings;

use vars qw($VERSION);
$VERSION = qw($Revision: 1.105.2.3 $) [1];

sub Data {
    my $Self = shift;

    # $$START$$
    # Last translation file sync: 2011-03-21 17:28:46

    # possible charsets
    $Self->{Charset} = ['iso-8859-2', ];
    # date formats (%A=WeekDay;%B=LongMonth;%T=Time;%D=Day;%M=Month;%Y=Year;)
    $Self->{DateFormat}          = '%Y-%M-%D %T';
    $Self->{DateFormatLong}      = '%A %D %B %T %Y';
    $Self->{DateFormatShort}     = '%Y%-M-%D';
    $Self->{DateInputFormat}     = '%Y-%M-%D';
    $Self->{DateInputFormatLong} = '%Y-%M-%D - %T';

    # csv separator
    $Self->{Separator} = ';';

    $Self->{Translation} = {

        # Template: AAABase
        'Yes' => 'Tak',
        'No' => 'Nie',
        'yes' => 'tak',
        'no' => 'nie',
        'Off' => 'Wyczone',
        'off' => 'wyczone',
        'On' => 'Wczone',
        'on' => 'wczone',
        'top' => 'gra',
        'end' => 'koniec',
        'Done' => 'Zrobione',
        'Cancel' => 'Anuluj',
        'Reset' => 'Resetuj',
        'last' => 'w cigu',
        'before' => 'przed',
        'Today' => 'Dzi',
        'Tomorrow' => 'Jutro',
        'Next Week' => 'Nastpny tydzie',
        'day' => 'dzie',
        'days' => 'dni',
        'day(s)' => 'dzie(dni)',
        'd' => '',
        'hour' => 'godzina',
        'hours' => 'godz.',
        'hour(s)' => 'godz.',
        'Hours' => '',
        'h' => '',
        'minute' => 'minuta',
        'minutes' => 'minut',
        'minute(s)' => 'minuta(minut)',
        'Minutes' => '',
        'm' => '',
        'month' => 'miesic',
        'months' => 'miesicy',
        'month(s)' => 'miesic(-cy)',
        'week' => 'tydzie',
        'week(s)' => 'tydzie(tygodnie)',
        'year' => 'rok',
        'years' => 'lat',
        'year(s)' => 'rok(lat)',
        'second(s)' => 'sekund(a)',
        'seconds' => 'sekund',
        'second' => 'drugi',
        's' => '',
        'wrote' => 'napisa',
        'Message' => 'Wiadomo',
        'Error' => 'Bd',
        'Bug Report' => 'Zgo bd',
        'Attention' => 'Uwaga',
        'Warning' => 'Ostrzeenie',
        'Module' => 'Modu',
        'Modulefile' => 'Plik Moduu',
        'Subfunction' => 'Funkcja podrzdna',
        'Line' => 'Linia',
        'Setting' => 'Ustawienie',
        'Settings' => 'Ustawienia',
        'Example' => 'Przykad',
        'Examples' => 'Przykady',
        'valid' => 'aktywne',
        'invalid' => 'nieaktywne',
        '* invalid' => '* nieaktywne',
        'invalid-temporarily' => 'Czasowo nieaktywne',
        ' 2 minutes' => ' 2 Minuty',
        ' 5 minutes' => ' 5 Minut',
        ' 7 minutes' => ' 7 Minut',
        '10 minutes' => '10 Minut',
        '15 minutes' => '15 Minut',
        'Mr.' => 'Pan',
        'Mrs.' => 'Pani',
        'Next' => 'Dalej',
        'Back' => 'Powrt',
        'Next...' => 'Dalej...',
        '...Back' => '...Powrt',
        '-none-' => '-brak-',
        'none' => 'brak danych',
        'none!' => 'brak!',
        'none - answered' => 'brak - odpowiedziane',
        'please do not edit!' => 'nie edytowa!',
        'Need Action' => 'Wymagana akcja',
        'AddLink' => 'Dodaj link',
        'Link' => 'Pocz',
        'Unlink' => 'Rozcz',
        'Linked' => 'Poczone',
        'Link (Normal)' => 'Poczone (rwnorzdnie)',
        'Link (Parent)' => 'Poczone (Rodzic)',
        'Link (Child)' => 'Poczone (Potomek)',
        'Normal' => 'Normalne',
        'Parent' => 'Rodzic',
        'Child' => 'Potomek',
        'Hit' => 'Odsona',
        'Hits' => 'Odson',
        'Text' => 'Tre',
        'Standard' => 'Standard',
        'Lite' => 'Lekkie',
        'User' => 'Uytkownik',
        'Username' => 'Nazwa uytkownika',
        'Language' => 'Jzyk',
        'Languages' => 'Jzyki',
        'Password' => 'Haso',
        'Preferences' => 'Ustawienia',
        'Salutation' => 'Zwrot grzecznociowy',
        'Salutations' => 'Powitania',
        'Signature' => 'Podpis',
        'Signatures' => 'Podpisy',
        'Customer' => 'Klient',
        'CustomerID' => 'ID klienta',
        'CustomerIDs' => 'IDs Klienta',
        'customer' => 'klient',
        'agent' => 'agent',
        'system' => 'System',
        'Customer Info' => 'Informacja o kliencie',
        'Customer Information' => 'Informacje o kliencie',
        'Customer Company' => 'Firma klienta',
        'Customer Companies' => 'Firmy klientw',
        'Company' => 'Firma',
        'go!' => 'Start!',
        'go' => 'Start',
        'All' => 'Wszystkie',
        'all' => 'wszystkie',
        'Sorry' => 'Przykro mi',
        'update!' => 'zapisz!',
        'update' => 'zapisz',
        'Update' => 'Zapisz',
        'Updated!' => 'Uaktualniono!',
        'submit!' => 'akceptuj!',
        'submit' => 'akceptuj',
        'Submit' => 'Akceptuj',
        'change!' => 'Zmie!',
        'Change' => 'Zmie',
        'change' => 'zmie',
        'click here' => 'kliknij tutaj',
        'Comment' => 'Komentarz',
        'Valid' => 'Aktywne',
        'Invalid Option!' => 'Bdna opcja!',
        'Invalid time!' => 'Bdny czas!',
        'Invalid date!' => 'Bedna data!',
        'Name' => 'Nazwa',
        'Group' => 'Grupa',
        'Description' => 'Opis',
        'description' => 'opis',
        'Theme' => 'Schemat',
        'Created' => 'Utworzone',
        'Created by' => 'Utworzone przez',
        'Changed' => 'Zmienione',
        'Changed by' => 'Zmienione przez',
        'Search' => 'Szukaj',
        'and' => 'i',
        'between' => 'pomidzy',
        'Fulltext Search' => 'Wyszukiwanie penotekstowe',
        'Data' => 'Data',
        'Options' => 'Opcje',
        'Title' => 'Tytu',
        'Item' => 'Pozycja',
        'Delete' => 'Kasuj',
        'Edit' => 'Edytuj',
        'View' => 'Widok',
        'Number' => 'Liczba',
        'System' => 'System',
        'Contact' => 'Kontakt',
        'Contacts' => 'Kontakty',
        'Export' => 'Eksport',
        'Up' => 'Gra',
        'Down' => 'D',
        'Add' => 'Dodaj',
        'Added!' => 'Dodano!',
        'Category' => 'Kategoria',
        'Viewer' => 'Przegldarka',
        'Expand' => 'Rozwi',
        'Small' => 'Mae',
        'Medium' => 'rednie',
        'Large' => 'Due',
        'Date picker' => 'Wybr daty',
        'New message' => 'Nowa wiadomo',
        'New message!' => 'Nowa wiadomo!',
        'Please answer this ticket(s) to get back to the normal queue view!' => 'Prosz odpowiedz na to zgoszenie, by mc powroci do zwykego widoku kolejki zgosze!',
        'You have %s new message(s)!' => 'Masz %s nowych wiadomoci!',
        'You have %s reminder ticket(s)!' => 'Masz %s przypomnie o zgoszeniach!',
        'The recommended charset for your language is %s!' => 'Sugerowane kodowanie dla Twojego jzyka to %s!',
        'Change your password.' => 'Zmie haso',
        'Please activate %s first!' => 'Najpierw aktywuj %s',
        'No suggestions' => 'Brak podpowiedzi',
        'Word' => 'Sowo',
        'Ignore' => 'Ignoruj',
        'replace with' => 'zamie z',
        'There is no account with that login name.' => 'Nie istnieje konto z takim loginem.',
        'Login failed! Your user name or password was entered incorrectly.' => '',
        'There is no acount with that user name.' => '',
        'Please contact your administrator' => '',
        'Logout' => 'Wyloguj',
        'Logout successful. Thank you for using OTRS!' => 'Wylogowanie zakoczone! Dzikujemy za uywanie OTRS!',
        'Invalid SessionID!' => 'Niepoprawne ID Sesji!',
        'Feature not active!' => 'Funkcja nie aktywna!',
        'Agent updated!' => '',
        'Create Database' => 'Stwrz baz danych',
        'System Settings' => 'Ustawienia systemu',
        'Mail Configuration' => '',
        'Finished' => 'Zakoczono',
        'Login is needed!' => 'Wymagane zalogowanie!',
        'Password is needed!' => 'Haso jest wymagane!',
        'License' => 'Licencja',
        'Take this Customer' => 'Uyj tego klienta!',
        'Take this User' => 'Uyj tego uytkownika',
        'possible' => 'moliwe',
        'reject' => 'odrzu',
        'reverse' => 'odwr',
        'Facility' => 'Uatwienie',
        'Time Zone' => 'Strefa czasowa',
        'Pending till' => 'Oczekuje do',
        'Don\'t work with UserID 1 (System account)! Create new users!' => 'Nie uywaj uytkownika z UserID 1 (Konto systemowe)! Stwrz nowych uytkownikw!',
        'Dispatching by email To: field.' => 'Przekazywanie na podstawie pola DO:',
        'Dispatching by selected Queue.' => 'Przekazywanie na podstawie zaznaczonej kolejki.',
        'No entry found!' => 'Nic nie odnaleziono!',
        'Session has timed out. Please log in again.' => 'Sesja wygasa. Zaloguj si ponownie',
        'No Permission!' => 'Brak uprawnie',
        'To: (%s) replaced with database email!' => 'DO: (%s) zamienione z adresem email z bazy danych',
        'Cc: (%s) added database email!' => 'Cc: (%s) zamienione z adresem email z bazy danych',
        '(Click here to add)' => '(By doda kliknij tutaj)',
        'Preview' => 'Podgld',
        'Package not correctly deployed! You should reinstall the Package again!' => 'Pakiet niewaciwie zainstalowany! Naley reinstalowa pakiet!',
        '%s is not writable!' => '',
        'Cannot create %s!' => 'Nie mona utworzy %s!',
        'Customer %s added' => '',
        'Role added!' => 'Rola dodana!',
        'Role updated!' => '',
        'Attachment added!' => '',
        'Attachment updated!' => '',
        'Response added!' => '',
        'Response updated!' => '',
        'Group updated!' => '',
        'Queue added!' => '',
        'Queue updated!' => '',
        'State added!' => '',
        'State updated!' => '',
        'Type added!' => '',
        'Type updated!' => '',
        'Customer updated!' => '',
        'Contract' => 'Umowa',
        'Online Customer: %s' => 'Klient zalogowany: %s',
        'Online Agent: %s' => 'Agent zalogowany: %s',
        'Calendar' => 'Kalendarz',
        'File' => 'Plik',
        'Filename' => 'Nazwa pliku',
        'Type' => 'Typ zgoszenia',
        'Size' => 'Rozmiar',
        'Upload' => 'Wysyanie',
        'Directory' => 'Katalog',
        'Signed' => 'Podpisany',
        'Sign' => 'Podpis',
        'Crypted' => 'Zaszyfrowany',
        'Crypt' => 'Szyfr',
        'PGP' => 'PGP',
        'PGP Key' => 'Klucz PGP',
        'PGP Keys' => 'Klucze PGP',
        'S/MIME' => '',
        'S/MIME Certificate' => 'Certyfikat S/MIME',
        'S/MIME Certificates' => 'Certyfikaty S/MIME',
        'Office' => 'Biuro',
        'Phone' => 'Tel.',
        'Fax' => 'Fax',
        'Mobile' => 'Tel. komrkowy',
        'Zip' => 'Kod',
        'City' => 'Miasto',
        'Street' => 'Ulica',
        'Country' => 'Kraj',
        'Location' => 'Miejsce',
        'installed' => 'zainstalowany',
        'uninstalled' => 'odinstalowany',
        'Security Note: You should activate %s because application is already running!' => 'Nota bezpieczestwa: Naley aktywowa %s poniewa aplikacja jest uruchomiona!',
        'Unable to parse repository index document.' => '',
        'No packages for your framework version found in this repository, it only contains packages for other framework versions.' => '',
        'No packages, or no new packages, found in selected repository.' => '',
        'Edit the system configuration settings.' => '',
        'printed at' => 'wydrukowano',
        'Loading...' => 'adowanie...',
        'Dear Mr. %s,' => 'Drogi Panie %s,',
        'Dear Mrs. %s,' => 'Droga Pani %s,',
        'Dear %s,' => 'Drogi %s,',
        'Hello %s,' => 'Witaj %s,',
        'This email address already exists. Please log in or reset your password.' => '',
        'New account created. Sent login information to %s. Please check your email.' => '',
        'Please press Back and try again.' => 'Prosze wybra Cofnij i sprbowac ponownie.',
        'Sent password reset instructions. Please check your email.' => '',
        'Sent new password to %s. Please check your email.' => '',
        'Upcoming Events' => 'Zbliajce si wydarzenia',
        'Event' => 'Zdarzenie',
        'Events' => 'Zdarzenia',
        'Invalid Token!' => 'Bdny token!',
        'more' => 'wicej',
        'For more info see:' => 'Wicej informacji',
        'Package verification failed!' => 'Weryfikacja pakietu nie powioda si!',
        'Collapse' => 'Zwi',
        'Shown' => 'Pokazane',
        'News' => 'Informacje',
        'Product News' => 'Informacje o produkcie',
        'OTRS News' => 'Wiadomoci OTRS',
        '7 Day Stats' => 'Statystyki z 7 dni',
        'Bold' => 'Pogrubienie',
        'Italic' => 'Italiki',
        'Underline' => 'Podkrelenie',
        'Font Color' => 'Kolor czcionki',
        'Background Color' => 'Kolor ta',
        'Remove Formatting' => 'Usu formatowanie',
        'Show/Hide Hidden Elements' => 'Poka/Ukryj ukryte wiadomoci',
        'Align Left' => 'Wyrwnanie do lewej',
        'Align Center' => 'Wyrwnanie do rodka',
        'Align Right' => 'Wyrwnanie do prawej',
        'Justify' => 'Justowanie',
        'Header' => 'Nagwek',
        'Indent' => 'Wcicie',
        'Outdent' => '',
        'Create an Unordered List' => 'Stwrz list nienumerowan',
        'Create an Ordered List' => 'Stwrz list numerowan',
        'HTML Link' => 'cze',
        'Insert Image' => 'Wstaw obraz',
        'CTRL' => '',
        'SHIFT' => '',
        'Undo' => 'Cofnij',
        'Redo' => 'Ponw',

        # Template: AAAMonth
        'Jan' => 'Sty',
        'Feb' => 'Lut',
        'Mar' => 'Mar',
        'Apr' => 'Kwi',
        'May' => 'Maj',
        'Jun' => 'Cze',
        'Jul' => 'Lip',
        'Aug' => 'Sie',
        'Sep' => 'Wrz',
        'Oct' => 'Pa',
        'Nov' => 'Lis',
        'Dec' => 'Gru',
        'January' => 'Stycze',
        'February' => 'Luty',
        'March' => 'Marzec',
        'April' => 'Kwiecie',
        'May_long' => 'Maj',
        'June' => 'Czerwiec',
        'July' => 'Lipiec',
        'August' => 'Sierpie',
        'September' => 'Wrzesie',
        'October' => 'Padziernik',
        'November' => 'Listopad',
        'December' => 'Grudzie',

        # Template: AAAPreferences
        'Preferences updated successfully!' => 'Ustawienia zapisano pomylnie!',
        'User Profile' => 'Profil uytkownika',
        'Email Settings' => 'Ustawienia poczty email',
        'Other Settings' => 'Inne ustawienia',
        'Change Password' => 'Zmie haso',
        'Current Password' => 'Aktualne haso',
        'New password' => 'Nowe haso',
        'Verify password' => '',
        'Spelling Dictionary' => 'Sownik pisowni',
        'Default spelling dictionary' => 'Domylny sownik sprawdzania pisowni.',
        'Max. shown Tickets a page in Overview.' => 'Limit pokazywanych zgosze na stronie Podsumowania',
        'The current password is not correct. Please try again!' => 'Haso jest niepoprawne. Sprbuj jeszcze raz!',
        'Can\'t update password, your new passwords do not match. Please try again!' => 'Nie mona zmieni hasa, nowe powtrzenia nowego hasa nie zgadzaj si.',
        'Can\'t update password, it contains invalid characters!' => 'Nie mona zmieni hasa poniewa nowe haso zawiera nidozwolone znaki.',
        'Can\'t update password, it must be at least %s characters long!' => 'Nie mona zmieni hasa, nowe haso musi zawiera co najmniej $s znakw.',
        'Can\'t update password, it must contain at least 2 lowercase  and 2 uppercase characters!' => 'Nie mona zmieni hasa. Haso musi zawiera co najmniej 2 wielkie i 2 mae litery.',
        'Can\'t update password, it must contain at least 1 digit!' => 'Nie mona zmieni hasa. Haso musi zawiera co najmniej 1 cyfr.',
        'Can\'t update password, it must contain at least 2 characters!' => 'Nie mona zmieni hasa. Haso musi zawiera co najmniej dwa znaki specjalne.',
        'Can\'t update password, this password has already been used. Please choose a new one!' => 'Nie mona zmieni hasa poniewa byo ju uywane. Naley wybra nowe haso!',
        'Select the separator character used in CSV files (stats and searches). If you don\'t select a separator here, the default separator for your language will be used.' => '',
        'CSV Separator' => '',

        # Template: AAAStats
        'Stat' => 'Statystyki',
        'Sum' => '',
        'Please fill out the required fields!' => 'Wypenij wymagane pola!',
        'Please select a file!' => 'Wybierz plik!',
        'Please select an object!' => 'Wybierz obiekt!',
        'Please select a graph size!' => 'Wybierz rozmiar wykresu!',
        'Please select one element for the X-axis!' => 'Wybierz element dla osi X!',
        'Please select only one element or turn off the button \'Fixed\' where the select field is marked!' => 'Wybierz tylko jeden element lyb wycz klawisz\'Stae\' przy zaznaczonym polu!',
        'If you use a checkbox you have to select some attributes of the select field!' => 'Po zaznaczeniu pola wyboru musisz wskaza atrybuty wybranego pola!',
        'Please insert a value in the selected input field or turn off the \'Fixed\' checkbox!' => 'Wprowad warto w wybrane pole lub odznacz pole \'Stay\'!',
        'The selected end time is before the start time!' => 'Czas zakoczenia wczeniejszy od czasu rozpoczcia!',
        'You have to select one or more attributes from the select field!' => 'Wska jeden lub wicej atrybut z pola wyboru!',
        'The selected Date isn\'t valid!' => 'Wybrana data jest nieprawidowa!',
        'Please select only one or two elements via the checkbox!' => 'Zaznacz tylko jeden lub dwa pola wyboru!',
        'If you use a time scale element you can only select one element!' => 'Jeeli uywasz skalowania czasu moesz wybra tylko jeden element!',
        'You have an error in your time selection!' => 'Bd w wyborze czasu!',
        'Your reporting time interval is too small, please use a larger time scale!' => 'Wybrany zakres czasu jest za may, uyj wikszej skali czasu!',
        'The selected start time is before the allowed start time!' => 'Wybrany czas pocztku jest przed dozwolonym czasem rozpoczcia!',
        'The selected end time is after the allowed end time!' => 'Wybrany czas koca przekracza dopuszczalny czas zakoczenia!',
        'The selected time period is larger than the allowed time period!' => 'Wybrany zakres czasu przekracza maksymalny dopuszczalny!',
        'Common Specification' => 'Podstawowa specyfikacja',
        'X-axis' => 'O X',
        'Value Series' => 'Serie wartoci',
        'Restrictions' => 'Ograniczenia',
        'graph-lines' => 'wykres-linie',
        'graph-bars' => 'wykres-supki',
        'graph-hbars' => 'wykres-supki poziome',
        'graph-points' => 'wykres-punkty',
        'graph-lines-points' => 'wykres- linie i punkty',
        'graph-area' => 'obszar wykresu',
        'graph-pie' => 'wykres-koowy',
        'extended' => 'rozszerzony',
        'Agent/Owner' => 'Obsugujcy/Waciciel',
        'Created by Agent/Owner' => 'Utworzony przez Obsugujcego/Waciciela',
        'Created Priority' => 'Utworzony prirytet',
        'Created State' => 'Utworzony status',
        'Create Time' => 'Czas utworzenia',
        'CustomerUserLogin' => 'Login klienta',
        'Close Time' => 'Czas zamknicia',
        'TicketAccumulation' => '',
        'Attributes to be printed' => 'Drukowane atrybuty',
        'Sort sequence' => 'Kolejno sortowania',
        'Order by' => 'Sortuj wedug',
        'Limit' => 'Limit',
        'Ticketlist' => 'Lista zgosze',
        'ascending' => 'rosnco',
        'descending' => 'malejco',
        'First Lock' => 'Pierwsza Blokada',
        'Evaluation by' => 'Ewaluacja do',
        'Total Time' => 'Cakowity Czas',
        'Ticket Average' => 'Zgoszenie rednio',
        'Ticket Min Time' => 'Zgoszenie Min Czas',
        'Ticket Max Time' => 'Zgoszenie Max Czas',
        'Number of Tickets' => 'Ilo Zgosze',
        'Article Average' => 'Wiadomo rednio',
        'Article Min Time' => 'Wiadomo Min Czas',
        'Article Max Time' => 'Wiadomo Max Czas',
        'Number of Articles' => 'Ilo wiadomoci',
        'Accounted time by Agent' => 'Czas zaraportowany przez Agenta',
        'Ticket/Article Accounted Time' => 'Zaraportowany czas Zgoszenia/Wiadomoci',
        'TicketAccountedTime' => 'Zaraportowany Czas Zgoszenia',
        'Ticket Create Time' => 'Czas Utworzenia Zgoszenia',
        'Ticket Close Time' => 'Czas Zamknicia Zgoszenia',

        # Template: AAATicket
        'Status View' => '',
        'Bulk' => 'Zaznacz',
        'Lock' => 'Zablokuj',
        'Unlock' => 'Odblokuj',
        'History' => 'Historia',
        'Zoom' => 'Podgld',
        'Age' => 'Wiek',
        'Bounce' => 'Przeka',
        'Forward' => 'Przelij dalej',
        'From' => 'Od',
        'To' => 'Do',
        'Cc' => 'Cc',
        'Bcc' => 'Bcc',
        'Subject' => 'Temat',
        'Move' => 'Przenie',
        'Queue' => 'Kolejka',
        'Queues' => 'Kolejki',
        'Priority' => 'Priorytet',
        'Priorities' => 'Priorytety',
        'Priority Update' => 'Aktualizacja priorytetu',
        'SLA' => 'SLA',
        'Service Level Agreement' => 'Poziom Serwisu (SLA)',
        'Service Level Agreements' => 'Poziomy serwisu (SLA)',
        'Service' => 'Usuga',
        'Services' => 'Usugi serwisowe',
        'State' => 'Status',
        'States' => 'Statusy',
        'Status' => 'Status',
        'Statuses' => 'Statusy',
        'Ticket Type' => 'Typ zgoszenia',
        'Ticket Types' => 'Typy zgosze',
        'Compose' => 'Stwrz',
        'Pending' => 'Oczekujce',
        'Owner' => 'Waciciel',
        'Owner Update' => 'Aktualizacja wasciciela',
        'Responsible' => 'Odpowiedzialny',
        'Responsible Update' => 'Aktualizacja odpowiedzialnego',
        'Sender' => 'Nadawca',
        'Article' => 'Artyku',
        'Ticket' => 'Zgoszenie',
        'Createtime' => 'Utworzone o',
        'plain' => 'bez formatowania',
        'Email' => 'E-Mail',
        'email' => 'e-mail',
        'Close' => 'Zamknij',
        'Action' => 'Akcja',
        'Attachment' => 'Zacznik',
        'Attachments' => 'Zaczniki',
        'This message was written in a character set other than your own.' => 'Ta wiadomo zostaa napisana z uyciem kodowania znakw innego ni Twj.',
        'If it is not displayed correctly,' => 'Jeli nie jest wywietlane poprawnie,',
        'This is a' => 'To jest',
        'to open it in a new window.' => 'by otworzy w oddzielnym oknie',
        'This is a HTML email. Click here to show it.' => 'To jest e-mail w formacie HTML. Kliknij tutaj, by go przeczyta.',
        'Free Fields' => 'Dodatkowe atrybuty',
        'Merge' => 'Scalaj',
        'merged' => 'scalone',
        'closed successful' => 'zamknite z powodzeniem',
        'closed unsuccessful' => 'zamknite bez powodzenia',
        'Locked Tickets Total' => '',
        'Locked Tickets Reminder Reached' => '',
        'Locked Tickets New' => '',
        'Responsible Tickets Total' => '',
        'Responsible Tickets New' => '',
        'Responsible Tickets Reminder Reached' => '',
        'Watched Tickets Total' => '',
        'Watched Tickets New' => '',
        'Watched Tickets Reminder Reached' => '',
        'All tickets' => 'Wszystkie zgoszenia',
        'Tickets available' => 'Dostpne zgoszenia',
        'Escalation' => 'Eskalacja',
        'last-search' => '',
        'QueueView' => 'Przegld kolejki',
        'Ticket Escalation View' => 'Widok eskalowanych zgosze',
        'new' => 'nowe',
        'open' => 'otwarte',
        'Open' => 'Otwarte',
        'closed' => 'zamknite',
        'Closed' => 'Zamknite',
        'removed' => 'usunite',
        'pending reminder' => 'oczekujce przypomnienie',
        'pending auto' => 'oczekujce auto',
        'pending auto close+' => 'oczekujce na automatyczne zamknicie+',
        'pending auto close-' => 'oczekujce na automatyczne zamknicie-',
        'email-external' => 'e-mail zewntrzny',
        'email-internal' => 'e-mail wewntrzny',
        'note-external' => 'Notatka zewntrzna',
        'note-internal' => 'Notatka wewntrzna',
        'note-report' => 'Notatka raportujaca',
        'phone' => 'telefon',
        'sms' => 'SMS',
        'webrequest' => 'zgoszenie WWW',
        'lock' => 'zablokowane',
        'unlock' => 'odblokowane',
        'very low' => 'bardzo niski',
        'low' => 'niski',
        'normal' => 'normalny',
        'high' => 'wysoki',
        'very high' => 'bardzo wysoki',
        '1 very low' => '1 bardzo niski',
        '2 low' => '2 niski',
        '3 normal' => '3 normalny',
        '4 high' => '4 wysoki',
        '5 very high' => '5 bardzo wysoki',
        'Ticket "%s" created!' => 'Zgoszenie "%s" utworzone!',
        'Ticket Number' => 'Numer zgoszenia',
        'Ticket Object' => 'Obiekt zgoszenia',
        'No such Ticket Number "%s"! Can\'t link it!' => 'Nie znaleziono zgoszenia numer "%s"! Nie mozna poczy!',
        'Don\'t show closed Tickets' => 'Nie pokazuj zamknitych zgosze',
        'Show closed Tickets' => 'Poka zamknite zgoszenia',
        'New Article' => 'Nowy artyku',
        'Unread article(s) available' => '',
        'Remove from list of watched tickets' => '',
        'Add to list of watched tickets' => '',
        'Email-Ticket' => 'Zgoszenie e-mail',
        'Create new Email Ticket' => 'Utwrz nowe zgoszenie e-mail',
        'Phone-Ticket' => 'Zgoszenie telefoniczne',
        'Search Tickets' => 'Szukaj zgosze',
        'Edit Customer Users' => 'Edycja klientw',
        'Edit Customer Company' => 'Edycja firm',
        'Bulk Action' => 'Akcja grupowa',
        'Bulk Actions on Tickets' => 'Akcje grupowe na zgoszeniach',
        'Send Email and create a new Ticket' => 'Wylij e-mail i utwrz nowe zgoszenie',
        'Create new Email Ticket and send this out (Outbound)' => 'Utwrz nowe zgoszenie e-mail i wylij (wychodzce)',
        'Create new Phone Ticket (Inbound)' => 'Utwrz zgoszenie telefoniczne (przychodzce)',
        'Overview of all open Tickets' => 'Przegld otwartych zgosze',
        'Locked Tickets' => 'Zablokowane Zgoszenia',
        'My Locked Tickets' => 'Moje Zablokowane Zgoszenia',
        'My Watched Tickets' => '',
        'My Responsible Tickets' => '',
        'Watched Tickets' => 'Obserwowane zgoszenia',
        'Watched' => 'Obserwowane',
        'Watch' => '',
        'Unwatch' => '',
        'Lock it to work on it!' => 'Zablokuj w celu obsugi',
        'Unlock to give it back to the queue!' => 'Odblokuj i skieruj do kolejki!',
        'Shows the ticket history!' => 'Poka histori zgoszenia!',
        'Print this ticket!' => 'Wydrukuj zgoszenie!',
        'Change the ticket priority!' => 'Zmie priorytet zgoszenia!',
        'Change the ticket free fields!' => 'Ustaw dodatkowe atrybuty zgoszenia!',
        'Link this ticket to an other objects!' => 'Pocz zgoszenie z innym!',
        'Change the ticket owner!' => 'Zmie waciciela zgoszenia!',
        'Change the ticket customer!' => 'Zmie klienta zgoszenia!',
        'Add a note to this ticket!' => 'Dodaj notatk do zgoszenia!',
        'Merge this ticket!' => 'Docz zgoszenie!',
        'Set this ticket to pending!' => 'Ustaw zgoszenie jako oczekujce!',
        'Close this ticket!' => 'Zamknij zgoszenie!',
        'Look into a ticket!' => 'Szczegy zgoszenia!',
        'Delete this ticket!' => 'Usu zgoszenie!',
        'Mark as Spam!' => 'Oznacz jako spam!',
        'My Queues' => 'Moje kolejki',
        'Shown Tickets' => 'Poka zgoszenia',
        'Your email with ticket number "<OTRS_TICKET>" is merged to "<OTRS_MERGE_TO_TICKET>".' => 'Twoje zgoszenie o numerze "<OTRS_TICKET>" zostao doczone do "<OTRS_MERGE_TO_TICKET>".',
        'Ticket %s: first response time is over (%s)!' => 'Zgoszenie %s: czas pierwszej odpowiedzi przekroczony (%s)!',
        'Ticket %s: first response time will be over in %s!' => 'Zgoszenie %s: czas pierwszej odpowiedzi zostanie przekroczony za %s!',
        'Ticket %s: update time is over (%s)!' => 'Zgoszenie %s: czas aktualizacji przekroczony (%s)!',
        'Ticket %s: update time will be over in %s!' => 'Zgoszenie %s: czas aktualizacji zostanie przekroczony za %s!',
        'Ticket %s: solution time is over (%s)!' => 'Zgoszenie %s: czas rozwizania przekroczony (%s)!',
        'Ticket %s: solution time will be over in %s!' => 'Zgoszenie %s: czas rozwizania zostanie przekroczony za %s!',
        'There are more escalated tickets!' => 'Wicej przeterminowanych zgosze!',
        'Plain Format' => '',
        'Reply All' => '',
        'Direction' => '',
        'Agent (All with write permissions)' => '',
        'Agent (Owner)' => '',
        'Agent (Responsible)' => '',
        'New ticket notification' => 'Powiadomienie o nowym zgoszeniu',
        'Send me a notification if there is a new ticket in "My Queues".' => 'Powiadom o nowym zgoszeniu w moich kolejkach.',
        'Send new ticket notifications' => 'Wysyaj powiadomienia o nowych zgoszeniach',
        'Ticket follow up notification' => 'Wysyaj powiadomienia o nowych wiadomociach w zgoszeniach',
        'Ticket lock timeout notification' => 'Powiadomienie o przekroczonym czasie blokady zgoszenia',
        'Send me a notification if a ticket is unlocked by the system.' => 'Wylij mi wiadomo, gdy zgoszenie zostanie odblokowane przez system.',
        'Send ticket lock timeout notifications' => 'Wysyaj powiadomienia o upyniciu terminu przypomnienia ustawionego w zgoszeniu',
        'Ticket move notification' => 'Powiadomienie o przeniesieniu zgoszenia',
        'Send me a notification if a ticket is moved into one of "My Queues".' => 'Powiadom o przesuniciu do mojej kolejki',
        'Send ticket move notifications' => 'Wysyaj powiadomienia o przesuniciu zgoszenia do innej kolejki',
        'Your queue selection of your favourite queues. You also get notified about those queues via email if enabled.' => 'Twj zestaw wybranych kolejek. Jeeli wczysz opcj "Powiadomienie o nowym zgoszeniu" to dostaniesz wiadomo email o kadym nowym zgoszeniu, ktre pojawi si w tych kolejkach.',
        'Custom Queue' => 'Kolejka modyfikowana',
        'QueueView refresh time' => 'Interwa odwieania Widoku Kolejek',
        'If enabled, the QueueView will automatically refresh after the specified time.' => 'Jeeli ustawisz tu jak warto, widok kolejek zgosze bdzie odwieany w okrelonym interwale.',
        'Refresh QueueView after' => 'Odwieaj widok kolejek co',
        'Screen after new ticket' => 'Ekran po nowym zgoszeniu',
        'Show this screen after I created a new ticket' => 'Poka nastpujcy widok po utworzeniu nowego zgoszenia',
        'Closed Tickets' => 'Zamknite zgoszenia',
        'Show closed tickets.' => 'Poka zamknite zgoszenia.',
        'Max. shown Tickets a page in QueueView.' => 'Limit pokazywanych zgosze na stronie Podgldu Kolejki',
        'Ticket Overview "Small" Limit' => '',
        'Ticket limit per page for Ticket Overview "Small"' => '',
        'Ticket Overview "Medium" Limit' => '',
        'Ticket limit per page for Ticket Overview "Medium"' => '',
        'Ticket Overview "Preview" Limit' => '',
        'Ticket limit per page for Ticket Overview "Preview"' => '',
        'Ticket watch notification' => 'Powiadomienie o obserwowaniu zgoszenia',
        'Send me the same notifications for my watched tickets that the ticket owners will get.' => '',
        'Send ticket watch notifications' => 'Przysyaj powiadomienia gdy kto zacznie obserwowa moje zgoszenie',
        'Out Of Office Time' => 'Jestem poza biurem',
        'New Ticket' => 'Nowe zgoszenie',
        'Create new Ticket' => 'Utwrz nowe zgoszenie',
        'Customer called' => 'Telefon od klienta',
        'phone call' => 'rozmowa telefoniczna',
        'Phone Call Outbound' => 'Rejestracja rozmowy telefonicznej',
        'Reminder Reached' => 'Przypomnienie osignito',
        'Reminder Tickets' => 'Zgoszenia z ustawionym przypomnieniem',
        'Escalated Tickets' => 'Zgoszenia eskalowane',
        'New Tickets' => 'Nowe zgoszenia',
        'Open Tickets / Need to be answered' => 'Otwarte zgoszenia wymagajce odpowiedzi',
        'All open tickets, these tickets have already been worked on, but need a response' => '',
        'All new tickets, these tickets have not been worked on yet' => '',
        'All escalated tickets' => '',
        'All tickets with a reminder set where the reminder date has been reached' => '',
        'Archived tickets' => '',
        'Unarchived tickets' => '',
        'History::Move' => 'Zgoszenie przeniesiono do kolejki "%s" (%s) z kolejki "%s" (%s).',
        'History::TypeUpdate' => 'Zaktualizowano typ do %s (ID=%s).',
        'History::ServiceUpdate' => 'Zaktualizowano usug do %s (ID=%s).',
        'History::SLAUpdate' => 'Zaktualizowano SLA do %s (ID=%s).',
        'History::NewTicket' => 'Nowe zgoszenie [%s] utworzone (Q=%s;P=%s;S=%s).',
        'History::FollowUp' => 'FollowUp dla [%s]. %s',
        'History::SendAutoReject' => 'Automatyczne odrzucenie wysano do "%s".',
        'History::SendAutoReply' => 'Auto odpowied wysano do "%s".',
        'History::SendAutoFollowUp' => 'AutoFollowUp wysano do "%s".',
        'History::Forward' => 'Przesano do "%s".',
        'History::Bounce' => 'Przekazano do "%s".',
        'History::SendAnswer' => 'Wysano odpowied do "%s".',
        'History::SendAgentNotification' => '"%s"-powiadomienie wysano do "%s".',
        'History::SendCustomerNotification' => 'Powiadomienie wysano do "%s".',
        'History::EmailAgent' => 'E-mail wysany do klienta.',
        'History::EmailCustomer' => 'Dodano e-mail. %s',
        'History::PhoneCallAgent' => 'Agent telefonowa do klienta.',
        'History::PhoneCallCustomer' => 'klient telefonowa.',
        'History::AddNote' => 'Dodano notatk (%s)',
        'History::Lock' => 'Zablokowano zgoszenie.',
        'History::Unlock' => 'Odblokowano zgoszenie.',
        'History::TimeAccounting' => '%s jednostek czasu zliczono. Czas cakowity %s jednostek.',
        'History::Remove' => 'Usunito zgoszenie %s',
        'History::CustomerUpdate' => 'Zaktualizowano: %s',
        'History::PriorityUpdate' => 'Zmieniono priorytet z "%s" (%s) na "%s" (%s).',
        'History::OwnerUpdate' => 'Nowym wacicielem jest "%s" (ID=%s).',
        'History::LoopProtection' => 'Loop-Protection! Nie wyslano auto-odpowiedzi do "%s".',
        'History::Misc' => '%s',
        'History::SetPendingTime' => 'Ustawiony czas przypomnienia: %s',
        'History::StateUpdate' => 'Aktualizacja statusu. Stary: "%s" nowy: "%s"',
        'History::TicketFreeTextUpdate' => 'Zaktualizowano: %s=%s;%s=%s;',
        'History::WebRequestCustomer' => 'danie klienta przez www.',
        'History::TicketLinkAdd' => 'Dodano cze do zgoszenia "%s".',
        'History::TicketLinkDelete' => 'Usunito acze ze zgoszenia "%s".',
        'History::Subscribe' => 'Dodano subskrypcje dla uytkownika "%s".',
        'History::Unsubscribe' => 'Usunito subskrypcje dla uytkownika "%s".',
        'History::SystemRequest' => '',
        'History::ResponsibleUpdate' => 'Zmieniono osob odpowiedzialn za obsug zgoszenia.',

        # Template: AAAWeekDay
        'Sun' => 'Nie',
        'Mon' => 'Pon',
        'Tue' => 'Wt',
        'Wed' => 'r',
        'Thu' => 'Czw',
        'Fri' => 'Pi',
        'Sat' => 'Sob',

        # Template: AdminAttachment
        'Attachment Management' => 'Zarzdzanie zacznikami',
        'Actions' => 'Akcje',
        'Go to overview' => 'Id do przegldu',
        'Add attachment' => '',
        'List' => 'Lista',
        'No data found.' => 'Nie odnaleziono adnych elementw speniajcych kryteria',
        'Download file' => 'Pobierz plik',
        'Delete this attachment' => 'Usu ten zacznik',
        'Add Attachment' => 'Dodaj zacznik',
        'Edit Attachment' => 'Edytuj zacznik',
        'This field is required.' => '',
        'or' => 'lub',

        # Template: AdminAutoResponse
        'Auto Response Management' => 'Zarzdzanie automatycznymi odpowiedziami',
        'Add auto response' => 'Dodaj odpowied automatyczn',
        'Add Auto Response' => 'Dodaj Odpowied Automatyczn',
        'Edit Auto Response' => 'Edytuj odpowied automatyczn',
        'Response' => 'Odpowied',
        'Auto response from' => 'Automatyczna odpowied od',
        'Reference' => 'Podpowiedzi',
        'You can use the following tags' => 'Moesz uywa nastpujcych znacznikw',
        'To get the first 20 character of the subject.' => 'Poka pierwsze 20 znakw tematu.',
        'To get the first 5 lines of the email.' => 'Poka 5 linii wiadomoci e-mail.',
        'To get the realname of the sender (if given).' => 'Poka imi i nazwisko nadawcy (jeeli poda).',
        'To get the article attribute' => '',
        ' e. g.' => 'np.',
        'Options of the current customer user data' => '',
        'Ticket owner options' => '',
        'Ticket responsible options' => '',
        'Options of the current user who requested this action' => '',
        'Options of the ticket data' => '',
        'Config options' => 'Opcje konfiguracyjne',
        'Example response' => 'Przykadowa odpowied',

        # Template: AdminCustomerCompany
        'Customer Company Management' => 'Zarzdzanie firmami',
        'Wildcards are allowed.' => '',
        'Add customer company' => 'Dodaj firm',
        'Please enter a search term to look for customer companies.' => '',
        'Add Customer Company' => 'Dodaj Firm',

        # Template: AdminCustomerUser
        'Customer Management' => 'Zarzdzanie klientami',
        'Add customer' => 'Dodaj klienta',
        'Select' => 'Zaznacz',
        'Hint' => '',
        'Customer will be needed to have a customer history and to login via customer panel.' => '',
        'Please enter a search term to look for customers.' => '',
        'Last Login' => 'Ostatnie logowanie',
        'Add Customer' => 'Dodaj Klienta',
        'Edit Customer' => 'Edytuj Klienta',
        'This field is required and needs to be a valid email address.' => '',
        'This email address is not allowed due to the system configuration.' => '',
        'This email address failed MX check.' => '',
        'The syntax of this email address is incorrect.' => '',
        'DNS problem, please check your configuration and the error log.' => '',

        # Template: AdminCustomerUserGroup
        'Manage Customer-Group Relations' => 'Zarzdzaj relacjami Klient-Grupa',
        'Notice' => 'Uwaga',
        'This feature is disabled!' => 'Ta funkcja jest wyczona!',
        'Just use this feature if you want to define group permissions for customers.' => '',
        'Enable it here!' => 'Wcz tutaj!',
        'Search for customers (wildcards are allowed).' => 'Wyszukaj klientw (* jest dozwolona)',
        'Edit Customer Default Groups' => 'Edytuj domylne Grupy Klientw',
        'These groups are automatically assigned to all customers.' => '',
        'You can manage these groups via the configuration setting "CustomerGroupAlwaysGroups".' => '',
        'Filter for Groups' => '',
        'Select the customer:group permissions.' => '',
        'If nothing is selected, then there are no permissions in this group (tickets will not be available for the customer).' => '',
        'Search Result:' => 'Wyniki wyszukiwania',
        'Customers' => 'Klienci',
        'Groups' => 'Grupy',
        'No matches found.' => '',
        'Change Group Relations for Customer' => '',
        'Change Customer Relations for Group' => '',
        'Toggle %s Permission for all' => '',
        'Toggle %s permission for %s' => '',
        'Customer Default Groups:' => 'Domylne grupy klientw',
        'No changes can be made to these groups.' => '',
        'ro' => 'odczyt',
        'Read only access to the ticket in this group/queue.' => 'Prawo jedynie do odczytu zgosze w tej grupie/kolejce',
        'rw' => 'odczyt/zapis',
        'Full read and write access to the tickets in this group/queue.' => 'Prawa penego odczytu i zapisu zgosze w tej grupie/kolejce',

        # Template: AdminCustomerUserService
        'Manage Customer-Services Relations' => 'Zarzdzaj relacjami Klient-Poziom Serwisu',
        'Edit default services' => 'Edytuj domyln usug',
        'Filter for Services' => 'Filtruj usugi',
        'Allocate Services to Customer' => '',
        'Allocate Customers to Service' => '',
        'Toggle active state for all' => '',
        'Active' => 'Aktywne',
        'Toggle active state for %s' => '',

        # Template: AdminEmail
        'Admin Notification' => 'Powiadomienia administratora',
        'With this module, administrators can send messages to agents, group or role members.' => '',
        'Create Administrative Message' => '',
        'Your message was sent to' => 'Twoja wiadomo zostaa wysana do',
        'Send message to users' => 'Wylij wiadomo do uytkownikw',
        'Send message to group members' => 'Wylij wiadomo do czonkw grupy',
        'Group members need to have permission' => 'Czonkowie grupy musz posiada uprawnienia',
        'Send message to role members' => 'Wylij wiadomo do posiadaczy roli',
        'Also send to customers in groups' => 'Wylij take, do klientw w grupach',
        'Body' => 'Tre',
        'Send' => 'Wylij',

        # Template: AdminGenericAgent
        'Generic Agent' => 'Agent automatyczny',
        'Add job' => 'Dodaj zadanie',
        'Last run' => 'Ostatnie uruchomienie',
        'Run Now!' => 'Uruchom teraz',
        'Delete this task' => 'Usu to zadanie',
        'Run this task' => 'Uruchom to zadanie',
        'Job Settings' => 'Ustawienia zadania',
        'Job name' => 'Nazwa zadania',
        'Currently this generic agent job will not run automatically.' => 'Zadanie nie zostanie uruchomione automatycznie.',
        'To enable automatic execution select at least one value from minutes, hours and days!' => '',
        'Schedule minutes' => '',
        'Schedule hours' => '',
        'Schedule days' => '',
        'Toggle this widget' => '',
        'Ticket Filter' => '',
        '(e. g. 10*5155 or 105658*)' => '(np. 10*5155 lub 105658*)',
        '(e. g. 234321)' => '(np. 3242442)',
        'Customer login' => '',
        '(e. g. U5150)' => '(np. U4543)',
        'Fulltext-search in article (e. g. "Mar*in" or "Baue*").' => '',
        'Agent' => 'Agent',
        'Ticket lock' => '',
        'TicketFreeFields' => 'Wolne pola zgoszenia',
        'Create times' => '',
        'No create time settings.' => 'Bez czasw utworzenia.',
        'Ticket created' => 'Zgoszenie utworzone',
        'Ticket created between' => 'Zgoszenie utworzone midzy',
        'Close times' => '',
        'No close time settings.' => 'Bez czasw zamkniecia.',
        'Ticket closed' => 'Zgoszenie zamknite',
        'Ticket closed between' => 'Zgoszenie zamknite midzy',
        'Pending times' => '',
        'No pending time settings.' => 'Bez czasw oczekiwania.',
        'Ticket pending time reached' => 'Oczekiwanie zakoczone',
        'Ticket pending time reached between' => 'Oczekiwanie zakoczone midzy',
        'Escalation times' => '',
        'No escalation time settings.' => '',
        'Ticket escalation time reached' => '',
        'Ticket escalation time reached between' => '',
        'Escalation - first response time' => '',
        'Ticket first response time reached' => '',
        'Ticket first response time reached between' => '',
        'Escalation - update time' => '',
        'Ticket update time reached' => '',
        'Ticket update time reached between' => '',
        'Escalation - solution time' => '',
        'Ticket solution time reached' => '',
        'Ticket solution time reached between' => '',
        'Archive search option' => '',
        'Ticket Action' => '',
        'Set new service' => '',
        'Set new Service Level Agreement' => '',
        'Set new priority' => '',
        'Set new queue' => '',
        'Set new state' => '',
        'Set new agent' => '',
        'new owner' => '',
        'Set new ticket lock' => '',
        'New customer' => '',
        'New customer ID' => '',
        'New title' => '',
        'New type' => '',
        'New TicketFreeFields' => 'Nowe wolne pole',
        'Archive selected tickets' => '',
        'Add Note' => 'Dodaj notatk',
        'Time units' => 'Jednostek czasu',
        ' (work units)' => ' (jednostek roboczych)',
        'Ticket Commands' => '',
        'Send agent/customer notifications on changes' => 'Wylij powidomienia agentowi/klientowi przy zmianie ',
        'CMD' => 'linia polece',
        'This command will be executed. ARG[0] will be the ticket number. ARG[1] the ticket id.' => 'Komenda zostanie wykonana. ARG[0] to numer zgoszenia. ARG[1] to id zgoszenia.',
        'Delete tickets' => 'Usu zgoszenia',
        'Warning: All affected tickets will be removed from the database and cannot be restored!' => '',
        'Execute Custom Module' => '',
        'Param %s key' => '',
        'Param %s value' => '',
        'Save Changes' => '',
        'Save' => 'Zapisz',
        'Results' => 'Wyniki',
        '%s Tickets affected! What do you want to do?' => '',
        'Warning: You used the DELETE option. All deleted tickets will be lost!' => '',
        'Edit job' => 'Edytuj zadanie',
        'Run job' => 'Wykonaj zadanie',
        'Affected Tickets' => '',

        # Template: AdminGroup
        'WARNING: When you change the name of the group \'admin\', before making the appropriate changes in the SysConfig, you will be locked out of the administrations panel! If this happens, please rename the group back to admin per SQL statement.' => 'Uwaga: Jezeli zmienisz nazw grupy \'admin\', przed wykonaniem waciwych zmian w SysConfig, zablokujesz panel administratorw! Jeeli to nastpi, przywr nazw grupy admin z uyciem SQL.',
        'Group Management' => 'Zarzdzanie grupami',
        'Add group' => 'Dodaj Grup',
        'The admin group is to get in the admin area and the stats group to get stats area.' => 'Grupa Admin pozwala posiada prawa Administracji systemem. Grupa Stats umoliwia przegldanie statystyk zgosze.',
        'Create new groups to handle access permissions for different groups of agent (e. g. purchasing department, support department, sales department, ...). ' => '',
        'It\'s useful for ASP solutions. ' => '',
        'Add Group' => 'Dodaj grup',
        'Edit Group' => 'Edytuj Grup',

        # Template: AdminLog
        'System Log' => 'Log Systemu',
        'Here you will find log information about your system.' => 'Tutaj znajdziesz informacje o swoim systemie OTRS',
        'Hide this message' => '',
        'Recent Log Entries' => '',
        'Time' => 'Czas',

        # Template: AdminMailAccount
        'Mail Account Management' => 'Zarzdzanie kontami e-mail',
        'Add mail account' => 'Dodaj konto pocztowe',
        'All incoming emails with one account will be dispatched in the selected queue!' => 'Wszystkie przychodzce na jedno konto wiadomoci bd umieszczone w zaznacznej kolejce!',
        'If your account is trusted, the already existing X-OTRS header at arrival time (for priority, ...) will be used! PostMaster filter will be used anyway.' => 'Jezeli konto jest zaufane, istniejce w chwili przybycia nagwki X-OTRS (priorytet, ...) zostan uyte! Filtr PostMaster zostanie wykonany.',
        'Host' => 'Komputer',
        'Delete account' => 'Usu konto',
        'Fetch mail' => 'Pobierz poczt',
        'Add Mail Account' => 'Dodaj Konto Pocztowe',
        'Example: mail.example.com' => '',
        'Trusted' => 'Zaufane',
        'Dispatching' => 'Przekazanie',
        'Edit Mail Account' => 'Edytuj Konto Pocztowe',

        # Template: AdminNavigationBar
        'Admin' => 'Administracja',
        'Agent Management' => 'Zarzdzanie agentami',
        'Queue Settings' => 'Ustawienia kolejki',
        'Ticket Settings' => 'Ustawienia zgoszenia',
        'System Administration' => 'Administracja systemem',

        # Template: AdminNotification
        'Notification Management' => 'Konfiguracja Powiadomie',
        'Select a different language' => '',
        'Filter for Notification' => 'Filtr powiadomie',
        'Notifications are sent to an agent or a customer.' => 'Powiadomienia s wysyane do agenta obsugi lub klienta',
        'Notification' => 'Powiadomienie',
        'Edit Notification' => 'Edytuj Powiadomienie',
        'e. g.' => 'np.',
        'Options of the current customer data' => '',

        # Template: AdminNotificationEvent
        'Add notification' => '',
        'Delete this notification' => '',
        'Add Notification' => '',
        'Recipient groups' => '',
        'Recipient agents' => '',
        'Recipient roles' => '',
        'Recipient email addresses' => '',
        'Article type' => 'Typ artykuu',
        'Only for ArticleCreate event' => '',
        'Subject match' => '',
        'Body match' => '',
        'Include attachments to notification' => '',
        'Notification article type' => '',
        'Only for notifications to specified email addresses' => '',
        'To get the first 20 character of the subject (of the latest agent article).' => '',
        'To get the first 5 lines of the body (of the latest agent article).' => '',
        'To get the first 20 character of the subject (of the latest customer article).' => '',
        'To get the first 5 lines of the body (of the latest customer article).' => '',

        # Template: AdminPGP
        'PGP Management' => 'Zarzdzanie PGP',
        'Use this feature if you want to work with PGP keys.' => '',
        'Add PGP key' => '',
        'In this way you can directly edit the keyring configured in SysConfig.' => 'W ten sposb mozesz bezporednio edytowa plik kluczy skonfigurowany w SysConfig.',
        'Introduction to PGP' => '',
        'Result' => 'Wynik',
        'Identifier' => 'Identyfikator',
        'Bit' => 'Bit',
        'Key' => 'Klucz',
        'Fingerprint' => 'Znacznik (fingerprint)',
        'Expires' => 'Wygasa',
        'Delete this key' => '',
        'Add PGP Key' => '',
        'PGP key' => '',

        # Template: AdminPackageManager
        'Package Manager' => 'Meneder pakietw',
        'Uninstall package' => '',
        'Version' => 'Wersja',
        'Do you really want to uninstall this package?' => 'Czy na pewno chcesz odinstalowa ten pakiet?',
        'Reinstall package' => '',
        'Do you really want to reinstall this package? Any manual changes will be lost.' => '',
        'Continue' => 'Kontynuuj',
        'Install' => 'Instaluj',
        'Install Package' => '',
        'Update repository information' => '',
        'Online Repository' => 'Baza on-line',
        'Vendor' => 'Wydawca',
        'Module documentation' => 'Dokumentacja moduu',
        'Upgrade' => 'Aktualizacja',
        'Local Repository' => 'Lokalna baza',
        'Uninstall' => 'Odinstaluj',
        'Package not correctly deployed! You should reinstall the package again!' => '',
        'Reinstall' => 'Przeinstaluj',
        'Download package' => '',
        'Rebuild package' => '',
        'Metadata' => '',
        'Change Log' => '',
        'Date' => 'Data',
        'List of Files' => '',
        'Permission' => 'Prawo dostpu',
        'Download' => 'Pobierz',
        'Download file from package!' => 'Pobierz plik z pakietu!',
        'Required' => 'Wymagany',
        'PrimaryKey' => 'Klucz podstawowy',
        'AutoIncrement' => 'Zwikszaj automatycznie',
        'SQL' => 'SQL',
        'File differences for file %s' => '',

        # Template: AdminPerformanceLog
        'Performance Log' => 'Log wydajnosci',
        'This feature is enabled!' => 'Ta funkcja jest wczona!',
        'Just use this feature if you want to log each request.' => 'Wybierz t opcj jezeli chcesz logowa kade danie.',
        'Activating this feature might affect your system performance!' => '',
        'Disable it here!' => 'Wycz tutaj!',
        'Logfile too large!' => 'Plik log jest za duy!',
        'The logfile is too large, you need to reset it' => '',
        'Overview' => 'Podsumowanie',
        'Range' => 'Zakres',
        'Interface' => 'Interfejs',
        'Requests' => 'dania',
        'Min Response' => 'Min. odpowied',
        'Max Response' => 'Max odpowied',
        'Average Response' => 'rednia odpowied',
        'Period' => 'Okres',
        'Min' => 'Min.',
        'Max' => 'Max.',
        'Average' => 'rednia',

        # Template: AdminPostMasterFilter
        'PostMaster Filter Management' => 'Zarzdzanie filtrami poczty',
        'Add filter' => '',
        'To dispatch or filter incoming emails based on email headers. Matching using Regular Expressions is also possible.' => '',
        'If you want to match only the email address, use EMAILADDRESS:info@example.com in From, To or Cc.' => 'Jeeli chcesz tylko dopasowa adres e-mail uyj EMAILADDRESS:info@example.com w polach Od, Do lub Cc.',
        'If you use Regular Expressions, you also can use the matched value in () as [***] in the \'Set\' action.' => '',
        'Delete this filter' => '',
        'Add PostMaster Filter' => '',
        'Edit PostMaster Filter' => '',
        'Filter name' => '',
        'The name is required.' => '',
        'Stop after match' => 'Zatrzymaj po dopasowaniu',
        'Filter Condition' => '',
        'Value' => 'Warto',
        'The field needs to be a valid regular expression or a literal word.' => '',
        'Set Email Headers' => '',
        'The field needs to be a literal word.' => '',

        # Template: AdminPriority
        'Priority Management' => 'Zarzdzanie priorytetami',
        'Add priority' => '',
        'Add Priority' => 'Dodaj priorytet',
        'Edit Priority' => '',

        # Template: AdminQueue
        'Manage Queues' => '',
        'Add queue' => '',
        'Add Queue' => '',
        'Edit Queue' => '',
        'Sub-queue of' => '',
        'Unlock timeout' => 'Limit czasowy odblokowania',
        '0 = no unlock' => '0 = bez odblokowania',
        'Only business hours are counted.' => 'Tylko godziny pracy s liczone.',
        'If an agent locks a ticket and does not close it before the unlock timeout has passed, the ticket will unlock and will become available for other agents.' => '',
        'Notify by' => 'Powiadom wczeniej',
        '0 = no escalation' => '0 = brak eskalacji',
        'If there is not added a customer contact, either email-external or phone, to a new ticket before the time defined here expires, the ticket is escalated.' => '',
        'If there is an article added, such as a follow-up via email or the customer portal, the escalation update time is reset. If there is no customer contact, either email-external or phone, added to a ticket before the time defined here expires, the ticket is escalated.' => '',
        'If the ticket is not set to closed before the time defined here expires, the ticket is escalated.' => '',
        'Follow up Option' => 'Opcja Follow Up',
        'Specifies if follow up to closed tickets would re-open the ticket, be rejected or lead to a new ticket.' => '',
        'Ticket lock after a follow up' => 'Zgoszenie zablokowane po odpowiedzi (Follow Up)',
        'If a ticket is closed and the customer sends a follow up the ticket will be locked to the old owner.' => '',
        'System address' => '',
        'Will be the sender address of this queue for email answers.' => 'Bdzie adresem nadawcy odpowiedzi emailowych wysyanych z tej kolejki.',
        'Default sign key' => '',
        'The salutation for email answers.' => 'Zwrot grzecznociowy dla odpowiedzi emailowych.',
        'The signature for email answers.' => 'Podpis dla odpowiedzi emailowych.',

        # Template: AdminQueueAutoResponse
        'Manage Queue-Auto Response Relations' => '',
        'Filter for Queues' => 'Filtrowanie kolejek',
        'Filter for Auto Responses' => 'Filtrowanie automatycznych odpowiedzi',
        'Auto Responses' => 'Automatyczna odpowied',
        'Change Auto Response Relations for Queue' => '',
        'settings' => 'ustawienia',

        # Template: AdminQueueResponses
        'Manage Response-Queue Relations' => '',
        'Filter' => 'Filtr',
        'Filter for Responses' => '',
        'Responses' => 'Odpowiedzi',
        'Change Queue Relations for Response' => '',
        'Change Response Relations for Queue' => '',

        # Template: AdminResponse
        'Manage Responses' => 'Zarzdzaj odpowiedziami',
        'Add response' => 'Dodaj odpowied',
        'A response is default text to write faster answer (with default text) to customers.' => 'Odpowied to domylny tekst wstawiany do odpowiedzi klientowi, dziki czemu agent moe szybciej odpowiedzie na zgoszenie.',
        'Don\'t forget to add a new response a queue!' => 'Nie zapomnij powiza nowej odpowiedzi z jak kolejk!',
        'Delete this entry' => 'Usu t pozycj',
        'Add Response' => 'Dodaj odpowied',
        'Edit Response' => 'Edytuj odpowied',
        'The current ticket state is' => 'Aktualny status zgoszenia to',
        'Your email address is' => 'Twj adres email to',

        # Template: AdminResponseAttachment
        'Manage Responses <-> Attachments Relations' => '',
        'Filter for Attachments' => '',
        'Change Response Relations for Attachment' => '',
        'Change Attachment Relations for Response' => '',
        'Toggle active for all' => '',
        'Link %s to selected %s' => '',

        # Template: AdminRole
        'Role Management' => 'Zarzdzanie rolami',
        'Add role' => 'Dodaj rol',
        'Create a role and put groups in it. Then add the role to the users.' => 'Utwrz rol i dodaj grup do niej. Potem dodaj rol do uytkownika.',
        'There are no roles defined. Please use the \'Add\' button to create a new role.' => '',
        'Add Role' => 'Dodaj rol',
        'Edit Role' => 'Edytuj rol',

        # Template: AdminRoleGroup
        'Manage Role-Group Relations' => '',
        'Filter for Roles' => '',
        'Roles' => 'Role',
        'Select the role:group permissions.' => '',
        'If nothing is selected, then there are no permissions in this group (tickets will not be available for the role).' => '',
        'Change Role Relations for Group' => '',
        'Change Group Relations for Role' => '',
        'Toggle %s permission for all' => '',
        'move_into' => 'przenie do',
        'Permissions to move tickets into this group/queue.' => 'Uprawnienia do przesuwania zgosze do tej grupy/kolejki',
        'create' => 'utwrz',
        'Permissions to create tickets in this group/queue.' => 'Uprawnienia do tworzenia zgosze w tej grupie/kolejce',
        'priority' => 'priorytet',
        'Permissions to change the ticket priority in this group/queue.' => 'Uprawnienia do zmiany priorytetu zgoszenia w tej grupie/kolejce',

        # Template: AdminRoleUser
        'Manage Agent-Role Relations' => '',
        'Filter for Agents' => 'Filtrowanie agentw',
        'Agents' => 'Agenci',
        'Manage Role-Agent Relations' => 'Zarzdzaj relacjami Rola<->Agent',
        'Change Role Relations for Agent' => '',
        'Change Agent Relations for Role' => '',

        # Template: AdminSLA
        'SLA Management' => 'Konfiguracja SLA',
        'Add SLA' => 'Dodaj SLA',
        'Edit SLA' => 'Edytuj SLA',
        'Please write only numbers!' => '',

        # Template: AdminSMIME
        'S/MIME Management' => 'Konfiguracja S/MIME',
        'Add certificate' => '',
        'Add private key' => '',
        'In this way you can directly edit the certification and private keys in file system.' => 'W taki sposb moesz bezporednio edytowa certyfikaty i klucze prywarne w systemie plikw',
        'See also' => 'Zobacz take',
        'Hash/Fingerprint' => '',
        'Create/Expires' => '',
        'Delete this certificate' => '',
        'Add Certificate' => 'Dodaj certyfikat',
        'Add Private Key' => 'Dodaj klucz prywatny',
        'Secret' => 'Haso',

        # Template: AdminSalutation
        'Salutation Management' => 'Konfiguracja zwrotw grzecznociowych',
        'Add salutation' => '',
        'Add Salutation' => 'Dodaj zwrot grzecznociowy',
        'Edit Salutation' => 'Edytuj zwrot',
        'Example salutation' => 'Przykadowy zwrot grzecznociowy',

        # Template: AdminSecureMode
        'Secure mode needs to be enabled!' => '',
        'Secure mode will (normally) be set after the initial installation is completed.' => '',
        'Secure mode must be disabled in order to reinstall using the web-installer.' => '',
        'If secure mode is not activated, activate it via SysConfig because your application is already running.' => '',

        # Template: AdminSelectBox
        'SQL Box' => 'Konsola SQL',
        'Here you can enter SQL to send it directly to the application database.' => 'Wpisz zapytanie SQL, ktre zostanie wysane bezporednio do bazy danych.',
        'The syntax of your SQL query has a mistake. Please check it.' => '',
        'There is at least one parameter missing for the binding. Please check it.' => '',
        'Result format' => 'Format wynikw',
        'Run Query' => 'Uruchom polecenie',

        # Template: AdminService
        'Service Management' => 'Konfiguracja usug',
        'Add service' => 'Dodaj usug',
        'Add Service' => 'Dodaj usug',
        'Edit Service' => 'Edytuj usug',
        'Sub-service of' => 'Usuga podrzdna',

        # Template: AdminSession
        'Session Management' => 'Zarzdzanie sesjami',
        'All sessions' => 'Wszystkie sesje',
        'Agent sessions' => 'Sesje agentw',
        'Customer sessions' => 'Sesje klientw',
        'Unique agents' => 'Unikalni agenci',
        'Unique customers' => 'Unikalni klienci',
        'Kill all sessions' => 'Zakocz wszystkie sesje',
        'Session' => 'Sesja',
        'Kill' => 'Zabij',
        'Kill this session' => 'Zabij t sesj',
        'Detail View for SessionID' => 'Widok szczegw sesji',

        # Template: AdminSignature
        'Signature Management' => 'Konfiguracja podpisw',
        'Add signature' => 'Dodaj podpis',
        'Add Signature' => 'Dodaj podpis',
        'Edit Signature' => 'Edytuj podpis',
        'Example signature' => 'Przykadowy podpis',

        # Template: AdminState
        'State Management' => 'Konfiguracja statusw',
        'Add state' => 'Dodaj status',
        'Take care that you also updated the default states in you Kernel/Config.pm!' => 'Pamitaj, by auktualni rwnie domylne statusy w pliku Kernel/Config.pm !',
        'Add State' => 'Dodaj status',
        'Edit State' => 'Edytuj status',
        'State type' => 'Typ statusu',

        # Template: AdminSysConfig
        'SysConfig' => 'Konfiguracja systemu',
        'Navigate by searching in %s settings' => '',
        'Navigate by selecting config groups' => '',
        'Download all system config changes' => '',
        'Export settings' => 'Eksportuj ustawienia',
        'Load SysConfig settings from file' => '',
        'Import settings' => 'Importuj ustawienia',
        'Import Settings' => 'Importuj ustawienia',
        'Import' => 'Importuj',
        'Please enter a search term to look for settings.' => '',
        'Subgroup' => 'Podgrupa',
        'Elements' => 'Elementy',

        # Template: AdminSysConfigEdit
        'Edit Config Settings' => 'Edytuj Ustawienia Konfiguracyjne',
        'This config item is only available in a higher config level!' => '',
        'Reset this setting' => 'Resetuj to ustawienie',
        'Default value' => 'Domylna warto',
        'Error: this file could not be found.' => '',
        'Error: this directory could not be found.' => '',
        'Error: an invalid value was entered.' => '',
        'Content' => 'Zawarto',
        'Remove this entry' => 'Usu t pozycj',
        'Add entry' => 'Dodaj pozycj',
        'Remove entry' => 'Usu pozycj',
        'Add new entry' => 'Dodaj now pozycj',
        'Create new entry' => 'Utwrz now pozycj',
        'New group' => 'Nowa grupa',
        'Group ro' => 'Grupa ro',
        'Readonly group' => 'Grupa readonly',
        'New group ro' => 'Nowa grupa ro',
        'Loader' => '',
        'File to load for this frontend module' => 'Plik do zaadowania dla tego moduu',
        'New Loader File' => '',
        'NavBarName' => 'Nazwa paska nawigacyjnego',
        'NavBar' => 'Pasek nawigacyjny',
        'LinkOption' => '',
        'Block' => 'Blok',
        'AccessKey' => 'Klawisz skrtu',
        'Add NavBar entry' => 'Dodaj pozycj paska nawigacyjnego',
        'Year' => 'Rok',
        'Month' => 'Miesic',
        'Day' => 'Dzie',
        'Invalid year' => 'Niewaciwy rok',
        'Invalid month' => 'Niewaciwy miesic',
        'Invalid day' => 'Niewaciwy dzie',

        # Template: AdminSystemAddress
        'System Email Addresses Management' => 'Konfiguracja adresw email Systemu',
        'Add system address' => '',
        'All incoming email with this address in To or Cc will be dispatched to the selected queue.' => '',
        'Email address' => '',
        'Display name' => '',
        'Add System Email Address' => '',
        'Edit System Email Address' => '',
        'The display name and email address will be shown on mail you send.' => '',

        # Template: AdminType
        'Type Management' => 'Zarzdzanie typami',
        'Add ticket type' => 'Dodaj typ zgoszenia',
        'Add Type' => 'Dodaj typ',
        'Edit Type' => 'Edytuj typ zgoszenia',

        # Template: AdminUser
        'Add agent' => '',
        'Agents will be needed to handle tickets.' => '',
        'Don\'t forget to add a new agent to groups and/or roles!' => '',
        'Please enter a search term to look for agents.' => '',
        'Last login' => '',
        'Login as' => 'Zaloguj jako',
        'Switch to agent' => '',
        'Add Agent' => '',
        'Edit Agent' => '',
        'Firstname' => 'Imi',
        'Lastname' => 'Nazwisko',
        'Password is required.' => '',
        'Start' => 'Pocztek',
        'End' => 'Koniec',

        # Template: AdminUserGroup
        'Manage Agent-Group Relations' => '',
        'Change Group Relations for Agent' => '',
        'Change Agent Relations for Group' => '',
        'note' => '',
        'Permissions to add notes to tickets in this group/queue.' => '',
        'owner' => 'waciciel',
        'Permissions to change the owner of tickets in this group/queue.' => '',

        # Template: AgentBook
        'Address Book' => 'Ksika adresowa',
        'Search for a customer' => '',
        'Add email address %s to the To field' => '',
        'Add email address %s to the Cc field' => '',
        'Add email address %s to the Bcc field' => '',
        'Apply' => '',

        # Template: AgentCustomerSearch
        'Search Customer' => 'Szukaj klienta',

        # Template: AgentCustomerTableView

        # Template: AgentDashboard
        'Dashboard' => 'Podsumowanie',
        'Show or hide the content' => 'Poka lub ukryj tre',

        # Template: AgentDashboardCalendarOverview
        'in' => 'za',

        # Template: AgentDashboardIFrame

        # Template: AgentDashboardImage

        # Template: AgentDashboardProductNotify
        '%s %s is available!' => '',
        'Please update now.' => '',
        'Release Note' => '',
        'Level' => '',

        # Template: AgentDashboardRSSOverview
        'Posted %s ago.' => '',

        # Template: AgentDashboardTicketGeneric

        # Template: AgentDashboardTicketStats

        # Template: AgentDashboardUserOnline

        # Template: AgentHTMLReferenceForms

        # Template: AgentHTMLReferenceOverview

        # Template: AgentHTMLReferencePageLayout
        'The ticket has been locked' => '',
        'Undo & close window' => '',

        # Template: AgentInfo
        'Info' => 'Info',
        'To accept some news, a license or some changes.' => '',

        # Template: AgentLinkObject
        'Link Object: %s' => 'Przypisz obiekt: %s',
        'Close window' => 'Zamknij okienko',
        'go to link delete screen' => '',
        'Select Target Object' => 'Wybierz obiekt docelowy',
        'Link Object' => 'Przypisz obiekt',
        'with' => 'z',
        'Unlink Object: %s' => 'Oddziel obiekt: %s',
        'go to link add screen' => '',

        # Template: AgentNavigationBar

        # Template: AgentPreferences
        'Edit your preferences' => 'Zmie swoje ustawienia',

        # Template: AgentSpelling
        'Spell Checker' => 'Sownik',
        'spelling error(s)' => 'bdw jzykowych',
        'Apply these changes' => 'Zastosuj te zmiany',

        # Template: AgentStatsDelete
        'Delete stat' => '',
        'Stat#' => 'Statystyka',
        'Do you really want to delete this stat?' => '',

        # Template: AgentStatsEditRestrictions
        'Step %s' => '',
        'General Specifications' => '',
        'Select the element that will be used at the X-axis' => '',
        'Select the elements for the value series' => 'Wybierz elementy dla serii danych',
        'Select the restrictions to characterize the stat' => '',
        'Here you can make restrictions to your stat.' => 'Tu moesz naoy ograniczenia na swj raport.',
        'If you remove the hook in the "Fixed" checkbox, the agent generating the stat can change the attributes of the corresponding element.' => 'Jeeli usuniesz znacznik  w polu "Fixed", agent bdzie mg zmieni atrybuty powiazanego elementu.',
        'Fixed' => 'Stay',
        'Please select only one element or turn off the button \'Fixed\'.' => 'Wybierz jeden element lub odznacz przycisk \'Stay\'',
        'Absolute Period' => '',
        'Between' => 'Pomiedzy',
        'Relative Period' => 'Wzgledny przedzia',
        'The last' => 'Ostatni',
        'Finish' => 'Koniec',

        # Template: AgentStatsEditSpecification
        'Permissions' => 'Prawa',
        'You can select one or more groups to define access for different agents.' => '',
        'Some result formats are disabled because at least one needed package is not installed.' => '',
        'Please contact your administrator.' => '',
        'Graph size' => '',
        'If you use a graph as output format you have to select at least one graph size.' => 'Jeeli uywasz wykresu jako formaty wyjsciowego musisz okresli jego rozmiar.',
        'Sum rows' => 'Suma wierszy',
        'Sum columns' => 'Suma kolumn',
        'Use cache' => '',
        'Most of the stats can be cached. This will speed up the presentation of this stat.' => 'Wikszo raportw moe by umieszczona w pamici podrcznej. Przyspiesza to wywietlanie tych raportw.',
        'If set to invalid end users can not generate the stat.' => '',

        # Template: AgentStatsEditValueSeries
        'Here you can define the value series.' => '',
        'You have the possibility to select one or two elements.' => '',
        'Then you can select the attributes of elements.' => '',
        'Each attribute will be shown as single value series.' => '',
        'If you don\'t select any attribute all attributes of the element will be used if you generate a stat, as well as new attributes which were added since the last configuration.' => '',
        'Scale' => 'Skala',
        'minimal' => 'minimum',
        'Please remember, that the scale for value series has to be larger than the scale for the X-axis (e.g. X-Axis => Month, ValueSeries => Year).' => 'Pamitaj e skala wartoci moze by wiksza od skali osi X (np. o X => Miesice, Wartoci => Rok).',

        # Template: AgentStatsEditXaxis
        'Here you can define the x-axis. You can select one element via the radio button.' => '',
        'maximal period' => 'maksymalny przedzia',
        'minimal scale' => 'minimalna skala',

        # Template: AgentStatsImport
        'Import Stat' => '',
        'File is not a Stats config' => 'Plik nie jest szablonem rapoortu',
        'No File selected' => 'Nie wybrano pliku',

        # Template: AgentStatsOverview
        'Stats' => 'Statystyki',
        'Object' => 'Obiekt',

        # Template: AgentStatsPrint
        'Print' => 'Drukuj',
        'No Element selected.' => 'Nie wybrano elementu.',

        # Template: AgentStatsView
        'Export config' => '',
        'With the input and select fields you can influence the format and contents of the statistic.' => '',
        'Exactly what fields and formats you can influence is defined by the statistic administrator.' => '',
        'Stat Details' => '',
        'Format' => 'Format',
        'Graphsize' => 'Wielko wykresu',
        'Cache' => 'Pami podrczna',
        'Exchange Axis' => 'Zamie osie',
        'Configurable params of static stat' => 'Konfigurowalne parametry statycznego raportu',
        'No element selected.' => 'Nie wybrano elementu',
        'maximal period from' => 'maksymalny przedzia od',
        'to' => 'do',

        # Template: AgentTicketActionCommon
        'Change Free Text of Ticket' => '',
        'Change Owner of Ticket' => '',
        'Close Ticket' => '',
        'Add Note to Ticket' => '',
        'Set Pending' => 'Ustaw oczekiwanie',
        'Change Priority of Ticket' => '',
        'Change Responsible of Ticket' => '',
        'Cancel & close window' => 'Anuluj i zamknij okienko',
        'Service invalid.' => '',
        'New Owner' => 'Nowy waciciel',
        'Please set a new owner!' => '',
        'Previous Owner' => 'Poprzedni waciciel',
        'Inform Agent' => 'Poinformuj agenta',
        'Optional' => 'Opcjonalny',
        'Inform involved Agents' => 'Poinformuj zaangaowanych agentw',
        'Spell check' => 'Sprawdzanie poprawnoci',
        'Note type' => 'Typ notatki',
        'Next state' => 'Nastpny status',
        'Pending date' => 'Data oczekiwania',
        'Date invalid!' => 'Niepoprawna data',

        # Template: AgentTicketActionPopupClose

        # Template: AgentTicketBounce
        'Bounce Ticket: ' => 'Przeka zgoszenie',
        'Bounce to' => 'Przeka do',
        'You need a email address.' => '',
        'Need a valid email address or don\'t use a local email address.' => '',
        'Next ticket state' => 'Nastpny status zgoszenia',
        'Inform sender' => 'Powiadom nadawc',
        'Send mail!' => 'Wylij wiadomo!',

        # Template: AgentTicketBulk
        'Ticket Bulk Action' => 'Akcja grupowa',
        'Merge to' => 'Przycz do',
        'Invalid ticket identifier!' => '',
        'Merge to oldest' => 'Przycz do najstarszego',
        'Link together' => 'Pocz razem',
        'Link to parent' => '',
        'Unlock tickets' => '',

        # Template: AgentTicketClose

        # Template: AgentTicketCompose
        'Compose answer for ticket' => 'Edytuj odpowied na zgoszenie',
        'Need a valid email address.' => '',
        'Address book' => '',
        'Pending Date' => 'Termin wyznaczony',
        'for pending* states' => 'dla statusw "oczekujcych" z pola powyej',
        'Date Invalid!' => '',

        # Template: AgentTicketCustomer
        'Change customer of ticket' => 'Zmie klienta dla zgoszenia',
        'Customer Data' => 'Dane klienta',
        'Customer user' => '',

        # Template: AgentTicketEmail
        'Create New Email Ticket' => 'Utwrz nowe zgoszenie email',
        'From queue' => 'Do kolejki',
        'Get all' => 'Pobierz wszystkich',

        # Template: AgentTicketEscalation

        # Template: AgentTicketForward
        'Forward ticket: ' => '',
        'Need a valid email address or don\'t use a local email address' => '',

        # Template: AgentTicketFreeText

        # Template: AgentTicketHistory
        'History of' => 'Historia',
        'History Content' => 'Zawarto historii',
        'Zoom view' => 'Widok szczegowy',

        # Template: AgentTicketMerge
        'Ticket Merge' => 'Scal zgoszenie',
        'You need to use a ticket number!' => 'Musisz uy numeru zgoszenia!',
        'A valid ticket number is required.' => 'Wymagany jest poprawny numer zgoszenia.',

        # Template: AgentTicketMove
        'Move Ticket' => 'Przenie zgoszenie',
        'New Queue' => 'Nowa kolejka',

        # Template: AgentTicketNote

        # Template: AgentTicketOverviewMedium
        'Select all' => 'Zaznacz wszystkie',
        'No ticket data found.' => '',
        'First Response Time' => 'Czas pozostay do pierwszej odpowiedzi',
        'Service Time' => 'W godzinach roboczych',
        'Update Time' => 'Czas pozostay do aktualizacji',
        'Solution Time' => 'Czas pozostay do rozwiazania',
        'Move ticket to a different queue' => 'Przenie zgoszenie do innej kolejki',
        'Change queue' => 'Zmie kolejk',

        # Template: AgentTicketOverviewNavBar
        'Change search options' => 'Zmie kryteria wyszukiwania',
        'Tickets per page' => '',

        # Template: AgentTicketOverviewPreview

        # Template: AgentTicketOverviewSmall
        'Escalation in' => 'Eskalowane w',
        'Locked' => 'Blokada',

        # Template: AgentTicketOwner

        # Template: AgentTicketPending

        # Template: AgentTicketPhone
        'Create New Phone Ticket' => 'Utwrz nowe zgoszenie telefoniczne',
        'From customer' => 'Od klienta',
        'To queue' => 'Do kolejki',
        'Create' => 'Utwrz',

        # Template: AgentTicketPhoneOutbound
        'Phone call' => 'Telefon',

        # Template: AgentTicketPlain
        'Email Text Plain View' => '',
        'Plain' => 'Puste',
        'Download this email' => '',

        # Template: AgentTicketPrint
        'Ticket-Info' => 'Informacje o zgoszeniu',
        'Accounted time' => 'Zaraportowany czas',
        'Linked-Object' => 'Powizany obiekt',
        'by' => 'przez',

        # Template: AgentTicketPriority

        # Template: AgentTicketQueue

        # Template: AgentTicketResponsible

        # Template: AgentTicketSearch
        'Search template' => 'Szablon wyszukiwania',
        'Create New' => 'Stwrz nowy',
        'Create Template' => 'Stwrz szablon',
        'Save changes in template' => '',
        'Add another attribute' => 'Dodaj kryterium wyszukiwania',
        'Output' => 'Formularz wynikw',
        'Fulltext' => 'Penotekstowe',
        'Remove' => 'Usu',
        'Customer User Login' => 'Login Klienta',
        'Time1' => '',
        'Time2' => '',
        'Time3' => '',
        'Time4' => '',
        'Time5' => '',
        'Time6' => '',
        'Created in Queue' => 'Utworzono w kolejce',
        'Lock state' => 'Stan blokady',
        'Watcher' => 'Obserwujcy',
        'Article Create Time (before/after)' => '',
        'Article Create Time (between)' => '',
        'Ticket Create Time (before/after)' => '',
        'Ticket Create Time (between)' => '',
        'Ticket Change Time (before/after)' => '',
        'Ticket Change Time (between)' => '',
        'Ticket Close Time (before/after)' => '',
        'Ticket Close Time (between)' => '',
        'Archive Search' => 'Szukanie w archiwum',
        'Run Search' => 'Wyszukaj',

        # Template: AgentTicketSearchOpenSearchDescriptionFulltext

        # Template: AgentTicketSearchOpenSearchDescriptionTicketNumber

        # Template: AgentTicketSearchResultPrint

        # Template: AgentTicketZoom
        'Article filter' => 'Filtr wiadomoci',
        'Article Type' => '',
        'Sender Type' => '',
        'Save filter settings as default' => 'Zapisz ustawienia filtru jako domylne',
        'Ticket Information' => 'Informacje o zgoszeniu',
        'Linked Objects' => 'Poczone elementy',
        'Article(s)' => 'Wiadomo(ci)',
        'Change Queue' => 'Zmie kolejk',
        'Article Filter' => '',
        'Add Filter' => 'Dodaj filtr',
        'Set' => 'Ustaw',
        'Reset Filter' => 'resetuj filtr',
        'Show one article' => 'Poka tylko jedn wiadomo',
        'Show all articles' => 'Poka wszystkie wiadomoci',
        'Unread articles' => 'Nieprzeczytane wiadomoci',
        'No.' => '',
        'Unread Article!' => 'Nieprzeczytana wiadomo!',
        'Incoming message' => '',
        'Outgoing message' => '',
        'Internal message' => '',
        'Resize' => '',

        # Template: AttachmentBlocker
        'To protect your privacy, active or/and remote content has blocked.' => '',
        'Load blocked content.' => 'Zaaduj zablokowan tre',

        # Template: Copyright

        # Template: CustomerAccept

        # Template: CustomerError
        'Traceback' => 'led wstecz',

        # Template: CustomerFooter
        'Powered by' => 'Oparte na',
        'One or more errors occurred!' => '',
        'Close this dialog' => '',
        'Could not open popup window. Please disable any popup blockers for this application.' => '',

        # Template: CustomerHeader

        # Template: CustomerLogin
        'Login' => 'Login',
        'User name' => '',
        'Your user name' => '',
        'Your password' => '',
        'Forgot password?' => 'Zapomniane haso?',
        'Log In' => '',
        'Not yet registered?' => 'Nie jeste jeszcze zarejetrowanym uytkownikiem?',
        'Sign up now' => 'Zarejestruj si',
        'Request new password' => 'Proba o nowe haso',
        'Your User Name' => 'Nazwa uytkownika',
        'A new password will be sent to your email address.' => '',
        'Create Account' => 'Utwrz konto',
        'Please fill out this form to recieve login credentials.' => '',
        'How we should address you' => '',
        'Your First Name' => 'Twoje imi',
        'Please supply a first name' => '',
        'Your Last Name' => 'Twoje nazwisko',
        'Please supply a last name' => '',
        'The User Name you wish to have' => '',
        'Please supply a' => '',

        # Template: CustomerNavigationBar
        'Edit personal preferences' => 'Edytuj ustawienia osobiste',

        # Template: CustomerPreferences

        # Template: CustomerRichTextEditor

        # Template: CustomerTicketMessage
        'Service level agreement' => '',

        # Template: CustomerTicketOverView
        'Welcome!' => '',
        'Please click the button below to create your first ticket.' => '',
        'Create your first ticket' => '',

        # Template: CustomerTicketPrint
        'Ticket Print' => '',

        # Template: CustomerTicketSearch
        'Profile' => 'Profil',
        'e. g. 10*5155 or 105658*' => 'np. 10*5155 lub 105658*',
        'Customer ID' => 'ID klienta',
        'Fulltext search in tickets (e. g. "John*n" or "Will*")' => 'Wyszukiwanie penotekstowe w zgoszeniach (np. "*odyfikacj* lub Axapta*"',
        'Recipient' => 'Odbiorca',
        'Carbon Copy' => 'Ukryta kopia (CC)',
        'Time restrictions' => 'Ograniczenia czasowe',
        'Only tickets created' => 'Tylko zgoszenia utworzone',
        'Only tickets created between' => 'Tylko zgoszenia utworzone midzy',
        'Search-Profile as Template?' => 'Zapisa jako szablon wyszukiwania?',
        'Save as Template?' => 'Zapisz jako szablon',
        'Template Name' => 'Nazwa szablonu',
        'Output to' => 'Wyniki prezentuj jako',

        # Template: CustomerTicketSearchOpenSearchDescription

        # Template: CustomerTicketSearchResultPrint

        # Template: CustomerTicketSearchResultShort
        'of' => 'z',
        'Page' => 'Strona',
        'Search Results for' => '',

        # Template: CustomerTicketZoom
        'Expand article' => '',
        'Reply' => 'Odpowied',

        # Template: CustomerWarning

        # Template: Datepicker
        'Invalid date (need a future date)!' => '',
        'Previous' => 'Poprzednie',
        'Sunday' => 'Niedziela',
        'Monday' => 'Poniedziaek',
        'Tuesday' => 'Wtorek',
        'Wednesday' => 'roda',
        'Thursday' => 'Czwartek',
        'Friday' => 'Pitek',
        'Saturday' => 'Sobota',
        'Su' => 'Ndz',
        'Mo' => 'Pnd',
        'Tu' => 'Wtk',
        'We' => 'rd',
        'Th' => 'Czw',
        'Fr' => 'Ptk',
        'Sa' => 'Sob',
        'Open date selection' => '',

        # Template: Error
        'Oops! An Error occurred.' => 'Ciemna rubka! Bond!',
        'Error Message' => 'Komunikat bdu',
        'You can' => 'Moesz',
        'Send a bugreport' => 'Wysa raport na temat bdu',
        'go back to the previous page' => 'powrci do poprzedniej strony',
        'Error Details' => 'Szczegy bdu',

        # Template: Footer
        'Top of page' => 'Gra strony',

        # Template: FooterJS
        'If you now leave this page, all open popup windows will be closed, too!' => '',
        'A popup of this screen is already open. Do you want to close it and load this one instead?' => '',

        # Template: FooterSmall

        # Template: HTMLHead

        # Template: HTMLHeadBlockEvents

        # Template: Header
        'You are logged in as' => 'Jeste zalogowany jako',

        # Template: HeaderSmall

        # Template: Installer
        'JavaScript not available' => '',
        'In order to experience OTRS, you\'ll need to enable JavaScript in your browser.' => '',
        'Database Settings' => '',
        'General Specifications and Mail Settings' => '',
        'Welcome to %s' => 'Witamy w %s',
        'Web site' => '',
        'Database check successful.' => '',
        'Mail check successful.' => '',
        'Error in the mail settings. Please correct and try again.' => '',

        # Template: InstallerConfigureMail
        'Configure Outbound Mail' => '',
        'Outbound mail type' => '',
        'Select outbound mail type.' => '',
        'Outbound mail port' => '',
        'Select outbound mail port.' => '',
        'SMTP host' => '',
        'SMTP host.' => '',
        'SMTP authentication' => '',
        'Does your SMTP host need authentication?' => '',
        'SMTP auth user' => '',
        'Username for SMTP auth.' => '',
        'SMTP auth password' => '',
        'Password for SMTP auth.' => '',
        'Configure Inbound Mail' => '',
        'Inbound mail type' => '',
        'Select inbound mail type.' => '',
        'Inbound mail host' => '',
        'Inbound mail host.' => '',
        'Inbound mail user' => '',
        'User for inbound mail.' => '',
        'Inbound mail password' => '',
        'Password for inbound mail.' => '',
        'Result of mail configuration check' => '',
        'Check mail configuration' => '',
        'Skip this step' => '',

        # Template: InstallerDBResult
        'False' => '',

        # Template: InstallerDBStart
        'If you have set a root password for your database, it must be entered here. If not, leave this field empty. For security reasons we do recommend setting a root password. For more information please refer to your database documentation.' => 'Jeeli masz haso administratora bazy danych wpisz je tutaj. Jeeli nie, zostaw pole puste. Ze wzgledw bezpieczestwa zalecamy ustawienia hasa administratoa bazy danych. Po szczegy signij do dokumentacji bazy danych.',
        'Currently only MySQL is supported in the web installer.' => '',
        'If you want to install OTRS on another database type, please refer to the file README.database.' => '',
        'Database-User' => 'Uytkownik bazy danych',
        'New' => 'Nowe',
        'A new database user with limited rights will be created for this OTRS system.' => '',
        'default \'hot\'' => 'domylne \'hot\'',
        'DB--- host' => '',
        'Database' => 'baza danych',
        'Check database settings' => '',
        'Result of database check' => '',

        # Template: InstallerFinish
        'To be able to use OTRS you have to enter the following line in your command line (Terminal/Shell) as root.' => 'Musisz wpisa nastpujce polecenie w linii komend (Terminal/Shell).',
        'Restart your webserver' => 'Uruchom ponownie serwer WWW',
        'After doing so your OTRS is up and running.' => 'Po zakoczeniu tych czynnoci Twj system OTRS bdzie gotowy do pracy',
        'Start page' => 'Strona startowa',
        'Your OTRS Team' => 'Twj Team OTRS',

        # Template: InstallerLicense
        'Accept license' => 'Akceptuj licencj',
        'Don\'t accept license' => 'Nie akceptuje licencji',

        # Template: InstallerLicenseText

        # Template: InstallerSystem
        'SystemID' => 'ID Systemu',
        'The identifier of the system. Each ticket number and each HTTP session ID contain this number.' => '',
        'System FQDN' => 'Pena domena systemu FQDN',
        'Fully qualified domain name of your system.' => '',
        'AdminEmail' => 'Email od Admina',
        'Email address of the system administrator.' => '',
        'Organization' => 'Organizacja',
        'Log' => 'Log',
        'LogModule' => 'Modu logowania',
        'Log backend to use.' => '',
        'LogFile' => '',
        'Log file location is only needed for File-LogModule!' => '',
        'Webfrontend' => 'Interfejs webowy',
        'Default language' => '',
        'Default language.' => '',
        'CheckMXRecord' => 'Sprawd rekord MX',
        'Email addresses that are manually entered are checked against the MX records found in DNS. Don\'t use this option if your DNS is slow or does not resolve public addresses.' => '',

        # Template: LinkObject
        'Object#' => '',
        'Add links' => '',
        'Delete links' => 'Usu linki',

        # Template: Login
        'JavaScript Not Available' => '',
        'Browser Warning' => '',
        'The browser you are using is too old.' => '',
        'OTRS runs with a huge lists of browsers, please upgrade to one of these.' => '',
        'Please see the documentation or ask your admin for further information.' => '',
        'Lost your password?' => 'Zapomniae hasa?',
        'Request New Password' => '',
        'Back to login' => '',

        # Template: Motd
        'Message of the Day' => '',

        # Template: NoPermission
        'Insufficient Rights' => '',
        'Back to the previous page' => '',

        # Template: Notify

        # Template: Pagination
        'Show first page' => '',
        'Show previous pages' => '',
        'Show page %s' => '',
        'Show next pages' => '',
        'Show last page' => '',

        # Template: PictureUpload
        'Need FormID!' => '',
        'No file found!' => '',
        'The file is not an image that can be shown inline!' => '',

        # Template: PrintFooter
        'URL' => 'URL',

        # Template: PrintHeader
        'printed by' => 'wydrukowane przez',

        # Template: PublicDefault

        # Template: Redirect

        # Template: RichTextEditor

        # Template: SpellingInline

        # Template: Test
        'OTRS Test Page' => 'OTRS Strona testowa',
        'Welcome %s' => 'Witaj %s',
        'Counter' => 'Licznik',

        # Template: Warning
        'Go back to the previous page' => '',

        # SysConfig
        'ACL module that allows closing parent tickets only if all its children are already closed ("State" shows which states are not available for the parent ticket until all child tickets are closed).' => '',
        'Activates TypeAhead for the autocomplete feature, that enables users to type in whatever speed they desire, without losing any information. Often this means that keystrokes entered will not be displayed on the screen immediately.' => '',
        'Activates a blinking mechanism of the queue that contains the oldest ticket.' => '',
        'Activates lost password feature for agents, in the agent interface.' => '',
        'Activates lost password feature for customers.' => '',
        'Activates support for customer groups.' => '',
        'Activates the article filter in the zoom view to specify which articles should be shown.' => '',
        'Activates the available themes on the system. Value 1 means active, 0 means inactive.' => '',
        'Activates the ticket archive system to have a faster system by moving some tickets out of the daily scope. To search for these tickets, the archive flag has to be enabled in the ticket search.' => '',
        'Activates time accounting.' => '',
        'Adds a suffix with the actual year and month to the OTRS log file. A logfile for every month will be created.' => '',
        'Adds customers email addresses to recipients in the ticket compose screen of the agent interface.' => '',
        'Adds the one time vacation days for the calendar number 1. Please use single digit pattern for numbers from 1 to 9 (instead of 01 - 09).' => '',
        'Adds the one time vacation days for the calendar number 2. Please use single digit pattern for numbers from 1 to 9 (instead of 01 - 09).' => '',
        'Adds the one time vacation days for the calendar number 3. Please use single digit pattern for numbers from 1 to 9 (instead of 01 - 09).' => '',
        'Adds the one time vacation days for the calendar number 4. Please use single digit pattern for numbers from 1 to 9 (instead of 01 - 09).' => '',
        'Adds the one time vacation days for the calendar number 5. Please use single digit pattern for numbers from 1 to 9 (instead of 01 - 09).' => '',
        'Adds the one time vacation days for the calendar number 6. Please use single digit pattern for numbers from 1 to 9 (instead of 01 - 09).' => '',
        'Adds the one time vacation days for the calendar number 7. Please use single digit pattern for numbers from 1 to 9 (instead of 01 - 09).' => '',
        'Adds the one time vacation days for the calendar number 8. Please use single digit pattern for numbers from 1 to 9 (instead of 01 - 09).' => '',
        'Adds the one time vacation days for the calendar number 9. Please use single digit pattern for numbers from 1 to 9 (instead of 01 - 09).' => '',
        'Adds the one time vacation days. Please use single digit pattern for numbers from 1 to 9 (instead of 01 - 09).' => '',
        'Adds the permanent vacation days for the calendar number 1. Please use single digit pattern for numbers from 1 to 9 (instead of 01 - 09).' => '',
        'Adds the permanent vacation days for the calendar number 2. Please use single digit pattern for numbers from 1 to 9 (instead of 01 - 09).' => '',
        'Adds the permanent vacation days for the calendar number 3. Please use single digit pattern for numbers from 1 to 9 (instead of 01 - 09).' => '',
        'Adds the permanent vacation days for the calendar number 4. Please use single digit pattern for numbers from 1 to 9 (instead of 01 - 09).' => '',
        'Adds the permanent vacation days for the calendar number 5. Please use single digit pattern for numbers from 1 to 9 (instead of 01 - 09).' => '',
        'Adds the permanent vacation days for the calendar number 6. Please use single digit pattern for numbers from 1 to 9 (instead of 01 - 09).' => '',
        'Adds the permanent vacation days for the calendar number 7. Please use single digit pattern for numbers from 1 to 9 (instead of 01 - 09).' => '',
        'Adds the permanent vacation days for the calendar number 8. Please use single digit pattern for numbers from 1 to 9 (instead of 01 - 09).' => '',
        'Adds the permanent vacation days for the calendar number 9. Please use single digit pattern for numbers from 1 to 9 (instead of 01 - 09).' => '',
        'Adds the permanent vacation days. Please use single digit pattern for numbers from 1 to 9 (instead of 01 - 09).' => '',
        'Agent Notifications' => 'Powiadomienie dla agentw',
        'Agent interface article notification module to check PGP.' => '',
        'Agent interface article notification module to check S/MIME.' => '',
        'Agent interface module to access fulltext search via nav bar.' => '',
        'Agent interface module to access search profiles via nav bar.' => '',
        'Agent interface module to check incoming emails in the Ticket-Zoom-View if the S/MIME-key is available and true.' => '',
        'Agent interface notification module to check the used charset.' => '',
        'Agent interface notification module to see the number of tickets an agent is responsible for.' => '',
        'Agent interface notification module to see the number of watched tickets.' => '',
        'Agents <-> Groups' => 'Agenci <-> Grupy',
        'Agents <-> Roles' => '',
        'Allows adding notes in the close ticket screen of the agent interface.' => '',
        'Allows adding notes in the ticket free text screen of the agent interface.' => '',
        'Allows adding notes in the ticket note screen of the agent interface.' => '',
        'Allows adding notes in the ticket owner screen of a zoomed ticket in the agent interface.' => '',
        'Allows adding notes in the ticket pending screen of a zoomed ticket in the agent interface.' => '',
        'Allows adding notes in the ticket priority screen of a zoomed ticket in the agent interface.' => '',
        'Allows adding notes in the ticket responsible screen of the agent interface.' => '',
        'Allows agents to exchange the axis of a stat if they generate one.' => '',
        'Allows agents to generate individual-related stats.' => '',
        'Allows choosing between showing the attachments of a ticket in the browser (inline) or just make them downloadable (attachment).' => '',
        'Allows choosing the next compose state for customer tickets in the customer interface.' => '',
        'Allows customers to change the ticket priority in the customer interface.' => '',
        'Allows customers to set the ticket SLA in the customer interface.' => '',
        'Allows customers to set the ticket priority in the customer interface.' => '',
        'Allows customers to set the ticket queue in the customer interface. If this is set to \'No\', QueueDefault should be configured.' => '',
        'Allows customers to set the ticket service in the customer interface.' => '',
        'Allows defining new types for ticket (if ticket type feature is enabled).' => '',
        'Allows defining services and SLAs for tickets (e. g. email, desktop, network, ...), and escalation attributes for SLAs (if ticket service/SLA feature is enabled).' => '',
        'Allows extended search conditions in ticket search of the agent interface. With this feature you can search w. g. with this kind of conditions like "(key1&&key2)" or "(key1||key2)".' => '',
        'Allows extended search conditions in ticket search of the customer interface. With this feature you can search w. g. with this kind of conditions like "(key1&&key2)" or "(key1||key2)".' => '',
        'Allows having a medium format ticket overview (CustomerInfo => 1 - shows also the customer information).' => '',
        'Allows having a small format ticket overview (CustomerInfo => 1 - shows also the customer information).' => '',
        'Allows the administrators to login as other users, via the users administration panel.' => '',
        'Allows to set a new ticket state in the move ticket screen of the agent interface.' => '',
        'Article free text options shown in the close ticket screen of the agent interface. Possible settings: 0 = Disabled, 1 = Enabled, 2 = Enabled and required.' => '',
        'Article free text options shown in the email ticket screen of the agent interface. Possible settings: 0 = Disabled, 1 = Enabled, 2 = Enabled and required.' => '',
        'Article free text options shown in the phone ticket screen of the agent interface. Possible settings: 0 = Disabled, 1 = Enabled, 2 = Enabled and required.' => '',
        'Article free text options shown in the ticket compose screen of the agent interface. Possible settings: 0 = Disabled, 1 = Enabled, 2 = Enabled and required.' => '',
        'Article free text options shown in the ticket free text screen of the agent interface. Possible settings: 0 = Disabled, 1 = Enabled, 2 = Enabled and required.' => '',
        'Article free text options shown in the ticket message screen of the customer interface. Possible settings: 0 = Disabled, 1 = Enabled, 2 = Enabled and required. NOTE. If you want to display these fields also in the ticket zoom of the customer interface, you have to enable them in CustomerTicketZoom###AttributesView.' => '',
        'Article free text options shown in the ticket note screen of the agent interface. Possible settings: 0 = Disabled, 1 = Enabled, 2 = Enabled and required.' => '',
        'Article free text options shown in the ticket owner screen of a zoomed ticket in the agent interface. Possible settings: 0 = Disabled, 1 = Enabled, 2 = Enabled and required.' => '',
        'Article free text options shown in the ticket pending screen of a zoomed ticket in the agent interface. Possible settings: 0 = Disabled, 1 = Enabled, 2 = Enabled and required.' => '',
        'Article free text options shown in the ticket phone outbound screen of the agent interface. Possible settings: 0 = Disabled, 1 = Enabled, 2 = Enabled and required.' => '',
        'Article free text options shown in the ticket priority screen of a zoomed ticket in the agent interface. Possible settings: 0 = Disabled, 1 = Enabled, 2 = Enabled and required.' => '',
        'Article free text options shown in the ticket responsible screen of the agent interface. Possible settings: 0 = Disabled, 1 = Enabled, 2 = Enabled and required.' => '',
        'Attachments <-> Responses' => 'Zaczniki <-> Odpowiedzi',
        'Auto Responses <-> Queues' => '',
        'Automated line break in text messages after x number of chars.' => '',
        'Automatically lock and set owner to current Agent after selecting for an Bulk Action.' => '',
        'Automatically sets the owner of a ticket as the responsible for it (if ticket responsible feature is enabled).' => '',
        'Automatically sets the responsible of a ticket (if it is not set yet) after the first owner update.' => '',
        'Balanced white skin by Felix Niklas.' => '',
        'Blocks all the incoming emails that do not have a valid ticket number in subject with From: @example.com address.' => '',
        'Builds an article index right after the article\'s creation.' => '',
        'CMD example setup. Ignores emails where external CMD returns some output on STDOUT (email will be piped into STDIN of some.bin).' => '',
        'Change password' => '',
        'Change queue!' => '',
        'Change the ticket responsible!' => '',
        'Changes the owner of tickets to everyone (useful for ASP). Normally only agent with rw permissions in the queue of the ticket will be shown.' => '',
        'Checks the SystemID in ticket number detection for follow-ups (use "No" if SystemID has been changed after using the system).' => '',
        'Comment for new history entries in the customer interface.' => '',
        'Companies' => '',
        'Company Tickets' => 'Zgoszenia firmowe',
        'Configure your own log text for PGP.' => '',
        'Configures a default TicketFreeField setting. "Counter" defines the free text field which should be used, "Key" is the TicketFreeKey, "Value" is the TicketFreeText and "Event" defines the trigger event.' => '',
        'Configures a default TicketFreeField setting. "Counter" defines the free text field which should be used, "Key" is the TicketFreeKey, "Value" is the TicketFreeText and "Event" defines the trigger event. Please check the developer manual (http://doc.otrs.org/), chapter "Ticket Event Module".' => '',
        'Configures the full-text index. Execute "bin/otrs.RebuildFulltextIndex.pl" in order to generate a new index.' => '',
        'Controls if customers have the ability to sort their tickets.' => '',
        'Converts HTML mails into text messages.' => '',
        'Create and manage Service Level Agreements (SLAs).' => 'Ustawienia Poziomw Serwisu (SLA)',
        'Create and manage agents.' => 'Zarzdzanie list agentw',
        'Create and manage attachments.' => 'Ustawienia standardowych zacznikw',
        'Create and manage companies.' => 'Zarzdzanie list Firm klientw',
        'Create and manage customers.' => 'Zarzdzanie list klientw',
        'Create and manage event based notifications.' => '',
        'Create and manage groups.' => 'Ustawienia grup agentw',
        'Create and manage notifications that are sent to agents.' => 'Ustawienia powiadomie wysyanych do agentw',
        'Create and manage queues.' => 'Ustawienia kolejek zgosze',
        'Create and manage response templates.' => 'Ustawienia szablonw odpowiedzi',
        'Create and manage responses that are automatically sent.' => 'Ustawienia szablonw odpowiedzi automatycznych',
        'Create and manage roles.' => 'Zarzdzanie rolami systemowymi',
        'Create and manage salutations.' => 'Ustawienia szablonw powita',
        'Create and manage services.' => 'Zarzdzanie usugami serwisowymi',
        'Create and manage signatures.' => 'Ustawienia szablonw podpisw',
        'Create and manage ticket priorities.' => 'Ustawianie priorytetw zgosze',
        'Create and manage ticket states.' => 'Ustawienia statusw zgosze',
        'Create and manage ticket types.' => 'Ustawienia typw zgosze',
        'Create new email ticket and send this out (outbound)' => 'Utwrz i wylij nowe zgoszenie mejlowe (wychodzce)',
        'Create new phone ticket (inbound)' => 'Utwrz nowe zgoszenie telefoniczne (przychodzce)',
        'Custom text for the page shown to customers that have no tickets yet.' => '',
        'Customer item (icon) which shows the open tickets of this customer as info block.' => '',
        'Customers <-> Groups' => 'Klienci <-> Grupy',
        'Customers <-> Services' => 'Klienci <-> Usugi',
        'Data used to export the search result in CSV format.' => '',
        'Debugs the translation set. If this is set to "Yes" all strings (text) without translations are written to STDERR. This can be helpful when you are creating a new translation file. Otherwise, this option should remain set to "No".' => '',
        'Default ACL values for ticket actions.' => '',
        'Default data to use on attribute for ticket search screen. Example: "TicketCreateTimePointFormat=year;TicketCreateTimePointStart=Last;TicketCreateTimePoint=2;".' => '',
        'Default data to use on attribute for ticket search screen. Example: "TicketCreateTimeStartYear=2010;TicketCreateTimeStartMonth=10;TicketCreateTimeStartDay=4;TicketCreateTimeStopYear=2010;TicketCreateTimeStopMonth=11;TicketCreateTimeStopDay=3;".' => '',
        'Default loop protection module.' => '',
        'Default queue ID used by the system in the agent interface.' => '',
        'Default skin for OTRS 3.0 interface.' => '',
        'Default skin for interface.' => '',
        'Default ticket ID used by the system in the agent interface.' => '',
        'Default ticket ID used by the system in the customer interface.' => '',
        'Define a filter for html output to add links behind a defined string. The element Image allows two input kinds. At once the name of an image (e.g. faq.png). In this case the OTRS image path will be used. The second possiblity is to insert the link to the image.' => '',
        'Define the start day of the week for the date picker.' => '',
        'Defines a customer item, which generates a LinkedIn icon at the end of a customer info block.' => '',
        'Defines a customer item, which generates a XING icon at the end of a customer info block.' => '',
        'Defines a customer item, which generates a google icon at the end of a customer info block.' => '',
        'Defines a customer item, which generates a google maps icon at the end of a customer info block.' => '',
        'Defines a default list of words, that are ignored by the spell checker.' => '',
        'Defines a filter for html output to add links behind CVE numbers. The element Image allows two input kinds. At once the name of an image (e.g. faq.png). In this case the OTRS image path will be used. The second possiblity is to insert the link to the image.' => '',
        'Defines a filter for html output to add links behind MSBulletin numbers. The element Image allows two input kinds. At once the name of an image (e.g. faq.png). In this case the OTRS image path will be used. The second possiblity is to insert the link to the image.' => '',
        'Defines a filter for html output to add links behind a defined string. The element Image allows two input kinds. At once the name of an image (e.g. faq.png). In this case the OTRS image path will be used. The second possiblity is to insert the link to the image.' => '',
        'Defines a filter for html output to add links behind bugtraq numbers. The element Image allows two input kinds. At once the name of an image (e.g. faq.png). In this case the OTRS image path will be used. The second possiblity is to insert the link to the image.' => '',
        'Defines a filter to process the text in the articles, in order to highlight predefined keywords.' => '',
        'Defines a regular expression that excludes some addresses from the syntax check (if "CheckEmailAddresses" is set to "Yes"). Please enter a regex in this field for email addresses, that aren\'t syntactically valid, but are necessary for the system (i.e. "root@localhost").' => '',
        'Defines a regular expression that filters all email addresses that should not be used in the application.' => '',
        'Defines a useful module to load specific user options or to display news.' => '',
        'Defines all the X-headers that should be scanned.' => '',
        'Defines all the languages that are available to the application. The Key/Content pair links the front-end display name to the appropriate language PM file. The "Key" value should be the base-name of the PM file (i.e. de.pm is the file, then de is the "Key" value). The "Content" value should be the display name for the front-end. Specify any own-defined language here (see the developer documentation http://doc.otrs.org/ for more infomation). Please remember to use the HTML equivalents for non-ASCII characters (i.e. for the German oe = o umlaut, it is necessary to use the &ouml; symbol).' => '',
        'Defines all the parameters for the RefreshTime object in the customer preferences of the customer interface.' => '',
        'Defines all the parameters for the ShownTickets object in the customer preferences of the customer interface.' => '',
        'Defines all the parameters for this item in the customer preferences.' => '',
        'Defines all the possible stats output formats.' => '',
        'Defines an alternate URL, where the login link refers to.' => '',
        'Defines an alternate URL, where the logout link refers to.' => '',
        'Defines an alternate login URL for the customer panel..' => '',
        'Defines an alternate logout URL for the customer panel.' => '',
        'Defines an external link to the database of the customer (e.g. \'http://yourhost/customer.php?CID=$Data{"CustomerID"}\' or \'\').' => '',
        'Defines how the From field from the emails (sent from answers and email tickets) should look like.' => '',
        'Defines if a ticket lock is required in the close ticket screen of the agent interface (if the ticket isn\'t locked yet, the ticket gets locked and the current agent will be set automatically as its owner).' => '',
        'Defines if a ticket lock is required in the ticket bounce screen of the agent interface (if the ticket isn\'t locked yet, the ticket gets locked and the current agent will be set automatically as its owner).' => '',
        'Defines if a ticket lock is required in the ticket compose screen of the agent interface (if the ticket isn\'t locked yet, the ticket gets locked and the current agent will be set automatically as its owner).' => '',
        'Defines if a ticket lock is required in the ticket forward screen of the agent interface (if the ticket isn\'t locked yet, the ticket gets locked and the current agent will be set automatically as its owner).' => '',
        'Defines if a ticket lock is required in the ticket free text screen of the agent interface (if the ticket isn\'t locked yet, the ticket gets locked and the current agent will be set automatically as its owner).' => '',
        'Defines if a ticket lock is required in the ticket merge screen of a zoomed ticket in the agent interface (if the ticket isn\'t locked yet, the ticket gets locked and the current agent will be set automatically as its owner).' => '',
        'Defines if a ticket lock is required in the ticket note screen of the agent interface (if the ticket isn\'t locked yet, the ticket gets locked and the current agent will be set automatically as its owner).' => '',
        'Defines if a ticket lock is required in the ticket owner screen of a zoomed ticket in the agent interface (if the ticket isn\'t locked yet, the ticket gets locked and the current agent will be set automatically as its owner).' => '',
        'Defines if a ticket lock is required in the ticket pending screen of a zoomed ticket in the agent interface (if the ticket isn\'t locked yet, the ticket gets locked and the current agent will be set automatically as its owner).' => '',
        'Defines if a ticket lock is required in the ticket phone outbound screen of the agent interface (if the ticket isn\'t locked yet, the ticket gets locked and the current agent will be set automatically as its owner).' => '',
        'Defines if a ticket lock is required in the ticket priority screen of a zoomed ticket in the agent interface (if the ticket isn\'t locked yet, the ticket gets locked and the current agent will be set automatically as its owner).' => '',
        'Defines if a ticket lock is required in the ticket responsible screen of the agent interface (if the ticket isn\'t locked yet, the ticket gets locked and the current agent will be set automatically as its owner).' => '',
        'Defines if a ticket lock is required to change the customer of a ticket in the agent interface (if the ticket isn\'t locked yet, the ticket gets locked and the current agent will be set automatically as its owner).' => '',
        'Defines if composed messages have to be spell checked in the agent interface.' => '',
        'Defines if time accounting is mandatory in the agent interface.' => '',
        'Defines if time accounting must be set to all tickets in bulk action.' => '',
        'Defines the =hHeight for the rich text editor component. Enter number (pixels) or percent value (relative).' => '',
        'Defines the IP regular expression for accessing the local repository. You need to enable this to have access to your local repository and the package::RepositoryList is required on the remote host.' => '',
        'Defines the URL CSS path.' => '',
        'Defines the URL base path of icons, CSS and Java Script.' => '',
        'Defines the URL image path of icons for navigation.' => '',
        'Defines the URL java script path.' => '',
        'Defines the URL rich text editor path.' => '',
        'Defines the address of a dedicated DNS server, if necessary, for the "CheckMXRecord" look-ups.' => '',
        'Defines the body text for notification mails sent to agents, about new password (after using this link the new password will be sent).' => '',
        'Defines the body text for notification mails sent to agents, with token about new requested password (after using this link the new password will be sent).' => '',
        'Defines the body text for notification mails sent to customers, about new account.' => '',
        'Defines the body text for notification mails sent to customers, about new password (after using this link the new password will be sent).' => '',
        'Defines the body text for notification mails sent to customers, with token about new requested password (after using this link the new password will be sent).' => '',
        'Defines the body text for rejected emails.' => '',
        'Defines the boldness of the line drawed by the graph.' => '',
        'Defines the colors for the graphs.' => '',
        'Defines the column to store the keys for the preferences table.' => '',
        'Defines the config parameters of this item, to be shown in the preferences view.' => '',
        'Defines the config parameters of this item, to be shown in the preferences view. Take care to maintain the dictionaries installed in the system in the data section.' => '',
        'Defines the connections for http/ftp, via a proxy.' => '',
        'Defines the date input format used in forms (option or input fields).' => '',
        'Defines the default CSS used in rich text editors.' => '',
        'Defines the default body of a note in the ticket free text screen of the agent interface.' => '',
        'Defines the default front-end (HTML) theme to be used by the agents and customers. The default themes are Standard and Lite. If you like, you can add your own theme. Please refer the administrator manual located at http://doc.otrs.org/.' => '',
        'Defines the default front-end language. All the possible values are determined by the available language files on the system (see the next setting).' => '',
        'Defines the default history type in the customer interface.' => '',
        'Defines the default maximum number of X-axis attributes for the time scale.' => '',
        'Defines the default maximum number of search results shown on the overview page.' => '',
        'Defines the default next state for a ticket after customer follow up in the customer interface.' => '',
        'Defines the default next state of a ticket after adding a note, in the close ticket screen of the agent interface.' => '',
        'Defines the default next state of a ticket after adding a note, in the ticket bulk screen of the agent interface.' => '',
        'Defines the default next state of a ticket after adding a note, in the ticket free text screen of the agent interface.' => '',
        'Defines the default next state of a ticket after adding a note, in the ticket note screen of the agent interface.' => '',
        'Defines the default next state of a ticket after adding a note, in the ticket owner screen of a zoomed ticket in the agent interface.' => '',
        'Defines the default next state of a ticket after adding a note, in the ticket pending screen of a zoomed ticket in the agent interface.' => '',
        'Defines the default next state of a ticket after adding a note, in the ticket priority screen of a zoomed ticket in the agent interface.' => '',
        'Defines the default next state of a ticket after adding a note, in the ticket responsible screen of the agent interface.' => '',
        'Defines the default next state of a ticket after being bounced, in the ticket bounce screen of the agent interface.' => '',
        'Defines the default next state of a ticket after being forwarded, in the ticket forward screen of the agent interface.' => '',
        'Defines the default next state of a ticket if it is composed / answered in the ticket compose screen of the agent interface.' => '',
        'Defines the default note body text for phone tickets in the ticket phone outbound screen of the agent interface.' => '',
        'Defines the default priority of follow up customer tickets in the ticket zoom screen in the customer interface.' => '',
        'Defines the default priority of new customer tickets in the customer interface.' => '',
        'Defines the default priority of new tickets.' => '',
        'Defines the default queue for new customer tickets in the customer interface.' => '',
        'Defines the default selection at the drop down menu for dynamic objects (Form: Common Specification).' => '',
        'Defines the default selection at the drop down menu for permissions (Form: Common Specification).' => '',
        'Defines the default selection at the drop down menu for stats format (Form: Common Specification). Please insert the format key (see Stats::Format).' => '',
        'Defines the default selection of the free key field number 1 for articles (if more than one option is provided).' => '',
        'Defines the default selection of the free key field number 1 for tickets (if more than one option is provided).' => '',
        'Defines the default selection of the free key field number 10 for tickets (if more than one option is provided).' => '',
        'Defines the default selection of the free key field number 11 for tickets (if more than one option is provided).' => '',
        'Defines the default selection of the free key field number 12 for tickets (if more than one option is provided).' => '',
        'Defines the default selection of the free key field number 13 for tickets (if more than one option is provided).' => '',
        'Defines the default selection of the free key field number 14 for tickets (if more than one option is provided).' => '',
        'Defines the default selection of the free key field number 15 for tickets (if more than one option is provided).' => '',
        'Defines the default selection of the free key field number 16 for tickets (if more than one option is provided).' => '',
        'Defines the default selection of the free key field number 2 for articles (if more than one option is provided).' => '',
        'Defines the default selection of the free key field number 2 for tickets (if more than one option is provided).' => '',
        'Defines the default selection of the free key field number 3 for articles (if more than one option is provided).' => '',
        'Defines the default selection of the free key field number 3 for tickets (if more than one option is provided).' => '',
        'Defines the default selection of the free key field number 4 for tickets (if more than one option is provided).' => '',
        'Defines the default selection of the free key field number 5 for tickets (if more than one option is provided).' => '',
        'Defines the default selection of the free key field number 6 for tickets (if more than one option is provided).' => '',
        'Defines the default selection of the free key field number 7 for tickets (if more than one option is provided).' => '',
        'Defines the default selection of the free key field number 8 for tickets (if more than one option is provided).' => '',
        'Defines the default selection of the free key field number 9 for tickets (if more than one option is provided).' => '',
        'Defines the default selection of the free text field number 1 for articles (if more than one option is provided).' => '',
        'Defines the default selection of the free text field number 1 for tickets (if more than one option is provided).' => '',
        'Defines the default selection of the free text field number 10 for tickets (if more than one option is provided).' => '',
        'Defines the default selection of the free text field number 11 for tickets (if more than one option is provided).' => '',
        'Defines the default selection of the free text field number 12 for tickets (if more than one option is provided).' => '',
        'Defines the default selection of the free text field number 13 for tickets (if more than one option is provided).' => '',
        'Defines the default selection of the free text field number 14 for tickets (if more than one option is provided).' => '',
        'Defines the default selection of the free text field number 15 for tickets (if more than one option is provided).' => '',
        'Defines the default selection of the free text field number 16 for tickets (if more than one option is provided).' => '',
        'Defines the default selection of the free text field number 2 for articles (if more than one option is provided).' => '',
        'Defines the default selection of the free text field number 2 for tickets (if more than one option is provided).' => '',
        'Defines the default selection of the free text field number 3 for articles (if more than one option is provided).' => '',
        'Defines the default selection of the free text field number 3 for tickets (if more than one option is provided).' => '',
        'Defines the default selection of the free text field number 4 for tickets (if more than one option is provided).' => '',
        'Defines the default selection of the free text field number 5 for tickets (if more than one option is provided).' => '',
        'Defines the default selection of the free text field number 6 for tickets (if more than one option is provided).' => '',
        'Defines the default selection of the free text field number 7 for tickets (if more than one option is provided).' => '',
        'Defines the default selection of the free text field number 8 for tickets (if more than one option is provided).' => '',
        'Defines the default selection of the free text field number 9 for tickets (if more than one option is provided).' => '',
        'Defines the default sender type for phone tickets in the ticket phone outbound screen of the agent interface.' => '',
        'Defines the default sender type for tickets in the ticket zoom screen of the customer interface.' => '',
        'Defines the default shown ticket search attribute for ticket search screen.' => '',
        'Defines the default sort criteria for all queues displayed in the queue view, after sort by priority is done.' => '',
        'Defines the default sort order for all queues in the queue view, after priority sort.' => '',
        'Defines the default spell checker dictionary.' => '',
        'Defines the default state of new customer tickets in the customer interface.' => '',
        'Defines the default state of new tickets.' => '',
        'Defines the default subject for phone tickets in the ticket phone outbound screen of the agent interface.' => '',
        'Defines the default subject of a note in the ticket free text screen of the agent interface.' => '',
        'Defines the default ticket attribute for ticket sorting in a ticket search of the customer interface.' => '',
        'Defines the default ticket attribute for ticket sorting in the escalation view of the agent interface.' => '',
        'Defines the default ticket attribute for ticket sorting in the locked ticket view of the agent interface.' => '',
        'Defines the default ticket attribute for ticket sorting in the responsible view of the agent interface.' => '',
        'Defines the default ticket attribute for ticket sorting in the status view of the agent interface.' => '',
        'Defines the default ticket attribute for ticket sorting in the watch view of the agent interface.' => '',
        'Defines the default ticket attribute for ticket sorting of the ticket search result of the agent interface.' => '',
        'Defines the default ticket bounced notification for customer/sender in the ticket bounce screen of the agent interface.' => '',
        'Defines the default ticket next state after adding a phone note in the ticket phone outbound screen of the agent interface.' => '',
        'Defines the default ticket order (after priority sort) in the escalation view of the agent interface. Up: oldest on top. Down: latest on top.' => '',
        'Defines the default ticket order (after priority sort) in the status view of the agent interface. Up: oldest on top. Down: latest on top.' => '',
        'Defines the default ticket order in the responsible view of the agent interface. Up: oldest on top. Down: latest on top.' => '',
        'Defines the default ticket order in the ticket locked view of the agent interface. Up: oldest on top. Down: latest on top.' => '',
        'Defines the default ticket order in the ticket search result of the agent interface. Up: oldest on top. Down: latest on top.' => '',
        'Defines the default ticket order in the watch view of the agent interface. Up: oldest on top. Down: latest on top.' => '',
        'Defines the default ticket order of a search result in the customer interface. Up: oldest on top. Down: latest on top.' => '',
        'Defines the default ticket priority in the close ticket screen of the agent interface.' => '',
        'Defines the default ticket priority in the ticket bulk screen of the agent interface.' => '',
        'Defines the default ticket priority in the ticket free text screen of the agent interface.' => '',
        'Defines the default ticket priority in the ticket note screen of the agent interface.' => '',
        'Defines the default ticket priority in the ticket owner screen of a zoomed ticket in the agent interface.' => '',
        'Defines the default ticket priority in the ticket pending screen of a zoomed ticket in the agent interface.' => '',
        'Defines the default ticket priority in the ticket priority screen of a zoomed ticket in the agent interface.' => '',
        'Defines the default ticket priority in the ticket responsible screen of the agent interface.' => '',
        'Defines the default type for article in the customer interface.' => '',
        'Defines the default type of forwarded message in the ticket forward screen of the agent interface.' => '',
        'Defines the default type of the note in the close ticket screen of the agent interface.' => '',
        'Defines the default type of the note in the ticket bulk screen of the agent interface.' => '',
        'Defines the default type of the note in the ticket free text screen of the agent interface.' => '',
        'Defines the default type of the note in the ticket note screen of the agent interface.' => '',
        'Defines the default type of the note in the ticket owner screen of a zoomed ticket in the agent interface.' => '',
        'Defines the default type of the note in the ticket pending screen of a zoomed ticket in the agent interface.' => '',
        'Defines the default type of the note in the ticket phone outbound screen of the agent interface.' => '',
        'Defines the default type of the note in the ticket priority screen of a zoomed ticket in the agent interface.' => '',
        'Defines the default type of the note in the ticket responsible screen of the agent interface.' => '',
        'Defines the default type of the note in the ticket zoom screen of the customer interface.' => '',
        'Defines the default used Frontend-Module if no Action parameter given in the url on the agent interface.' => '',
        'Defines the default used Frontend-Module if no Action parameter given in the url on the customer interface.' => '',
        'Defines the default value for the action parameter for the public frontend. The action parameter is used in the scripts of the system.' => '',
        'Defines the default viewable sender types of a ticket (default: customer).' => '',
        'Defines the difference from now (in seconds) of the free time field number 1\'s default value.' => '',
        'Defines the difference from now (in seconds) of the free time field number 2\'s default value.' => '',
        'Defines the difference from now (in seconds) of the free time field number 3\'s default value.' => '',
        'Defines the difference from now (in seconds) of the free time field number 4\'s default value.' => '',
        'Defines the difference from now (in seconds) of the free time field number 5\'s default value.' => '',
        'Defines the difference from now (in seconds) of the free time field number 6\'s default value.' => '',
        'Defines the filter that processes the text in the articles, in order to highlight URLs.' => '',
        'Defines the format of responses in the ticket compose screen of the agent interface ($QData{"OrigFrom"} is From 1:1, $QData{"OrigFromName"} is only realname of From).' => '',
        'Defines the free key field number 1 for articles to add a new article attribute.' => '',
        'Defines the free key field number 1 for tickets to add a new ticket attribute.' => '',
        'Defines the free key field number 10 for tickets to add a new ticket attribute.' => '',
        'Defines the free key field number 11 for tickets to add a new ticket attribute.' => '',
        'Defines the free key field number 12 for tickets to add a new ticket attribute.' => '',
        'Defines the free key field number 13 for tickets to add a new ticket attribute.' => '',
        'Defines the free key field number 14 for tickets to add a new ticket attribute.' => '',
        'Defines the free key field number 15 for tickets to add a new ticket attribute.' => '',
        'Defines the free key field number 16 for tickets to add a new ticket attribute.' => '',
        'Defines the free key field number 2 for articles to add a new article attribute.' => '',
        'Defines the free key field number 2 for tickets to add a new ticket attribute.' => '',
        'Defines the free key field number 3 for articles to add a new article attribute.' => '',
        'Defines the free key field number 3 for tickets to add a new ticket attribute.' => '',
        'Defines the free key field number 4 for tickets to add a new ticket attribute.' => '',
        'Defines the free key field number 5 for tickets to add a new ticket attribute.' => '',
        'Defines the free key field number 6 for tickets to add a new ticket attribute.' => '',
        'Defines the free key field number 7 for tickets to add a new ticket attribute.' => '',
        'Defines the free key field number 8 for tickets to add a new ticket attribute.' => '',
        'Defines the free key field number 9 for tickets to add a new ticket attribute.' => '',
        'Defines the free text field number 1 for articles to add a new article attribute.' => '',
        'Defines the free text field number 1 for tickets to add a new ticket attribute.' => '',
        'Defines the free text field number 10 for tickets to add a new ticket attribute.' => '',
        'Defines the free text field number 11 for tickets to add a new ticket attribute.' => '',
        'Defines the free text field number 12 for tickets to add a new ticket attribute.' => '',
        'Defines the free text field number 13 for tickets to add a new ticket attribute.' => '',
        'Defines the free text field number 14 for tickets to add a new ticket attribute.' => '',
        'Defines the free text field number 15 for tickets to add a new ticket attribute.' => '',
        'Defines the free text field number 16 for tickets to add a new ticket attribute.' => '',
        'Defines the free text field number 2 for articles to add a new article attribute.' => '',
        'Defines the free text field number 2 for tickets to add a new ticket attribute.' => '',
        'Defines the free text field number 3 for articles to add a new article attribute.' => '',
        'Defines the free text field number 3 for ticket to add a new ticket attribute.' => '',
        'Defines the free text field number 4 for tickets to add a new ticket attribute.' => '',
        'Defines the free text field number 5 for tickets to add a new ticket attribute.' => '',
        'Defines the free text field number 6 for tickets to add a new ticket attribute.' => '',
        'Defines the free text field number 7 for tickets to add a new ticket attribute.' => '',
        'Defines the free text field number 8 for tickets to add a new ticket attribute.' => '',
        'Defines the free text field number 9 for tickets to add a new ticket attribute.' => '',
        'Defines the free time key field number 1 for tickets.' => '',
        'Defines the free time key field number 2 for tickets.' => '',
        'Defines the free time key field number 3 for tickets.' => '',
        'Defines the free time key field number 4 for tickets.' => '',
        'Defines the free time key field number 5 for tickets.' => '',
        'Defines the free time key field number 6 for tickets.' => '',
        'Defines the fully qualified domain name of the system. This setting is used as a variable, OTRS_CONFIG_FQDN which is found in all forms of messaging used by the application, to build links to the tickets within your system.' => '',
        'Defines the groups every customer user will be in (if CustomerGroupSupport is enabled and you don\'t want to manage every user for these groups).' => '',
        'Defines the height of the legend.' => '',
        'Defines the history comment for the close ticket screen action, which gets used for ticket history in the agent interface.' => '',
        'Defines the history comment for the email ticket screen action, which gets used for ticket history in the agent interface.' => '',
        'Defines the history comment for the phone ticket screen action, which gets used for ticket history in the agent interface.' => '',
        'Defines the history comment for the ticket free text screen action, which gets used for ticket history.' => '',
        'Defines the history comment for the ticket note screen action, which gets used for ticket history in the agent interface.' => '',
        'Defines the history comment for the ticket owner screen action, which gets used for ticket history in the agent interface.' => '',
        'Defines the history comment for the ticket pending screen action, which gets used for ticket history in the agent interface.' => '',
        'Defines the history comment for the ticket phone outbound screen action, which gets used for ticket history in the agent interface.' => '',
        'Defines the history comment for the ticket priority screen action, which gets used for ticket history in the agent interface.' => '',
        'Defines the history comment for the ticket responsible screen action, which gets used for ticket history in the agent interface.' => '',
        'Defines the history comment for the ticket zoom action, which gets used for ticket history in the customer interface.' => '',
        'Defines the history type for the close ticket screen action, which gets used for ticket history in the agent interface.' => '',
        'Defines the history type for the email ticket screen action, which gets used for ticket history in the agent interface.' => '',
        'Defines the history type for the phone ticket screen action, which gets used for ticket history in the agent interface.' => '',
        'Defines the history type for the ticket free text screen action, which gets used for ticket history.' => '',
        'Defines the history type for the ticket note screen action, which gets used for ticket history in the agent interface.' => '',
        'Defines the history type for the ticket owner screen action, which gets used for ticket history in the agent interface.' => '',
        'Defines the history type for the ticket pending screen action, which gets used for ticket history in the agent interface.' => '',
        'Defines the history type for the ticket phone outbound screen action, which gets used for ticket history in the agent interface.' => '',
        'Defines the history type for the ticket priority screen action, which gets used for ticket history in the agent interface.' => '',
        'Defines the history type for the ticket responsible screen action, which gets used for ticket history in the agent interface.' => '',
        'Defines the history type for the ticket zoom action, which gets used for ticket history in the customer interface.' => '',
        'Defines the hours and week days of the calendar number 1, to count the working time.' => '',
        'Defines the hours and week days of the calendar number 2, to count the working time.' => '',
        'Defines the hours and week days of the calendar number 3, to count the working time.' => '',
        'Defines the hours and week days of the calendar number 4, to count the working time.' => '',
        'Defines the hours and week days of the calendar number 5, to count the working time.' => '',
        'Defines the hours and week days of the calendar number 6, to count the working time.' => '',
        'Defines the hours and week days of the calendar number 7, to count the working time.' => '',
        'Defines the hours and week days of the calendar number 8, to count the working time.' => '',
        'Defines the hours and week days of the calendar number 9, to count the working time.' => '',
        'Defines the hours and week days to count the working time.' => '',
        'Defines the http link for the free text field number 1 for tickets (it will be used in every ticket view).' => '',
        'Defines the http link for the free text field number 10 for tickets (it will be used in every ticket view).' => '',
        'Defines the http link for the free text field number 11 for tickets (it will be used in every ticket view).' => '',
        'Defines the http link for the free text field number 12 for tickets (it will be used in every ticket view).' => '',
        'Defines the http link for the free text field number 13 for tickets (it will be used in every ticket view).' => '',
        'Defines the http link for the free text field number 14 for tickets (it will be used in every ticket view).' => '',
        'Defines the http link for the free text field number 15 for tickets (it will be used in every ticket view).' => '',
        'Defines the http link for the free text field number 16 for tickets (it will be used in every ticket view).' => '',
        'Defines the http link for the free text field number 2 for tickets (it will be used in every ticket view).' => '',
        'Defines the http link for the free text field number 3 for tickets (it will be used in every ticket view).' => '',
        'Defines the http link for the free text field number 4 for tickets (it will be used in every ticket view).' => '',
        'Defines the http link for the free text field number 5 for tickets (it will be used in every ticket view).' => '',
        'Defines the http link for the free text field number 6 for tickets (it will be used in every ticket view).' => '',
        'Defines the http link for the free text field number 7 for tickets (it will be used in every ticket view).' => '',
        'Defines the http link for the free text field number 8 for tickets (it will be used in every ticket view).' => '',
        'Defines the http link for the free text field number 9 for tickets (it will be used in every ticket view).' => '',
        'Defines the key to be checked with Kernel::Modules::AgentInfo module. If this user preferences key is true, the message is accepted by the system.' => '',
        'Defines the key to check with CustomerAccept. If this user preferences key is true, then the message is accepted by the system.' => '',
        'Defines the link type \'Normal\'. If the source name and the target name contain the same value, the resulting link is a non-directional one; otherwise, the result is a directional link.' => '',
        'Defines the link type \'ParentChild\'. If the source name and the target name contain the same value, the resulting link is a non-directional one; otherwise, the result is a directional link.' => '',
        'Defines the link type groups. The link types of the same group cancel one another. Example: If ticket A is linked per a \'Normal\' link with ticket B, then these tickets could not be additionally linked with link of a \'ParentChild\' relationship.' => '',
        'Defines the list of online repositories. Another installations can be used as repository, for example: Key="http://example.com/otrs/public.pl?Action=PublicRepository;File=" and Content="Some Name".' => '',
        'Defines the location to get online repository list for additional packages. The first available result will be used.' => '',
        'Defines the log module for the system. "File" writes all messages in a given logfile, "SysLog" uses the syslog daemon of the system, e.g. syslogd.' => '',
        'Defines the maximal size (in bytes) for file uploads via the browser.' => '',
        'Defines the maximal valid time (in seconds) for a session id.' => '',
        'Defines the maximum number of pages per PDF file.' => '',
        'Defines the maximum size (in MB) of the log file.' => '',
        'Defines the module that shows all the currently loged in customers in the agent interface.' => '',
        'Defines the module that shows all the currently logged in agents in the agent interface.' => '',
        'Defines the module that shows the currently loged in agents in the customer interface.' => '',
        'Defines the module that shows the currently loged in customers in the customer interface.' => '',
        'Defines the module to authenticate customers.' => '',
        'Defines the module to display a notification in the agent interface, if the system is used by the admin user (normally you shouldn\'t work as admin).' => '',
        'Defines the module to generate html refresh headers of html sites, in the customer interface.' => '',
        'Defines the module to generate html refresh headers of html sites.' => '',
        'Defines the module to send emails. "Sendmail" directly uses the sendmail binary of your operating system. Any of the "SMTP" mechanisms use a specified (external) mailserver. "DoNotSendEmail" doesn\'t send emails and it is useful for test systems.' => '',
        'Defines the module used to store the session data. With "DB" the frontend server can be splitted from the db server. "FS" is faster.' => '',
        'Defines the name of the application, shown in the web interface, tabs and title bar of the web browser.' => '',
        'Defines the name of the calendar number 1.' => '',
        'Defines the name of the calendar number 2.' => '',
        'Defines the name of the calendar number 3.' => '',
        'Defines the name of the calendar number 4.' => '',
        'Defines the name of the calendar number 5.' => '',
        'Defines the name of the calendar number 6.' => '',
        'Defines the name of the calendar number 7.' => '',
        'Defines the name of the calendar number 8.' => '',
        'Defines the name of the calendar number 9.' => '',
        'Defines the name of the column to store the data in the preferences table.' => '',
        'Defines the name of the column to store the user identifier in the preferences table.' => '',
        'Defines the name of the key for customer sessions.' => '',
        'Defines the name of the session key. E.g. Session, SessionID or OTRS.' => '',
        'Defines the name of the table, where the customer preferences are stored.' => '',
        'Defines the next possible states after composing / answering a ticket in the ticket compose screen of the agent interface.' => '',
        'Defines the next possible states after forwarding a ticket in the ticket forward screen of the agent interface.' => '',
        'Defines the next possible states for customer tickets in the customer interface.' => '',
        'Defines the next state of a ticket after adding a note, in the close ticket screen of the agent interface.' => '',
        'Defines the next state of a ticket after adding a note, in the ticket bulk screen of the agent interface.' => '',
        'Defines the next state of a ticket after adding a note, in the ticket free text screen of the agent interface.' => '',
        'Defines the next state of a ticket after adding a note, in the ticket note screen of the agent interface.' => '',
        'Defines the next state of a ticket after adding a note, in the ticket owner screen of a zoomed ticket in the agent interface.' => '',
        'Defines the next state of a ticket after adding a note, in the ticket pending screen of a zoomed ticket in the agent interface.' => '',
        'Defines the next state of a ticket after adding a note, in the ticket priority screen of a zoomed ticket in the agent interface.' => '',
        'Defines the next state of a ticket after adding a note, in the ticket responsible screen of the agent interface.' => '',
        'Defines the next state of a ticket after being bounced, in the ticket bounce screen of the agent interface.' => '',
        'Defines the next state of a ticket after being moved to another queue, in the move ticket screen of the agent interface.' => '',
        'Defines the parameters for the customer preferences table.' => '',
        'Defines the parameters for the dashboard backend. "Group" is used to restrict access to the plugin (e. g. Group: admin;group1;group2;). "Default" indicates if the plugin is enabled by default or if the user needs to enable it manually. "CacheTTL" indicates the cache expiration period in minutes for the plugin.' => '',
        'Defines the parameters for the dashboard backend. "Group" is used to restrict access to the plugin (e. g. Group: admin;group1;group2;). "Default" indicates if the plugin is enabled by default or if the user needs to enable it manually. "CacheTTLLocal" defines the cache expiration period in minutes for the plugin.' => '',
        'Defines the parameters for the dashboard backend. "Limit" defines the number of entries displayed by default. "Group" is used to restrict access to the plugin (e. g. Group: admin;group1;group2;). "Default" indicates if the plugin is enabled by default or if the user needs to enable it manually. "CacheTTL" indicates the cache expiration period in minutes for the plugin.' => '',
        'Defines the parameters for the dashboard backend. "Limit" defines the number of entries displayed by default. "Group" is used to restrict access to the plugin (e. g. Group: admin;group1;group2;). "Default" indicates if the plugin is enabled by default or if the user needs to enable it manually. "CacheTTLLocal" defines the cache expiration period in minutes for the plugin.' => '',
        'Defines the password to access the SOAP handle (bin/cgi-bin/rpc.pl).' => '',
        'Defines the path and TTF-File to handle bold italic monospaced font in PDF documents.' => '',
        'Defines the path and TTF-File to handle bold italic proportional font in PDF documents.' => '',
        'Defines the path and TTF-File to handle bold monospaced font in PDF documents.' => '',
        'Defines the path and TTF-File to handle bold proportional font in PDF documents.' => '',
        'Defines the path and TTF-File to handle italic monospaced font in PDF documents.' => '',
        'Defines the path and TTF-File to handle italic proportional font in PDF documents.' => '',
        'Defines the path and TTF-File to handle monospaced font in PDF documents.' => '',
        'Defines the path and TTF-File to handle proportional font in PDF documents.' => '',
        'Defines the path of the shown info file, that is located under Kernel/Output/HTML/Standard/CustomerAccept.dtl.' => '',
        'Defines the path to PGP binary.' => '',
        'Defines the path to open ssl binary. It may need a HOME env ($ENV{HOME} = \'/var/lib/wwwrun\';).' => '',
        'Defines the placement of the legend. This should be a two letter key of the form: \'B[LCR]|R[TCB]\'. The first letter indicates the placement (Bottom or Right), and the second letter the alignment (Left, Right, Center, Top, or Bottom).' => '',
        'Defines the postmaster default queue.' => '',
        'Defines the receipent target of the phone ticket and the sender of the email ticket ("Queue" shows all queues, "SystemAddress" displays all system addresses) in the agent interface.' => '',
        'Defines the receipent target of the tickets ("Queue" shows all queues, "SystemAddress" displays all system addresses) in the customer interface.' => '',
        'Defines the search limit for the stats.' => '',
        'Defines the separator between the agents real name and the given queue email address.' => '',
        'Defines the spacing of the legends.' => '',
        'Defines the standard permissions available for customers within the application. If more permissions are needed, you can enter them here. Permissions must be hard coded to be effective. Please ensure, when adding any of the afore mentioned permissions, that the "rw" permission remains the last entry.' => '',
        'Defines the standard size of PDF pages.' => '',
        'Defines the state of a ticket if it gets a follow-up and the ticket was already closed.' => '',
        'Defines the state of a ticket if it gets a follow-up.' => '',
        'Defines the state type of the reminder for pending tickets.' => '',
        'Defines the subject for notification mails sent to agents, about new password.' => '',
        'Defines the subject for notification mails sent to agents, with token about new requested password.' => '',
        'Defines the subject for notification mails sent to customers, about new account.' => '',
        'Defines the subject for notification mails sent to customers, about new password.' => '',
        'Defines the subject for notification mails sent to customers, with token about new requested password.' => '',
        'Defines the subject for rejected emails.' => '',
        'Defines the system administrator\'s email address. It will be displayed in the error screens of the application.' => '',
        'Defines the system identifier. Every ticket number and http session string contain this ID. This ensures that only tickets which belong to your system will be processed as follow-ups (useful when communicating between two instances of OTRS).' => '',
        'Defines the target attribute in the link to external customer database. E.g. \'target="cdb"\'.' => '',
        'Defines the time zone of the calendar number 1, which can be assigned later to a specific queue.' => '',
        'Defines the time zone of the calendar number 2, which can be assigned later to a specific queue.' => '',
        'Defines the time zone of the calendar number 3, which can be assigned later to a specific queue.' => '',
        'Defines the time zone of the calendar number 4, which can be assigned later to a specific queue.' => '',
        'Defines the time zone of the calendar number 5, which can be assigned later to a specific queue.' => '',
        'Defines the time zone of the calendar number 6, which can be assigned later to a specific queue.' => '',
        'Defines the time zone of the calendar number 7, which can be assigned later to a specific queue.' => '',
        'Defines the time zone of the calendar number 8, which can be assigned later to a specific queue.' => '',
        'Defines the time zone of the calendar number 9, which can be assigned later to a specific queue.' => '',
        'Defines the type of protocol, used by ther web server, to serve the application. If https protocol will be used instead of plain http, it must be specified it here. Since this has no affect on the web server\'s settings or behavior, it will not change the method of access to the application and, if it is wrong, it will not prevent you from logging into the application. This setting is used as a variable, OTRS_CONFIG_HttpType which is found in all forms of messaging used by the application, to build links to the tickets within your system.' => '',
        'Defines the used character for email quotes in the ticket compose screen of the agent interface.' => '',
        'Defines the user identifier for the customer panel.' => '',
        'Defines the username to access the SOAP handle (bin/cgi-bin/rpc.pl).' => '',
        'Defines the valid state types for a ticket.' => '',
        'Defines the valid states for unlocked tickets. To unlock tickets the script "bin/otrs.UnlockTickets.pl" can be used.' => '',
        'Defines the viewable locks of a ticket. Default: unlock, tmp_lock.' => '',
        'Defines the width for the rich text editor component. Enter number (pixels) or percent value (relative).' => '',
        'Defines the width of the legend.' => '',
        'Defines the years (in future and in past) which can get selected in free time field number 1.' => '',
        'Defines the years (in future and in past) which can get selected in free time field number 2.' => '',
        'Defines the years (in future and in past) which can get selected in free time field number 3.' => '',
        'Defines the years (in future and in past) which can get selected in free time field number 4.' => '',
        'Defines the years (in future and in past) which can get selected in free time field number 5.' => '',
        'Defines the years (in future and in past) which can get selected in free time field number 6.' => '',
        'Defines whether the free time field number 1 is optional or not.' => '',
        'Defines whether the free time field number 2 is optional or not.' => '',
        'Defines whether the free time field number 3 is optional or not.' => '',
        'Defines whether the free time field number 4 is optional or not.' => '',
        'Defines whether the free time field number 5 is optional or not.' => '',
        'Defines whether the free time field number 6 is optional or not.' => '',
        'Defines which states should be set automatically (Content), after the pending time of state (Key) has been reached.' => '',
        'Delay time between autocomplete queries.' => '',
        'Deletes a session if the session id is used with an invalid remote IP address.' => '',
        'Deletes requested sessions if they have timed out.' => '',
        'Determines if the list of possible queues to move to ticket into should be displayed in a dropdown list or in a new window in the agent interface. If "New Window" is set you can add a move note to the ticket.' => '',
        'Determines if the search results container for the autocomplete feature should adjust its width dynamically.' => '',
        'Determines if the statatistics module may generate ticket lists.' => '',
        'Determines the next possible ticket states, after the creation of a new email ticket in the agent interface.' => '',
        'Determines the next possible ticket states, after the creation of a new phone ticket in the agent interface.' => '',
        'Determines the next screen after new customer ticket in the customer interface.' => '',
        'Determines the next screen after the follow up screen of a zoomed ticket in the customer interface.' => '',
        'Determines the possible states for pending tickets that changed state after reaching time limit.' => '',
        'Determines the strings that will be shown as receipent (To:) of the phone ticket and as sender (From:) of the email ticket in the agent interface. For Queue as NewQueueSelectionType "<Queue>" shows the names of the queues and for SystemAddress "<Realname> <<Email>>" shows the name and email of the receipent.' => '',
        'Determines the strings that will be shown as receipent (To:) of the ticket in the customer interface. For Queue as CustomerPanelSelectionType, "<Queue>" shows the names of the queues, and for SystemAddress, "<Realname> <<Email>>" shows the name and email of the receipent.' => '',
        'Determines the way the linked objects are displayed in each zoom mask.' => '',
        'Determines which options will be valid of the recepient (phone ticket) and the sender (email ticket) in the agent interface.' => '',
        'Determines which queues will be valid for ticket\'s recepients in the customer interface.' => '',
        'Disables sending reminder notifications to the responsible agent of a ticket (Ticket::Responsible needs to be activated).' => '',
        'Disables the web installer (http://yourhost.example.com/otrs/installer.pl), to prevent the system from being hijacked. If set to "No", the system can be reinstalled and the current basic configuration will be used to pre-populate the questions within the installer script. If not active, it also disables the GenericAgent, PackageManager and SQL Box (to avoid the use of destructive queries, such as DROP DATABASE, and also to steal user passwords).' => '',
        'Displays the accounted time for an article in the ticket zoom view.' => '',
        'Email Addresses' => 'Adresy e-mail',
        'Enables PDF output. The CPAN module PDF::API2 is required, if not installed, PDF output will be disabled.' => '',
        'Enables PGP support. When PGP support is enabled for signing and securing mail, it is HIGHLY recommended that the web server be run as the OTRS user. Otherwise, there will be problems with the privileges when accessing .gnupg folder.' => '',
        'Enables S/MIME support.' => '',
        'Enables customers to create their own accounts.' => '',
        'Enables file upload in the package manager frontend.' => '',
        'Enables or disable the debug mode over frontend interface.' => '',
        'Enables or disables the autocomplete feature for the customer search in the agent interface.' => '',
        'Enables or disables the ticket watcher feature, to keep track of tickets without being the owner nor the responsible.' => '',
        'Enables performance log (to log the page response time). It will affect the system performance. Frontend::Module###AdminPerformanceLog must be enabled.' => '',
        'Enables spell checker support.' => '',
        'Enables ticket bulk action feature for the agent frontend to work on more than one ticket at a time.' => '',
        'Enables ticket bulk action feature only for the listed groups.' => '',
        'Enables ticket responsible feature, to keep track of a specific ticket.' => '',
        'Enables ticket watcher feature only for the listed groups.' => '',
        'Escalation view' => 'Zgoszenia eskalowane',
        'Event module registration. For more performance you can define a trigger event (e. g. Event => TicketCreate). This is only possible if all TicketFreeField elements need the same event.' => '',
        'Example for free text' => '',
        'Execute SQL statements.' => 'Wykonaj polecenia SQL',
        'Executes follow up checks on In-Reply-To or References headers for mails that don\'t have a ticket number in the subject.' => '',
        'Executes follow up mail attachments checks in  mails that don\'t have a ticket number in the subject.' => '',
        'Executes follow up mail body checks in mails that don\'t have a ticket number in the subject.' => '',
        'Executes follow up plain/raw mail checks in mails that don\'t have a ticket number in the subject.' => '',
        'Experimental "Slim" skin which tries to save screen space for power users.' => '',
        'Exports the whole article tree in search result (it can affect the system performance).' => '',
        'Fetches packages via proxy. Overwrites "WebUserAgent::Proxy".' => '',
        'File that is displayed in the Kernel::Modules::AgentInfo module, if located under Kernel/Output/HTML/Standard/AgentInfo.dtl.' => '',
        'Filter incoming emails.' => '',
        'Forces encoding of outgoing emails (7bit|8bit|quoted-printable|base64).' => '',
        'Forces to choose a different ticket state (from current) after lock action. Define the current state as key, and the next state after lock action as content.' => '',
        'Forces to unlock tickets after being moved to another queue.' => '',
        'Frontend language' => 'Jzyk interfejsu',
        'Frontend module registration (disable company link if no company feature is used).' => '',
        'Frontend module registration for the agent interface.' => '',
        'Frontend module registration for the customer interface.' => '',
        'Frontend theme' => 'Schemat graficzny',
        'GenericAgent' => 'Agent automatyczny',
        'Gives end users the possibility to override the separator character for CSV files, defined in the translation files.' => '',
        'Grants access, if the customer ID of the ticket matches the customer user\'s ID and the customer user has group permissions on the queue the ticket is in.' => '',
        'Helps to extend your articles full-text search (From, To, Cc, Subject and Body search). Runtime will do full-text searches on live data (it works fine for up to 50.000 tickets). StaticDB will strip all articles and will build an index after article creation, increasing fulltext searches about 50%. To create an initial index use "bin/otrs.RebuildFulltextIndex.pl".' => '',
        'If "DB" was selected for Customer::AuthModule, a database driver (normally autodetection is used) can be specified.' => '',
        'If "DB" was selected for Customer::AuthModule, a password to connect to the customer table can be specified.' => '',
        'If "DB" was selected for Customer::AuthModule, a username to connect to the customer table can be specified.' => '',
        'If "DB" was selected for Customer::AuthModule, the DSN for the connection to the customer table must be specified.' => '',
        'If "DB" was selected for Customer::AuthModule, the column name for the CustomerPassword in the customer table must be specified.' => '',
        'If "DB" was selected for Customer::AuthModule, the crypt type of passwords must be specified.' => '',
        'If "DB" was selected for Customer::AuthModule, the name of the column for the CustomerKey in the customer table must be specified.' => '',
        'If "DB" was selected for Customer::AuthModule, the name of the table where your customer data should be stored must be specified.' => '',
        'If "DB" was selected for SessionModule, a column for the identifiers in session table must be specified.' => '',
        'If "DB" was selected for SessionModule, a column for the values in session table must be specified.' => '',
        'If "DB" was selected for SessionModule, a table in database where session data will be stored must be specified.' => '',
        'If "FS" was selected for SessionModule, a directory where the session data will be stored must be specified.' => '',
        'If "HTTPBasicAuth" was selected for Customer::AuthModule, you can specify (by using a RegExp) to strip parts of REMOTE_USER (e. g. for to remove trailing domains). RegExp-Note, $1 will be the new Login.' => '',
        'If "HTTPBasicAuth" was selected for Customer::AuthModule, you can specify to strip leading parts of user names (e. g. for domains like example_domain\user to user).' => '',
        'If "LDAP" was selected for Customer::AuthModule and if you want to add a suffix to every customer login name, specifiy it here, e. g. you just want to write the username user but in your LDAP directory exists user@domain.' => '',
        'If "LDAP" was selected for Customer::AuthModule and special paramaters are needed for the Net::LDAP perl module, you can specify them here. See "perldoc Net::LDAP" for more information about the parameters.' => '',
        'If "LDAP" was selected for Customer::AuthModule and your users have only anonymous access to the LDAP tree, but you want to search through the data, you can do this with a user who has access to the LDAP directory. Specify the password for this special user here.' => '',
        'If "LDAP" was selected for Customer::AuthModule and your users have only anonymous access to the LDAP tree, but you want to search through the data, you can do this with a user who has access to the LDAP directory. Specify the username for this special user here.' => '',
        'If "LDAP" was selected for Customer::AuthModule, the BaseDN must be specified.' => '',
        'If "LDAP" was selected for Customer::AuthModule, the LDAP host can be specified.' => '',
        'If "LDAP" was selected for Customer::AuthModule, the user identifier must be specified.' => '',
        'If "LDAP" was selected for Customer::AuthModule, user attributes can be specified. For LDAP posixGroups use UID, for non LDAP posixGroups use full user DN.' => '',
        'If "LDAP" was selected for Customer::AuthModule, you can specify access attributes here.' => '',
        'If "LDAP" was selected for Customer::AuthModule, you can specify if the applications will stop if e. g. a connection to a server can\'t be established due to network problems.' => '',
        'If "LDAP" was selected for Customer::Authmodule, you can check if the user is allowed to authenticate because he is in a posixGroup, e.g. user needs to be in a group xyz to use OTRS. Specify the group, who may access the system.' => '',
        'If "LDAP" was selected, you can add a filter to each LDAP query, e.g. (mail=*), (objectclass=user) or (!objectclass=computer).' => '',
        'If "Radius" was selected for Customer::AuthModule, the password to authenticate to the radius host must be specified.' => '',
        'If "Radius" was selected for Customer::AuthModule, the radius host must be specified.' => '',
        'If "Radius" was selected for Customer::AuthModule, you can specify if the applications will stop if e. g. a connection to a server can\'t be established due to network problems.' => '',
        'If "Sendmail" was selected as SendmailModule, the location of the sendmail binary and the needed options must be specified.' => '',
        'If "SysLog" was selected for LogModule, a special log facility can be specified.' => '',
        'If "SysLog" was selected for LogModule, a special log sock can be specified (on solaris you may need to use \'stream\').' => '',
        'If "SysLog" was selected for LogModule, the charset that should be used for logging can be specified.' => '',
        'If "file" was selected for LogModule, a logfile must be specified. If the file doesn\'t exist, it will be created by the system.' => '',
        'If a note is added by an agent, sets the state of a ticket in the close ticket screen of the agent interface.' => '',
        'If a note is added by an agent, sets the state of a ticket in the ticket bulk screen of the agent interface.' => '',
        'If a note is added by an agent, sets the state of a ticket in the ticket free text screen of the agent interface.' => '',
        'If a note is added by an agent, sets the state of a ticket in the ticket note screen of the agent interface.' => '',
        'If a note is added by an agent, sets the state of a ticket in the ticket responsible screen of the agent interface.' => '',
        'If a note is added by an agent, sets the state of the ticket in the ticket owner screen of a zoomed ticket in the agent interface.' => '',
        'If a note is added by an agent, sets the state of the ticket in the ticket pending screen of a zoomed ticket in the agent interface.' => '',
        'If a note is added by an agent, sets the state of the ticket in the ticket priority screen of a zoomed ticket in the agent interface.' => '',
        'If any of the "SMTP" mechanisms was selected as SendmailModule, and authentication to the mail server is needed, a password must be specified.' => '',
        'If any of the "SMTP" mechanisms was selected as SendmailModule, and authentication to the mail server is needed, an username must be specified.' => '',
        'If any of the "SMTP" mechanisms was selected as SendmailModule, the mailhost that sends out the mails must be specified.' => '',
        'If any of the "SMTP" mechanisms was selected as SendmailModule, the port where your mailserver is listening for incoming connections must be specified.' => '',
        'If configured, all emails sent by the application will contain an X-Header with this organization or company name.' => '',
        'If enabled, OTRS will deliver all CSS files in minified form. WARNING: If you turn this off, there will likely be problems in IE 7, because it cannot load more than 32 CSS files.' => '',
        'If enabled, OTRS will deliver all JavaScript files in minified form.' => '',
        'If enabled, TicketPhone and TicketEmail will be open in new windows.' => '',
        'If enabled, the OTRS version tag will be removed from the HTTP headers.' => '',
        'If enabled, the first level of the main menu opens on mouse hover (instead of click only).' => '',
        'If set, this address is used as envelope from header in outgoing notifications. If no address is specified, the envelope from header is empty.' => '',
        'If this regex matches, no message will be send by the autoresponder.' => '',
        'If you want to use a mirror database for agent ticket fulltext search or to generate stats, specify the DSN to this database.' => '',
        'If you want to use a mirror database for agent ticket fulltext search or to generate stats, the password to authenticate to this database can be specified.' => '',
        'If you want to use a mirror database for agent ticket fulltext search or to generate stats, the user to authenticate to this database can be specified.' => '',
        'Ignore article with system sender type for new article feature (e. g. auto responses or email notifications).' => '',
        'Includes article create times in the ticket search of the agent interface.' => '',
        'IndexAccelerator: to choose your backend TicketViewAccelerator module. "RuntimeDB" generates each queue view on the fly from ticket table (no performance problems up to approx. 60.000 tickets in total and 6.000 open tickets in the system). "StaticDB" is the most powerful module, it uses an extra ticket-index table that works like a view (recommended if more than 80.000 and 6.000 open tickets are stored in the system). Use the script "bin/otrs.RebuildTicketIndex.pl" for initial index update.' => '',
        'Install ispell or aspell on the system, if you want to use a spell checker. Please specify the path to the aspell or ispell binary on your operating system.' => '',
        'Interface language' => 'Jzyk interfejsu',
        'It is possible to configure different skins, for example to distinguish between diferent agents, to be used on a per-domain basis within the application. Using a regular expression (regex), you can configure a Key/Content pair to match a domain. The value in "Key" should match the domain, and the value in "Content" should be a valid skin on your system. Please see the example entries for the proper form of the regex.' => '',
        'It is possible to configure different skins, for example to distinguish between diferent customers, to be used on a per-domain basis within the application. Using a regular expression (regex), you can configure a Key/Content pair to match a domain. The value in "Key" should match the domain, and the value in "Content" should be a valid skin on your system. Please see the example entries for the proper form of the regex.' => '',
        'It is possible to configure different themes, for example to distinguish between agents and customers, to be used on a per-domain basis within the application. Using a regular expression (regex), you can configure a Key/Content pair to match a domain. The value in "Key" should match the domain, and the value in "Content" should be a valid theme on your system. Please see the example entries for the proper form of the regex.' => '',
        'Link agents to groups.' => 'Zarzdzanie relacjami Agenci <-> Grupy',
        'Link agents to roles.' => 'Zarzdzanie relacjami Agenci <-> Role',
        'Link attachments to responses templates.' => 'Poczenia zacznikw i standardowych odpowiedzi',
        'Link customers to groups.' => 'Poczenia klientw i grup klientw',
        'Link customers to services.' => 'Zarzdzanie relacjimi Klienci <-> Poziomy Serwisu',
        'Link queues to auto responses.' => '',
        'Link responses to queues.' => 'Zarzdzanie relacjami Odpowied <-> Kolejka',
        'Link roles to groups.' => '',
        'Link this ticket to other objects!' => '',
        'Links 2 tickets with a "Normal" type link.' => '',
        'Links 2 tickets with a "ParentChild" type link.' => '',
        'List of CSS files to always be loaded for the agent interface.' => '',
        'List of CSS files to always be loaded for the customer interface.' => '',
        'List of IE6-specific CSS files to always be loaded for the customer interface.' => '',
        'List of IE7-specific CSS files to always be loaded for the agent interface.' => '',
        'List of IE7-specific CSS files to always be loaded for the customer interface.' => '',
        'List of IE8-specific CSS files to always be loaded for the agent interface.' => '',
        'List of IE8-specific CSS files to always be loaded for the customer interface.' => '',
        'List of JS files to always be loaded for the agent interface.' => '',
        'List of JS files to always be loaded for the customer interface.' => '',
        'Log file for the ticket counter.' => '',
        'Makes the application check the MX record of email addresses before sending an email or submitting a telephone or email ticket.' => '',
        'Makes the application check the syntax of email addresses.' => '',
        'Makes the picture transparent.' => '',
        'Makes the session management use html cookies. If html cookies are disabled or if the client browser disabled html cookies, then the system will work as usual and append the session id to the links.' => '',
        'Manage PGP keys for email encryption.' => '',
        'Manage POP3 or IMAP accounts to fetch email from.' => 'Ustawienia konto pocztowych POP3 i IMAP, z ktrych pobierana jest poczta przychodzca do systemu',
        'Manage S/MIME certificates for email encryption.' => 'Zarzdzanie certyfikatami S/MIME sucymi do szyfrowania poczty wychodzcej',
        'Manage existing sessions.' => 'Zarzdzanie aktywnymi sesjami agentw i klientw',
        'Manage periodic tasks.' => 'Ustawienia automatycznych zada',
        'Max size (in characters) of the customer information table (phone and email) in the compose screen.' => '',
        'Max size of the subjects in an email reply.' => '',
        'Max. displayed tickets' => 'Maksymalna ilo wywietlanych zgosze',
        'Maximal auto email responses to own email-address a day (Loop-Protection).' => '',
        'Maximal size in KBytes for mails that can be fetched via POP3/POP3S/IMAP/IMAPS (KBytes).' => '',
        'Maximum number of tickets to be displayed in the result of a search in the agent interface.' => '',
        'Maximum number of tickets to be displayed in the result of a search in the customer interface.' => '',
        'Maximum size (in characters) of the customer info table in the queue view.' => '',
        'Maximum size (in characters) of the customer information table in the ticket zoom view.' => '',
        'Module for To-selection in new ticket screen in the customer interface.' => '',
        'Module to check customer permissions.' => '',
        'Module to check if a user is in a special group. Access is granted, if the user is in the specified group and has ro and rw permissions.' => '',
        'Module to check if arrived emails should be marked as email-internal (because of original forwared internal email it college). ArticleType and SenderType define the values for the arrived email/article.' => '',
        'Module to check the agent responsible of a ticket.' => '',
        'Module to check the group permissions for the access to customer tickets.' => '',
        'Module to check the owner of a ticket.' => '',
        'Module to check the watcher agents of a ticket.' => '',
        'Module to compose signed messages (PGP or S/MIME).' => '',
        'Module to crypt composed messages (PGP or S/MIME).' => '',
        'Module to filter and manipulate incoming messages. Block/ignore all spam email with From: noreply@ address.' => '',
        'Module to filter and manipulate incoming messages. Get a 4 digit number to ticket free text, use regex in Match e. g. From => \'(.+?)@.+?\', and use () as [***] in Set =>.' => '',
        'Module to generate accounted time ticket statistics.' => '',
        'Module to generate html OpenSearch profile for short ticket search in the agent interface.' => '',
        'Module to generate html OpenSearch profile for short ticket search in the customer interface.' => '',
        'Module to generate ticket solution and response time statistics.' => '',
        'Module to generate ticket statistics.' => '',
        'Module to inform agents, via the agent interface, about the used charset. A notification is displayed, if the default charset is not used, e.g. in tickets.' => '',
        'Module to show notifications and escalations (ShownMax: max. shown escalations, EscalationInMinutes: Show ticket which will escalation in, CacheTime: Cache of calculated escalations in seconds).' => '',
        'Module to use database filter storage.' => '',
        'My Tickets' => 'Moje zgoszenia',
        'Name of custom queue. The custom queue is a queue selection of your preferred queues and can be selected in the preferences settings.' => '',
        'New email ticket' => 'Nowe zgoszenie email',
        'New phone ticket' => 'Nowe zgoszenie telefoniczne',
        'Next possible ticket states after adding a phone note in the ticket phone outbound screen of the agent interface.' => '',
        'Notifications (Event)' => 'Powiadomienia o zdarzeniu',
        'Number of displayed tickets' => 'Liczba wywietlanych zgosze',
        'Number of lines (per ticket) that are shown by the search utility in the agent interface.' => '',
        'Number of tickets to be displayed in each page of a search result in the agent interface.' => '',
        'Number of tickets to be displayed in each page of a search result in the customer interface.' => '',
        'Overloads (redefines) existing functions in Kernel::System::Ticket. Used to easily add customizations.' => '',
        'Overview Escalated Tickets' => '',
        'Overview of all open Tickets.' => '',
        'PGP Key Upload' => 'Przelij klucz PGP',
        'Parameters for the CreateNextMask object in the preference view of the agent interface.' => '',
        'Parameters for the CustomQueue object in the preference view of the agent interface.' => '',
        'Parameters for the FollowUpNotify object in the preference view of the agent interface.' => '',
        'Parameters for the LockTimeoutNotify object in the preference view of the agent interface.' => '',
        'Parameters for the MoveNotify object in the preference view of the agent interface.' => '',
        'Parameters for the NewTicketNotify object in the preferences view of the agent interface.' => '',
        'Parameters for the RefreshTime object in the preference view of the agent interface.' => '',
        'Parameters for the WatcherNotify object in the preference view of the agent interface.' => '',
        'Parameters for the dashboard backend of the new tickets overview of the agent interface. "Limit" is the number of entries shown by default. "Group" is used to restrict the access to the plugin (e. g. Group: admin;group1;group2;). "Default" determines if the plugin is enabled by default or if the user needs to enable it manually. "CacheTTLLocal" is the cache time in minutes for the plugin.' => '',
        'Parameters for the dashboard backend of the ticket calendar of the agent interface. "Limit" is the number of entries shown by default. "Group" is used to restrict the access to the plugin (e. g. Group: admin;group1;group2;). "Default" determines if the plugin is enabled by default or if the user needs to enable it manually. "CacheTTLLocal" is the cache time in minutes for the plugin.' => '',
        'Parameters for the dashboard backend of the ticket escalation overview of the agent interface . "Limit" is the number of entries shown by default. "Group" is used to restrict the access to the plugin (e. g. Group: admin;group1;group2;). "Default" determines if the plugin is enabled by default or if the user needs to enable it manually. "CacheTTLLocal" is the cache time in minutes for the plugin.' => '',
        'Parameters for the dashboard backend of the ticket pending reminder overview of the agent interface . "Limit" is the number of entries shown by default. "Group" is used to restrict the access to the plugin (e. g. Group: admin;group1;group2;). "Default" determines if the plugin is enabled by default or if the user needs to enable it manually. "CacheTTLLocal" is the cache time in minutes for the plugin.' => '',
        'Parameters for the dashboard backend of the ticket pending reminder overview of the agent interface. "Limit" is the number of entries shown by default. "Group" is used to restrict the access to the plugin (e. g. Group: admin;group1;group2;). "Default" determines if the plugin is enabled by default or if the user needs to enable it manually. "CacheTTLLocal" is the cache time in minutes for the plugin.' => '',
        'Parameters for the dashboard backend of the ticket stats of the agent interface. "Limit" is the number of entries shown by default. "Group" is used to restrict the access to the plugin (e. g. Group: admin;group1;group2;). "Default" determines if the plugin is enabled by default or if the user needs to enable it manually. "CacheTTLLocal" is the cache time in minutes for the plugin.' => '',
        'Parameters for the pages (in which the tickets are shown) of the medium ticket overview.' => '',
        'Parameters for the pages (in which the tickets are shown) of the small ticket overview.' => '',
        'Parameters for the pages (in which the tickets are shown) of the ticket preview overview.' => '',
        'Parameters of the example SLA attribute Comment2.' => '',
        'Parameters of the example queue attribute Comment2.' => '',
        'Parameters of the example service attribute Comment2.' => '',
        'Path for the log file (it only applies if "FS" was selected for LoopProtectionModule and it is mandatory).' => '',
        'Path of the file that stores all the settings for the QueueObject object for the agent interface.' => '',
        'Path of the file that stores all the settings for the QueueObject object for the customer interface.' => '',
        'Path of the file that stores all the settings for the TicketObject for the agent interface.' => '',
        'Path of the file that stores all the settings for the TicketObject for the customer interface.' => '',
        'Permitted width for compose email windows.' => '',
        'Permitted width for compose note windows.' => '',
        'PostMaster Filters' => 'Filtrowanie poczty przychodzcej',
        'PostMaster Mail Accounts' => 'Konta pocztowe systemu',
        'Protection against CSRF (Cross Site Request Forgery) exploits (for more info see http://en.wikipedia.org/wiki/Cross-site_request_forgery).' => '',
        'Queue view' => 'Widok kolejek',
        'QueueView Refresh Time' => 'Interwa odwieania widoku kolejek',
        'Refresh interval' => 'Interwa odwieania',
        'Replaces the original sender with current customer\'s email address on compose answer in the ticket compose screen of the agent interface.' => '',
        'Required permissions to change the customer of a ticket in the agent interface.' => '',
        'Required permissions to use the close ticket screen in the agent interface.' => '',
        'Required permissions to use the ticket bounce screen in the agent interface.' => '',
        'Required permissions to use the ticket compose screen in the agent interface.' => '',
        'Required permissions to use the ticket forward screen in the agent interface.' => '',
        'Required permissions to use the ticket free text screen in the agent interface.' => '',
        'Required permissions to use the ticket merge screen of a zoomed ticket in the agent interface.' => '',
        'Required permissions to use the ticket note screen in the agent interface.' => '',
        'Required permissions to use the ticket owner screen of a zoomed ticket in the agent interface.' => '',
        'Required permissions to use the ticket pending screen of a zoomed ticket in the agent interface.' => '',
        'Required permissions to use the ticket phone outbound screen in the agent interface.' => '',
        'Required permissions to use the ticket priority screen of a zoomed ticket in the agent interface.' => '',
        'Required permissions to use the ticket responsible screen in the agent interface.' => '',
        'Resets and unlocks the owner of a ticket if it was moved to another queue.' => '',
        'Responses <-> Queues' => 'Odpowied <-> Kolejka',
        'Restores a ticket from the archive (only if the event is a state change, from closed to any open available state).' => '',
        'Roles <-> Groups' => 'Role <-> Grupy',
        'Runs an initial wildcard search of the existing customer users when accessing the AdminCustomerUser module.' => '',
        'Runs the system in "Demo" mode. If set to "Yes", agents can change preferences, such as selection of language and theme via the agent web interface. These changes are only valid for the current session. It will not be possible for agents to change their passwords.' => '',
        'S/MIME Certificate Upload' => '',
        'Saves the attachments of articles. "DB" stores all data in the database (not recommended for storing big attachments). "FS" stores the data on the filesystem; this is faster but the webserver should run under the OTRS user. You can switch between the modules even on a system that is already in production without any loss of data.' => '',
        'Saves the login and password on the session table in the database, if "DB" was selected for SessionModule.' => '',
        'Search backend default router.' => '',
        'Search backend router.' => '',
        'Select your frontend Theme.' => 'Wybierz schemat wygldu systemu.',
        'Selects the module to handle uploads via the web interface. "DB" stores all uploads in the database, "FS" uses the file system.' => '',
        'Selects the ticket number generator module. "AutoIncrement" increments the ticket number, the SystemID and the counter are used with SystemID.counter format (e.g. 1010138, 1010139). With "Date" the ticket numbers will be generated by the current date, the SystemID and the counter. The format looks like Year.Month.Day.SystemID.counter (e.g. 200206231010138, 200206231010139). With "DateChecksum"  the counter will be appended as checksum to the string of date and SystemID. The checksum will be rotated on a daily basis. The format looks like Year.Month.Day.SystemID.Counter.CheckSum (e.g. 2002070110101520, 2002070110101535). "Random" generates randomized ticket numbers in the format "SystemID.Random" (e.g. 100057866352, 103745394596).' => '',
        'Send me a notification if a customer sends a follow up and I\'m the owner of the ticket or the ticket is unlocked and is in one of my subscribed queues.' => 'Wylij mi wiadomo, gdy klient odpowie na zgoszenie, ktrego ja jestem wacicielem.',
        'Send notifications to users.' => 'Wylij powiadomienie do uytkownikw',
        'Send ticket follow up notifications' => 'Wysyaj powiadomienia o nowych wiadomociach w zgoszeniach',
        'Sender type for new tickets from the customer inteface.' => '',
        'Sends agent follow-up notification only to the owner, if a ticket is unlocked (the default is to send the notification to all agents).' => '',
        'Sends all outgoing email via bcc to the specified address. Please use this only for backup reasons.' => '',
        'Sends customer notifications just to the mapped customer. Normally, if no customer is mapped, the latest customer sender gets the notification.' => '',
        'Sends reminder notifications of unlocked ticket after reaching the reminder date (only sent to ticket owner).' => '',
        'Sends the notifications which are configured in the admin interface under "Notfication (Event)".' => '',
        'Set sender email addresses for this system.' => 'Ustaw adresa nadawcy dla tego systemu',
        'Set the default height (in pixels) of inline HTML articles in AgentTicketZoom.' => '',
        'Set the maximum height (in pixels) of inline HTML articles in AgentTicketZoom.' => '',
        'Set this to yes if you trust in all your public and private pgp keys, even if they are not certified with a trusted signature.' => '',
        'Sets if ticket owner must be selected by the agent.' => '',
        'Sets the PendingTime of a ticket to 0 if the state is changed to a non-pending state.' => '',
        'Sets the age in minutes (first level) for highlighting queues that contain untouched tickets.' => '',
        'Sets the age in minutes (second level) for highlighting queues that contain untouched tickets.' => '',
        'Sets the configuration level of the administrator. Depending on the config level, some sysconfig options will be not shown. The config levels are in in ascending order: Expert, Advanced, Beginner. The higher the config level is (e.g. Beginner is the highest), the less likely is it that the user can accidentally configure the system in a way that it is not usable any more.' => '',
        'Sets the default article type for new email tickets in the agent interface.' => '',
        'Sets the default article type for new phone tickets in the agent interface.' => '',
        'Sets the default body text for notes added in the close ticket screen of the agent interface.' => '',
        'Sets the default body text for notes added in the ticket move screen of the agent interface.' => '',
        'Sets the default body text for notes added in the ticket note screen of the agent interface.' => '',
        'Sets the default body text for notes added in the ticket owner screen of a zoomed ticket in the agent interface.' => '',
        'Sets the default body text for notes added in the ticket pending screen of a zoomed ticket in the agent interface.' => '',
        'Sets the default body text for notes added in the ticket priority screen of a zoomed ticket in the agent interface.' => '',
        'Sets the default body text for notes added in the ticket responsible screen of the agent interface.' => '',
        'Sets the default charset for the web interface to use (should represent the charset used to create the database or, in some cases, the database management system being used). "utf-8" is a good choice for environments expecting many charsets. You can specify another charset here (i.e. "iso-8859-1"). Please be sure that you will not be receiving foreign emails, or text, otherwise this could lead to problems.' => '',
        'Sets the default link type of splitted tickets in the agent interface.' => '',
        'Sets the default next state for new phone tickets in the agent interface.' => '',
        'Sets the default next ticket state, after the creation of an email ticket in the agent interface.' => '',
        'Sets the default note text for new telephone tickets. E.g \'New ticket via call\' in the agent interface.' => '',
        'Sets the default priority for new email tickets in the agent interface.' => '',
        'Sets the default priority for new phone tickets in the agent interface.' => '',
        'Sets the default sender type for new email tickets in the agent interface.' => '',
        'Sets the default sender type for new phone ticket in the agent interface.' => '',
        'Sets the default subject for new email tickets (e.g. \'email Outbound\') in the agent interface.' => '',
        'Sets the default subject for new phone tickets (e.g. \'Phone call\') in the agent interface.' => '',
        'Sets the default subject for notes added in the close ticket screen of the agent interface.' => '',
        'Sets the default subject for notes added in the ticket move screen of the agent interface.' => '',
        'Sets the default subject for notes added in the ticket note screen of the agent interface.' => '',
        'Sets the default subject for notes added in the ticket owner screen of a zoomed ticket in the agent interface.' => '',
        'Sets the default subject for notes added in the ticket pending screen of a zoomed ticket in the agent interface.' => '',
        'Sets the default subject for notes added in the ticket priority screen of a zoomed ticket in the agent interface.' => '',
        'Sets the default subject for notes added in the ticket responsible screen of the agent interface.' => '',
        'Sets the default text for new email tickets in the agent interface.' => '',
        'Sets the display order of the different items in the preferences view.' => '',
        'Sets the inactivity time (in seconds) to pass before a session is killed and a user is loged out.' => '',
        'Sets the minimal ticket counter size (if "AutoIncrement" was selected as TicketNumberGenerator). Default is 5, this means the counter starts from 10000.' => '',
        'Sets the minimum number of characters before autocomplete query is sent.' => '',
        'Sets the number of lines that are displayed in text messages (e.g. ticket lines in the QueueZoom).' => '',
        'Sets the number of lines that are displayed in the preview of messages (e.g. for tickets in the QueueView).' => '',
        'Sets the number of search results to be displayed for the autocomplete feature.' => '',
        'Sets the options for PGP binary.' => '',
        'Sets the order of the different items in the customer preferences view.' => '',
        'Sets the password for private PGP key.' => '',
        'Sets the prefered time units (e.g. work units, hours, minutes).' => '',
        'Sets the prefix to the scripts folder on the server, as configured on the web server. This setting is used as a variable, OTRS_CONFIG_ScriptAlias which is found in all forms of messaging used by the application, to build links to the tickets within the system.' => '',
        'Sets the responsible agent of the ticket in the close ticket screen of the agent interface.' => '',
        'Sets the responsible agent of the ticket in the ticket bulk screen of the agent interface.' => '',
        'Sets the responsible agent of the ticket in the ticket free text screen of the agent interface.' => '',
        'Sets the responsible agent of the ticket in the ticket note screen of the agent interface.' => '',
        'Sets the responsible agent of the ticket in the ticket owner screen of a zoomed ticket in the agent interface.' => '',
        'Sets the responsible agent of the ticket in the ticket pending screen of a zoomed ticket in the agent interface.' => '',
        'Sets the responsible agent of the ticket in the ticket priority screen of a zoomed ticket in the agent interface.' => '',
        'Sets the responsible agent of the ticket in the ticket responsible screen of the agent interface.' => '',
        'Sets the service in the close ticket screen of the agent interface (Ticket::Service needs to be activated).' => '',
        'Sets the service in the ticket free text screen of the agent interface (Ticket::Service needs to be activated).' => '',
        'Sets the service in the ticket note screen of the agent interface (Ticket::Service needs to be activated).' => '',
        'Sets the service in the ticket owner screen of a zoomed ticket in the agent interface (Ticket::Service needs to be activated).' => '',
        'Sets the service in the ticket pending screen of a zoomed ticket in the agent interface (Ticket::Service needs to be activated).' => '',
        'Sets the service in the ticket priority screen of a zoomed ticket in the agent interface (Ticket::Service needs to be activated).' => '',
        'Sets the service in the ticket responsible screen of the agent interface (Ticket::Service needs to be activated).' => '',
        'Sets the size of the statistic graph.' => '',
        'Sets the stats hook.' => '',
        'Sets the system time zone (required a system with UTC as system time). Otherwise this is a diff time to the local time.' => '',
        'Sets the ticket owner in the close ticket screen of the agent interface.' => '',
        'Sets the ticket owner in the ticket bulk screen of the agent interface.' => '',
        'Sets the ticket owner in the ticket free text screen of the agent interface.' => '',
        'Sets the ticket owner in the ticket note screen of the agent interface.' => '',
        'Sets the ticket owner in the ticket owner screen of a zoomed ticket in the agent interface.' => '',
        'Sets the ticket owner in the ticket pending screen of a zoomed ticket in the agent interface.' => '',
        'Sets the ticket owner in the ticket priority screen of a zoomed ticket in the agent interface.' => '',
        'Sets the ticket owner in the ticket responsible screen of the agent interface.' => '',
        'Sets the ticket type in the close ticket screen of the agent interface (Ticket::Type needs to be activated).' => '',
        'Sets the ticket type in the ticket free text screen of the agent interface (Ticket::Type needs to be activated).' => '',
        'Sets the ticket type in the ticket note screen of the agent interface (Ticket::Type needs to be activated).' => '',
        'Sets the ticket type in the ticket owner screen of a zoomed ticket in the agent interface (Ticket::Type needs to be activated).' => '',
        'Sets the ticket type in the ticket pending screen of a zoomed ticket in the agent interface (Ticket::Type needs to be activated).' => '',
        'Sets the ticket type in the ticket priority screen of a zoomed ticket in the agent interface (Ticket::Type needs to be activated).' => '',
        'Sets the ticket type in the ticket responsible screen of the agent interface (Ticket::Type needs to be activated).' => '',
        'Sets the time type which should be shown.' => '',
        'Sets the timeout (in seconds) for http/ftp downloads.' => '',
        'Sets the timeout (in seconds) for package downloads. Overwrites "WebUserAgent::Timeout".' => '',
        'Sets the user time zone per user (required a system with UTC as system time and UTC under TimeZone). Otherwise this is a diff time to the local time.' => '',
        'Sets the user time zone per user based on java script / browser time zone offset feature at login time.' => '',
        'Show a responsible selection in phone and email tickets in the agent interface.' => '',
        'Show article as rich text even if rich text writing is disabled.' => '',
        'Shows a count of icons in the ticket zoom, if the article has attachments.' => '',
        'Shows a link in the menu for subscribing / unsubscribing from a ticket in the ticket zoom view of the agent interface.' => '',
        'Shows a link in the menu that allows linking a ticket with another object in the ticket zoom view of the agent interface.' => '',
        'Shows a link in the menu that allows merging tickets in the ticket zoom view of the agent interface.' => '',
        'Shows a link in the menu to access the history of a ticket in the ticket zoom view of the agent interface.' => '',
        'Shows a link in the menu to add a free text field in the ticket zoom view of the agent interface.' => '',
        'Shows a link in the menu to add a note in the ticket zoom view of the agent interface.' => '',
        'Shows a link in the menu to add a note to a ticket in every ticket overview of the agent interface.' => '',
        'Shows a link in the menu to close a ticket in every ticket overview of the agent interface.' => '',
        'Shows a link in the menu to close a ticket in the ticket zoom view of the agent interface.' => '',
        'Shows a link in the menu to delete a ticket in every ticket overview of the agent interface. Additional access control to show or not show this link can be done by using Key "Group" and Content like "rw:group1;move_into:group2".' => '',
        'Shows a link in the menu to delete a ticket in the ticket zoom view of the agent interface. Additional access control to show or not show this link can be done by using Key "Group" and Content like "rw:group1;move_into:group2".' => '',
        'Shows a link in the menu to go back in the ticket zoom view of the agent interface.' => '',
        'Shows a link in the menu to lock / unlock a ticket in the ticket overviews of the agent interface.' => '',
        'Shows a link in the menu to lock/unlock tickets in the ticket zoom view of the agent interface.' => '',
        'Shows a link in the menu to move a ticket in every ticket overview of the agent interface.' => '',
        'Shows a link in the menu to print a ticket or an article in the ticket zoom view of the agent interface.' => '',
        'Shows a link in the menu to see the customer who requested the ticket in the ticket zoom view of the agent interface.' => '',
        'Shows a link in the menu to see the history of a ticket in every ticket overview of the agent interface.' => '',
        'Shows a link in the menu to see the owner of a ticket in the ticket zoom view of the agent interface.' => '',
        'Shows a link in the menu to see the priority of a ticket in the ticket zoom view of the agent interface.' => '',
        'Shows a link in the menu to see the responsible agent of a ticket in the ticket zoom view of the agent interface.' => '',
        'Shows a link in the menu to set a ticket as pending in the ticket zoom view of the agent interface.' => '',
        'Shows a link in the menu to set a ticket as spam in every ticket overview of the agent interface. Additional access control to show or not show this link can be done by using Key "Group" and Content like "rw:group1;move_into:group2".' => '',
        'Shows a link in the menu to set the priority of a ticket in every ticket overview of the agent interface.' => '',
        'Shows a link in the menu to zoom a ticket in the ticket overviews of the agent interface.' => '',
        'Shows a link to access article attachments via a html online viewer in the zoom view of the article in the agent interface.' => '',
        'Shows a link to download article attachments in the zoom view of the article in the agent interface.' => '',
        'Shows a link to see a zoomed email ticket in plain text.' => '',
        'Shows a link to set a ticket as spam in the ticket zoom view of the agent interface. Additional access control to show or not show this link can be done by using Key "Group" and Content like "rw:group1;move_into:group2".' => '',
        'Shows a list of all the involved agents on this ticket, in the close ticket screen of the agent interface.' => '',
        'Shows a list of all the involved agents on this ticket, in the ticket free text screen of the agent interface.' => '',
        'Shows a list of all the involved agents on this ticket, in the ticket note screen of the agent interface.' => '',
        'Shows a list of all the involved agents on this ticket, in the ticket owner screen of a zoomed ticket in the agent interface.' => '',
        'Shows a list of all the involved agents on this ticket, in the ticket pending screen of a zoomed ticket in the agent interface.' => '',
        'Shows a list of all the involved agents on this ticket, in the ticket priority screen of a zoomed ticket in the agent interface.' => '',
        'Shows a list of all the involved agents on this ticket, in the ticket responsible screen of the agent interface.' => '',
        'Shows a list of all the possible agents (all agents with note permissions on the queue/ticket) to determine who should be informed about this note, in the close ticket screen of the agent interface.' => '',
        'Shows a list of all the possible agents (all agents with note permissions on the queue/ticket) to determine who should be informed about this note, in the ticket free text screen of the agent interface.' => '',
        'Shows a list of all the possible agents (all agents with note permissions on the queue/ticket) to determine who should be informed about this note, in the ticket note screen of the agent interface.' => '',
        'Shows a list of all the possible agents (all agents with note permissions on the queue/ticket) to determine who should be informed about this note, in the ticket owner screen of a zoomed ticket in the agent interface.' => '',
        'Shows a list of all the possible agents (all agents with note permissions on the queue/ticket) to determine who should be informed about this note, in the ticket pending screen of a zoomed ticket in the agent interface.' => '',
        'Shows a list of all the possible agents (all agents with note permissions on the queue/ticket) to determine who should be informed about this note, in the ticket priority screen of a zoomed ticket in the agent interface.' => '',
        'Shows a list of all the possible agents (all agents with note permissions on the queue/ticket) to determine who should be informed about this note, in the ticket responsible screen of the agent interface.' => '',
        'Shows a preview of the ticket overview (CustomerInfo => 1 - shows also Customer-Info, CustomerInfoMaxSize max. size in characters of Customer-Info).' => '',
        'Shows all both ro and rw queues in the queue view.' => '',
        'Shows all open tickets (even if they are locked) in the escalation view of the agent interface.' => '',
        'Shows all open tickets (even if they are locked) in the status view of the agent interface.' => '',
        'Shows all the articles of the ticket (expanded) in the zoom view.' => '',
        'Shows all the customer identifiers in a multi-select field (not useful if you have a lot of customer identifiers).' => '',
        'Shows an owner selection in phone and email tickets in the agent interface.' => '',
        'Shows customer history tickets in AgentTicketPhone, AgentTicketEmail and AgentTicketCustomer.' => '',
        'Shows either the last customer article\'s subject or the ticket title in the small format overview.' => '',
        'Shows existing parent/child queue lists in the system in the form of a tree or a list.' => '',
        'Shows the activated ticket attributes in the customer interface (0 = Disabled and 1 = Enabled).' => '',
        'Shows the articles sorted normally or in reverse, under ticket zoom in the agent interface.' => '',
        'Shows the customer user information (phone and email) in the compose screen.' => '',
        'Shows the customer user\'s info in the ticket zoom view.' => '',
        'Shows the message of the day (MOTD) in the agent dashboard. "Group" is used to restrict access to the plugin (e. g. Group: admin;group1;group2;). "Default" indicates if the plugin is enabled by default or if the user needs to enable it manually.' => '',
        'Shows the message of the day on login screen of the agent interface.' => '',
        'Shows the ticket history (reverse ordered) in the agent interface.' => '',
        'Shows the ticket priority options in the close ticket screen of the agent interface.' => '',
        'Shows the ticket priority options in the move ticket screen of the agent interface.' => '',
        'Shows the ticket priority options in the ticket bulk screen of the agent interface.' => '',
        'Shows the ticket priority options in the ticket free text screen of the agent interface.' => '',
        'Shows the ticket priority options in the ticket note screen of the agent interface.' => '',
        'Shows the ticket priority options in the ticket owner screen of a zoomed ticket in the agent interface.' => '',
        'Shows the ticket priority options in the ticket pending screen of a zoomed ticket in the agent interface.' => '',
        'Shows the ticket priority options in the ticket priority screen of a zoomed ticket in the agent interface.' => '',
        'Shows the ticket priority options in the ticket responsible screen of the agent interface.' => '',
        'Shows the title fields in the close ticket screen of the agent interface.' => '',
        'Shows the title fields in the ticket free text screen of the agent interface.' => '',
        'Shows the title fields in the ticket note screen of the agent interface.' => '',
        'Shows the title fields in the ticket owner screen of a zoomed ticket in the agent interface.' => '',
        'Shows the title fields in the ticket pending screen of a zoomed ticket in the agent interface.' => '',
        'Shows the title fields in the ticket priority screen of a zoomed ticket in the agent interface.' => '',
        'Shows the title fields in the ticket responsible screen of the agent interface.' => '',
        'Shows time in long format (days, hours, minutes), if set to "Yes"; or in short format (days, hours), if set to "No".' => '',
        'Shows time use complete description (days, hours, minutes), if set to "Yes"; or just first letter (d, h, m), if set to "No".' => '',
        'Skin' => 'Skrka',
        'Sorts the tickets (ascendingly or descendingly) when a single queue is selected in the queue view and after the tickets are sorted by priority. Values: 0 = ascending (oldest on top, default), 1 = descending (youngest on top). Use the QueueID for the key and 0 or 1 for value.' => '',
        'Spam Assassin example setup. Ignores emails that are marked with SpamAssassin.' => '',
        'Spam Assassin example setup. Moves marked mails to spam queue.' => '',
        'Specifies if an agent should receive email notification of his own actions.' => '',
        'Specifies the background color of the chart.' => '',
        'Specifies the background color of the picture.' => '',
        'Specifies the border color of the chart.' => '',
        'Specifies the border color of the legend.' => '',
        'Specifies the bottom margin of the chart.' => '',
        'Specifies the different article types that will be used in the system.' => '',
        'Specifies the different note types that will be used in the system.' => '',
        'Specifies the directory to store the data in, if "FS" was selected for TicketStorageModule.' => '',
        'Specifies the directory where SSL certificates are stored.' => '',
        'Specifies the directory where private SSL certificates are stored.' => '',
        'Specifies the email address that should be used by the application when sending notifications. The email address is used to build the complete display name for the notification master (i.e. "OTRS Notification Master" otrs@your.example.com). You can use the OTRS_CONFIG_FQDN variable as set in your configuation, or choose another email address. Notifications are messages such as en::Customer::QueueUpdate or en::Agent::Move.' => '',
        'Specifies the left margin of the chart.' => '',
        'Specifies the name that should be used by the application when sending notifications. The sender name is used to build the complete display name for the notification master (i.e. "OTRS Notification Master" otrs@your.example.com). Notifications are messages such as en::Customer::QueueUpdate or en::Agent::Move.' => '',
        'Specifies the path of the file for the logo in the page header (gif|jpg|png, 700 x 100 pixel).' => '',
        'Specifies the path of the file for the performance log.' => '',
        'Specifies the path to the converter that allows the view of Microsoft Excel files, in the web interface.' => '',
        'Specifies the path to the converter that allows the view of Microsoft Word files, in the web interface.' => '',
        'Specifies the path to the converter that allows the view of PDF documents, in the web interface.' => '',
        'Specifies the path to the converter that allows the view of XML files, in the web interface.' => '',
        'Specifies the right margin of the chart.' => '',
        'Specifies the text color of the chart (e. g. caption).' => '',
        'Specifies the text color of the legend.' => '',
        'Specifies the text that should appear in the log file to denote a CGI script entry.' => '',
        'Specifies the top margin of the chart.' => '',
        'Specifies user id of the postmaster data base.' => '',
        'Standard available permissions for agents within the application. If more permissions are needed, they can be entered here. Permissions must be defined to be effective. Some other good permissions have also been provided built-in: note, close, pending, customer, freetext, move, compose, responsible, forward, and bounce. Make sure that "rw" is always the last registered permission.' => '',
        'Start number for statistics counting. Every new stat increments this number.' => '',
        'Statistics' => 'Statystyki',
        'Status view' => 'Widok statusw',
        'Stores cookies after the browser has been closed.' => '',
        'Strips empty lines on the ticket preview in the queue view.' => '',
        'The "bin/PostMasterMailAccount.pl" will reconnect to POP3/POP3S/IMAP/IMAPS host after the specified count of messages.' => '',
        'The agent skin\'s InternalName which should be used in the agent interface. Please check the available skins in Frontend::Agent::Skins.' => '',
        'The customer skin\'s InternalName which should be used in the customer interface. Please check the available skins in Frontend::Customer::Skins.' => '',
        'The divider between TicketHook and ticket number. E.g \': \'.' => '',
        'The format of the subject. \'Left\' means \'[TicketHook#:12345] Some Subject\', \'Right\' means \'Some Subject [TicketHook#:12345]\', \'None\' means \'Some Subject\' and no ticket number. In the last case you should enable PostmasterFollowupSearchInRaw or PostmasterFollowUpSearchInReferences to recognize followups based on email headers and/or body.' => '',
        'The headline shown in the customer interface.' => '',
        'The identifier for a ticket, e.g. Ticket#, Call#, MyTicket#. The default is Ticket#.' => '',
        'The logo shown in the header of the agent interface. The URL to the image must be a relative URL to the skin image directory.' => '',
        'The logo shown in the header of the customer interface. The URL to the image must be a relative URL to the skin image directory.' => '',
        'The logo shown on top of the login box of the agent interface. The URL to the image must be relative URL to the skin image directory.' => '',
        'The text at the beginning of the subject in an email reply, e.g. RE, AW, or AS.' => '',
        'The text at the beginning of the subject when an email is forwarded, e.g. FW, Fwd, or WG.' => '',
        'This module and its PreRun() function will be executed, if defined, for every request. This module is useful to check some user options or to display news about new applications.' => '',
        'Ticket free text options shown in the close ticket screen of the agent interface. Possible settings: 0 = Disabled, 1 = Enabled, 2 = Enabled and required.' => '',
        'Ticket free text options shown in the email ticket screen of the agent interface. Possible settings: 0 = Disabled, 1 = Enabled, 2 = Enabled and required.' => '',
        'Ticket free text options shown in the move ticket screen of the agent interface. Possible settings: 0 = Disabled, 1 = Enabled, 2 = Enabled and required.' => '',
        'Ticket free text options shown in the phone ticket screen of the agent interface. Possible settings: 0 = Disabled, 1 = Enabled, 2 = Enabled and required.' => '',
        'Ticket free text options shown in the ticket compose screen of the agent interface. Possible settings: 0 = Disabled, 1 = Enabled, 2 = Enabled and required.' => '',
        'Ticket free text options shown in the ticket forward screen of the agent interface. Possible settings: 0 = Disabled, 1 = Enabled, 2 = Enabled and required.' => '',
        'Ticket free text options shown in the ticket free text screen of the agent interface. Possible settings: 0 = Disabled, 1 = Enabled, 2 = Enabled and required.' => '',
        'Ticket free text options shown in the ticket message screen of the customer interface. Possible settings: 0 = Disabled, 1 = Enabled, 2 = Enabled and required. NOTE. If you want to display these fields also in the ticket zoom of the customer interface, you have to enable them in CustomerTicketZoom###AttributesView.' => '',
        'Ticket free text options shown in the ticket note screen of the agent interface. Possible settings: 0 = Disabled, 1 = Enabled, 2 = Enabled and required.' => '',
        'Ticket free text options shown in the ticket owner screen of a zoomed ticket in the agent interface. Possible settings: 0 = Disabled, 1 = Enabled, 2 = Enabled and required.' => '',
        'Ticket free text options shown in the ticket pending screen of a zoomed ticket in the agent interface. Possible settings: 0 = Disabled, 1 = Enabled, 2 = Enabled and required.' => '',
        'Ticket free text options shown in the ticket phone outbound screen of the agent interface. Possible settings: 0 = Disabled, 1 = Enabled, 2 = Enabled and required.' => '',
        'Ticket free text options shown in the ticket priority screen of a zoomed ticket in the agent interface. Possible settings: 0 = Disabled, 1 = Enabled, 2 = Enabled and required.' => '',
        'Ticket free text options shown in the ticket responsible screen of the agent interface. Possible settings: 0 = Disabled, 1 = Enabled, 2 = Enabled and required.' => '',
        'Ticket free text options shown in the ticket search of the agent interface. Possible settings: 0 = Disabled, 1 = Enabled, 2 = Enabled and required.' => '',
        'Ticket free text options shown in the ticket search screen in the customer interface. Possible settings: 0 = Disabled and 1 = Enabled.' => '',
        'Ticket free time options shown in the close ticket screen of the agent interface. Possible settings: 0 = Disabled, 1 = Enabled, 2 = Enabled and required.' => '',
        'Ticket free time options shown in the email ticket screen of the agent interface. Possible settings: 0 = Disabled, 1 = Enabled, 2 = Enabled and required.' => '',
        'Ticket free time options shown in the move ticket screen of the agent interface. Possible settings: 0 = Disabled, 1 = Enabled, 2 = Enabled and required.' => '',
        'Ticket free time options shown in the phone ticket screen of the agent interface. Possible settings: 0 = Disabled, 1 = Enabled, 2 = Enabled and required.' => '',
        'Ticket free time options shown in the ticket compose screen of the agent interface. Possible settings: 0 = Disabled, 1 = Enabled, 2 = Enabled and required.' => '',
        'Ticket free time options shown in the ticket forward screen of the agent interface. Possible settings: 0 = Disabled, 1 = Enabled, 2 = Enabled and required.' => '',
        'Ticket free time options shown in the ticket free text screen of the agent interface. Possible settings: 0 = Disabled, 1 = Enabled, 2 = Enabled and required.' => '',
        'Ticket free time options shown in the ticket message screen of the customer interface. Possible settings: 0 = Disabled, 1 = Enabled, 2 = Enabled and required. NOTE. If you want to display these fields also in the ticket zoom of the customer interface, you have to enable them in CustomerTicketZoom###AttributesView.' => '',
        'Ticket free time options shown in the ticket note screen of the agent interface. Possible settings: 0 = Disabled, 1 = Enabled, 2 = Enabled and required.' => '',
        'Ticket free time options shown in the ticket owner screen of a zoomed ticket in the agent interface. Possible settings: 0 = Disabled, 1 = Enabled, 2 = Enabled and required.' => '',
        'Ticket free time options shown in the ticket pending screen of a zoomed ticket in the agent interface. Possible settings: 0 = Disabled, 1 = Enabled, 2 = Enabled and required.' => '',
        'Ticket free time options shown in the ticket phone outbound screen of the agent interface. Possible settings: 0 = Disabled, 1 = Enabled, 2 = Enabled and required.' => '',
        'Ticket free time options shown in the ticket priority screen of a zoomed ticket in the agent interface. Possible settings: 0 = Disabled, 1 = Enabled, 2 = Enabled and required.' => '',
        'Ticket free time options shown in the ticket responsible screen of the agent interface. Possible settings: 0 = Disabled, 1 = Enabled, 2 = Enabled and required.' => '',
        'Ticket free time options shown in the ticket search of the agent interface. Possible settings: 0 = Disabled, 1 = Enabled.' => '',
        'Ticket free time options shown in the ticket search screen in the customer interface. Possible settings: 0 = Disabled and 1 = Enabled.' => '',
        'Ticket overview' => 'Lista zgosze',
        'Tickets' => 'Zgoszenia',
        'Time in seconds that gets added to the actual time if setting a pending-state (default: 86400 = 1 day).' => '',
        'Toolbar Item for a shortcut.' => '',
        'Turns on the animations used in the GUI. If you have problems with these animations (e.g. performance issues), you can turn them off here.' => '',
        'Turns on the remote ip address check. It should be set to "No" if the application is used, for example, via a proxy farm or a dialup connection, because the remote ip address is mostly different for the requests.' => '',
        'Types' => 'Typy zgosze',
        'Update Ticket "Seen" flag if every article got seen or a new Article got created.' => '',
        'Update and extend your system with software packages.' => '',
        'Updates the ticket escalation index after a ticket attribute got updated.' => '',
        'Updates the ticket index accelerator.' => '',
        'Uses Cc recipients in reply Cc list on compose an email answer in the ticket compose screen of the agent interface.' => '',
        'Uses richtext for viewing and editing: articles, salutations, signatures, standard responses, auto responses and notifications.' => '',
        'View performance benchmark results.' => 'Objerzyj wyniki testw wydajnoci systemu',
        'View system log messages.' => 'Podgld dziennika zdarze systemowych',
        'Wear this frontend skin' => 'Uyj wybranej skrki interfejsu',
        'When tickets are merged, a note will be added automatically to the ticket which is no longer active. In this text area you can define this text (This text cannot be changed by the agent).' => '',
        'When tickets are merged, the customer can be informed per email by setting the check box "Inform Sender". In this text area, you can define a pre-formatted text which can later be modified by the agents.' => '',
        'Your language' => 'Wybierz swj jzyk',
        'New Year\'s Day' => '',
        'International Workers\' Day' => '',
        'Christmas Eve' => '',
        'First Christmas Day' => '',
        'Second Christmas Day' => '',
        'New Year\'s Eve' => '',

        #
        # OBSOLETE ENTRIES FOR REFERENCE, DO NOT TRANSLATE!
        #
        '"}' => '"}',
        '%s Tickets affected! Do you really want to use this job?' => '%s zgosze dotyczy! Chcesz wykona zadanie?',
        '(Checks MX recordes of used email addresses by composing an answer. Don\'t use CheckMXRecord if your OTRS machine is behinde a dial-up line $!)' => '(Sprawd rekord MX uzytego adresu e-mailprzy tworzeniu odpowiedzi. Nie uywaj sprawdzania rekordu MX jeeli twoja maszyna z OTRS jest na aczu z dynamicznym IP $!)',
        '(Email of the system admin)' => '(Adres E-Mail Administratora Systemu)',
        '(Full qualified domain name of your system)' => '(Pena nazwa domeny Twojego systemu FQDN)',
        '(Logfile just needed for File-LogModule!)' => '(Logfile jest potrzebny jedynie dla moduu File-Log!)',
        '(Note: It depends on your installation how many dynamic objects you can use)' => '(Uwaga: Od instalacji zaley ile obiektw dynamicznych moesz uy)',
        '(Note: Useful for big databases and low performance server)' => '(Uwaga: Uyteczne dla duzych baz i wolnych serwerw)',
        '(The identify of the system. Each ticket number and each http session id starts with this number)' => '(Identyfikator systemu. Wszystkie zgoszenia oraz sesje http bd zaczynay si od tego cigu)',
        '(Ticket identifier. Some people want toset this to e. g. \'Ticket#\', \'Call#\' or \'MyTicket#\')' => '(Identyfikator zgoszenia. np. \'Ticket#\', \'Call#\' lub \'MyTicket#\')',
        '(Used default language)' => '(Domylny jzyk)',
        '(Used log backend)' => '(Uywany log backend)',
        '(Used ticket number format)' => '(Uywany format numerowania zgosze)',
        'A article should have a title!' => 'Artyku musi miec tytu!',
        'A message must be spell checked!' => 'Wiadomo musi zosta sprawdzona sownikiem!',
        'A message should have a To: recipient!' => 'Wiadomo musi zawiera wypenione adresem polu Do: (odbiorca)!',
        'A message should have a body!' => 'Wiadomo powinna zawiera jak tre!',
        'A message should have a customer!' => 'Naley wskaza klienta!',
        'A message should have a subject!' => 'Wiadomosc powinna posiada temat!',
        'A required field is:' => 'Wymagane pole to:',
        'A ticket should be associated with a queue!' => 'Zgoszenie musi zosta powizanie z kolejk',
        'A web calendar' => 'Kalendarz',
        'A web file manager' => 'Meneder plikw przez www ',
        'A web mail client' => 'Klient poczty przez www',
        'About OTRS' => 'O OTRS',
        'Absolut Period' => 'Bezwzgldny przedzia',
        'Add Customer User' => 'Dodaj klienta',
        'Add System Address' => 'Dodaj adres systemowy',
        'Add User' => 'Dodaj agenta',
        'Add a new Agent.' => 'Dodaj nowego agenta',
        'Add a new Customer Company.' => 'Dodaj now firm',
        'Add a new Group.' => 'Dodaj now grup',
        'Add a new Priority.' => 'Dodaj nowy priorytet',
        'Add a new Role.' => 'Dodaj now rol',
        'Add a new SLA.' => 'Dodaj now SLA',
        'Add a new Salutation.' => 'Dodaj nowy zwrot grzecznociowy',
        'Add a new Service.' => 'Dodaj now usug',
        'Add a new Signature.' => 'Dodaj nowy podpis',
        'Add a new State.' => 'Dodaj nowy status',
        'Add a new System Address.' => 'Dodaj nowy adres systemowy',
        'Add a new Type.' => 'Dodaj nowy typ',
        'Add a new salutation' => 'Dodaj zwrot',
        'Add new attachment' => 'Dodaj nowy zacznik',
        'Add note to ticket' => 'Dodaj notatk do zgoszenia',
        'Added User "%s"' => 'Dodano uytkownika "%s"',
        'Admin-Area' => 'Administracja',
        'Admin-Email' => 'Wiadomo od Administratora',
        'Admin-Password' => 'Haso administratora',
        'Admin-User' => 'Administrator',
        'Agent Mailbox' => 'Poczta',
        'Agent Preferences' => 'Ustawienia agenta',
        'Agent-Area' => 'Obsuga',
        'All Agents' => 'Wszyscy agenci',
        'All Customer variables like defined in config option CustomerUser.' => 'Wszystkie zdefiniowane zmienne klienta.',
        'All customer tickets.' => 'Wszystkie zgoszenia klienta',
        'All email addresses get excluded on replaying on composing an email.' => 'Wszystkie adresy e-mail zostan wykluczone z odpowiedzi.',
        'All email addresses get excluded on replaying on composing and email.' => 'Wszystkie adresy zostan pominite przy odpowiedzi, tworzeniu i wysyaniu wiadomoci.',
        'All incoming emails with this "Email" (To:) will be dispatched in the selected queue!' => 'Wszystkie wiadomoci przysane na ten adres w polu (Do:) zostan umieszczone w tej kolejce.',
        'All messages' => 'Wszystkie wiadomoci',
        'All new tickets!' => 'Wszystkie nowe zgoszenia!',
        'All tickets where the reminder date has reached!' => 'Wszystkie zgoszenia z przekroczonym terminem przypomnienia!',
        'All tickets which are escalated!' => 'Wszystkie eskalowane zgoszenia!',
        'Allocate CustomerUser to service' => 'Przypisz klienta do usugi',
        'Allocate services to CustomerUser' => 'Przypisz usugi do klienta',
        'Answer' => 'Odpowied',
        'Article Create Times' => 'Czasy utworzenia wiadomoci',
        'Article created' => 'Wiadomo utworzona',
        'Article created between' => 'Wiadomo utworzona pomidzy',
        'Article filter settings' => 'Ustawienie filtra artykuw',
        'ArticleID' => 'ID Artykuu',
        'Attach' => 'Wstaw',
        'Attribute' => 'Atrybut',
        'Auto Response From' => 'Automatyczna odpowied Od',
        'Bounce ticket' => 'Przeka zgoszenie',
        'Bulk-Action' => 'Akcja grupowa',
        'Can not create link with %s!' => 'Nie poczono z %s!',
        'Can not delete link with %s!' => 'Nie mona usun powizania z %s',
        'Can\'t update password, invalid characters!' => 'Nie mona zmieni hasa, niedozwolone znaki!',
        'Can\'t update password, need 2 lower and 2 upper characters!' => 'Nie mona zmieni hasa, wymagane 2 mae i 2 wielkie litery!',
        'Can\'t update password, need min. 1 digit!' => 'Nie mona zmieni hasa, wymagana conajmniej 1 cyfra!',
        'Can\'t update password, need min. 2 characters!' => 'Nie mona zmieni hasa, wymagane conajmniej 2 znaki!',
        'Can\'t update password, need min. 8 characters!' => 'Nie mona zmieni hasa, wymagane conajmniej 8 znakw!',
        'Can\'t update password, passwords doesn\'t match! Please try it again!' => 'Nie mona zmieni hasa, podano rne hasa! Sprbuj ponownie!',
        'Category Tree' => 'Drzewo kategorii',
        'Change %s settings' => 'Zmie %s ustawienia',
        'Change Times' => 'Zmie czasy',
        'Change free text of ticket' => 'Dodaj lub zmie dodatkowe informacje o zgoszeniu',
        'Change owner of ticket' => 'Zmie waciciela zgoszenia',
        'Change priority of ticket' => 'Zmie priorytet zgoszenia',
        'Change responsible of ticket' => 'Zmie odpowiedzialnego za zgoszenie',
        'Change user <-> group settings' => 'Zmie uytkownika <-> Ustawienia grupy',
        'ChangeLog' => 'Lista zmian',
        'Child-Object' => 'Obiekt potomny',
        'Clear From' => 'Wyczy pole Od:',
        'Clear To' => 'Wyczy do',
        'Click here to report a bug!' => 'Kliknij tutaj, by zgosi bd systemu OTRS!',
        'Close Times' => 'Czasy zamknicia',
        'Close ticket' => 'Zamknij zgoszenie',
        'Close type' => 'Typ zamknicia',
        'Close!' => 'Zamknij!',
        'Collapse View' => 'Zwi widok',
        'Comment (internal)' => 'Komentarz (wewntrzny)',
        'CompanyTickets' => 'Zgoszenia firmy',
        'Compose Answer' => 'Napisz odpowied',
        'Compose Email' => 'Nowa wiadomo',
        'Compose Follow up' => 'Napisz Odpowied (Follow Up)',
        'Config Options' => 'Opcje konfiguracyjne',
        'Config options (e. g. &lt;OTRS_CONFIG_HttpType&gt;)' => 'Parametry konfiguracyjne (np. &lt;OTRS_CONFIG_HttpType&gt;)',
        'Config options (e. g. <OTRS_CONFIG_HttpType>)' => 'Opcje konfiguracyjne (np. <OTRS_CONFIG_HttpType>)',
        'Config options (e. g. <OTRS_CONFIG_HttpType>).' => 'Wasnoci systemu (np. <OTRS_CONFIG_HttpType>).',
        'Contact customer' => 'Skontaktuj si z klientem',
        'Create New Template' => 'Stwrz nowy szablon wyszukiwania',
        'Create Times' => 'Czasy utworzenia',
        'Create new Phone Ticket' => 'Utwrz zgoszenie telefoniczne',
        'Create new database' => 'Stwrz now baz danych',
        'Create new groups to handle access permissions for different groups of agent (e. g. purchasing department, support department, sales department, ...).' => 'Stwrz nowe grupy, by mc efektywniej zarzdza dostpem do zgosze rnych grup ow (np. Serwisu, Sprzeday itp...).',
        'Create your first Ticket' => 'Utwrz pierwsze zgoszenie',
        'Customer Move Notify' => 'Powiadomienie klienta o przesuniciu',
        'Customer Owner Notify' => 'Powiadomienie klienta o zmianie waciciela',
        'Customer State Notify' => 'Powiadomienie klienta o zmianie statusu',
        'Customer User' => 'Klienci',
        'Customer User Management' => 'Zarzadzanie klientami',
        'Customer Users' => 'Klienci',
        'Customer Users <-> Groups' => 'Klienci <-> Grupy',
        'Customer Users <-> Groups Management' => 'Klienci <-> Grupy',
        'Customer Users <-> Services' => 'Klienci <-> Usugi',
        'Customer Users <-> Services Management' => 'Klienci <-> Usugi',
        'Customer history' => 'Historia klienta',
        'Customer history search' => 'Przeszukiwanie historii klienta',
        'Customer history search (e. g. "ID342425").' => 'Przeszukiwanie historii klienta (np. "ID342425").',
        'Customer user will be needed to have a customer history and to login via customer panel.' => 'Klient jest wymagany aby obejrze histori i zalogowa si do panelu.',
        'CustomerUser' => 'Klient',
        'DB Admin Password' => 'Haso Administratora bazy danych',
        'DB Admin User' => 'Uytkownik administrujcy baz danych',
        'DB Host' => 'Host bazy danych',
        'DB Type' => 'Typ bazy danych',
        'DB connect host' => 'komputer bazy danych',
        'Default' => 'Domyslne',
        'Default Charset' => 'Domylne kodowanie',
        'Default Language' => 'Domylny jzyk',
        'Delete old database' => 'Usu star baz danych',
        'Detail' => 'Szczeg',
        'Diff' => 'Rnica',
        'Discard all changes and return to the compose screen' => 'Anuluj wszystkie zmiany i powr do ekranu edycji',
        'Do dispatch or filter incoming emails based on email X-Headers! RegExp is also possible.' => 'Dostarcz lub filtruj przychodzce wiadomoci w oparciu o nagwki X-Headers! Wyraenia regularne (RegExp) take mog by uyte.',
        'Do you really want to delete this Object?' => 'Na pewno chcesz usun ten obiekt?',
        'Do you really want to reinstall this package (all manual changes get lost)?' => 'Czy chcesz przeinstalowa pakiet (wszystkie zmiany rczne zostan utracone)?',
        'Don\'t forget to add a new user to groups and/or roles!' => 'Nie zapomnij doda uytkownika do grup i/lub rl!',
        'Don\'t forget to add a new user to groups!' => 'Nie zapomnij doda uytkownika do grup!',
        'Download Settings' => 'Pobierz ustawienia',
        'Download all system config changes.' => 'Pobierz wszystkie ustawienia systemowe.',
        'Drop Database' => 'Usu baz danych',
        'Dynamic-Object' => 'Obiekt dynamiczny',
        'Edit Article' => 'Edytuj artyku',
        'Edit Customers' => 'Edytuj klientw',
        'Edit default services.' => 'Edycja domylnych usug.',
        'Escalation - First Response Time' => 'Eskalacja - czas pierwszej odpowiedzi',
        'Escalation - Solution Time' => 'Eskalacja - czas rozwizania',
        'Escalation - Update Time' => 'Eskalacja - czas aktualizacji',
        'Escalation time' => 'Czas eskalacji',
        'Expand View' => 'Rozwi widok',
        'Explanation' => 'Wyjanienie',
        'Export Config' => 'Eksportuj Config',
        'FileManager' => 'Meneder plikw',
        'Filelist' => 'Lista plikw',
        'Filter for Language' => 'Filtr jzyka',
        'Filtername' => 'Nazwa filtra',
        'Follow up' => 'Odpowiedz',
        'Follow up notification' => 'Powiadomienie o odpowiedzi',
        'For very complex stats it is possible to include a hardcoded file.' => 'Dla bardzo skomplikowanych statystyk mona uy pliku prekompilowanego.',
        'Foward ticket: ' => 'Przelij zgoszenie dalej',
        'Frontend' => 'Interfejs',
        'Fulltext-Search in Article (e. g. "Mar*in" or "Baue*")' => 'Przeszukiwanie penotekstowe w artykule (np. "Ja*k" lub "Rumia*)',
        'Go' => 'Start',
        'Group Ro' => 'Grupa ro',
        'Group selection' => 'Wybierz grup',
        'Hash' => 'Skrt (hash)',
        'Have a lot of fun!' => 'yczymy dobrej zabawy!',
        'Help' => 'Pomoc',
        'Here you can define the value series. You have the possibility to select one or two elements. Then you can select the attributes of elements. Each attribute will be shown as single value series. If you don\'t select any attribute all attributes of the element will be used if you generate a stat. As well a new attribute is added since the last configuration.' => 'Tu mozesz zdefiniowac wartoci. Moesz wybra jeden lub dwa elementy. Potemmozesz wybrac atrybuty elementw. Kady atrybut zostanie pokazany jako seria wartoci. Jezeli nie wybierzesz adnego z atrybutw elementu wszystkie zostana uyte przy generowaniu raportu. Tak samo jak nowe atrybuty dodane po ostatniej konfiguracji szablonu.',
        'Here you can define the x-axis. You can select one element via the radio button. Then you you have to select two or more attributes of the element. If you make no selection all attributes of the element will be used if you generate a stat. As well a new attribute is added since the last configuration.' => 'Tu moesz zdefiniowac o X. Moesz wybra jeden element ze zdefiniowanych. Nastpnie musisz wybra dwa lub wicej atrybutw wskazanego elementu. Jeeli nie wybrae wszystkich atrybutw elementu uyte one zostan przy generowaniu raportu. Tak samo jak nowe atrybuty dodane od ostatniej konfiguracji.',
        'Here you can insert a description of the stat.' => 'Tu moesz doda opis startstyki.',
        'Here you can select the dynamic object you want to use.' => 'Tu moesz wybra obiekt dynamiczny ktrego chcesz uy.',
        'Home' => 'Pocztek',
        'If a new hardcoded file is available this attribute will be shown and you can select one.' => 'Jeeli nowy plik prekompilowany bedzie dostepny, ten atrybut zostanie wywietlony i bedziesz mg wybra jeden.',
        'If a ticket is closed and the customer sends a follow up the ticket will be locked for the old owner.' => 'Jeli zgoszenie byo zamknite, a klient przyle do niego kolejn odpowied, wtedy zgoszenie zostanie zablokowane w kolejce starego waciciela.',
        'If a ticket will not be answered in this time, just only this ticket will be shown.' => 'Jeli, w podanym czasie, nie zostanie udzielona odpowied na zgoszenie, wtedy tylko to zgoszenie bdzie widoczne w kolejce.',
        'If an agent locks a ticket and he/she will not send an answer within this time, the ticket will be unlock automatically. So the ticket is viewable for all other agents.' => 'Jeli agent zablokuje zgoszenie, a nastpnie nie odpowie na nie w cigu wskazanego czasu, wtedy zgoszenie zostanie automatycznie odblokowane. Dziki temu pozostali agenci bd mogli je zobaczy.',
        'If nothing is selected, then there are no permissions in this group (tickets will not be available for the user).' => 'Jeli nic nie zaznaczono, wtedy uytkownik nie bdzie mia praw w tej grupie (zgoszenia bd niedostpne)',
        'If you need the sum of every column select yes.' => 'Jeeli chcesz sumowa kolumny wybierz tak.',
        'If you need the sum of every row select yes' => 'Jeeli chcesz sumowa wiersze wybierz tak.',
        'If you use RegExp, you also can use the matched value in () as [***] in \'Set\'.' => 'Jeeli uywasz wzorcw regularnych (RegExp), moesz take uy dopasowanych wartoci w () jako [***] w \'Set\'.',
        'Image' => 'Obraz',
        'Important' => 'Wane',
        'In this form you can select the basic specifications.' => 'W tym formularzu moesz wybra podstawowe parametry.',
        'In this way you can directly edit the keyring configured in Kernel/Config.pm.' => 'W ten sposb mona edytowa pk kluczy skofigurowany w Kernel/Config.pm',
        'Information about the Stat' => 'Informacja o szablonie',
        'Insert of the common specifications' => 'Wstaw podstawowe parametry',
        'Is Job Valid' => 'Zadanie jest wane',
        'Is Job Valid?' => 'Zadanie jest wane?',
        'It\'s useful for ASP solutions.' => 'Pomocne w rozwizanich ASP.',
        'It\'s useful for a lot of users and groups.' => 'Uyteczne dla wielu uytkownikw i grup.',
        'Job-List' => 'Lista zada',
        'Keyword' => 'Sowo kluczowe',
        'Keywords' => 'Sowa kluczowe',
        'Last update' => 'Ostatnia aktualizacja',
        'Link Table' => 'Pocz tabel',
        'Link auto responses to queues.' => 'Zarzdzanie relacjami Automatyczna Odpowied <-> Kolejka',
        'Link groups to roles.' => 'Zarzdzanie relacjami Grupy <-> Role',
        'Link to Parent' => 'Docz do rodzica',
        'Linked as' => 'Poczono jako',
        'Load Settings' => 'Zaaduj ustawienia',
        'Loading' => 'adowanie',
        'Logfile' => 'Plik logu',
        'Logfile too large, you need to reset it!' => 'Plik log jest za duy, naley go usun!',
        'Login failed! Your username or password was entered incorrectly.' => 'Logowanie niepoprawne! Twj login lub haso zostay wpisane niepoprawnie.',
        'Lookup' => 'Wyszukiwanie',
        'Mail Management' => 'Zarzdzanie poczt',
        'Mailbox' => 'Skrzynka',
        'Match' => 'Odpowiada',
        'Max. shown Tickets a page' => 'Maksymalna ilo zgosze na stronie',
        'Message for new Owner' => 'Wiadomo do nowego waciciela',
        'Message sent to' => 'Wiadomo wysana do',
        'Misc' => 'Rne',
        'Modified' => 'Zmodyfikowany',
        'Move notification' => 'Powiadomienie o przesuniciu',
        'Multiple selection of the output format.' => 'Wielokrotny wybr formatu wyjsciowego.',
        'MyTickets' => 'Moje zgoszenia',
        'Name is required!' => 'Nazwa jest wymagana!',
        'Need a valid email address or don\'t use a local address!' => 'Musisz poda poprawny adres email. Nie mona uywa lokalnych adresw.',
        'New Agent' => 'Nowy agent',
        'New Customer' => 'Nowy klient',
        'New Group' => 'Nowa grupa',
        'New Group Ro' => 'Nowa grupa ro',
        'New Password' => 'Nowe haso',
        'New Priority' => 'Nowy priorytet',
        'New SLA' => 'Nowa SLA',
        'New Service' => 'Nowa usuga',
        'New State' => 'Nowy status',
        'New Ticket Lock' => 'Nowa blokada zgoszenia',
        'New Title' => 'Nowy tytu',
        'New Type' => 'Nowy typ',
        'New account created. Sent Login-Account to %s.' => 'Konto zostao utworzone. Wysano informacje dotyczce logowania do %s.',
        'New messages' => 'Nowe wiadomoci',
        'New password again' => 'Ponownie nowe haso',
        'No * possible!' => 'Nie uywaj znaku "*"!',
        'No Packages for requested Framework in this Online Repository, but Packages for other Frameworks!' => 'Brak pakietw dla uywanej wersji Frameworka w tym repozytorium, ale s pakiety dla innych wersji!',
        'No Packages or no new Packages in selected Online Repository!' => 'Brak pakietw lub brak nowych pakietw w wybranym repozytorium!',
        'No Permission' => 'Brak dostpu',
        'No change time settings.' => 'Brak zmiany ustawie czasu',
        'No matches found' => 'Brak rezultatw',
        'No means, send agent and customer notifications on changes.' => '\'Nie\' oznacza - wylij agentowi i klientowi powiadomienia o zmianach.',
        'No time settings.' => 'Brak ustawie czasu',
        'Note' => 'Uwagi',
        'Note Text' => 'Tekst notatki',
        'Notification (Customer)' => 'Powiadomienie (Klient)',
        'Notifications' => 'Powiadomienia',
        'OTRS DB Name' => 'Nazwa bazy danych OTRS',
        'OTRS DB Password' => 'Haso dostpu do bazy dla OTRS',
        'OTRS DB User' => 'Uytkownik bazy danych OTRS',
        'OTRS DB connect host' => 'Host bazy danych',
        'OTRS sends an notification email to the customer if the ticket is moved.' => 'System wyle powiadomienie do klienta, gdy zgoszenie zostanie przesunite do innej kolejki.',
        'OTRS sends an notification email to the customer if the ticket owner has changed.' => 'System wyle powiadomienie do klienta, gdy zmieni sie waciciel zgoszenia.',
        'OTRS sends an notification email to the customer if the ticket state has changed.' => 'System wyle powiadomienie do klienta, gdy zmieni sie status zgoszenia.',
        'Object already linked as %s.' => 'Obiekt ju przypisany jako %s',
        'Of couse this feature will take some system performance it self!' => 'Oczywicie ta funkcja zabiera cz wydajnoci do obsugi samej siebie!',
        'Open Tickets' => 'Otwarte zg.',
        'Options of the current customer user data (e. g. &lt;OTRS_CUSTOMER_DATA_USERFIRSTNAME&gt;)' => 'Cechy aktualnego klienta (np. &lt;OTRS_CUSTOMER_DATA_USERFIRSTNAME&gt;)',
        'Options of the current customer user data (e. g. <OTRS_CUSTOMER_DATA_UserFirstname>)' => 'Opcje aktualnego klienta (np. <OTRS_CUSTOMER_DATA_UserFirstname>)',
        'Options of the current customer user data (e. g. <OTRS_CUSTOMER_DATA_UserFirstname>).' => 'Wasnoci aktualnego klienta(np. <OTRS_CUSTOMER_DATA_UserFirstname>).',
        'Options of the current user who requested this action (e. g. &lt;OTRS_CURRENT_USERFIRSTNAME&gt;)' => 'Opcje biecego uytkownika ktry wykona akcj (np. &lt;OTRS_CURRENT_USERFIRSTNAME&gt;)',
        'Options of the current user who requested this action (e. g. <OTRS_CURRENT_UserFirstname>)' => 'Opcje aktualnego agenta obsugi (np. <OTRS_CURRENT_UserFirstname>)',
        'Options of the current user who requested this action (e. g. <OTRS_CURRENT_UserFirstname>).' => 'Wasnoci aktualnego uytkownika ktry wykona akcj (np. <OTRS_CURRENT_UserFirstname>).',
        'Options of the ticket data (e. g. &lt;OTRS_TICKET_Number&gt;, &lt;OTRS_TICKET_ID&gt;, &lt;OTRS_TICKET_Queue&gt;, &lt;OTRS_TICKET_State&gt;)' => 'Opcjonalne dane (np. &lt;OTRS_TICKET_Number&gt;, &lt;OTRS_TICKET_ID&gt;, &lt;OTRS_TICKET_Queue&gt;, &lt;OTRS_TICKET_State&gt;)',
        'Options of the ticket data (e. g. <OTRS_TICKET_Number>, <OTRS_TICKET_ID>, <OTRS_TICKET_Queue>, <OTRS_TICKET_State>)' => 'Opcje zgoszenia (np. <OTRS_TICKET_Number>, <OTRS_TICKET_ID>, <OTRS_TICKET_Queue>, <OTRS_TICKET_State>)',
        'Options of the ticket data (e. g. <OTRS_TICKET_TicketNumber>, <OTRS_TICKET_ID>, <OTRS_TICKET_Queue>, <OTRS_TICKET_State>)' => 'Wasnoci zgoszenia (np. <OTRS_TICKET_TicketNumber>, <OTRS_TICKET_ID>, <OTRS_TICKET_Queue>, <OTRS_TICKET_State>)',
        'Options of the ticket data (e. g. <OTRS_TICKET_TicketNumber>, <OTRS_TICKET_TicketID>, <OTRS_TICKET_Queue>, <OTRS_TICKET_State>).' => 'Wasnoci zgoszenia (np. <OTRS_TICKET_TicketNumber>, <OTRS_TICKET_TicketID>, <OTRS_TICKET_Queue>, <OTRS_TICKET_State>).',
        'Order' => 'Porzdek',
        'Other Options' => 'Inne opcje',
        'Out Of Office' => 'Poza biurem',
        'POP3 Account Management' => 'Konfiguracja kont POP3',
        'Package' => 'Pakiet',
        'Param 1' => 'Parametr 1',
        'Param 2' => 'Parametr 2',
        'Param 3' => 'Parametr 3',
        'Param 4' => 'Parametr 4',
        'Param 5' => 'Parametr 5',
        'Param 6' => 'Parametr 6',
        'Parent-Object' => 'Obiekt macierzysty',
        'Password is already in use! Please use an other password!' => 'Haso obecnie uywane! Wybierz inne haso!',
        'Password is already used! Please use an other password!' => 'Haso uyte! Wybierz inne haso!',
        'Passwords doesn\'t match! Please try it again!' => 'Hasa nie s zgodne! Sprbuj ponownie!',
        'Pending Times' => 'Czasy oczekiwania',
        'Pending messages' => 'Oczekujce wiadomoci',
        'Pending type' => 'Typ oczekiwania',
        'Permission settings. You can select one or more groups to make the configurated stat visible for different agents.' => 'Ustawienia dostepu. Wybierz grupy mogce udostpnia przygotowane raporty dla innych agentw.',
        'Permissions to change the ticket owner in this group/queue.' => 'Uprawnienia do zmiany waciciela zgoszenia w tej grupie/kolejce',
        'PhoneView' => 'Nowy telefon',
        'Please contact your admin' => 'Skontaktuj si z Administratorem',
        'Please enter subject.' => 'Prosz poda tytu',
        'Please provide a name.' => 'Prosz poda nazw',
        'Prio' => 'Priorytet',
        'Problem' => 'Problem',
        'Queue <-> Auto Responses Management' => 'Kolejka <-> Zarzdzanie automatycznymi odpowiedziami',
        'Queue ID' => 'ID Kolejki',
        'Queue Management' => 'Zarzadzanie kolejkami',
        'Queue is required.' => 'Naley wskaza kolejk!',
        'Queues <-> Auto Responses' => 'Kolejka <-> Automatyczna odpowied',
        'Realname' => 'Prawdziwe Imi i Nazwisko',
        'Rebuild' => 'Przebuduj',
        'Recipients' => 'Adresaci',
        'Refresh' => 'Odswie',
        'Reminder' => 'Przypomnienie',
        'Reminder messages' => 'Tekst przypomnienia',
        'Required Field' => 'Pole wymagane',
        'Required!' => 'Wymagane!',
        'Response Management' => 'Konfiguracja Odpowiedzi',
        'Responses <-> Attachments Management' => 'Odpowiedzi <-> Zarzdzanie zacznikami',
        'Responses <-> Queue Management' => 'Odpowiedzi <-> Zarzdzanie kolejkami',
        'Return to the compose screen' => 'Powr do ekranu edycji',
        'Role' => 'Rola',
        'Roles <-> Agents' => 'Role <-> Agenci',
        'Roles <-> Groups Management' => 'Role <-> Zarzdzanie grupami',
        'Roles <-> Users' => 'Role <-> Uytkownicy',
        'Roles <-> Users Management' => ' Role <-> Zarzdzanie uytkownikami',
        'Save Job as?' => 'Zapisz zadanie jako',
        'Save Search-Profile as Template?' => 'Zachowaj profil wyszukiwania jako szablon',
        'Schedule' => 'Harmonogram',
        'Search Result' => 'Wyniki wyszukiwania',
        'Search Ticket' => 'Szukaj zgoszenia',
        'Search for' => 'Szukaj',
        'Select Box' => 'Zapytanie SQL',
        'Select Box Result' => 'Wyniki Zapytania',
        'Select Group' => 'Wybierz grup ustawie',
        'Select Source (for add)' => 'Wybierz rdo (dla dodania)',
        'Select group' => 'Wybierz grup ustawie',
        'Select the customeruser:service relations.' => 'Wybierz relacj klient:usuga.',
        'Select the element, which will be used at the X-axis' => 'Wybierz element ktry bdzie uzyty jako o X',
        'Select the restrictions to characterise the stat' => 'Wybierz ograniczenia do opisania raportu.',
        'Select the role:user relations.' => 'Wybierz role: relacje uytkownikw.',
        'Select the user:group permissions.' => 'Wybierz prawa dostpu dla uytkownika:grupy',
        'Select your QueueView refresh time.' => 'Wybierz okres odwierzania Podgldu Kolejki.',
        'Select your default spelling dictionary.' => 'Wybierz domylny sownik.',
        'Select your frontend Charset.' => 'Wybierz kodowanie.',
        'Select your frontend QueueView.' => 'Wybierz Podgld Kolejki.',
        'Select your frontend language.' => 'Wybierz jzyk.',
        'Select your out of office time.' => 'Wybierz czas nieobecnosci',
        'Select your screen after creating a new ticket.' => 'Wybierz ekran, ktry pokae si po rejestracji nowego zgoszenia',
        'Selection needed' => 'Wybr wymagany',
        'Send Notification' => 'Wylij powiadomienie',
        'Send me a notification if a customer sends a follow up and I\'m the owner of this ticket.' => 'Wylij mi wiadomo, gdy klient odpowie na zgoszenie, ktrego ja jestem wacicielem.',
        'Send me a notification of an watched ticket like an owner of an ticket.' => 'Wylij mi powiadomienie obserwowaych zgosze tak jak wacicielowi zgoszenia.',
        'Send no notifications' => 'Wylij bez powiadomie',
        'Sent new password to: %s' => 'Wysano nowe haso do: %s',
        'Sent password token to: %s' => 'Wysano token hasa do: %s',
        'Sessions' => 'Sesje',
        'Set customer user and customer id of a ticket' => 'Wska klienta i ID klienta dla zgoszenia',
        'Show' => 'Poka',
        'Site' => 'Witryna',
        'Solution' => 'Rozwizanie',
        'Sort by' => 'Sortuj wedug',
        'Source' => 'rdo',
        'Spell Check' => 'Sprawd poprawno',
        'Split' => 'Podziel',
        'State Type' => 'Typ statusu',
        'Static-File' => 'Plik statyczny',
        'Stats-Area' => 'Staystyki',
        'Sub-Queue of' => 'Kolejka podrzdna',
        'Sub-Service of' => 'Usuga podrzdna wobec',
        'Subscribe' => 'Obserwuj',
        'Symptom' => 'Objawy',
        'System State Management' => 'Konfiguracja statusw',
        'Systemaddress' => 'Adres systemowy',
        'The Ticket was locked' => 'Zgoszenie zostao zablokowane',
        'The customer is required.' => 'Naley wskaza klienta!',
        'The field is required.' => 'Pole jest wymagane',
        'The message being composed has been closed.  Exiting.' => 'Wiadomo edytowana zostaa zamknita.  Wychodz.',
        'The subject is required!' => 'Naley poda temat!',
        'The text is required!' => 'Wiadomo musi zawiera jak tre!',
        'These values are read-only.' => 'Warto tylko do odczytu.',
        'These values are required.' => 'Warto wymagana.',
        'This account exists.' => 'Konto istnieje.',
        'This is useful if you want that no one can get the result of the stat or the stat isn\'t ready configurated.' => 'To jest uyteczna blokada jeeli chcesz uniemoliwi generowanie raportu przed zakoczeniem tworzenia wzorca.',
        'This window must be called from compose window' => 'To okno musi zosta wywoane z okna edycji',
        'Ticket Change Times (between)' => 'Czas aktualizacji zgoszenia (pomidzy)',
        'Ticket Change Times (from moment)' => 'Czas aktualizacji zgoszenia (od momentu)',
        'Ticket Close Times (between)' => 'Czas zamknicia zgoszenia (pomidzy)',
        'Ticket Close Times (from moment)' => 'Czas zamknicia zgoszenia (od momentu)',
        'Ticket Create Times (between)' => 'Czas utworzenia zgoszenia (pomidzy)',
        'Ticket Create Times (from moment)' => 'Czas utworzenia zgoszenia (od momentu)',
        'Ticket Hook' => 'Identyfikator zgoszenia',
        'Ticket Lock' => 'Zablokowanie zgoszenia',
        'Ticket Number Generator' => 'Generator numerw zgosze',
        'Ticket Search' => 'Wyszukiwanie zgoszenia',
        'Ticket Status View' => 'Status zgoszenia',
        'Ticket Type is required!' => 'Typ zgoszenia jest wymagany!',
        'Ticket changed' => 'Zgoszenie zmieniono',
        'Ticket changed between' => 'Zgoszenie zmieniono pomidzy',
        'Ticket escalation!' => 'Eskalacja zgoszenia!',
        'Ticket locked!' => 'Zgoszenie zablokowane!',
        'Ticket owner options (e. g. &lt;OTRS_OWNER_USERFIRSTNAME&gt;)' => 'Opcje waciciela zgoszenia (np. &lt;OTRS_OWNER_USERFIRSTNAME&gt;)',
        'Ticket owner options (e. g. <OTRS_OWNER_UserFirstname>)' => 'Opcje dotyczce waciciela zgoszenia (np. <OTRS_OWNER_UserFirstname>)',
        'Ticket owner options (e. g. <OTRS_OWNER_UserFirstname>).' => 'Wasnoci wasciciela zgoszenia (np. <OTRS_OWNER_UserFirstname>).',
        'Ticket responsible options (e. g. <OTRS_RESPONSIBLE_UserFirstname>).' => 'Wasnoci odpowiedzialnego agenta (np. <OTRS_RESPONSIBLE_UserFirstname>).',
        'Ticket selected for bulk action!' => 'Zgoszenie wybrano do akcji grupowej!',
        'Ticket unlock!' => 'Zgoszenie odblokowane!',
        'Ticket#' => 'Zgoszenie',
        'Ticket-Area' => 'Zgoszenia',
        'TicketFreeText' => 'Dodatkowe informacje o zgoszeniu',
        'TicketID' => 'ID Zgoszenia',
        'TicketZoom' => 'Podgld zgoszenia',
        'Tickets shown' => 'Pokazane zgoszenia',
        'Tickets which need to be answered!' => 'Zgoszenia, na ktre naley odpowiedzie!',
        'Timeover' => 'Przekroczenie czasu',
        'Times' => 'Razy',
        'Title of the stat.' => 'Tytu statystyki.',
        'To enable automatic execusion select at least one value form minutes, hours and days!' => 'Aby wczy automatyczne wykonywanie ustaw dni, godziny i minuty!',
        'To get the article attribute (e. g. (<OTRS_CUSTOMER_From>, <OTRS_CUSTOMER_To>, <OTRS_CUSTOMER_Cc>, <OTRS_CUSTOMER_Subject> and <OTRS_CUSTOMER_Body>).' => 'Atrybuty artykuu (np. (<OTRS_CUSTOMER_From>, <OTRS_CUSTOMER_To>, <OTRS_CUSTOMER_Cc>, <OTRS_CUSTOMER_Subject> and <OTRS_CUSTOMER_Body>).',
        'Top of Page' => 'Gra strony',
        'Total hits' => 'Wszystkich trafie',
        'Type:' => 'Typ:',
        'U' => 'G',
        'Unable to parse Online Repository index document!' => 'Niedostpne repozytorium on-line',
        'Uniq' => 'Unikalne',
        'Unlock Tickets' => 'Odblokuj zgoszenia',
        'Unsubscribe' => 'Zakocz obserwowanie',
        'Use utf-8 it your database supports it!' => 'Uywaj kodowania UTF-8 jeli pozwala Ci na to baza danych!',
        'Useable options' => 'Uyteczne opcje',
        'User Management' => 'Zarzdzanie uytkownikami',
        'User will be needed to handle tickets.' => 'Uytkownik bdzie niezbdny do obsugi zgoszenia.',
        'Users' => 'Uytkownicy',
        'Users <-> Groups' => 'Uytkownicy <-> Grupy',
        'Users <-> Groups Management' => 'Uytkownicy <-> Zarzdzanie grupami',
        'Verify New Password' => 'Powtrz nowe haso',
        'Warning! This tickets will be removed from the database! This tickets are lost!' => 'Uwaga! Zgoszenia zostan usuniete z bazy danych! Zgoszenia zostan utracone!',
        'Watch notification' => 'Obserwuj powiadomienia',
        'Web-Installer' => 'Instalator Web',
        'WebMail' => 'Poczta przez www',
        'WebWatcher' => 'Obserwator Web',
        'Welcome to OTRS' => 'Witamy w OTRS',
        'With an invalid stat it isn\'t feasible to generate a stat.' => 'Niewany raport nie moe zosta wygenerowany.',
        'With the input and select fields you can configurate the stat at your needs. Which elements of a stat you can edit depends on your stats administrator who configurated the stat.' => 'Moesz utworzy szablony z wykorzystaniem pl wyboru i wprowadzania danych wedug wasnych potrzeb. Ktre elementy moesz edytowa okreli administrator statystyk ktry konfigurowa modu statystyk.',
        'Yes means, send no agent and customer notifications on changes.' => '\'Tak\' oznacza - nie wysyaj powiadomie agentowi i klientowpi przy zmianach.',
        'Yes, save it with name' => 'Tak, zapisz to pod nazw',
        'You got new message!' => 'Masz now wiadomo!',
        'You have to select two or more attributes from the select field!' => 'Musisz wybra dwa lub wicej atrybutw z pola wyboru!',
        'You need a email address (e. g. customer@example.com) in To:!' => 'W polu Do: musi znale si adres email (np. klient@przyklad.pl)!',
        'You need a to: recipient!.' => 'Musisz wskaza odbiorc',
        'You need min. one selected Ticket!' => 'Musisz wybra conajmniej jedno zgoszenie!',
        'You need to account time!' => 'Musisz zaraportowa czas!',
        'You need to activate %s first to use it!' => 'Musisz aktywowa %s przed uyciem!',
        'Your Password' => 'Haso',
        'Your email address is new' => 'Ustawiono nowy adres e-mail',
        'Your email with ticket number "<OTRS_TICKET>" is bounced to "<OTRS_BOUNCE_TO>". Contact this address for further information.' => 'Twoja wiadomo o numerze zgoszenia: "<OTRS_TICKET>" zostaa przekazana na adres "<OTRS_BOUNCE_TO>" . Prosimy kontaktowa si pod tym adresem we wszystkich sprawach dotyczcych tego zgoszenia.',
        'Your own Ticket' => 'Twoje wasne zgoszenie',
        'accept license' => 'akceptuj Licencj',
        'customer realname' => 'Prawdziwe dane klienta',
        'delete' => 'kasuj',
        'delete links' => 'usu linki',
        'don\'t accept license' => 'nie akceptuj Licencji',
        'down' => 'd',
        'false' => 'fasz',
        'for agent firstname' => 'dla imienia agenta',
        'for agent lastname' => 'dla nazwiska agenta',
        'for agent login' => 'dla loginu agenta',
        'for agent user id' => 'dla ID agenta',
        'go back' => 'powrt',
        'kill all sessions' => 'Zamknij wszystkie sesje',
        'kill session' => 'Zamknij sesj',
        'maximal period form' => 'maksymalny okres formularza',
        'modified' => 'zmieniony',
        'new ticket' => 'Nowe zgoszenie',
        'next step' => 'Nastpny krok',
        'send' => 'wylij',
        'sort downward' => 'sortuj malejco',
        'sort upward' => 'sortuj rosnco',
        'to get the first 20 character of the subject' => 'by wstawi pierwsze 20 znakw tematu',
        'to get the first 5 lines of the email' => 'by wstawi 5 pierwszych linii wiadomoci',
        'to get the from line of the email' => 'by wstawi pole Od wiadomoci',
        'to get the realname of the sender (if given)' => 'by wstawi prawdziwe imi i nazwisko klienta (jeli podano)',
        'up' => 'gra',
        'utf8' => 'UTF8',

    };
    # $$STOP$$
    return;
}

1;
