# --
# Kernel/Language/tr.pm - provides tr language translation
# Copyright (C) 2001-2008 OTRS AG, http://otrs.org/
# --
# $Id: tr.pm,v 1.13.2.1 2008/10/16 14:08:47 ub Exp $
# --
# This software comes with ABSOLUTELY NO WARRANTY. For details, see
# the enclosed file COPYING for license information (GPL). If you
# did not receive this file, see http://www.gnu.org/licenses/gpl-2.0.txt.
# --
package Kernel::Language::tr;

use strict;

use vars qw($VERSION);
$VERSION = '$Revision: 1.13.2.1 $';
$VERSION =~ s/^\$.*:\W(.*)\W.+?$/$1/;

sub Data {
    my $Self = shift;

    # $$START$$
    # Last translation file sync: Fri May 16 14:09:04 2008

    # possible charsets
    $Self->{Charset} = ['iso-8859-9', ];
    # date formats (%A=WeekDay;%B=LongMonth;%T=Time;%D=Day;%M=Month;%Y=Jear;)
    $Self->{DateFormat}          = '%D.%M.%Y %T';
    $Self->{DateFormatLong}      = '%T - %D.%M.%Y';
    $Self->{DateFormatShort}     = '%D.%M.%Y';
    $Self->{DateInputFormat}     = '%D.%M.%Y';
    $Self->{DateInputFormatLong} = '%D.%M.%Y - %T';

    $Self->{Translation} = {
        # Template: AAABase
        'Yes' => 'Evet',
        'No' => 'Hayr',
        'yes' => 'evet',
        'no' => 'hayr',
        'Off' => 'Kapal',
        'off' => 'kapal',
        'On' => 'Ak',
        'on' => 'ak',
        'top' => 'st',
        'end' => 'son',
        'Done' => 'Tamam',
        'Cancel' => 'ptl',
        'Reset' => 'Sfrla',
        'last' => 'son',
        'before' => 'nce',
        'day' => 'gn',
        'days' => 'gn',
        'day(s)' => 'gn',
        'hour' => 'saat',
        'hours' => 'saat',
        'hour(s)' => 'saat',
        'minute' => 'dakika',
        'minutes' => 'dakika',
        'minute(s)' => 'dakika',
        'month' => 'ay',
        'months' => 'ay',
        'month(s)' => 'ay',
        'week' => 'hafta',
        'week(s)' => 'hafta',
        'year' => 'yl',
        'years' => 'yl',
        'year(s)' => 'yl',
        'second(s)' => 'saniye',
        'seconds' => 'saniye',
        'second' => 'saniye',
        'wrote' => 'yazd',
        'Message' => 'Mesaj',
        'Error' => 'Hata',
        'Bug Report' => 'Hata Kayd',
        'Attention' => 'Dikkat',
        'Warning' => 'Uyar',
        'Module' => 'modl',
        'Modulefile' => 'modl dosyas',
        'Subfunction' => 'Altfonksiyon',
        'Line' => 'Hat',
        'Example' => 'rnek',
        'Examples' => 'Beispiele',
        'valid' => 'geerli',
        'invalid' => 'geersiz',
        '* invalid' => '* geersiz',
        'invalid-temporarily' => 'geici olarak geersiz',
        ' 2 minutes' => ' 2 dakika',
        ' 5 minutes' => ' 5 dakika',
        ' 7 minutes' => ' 7 dakika',
        '10 minutes' => '10 dakika',
        '15 minutes' => '15 dakika',
        'Mr.' => 'Bay',
        'Mrs.' => 'Bayan',
        'Next' => 'Sonraki',
        'Back' => 'Geri',
        'Next...' => 'Sonraki...',
        '...Back' => '...Geri',
        '-none-' => '-hibiri-',
        'none' => 'hibiri',
        'none!' => 'hibiri!',
        'none - answered' => 'hibiri - cevapland',
        'please do not edit!' => 'Ltfen deitirmeyiniz!',
        'AddLink' => 'Ba Ekle',
        'Link' => 'Ba',
        'Unlink' => '',
        'Linked' => 'Baland',
        'Link (Normal)' => 'Ba (Normal)',
        'Link (Parent)' => 'Ba (Ebeveyn)',
        'Link (Child)' => 'Ba (Alt)',
        'Normal' => 'Normal',
        'Parent' => 'Ebeveyn',
        'Child' => 'Alt',
        'Hit' => 'sabet',
        'Hits' => 'sabet',
        'Text' => 'Metin',
        'Lite' => 'Hafif',
        'User' => 'Kullanc',
        'Username' => 'Kullanc ad',
        'Language' => 'Dil',
        'Languages' => 'Diller',
        'Password' => 'Parola',
        'Salutation' => 'Selam',
        'Signature' => 'mza',
        'Customer' => 'Mteri',
        'CustomerID' => 'Mteri kimlii',
        'CustomerIDs' => 'Mteri kimlikleri',
        'customer' => 'mteri',
        'agent' => 'arac',
        'system' => 'sistem',
        'Customer Info' => 'Mteri Bilgisi',
        'Customer Company' => 'Mteri irket',
        'Company' => 'irket',
        'go!' => 'Bala!',
        'go' => 'bala',
        'All' => 'Tm',
        'all' => 'tm',
        'Sorry' => 'zgnm',
        'update!' => 'gncelle!',
        'update' => 'gncelle',
        'Update' => 'Gncelle',
        'submit!' => 'gnder!',
        'submit' => 'gnder',
        'Submit' => 'Gnder',
        'change!' => 'deitir!',
        'Change' => 'Deitir',
        'change' => 'deitir',
        'click here' => 'buraya tklayn',
        'Comment' => 'Yorum',
        'Valid' => 'Geerli',
        'Invalid Option!' => 'Geersiz Seenek!',
        'Invalid time!' => 'Geersiz saat!',
        'Invalid date!' => 'Geersiz tarih!',
        'Name' => 'Ad',
        'Group' => 'Grup',
        'Description' => 'Aklama',
        'description' => 'aklama',
        'Theme' => 'Tema',
        'Created' => 'Oluturma',
        'Created by' => 'Oluturan',
        'Changed' => 'Deiim',
        'Changed by' => 'Deitiren',
        'Search' => 'Ara',
        'and' => 've',
        'between' => 'arasnda',
        'Fulltext Search' => 'Tmmetin Aramas',
        'Data' => 'Veri',
        'Options' => 'Seenekler',
        'Title' => 'Balk',
        'Item' => 'Madde',
        'Delete' => 'Sil',
        'Edit' => 'Dzenle',
        'View' => 'Grnm',
        'Number' => 'Say',
        'System' => 'Sistem',
        'Contact' => 'Balant',
        'Contacts' => 'Balantlar',
        'Export' => 'Darya aktar',
        'Up' => 'Yukar',
        'Down' => 'Aa',
        'Add' => 'Ekle',
        'Category' => 'Kategori',
        'Viewer' => 'Grntleyen',
        'New message' => 'Yeni mesaj',
        'New message!' => 'Yeni mesaj!',
        'Please answer this ticket(s) to get back to the normal queue view!' => 'Ltfen normal kuyruk grnmne dnmek iin bu bilet(ler)i cevaplayn!',
        'You got new message!' => 'Yeni mesajnz var!',
        'You have %s new message(s)!' => '%s yeni mesajnz var!',
        'You have %s reminder ticket(s)!' => '%s hatrlatc biletiniz var!',
        'The recommended charset for your language is %s!' => 'Kullandnz dil iin tavsiye edilen karakter kmesi %s!',
        'Passwords doesn\'t match! Please try it again!' => 'Parolalar uyumuyor! Ltfen tekrar denetin!',
        'Password is already in use! Please use an other password!' => 'Parola zaten kullanmda! Ltfen baka bir parola kullann!',
        'Password is already used! Please use an other password!' => 'Parola zaten kullanld! Ltfen baka bir parola kullann!',
        'You need to activate %s first to use it!' => 'Kullanabilmek iin %s nce etkinletirilmeli!',
        'No suggestions' => 'neri yok',
        'Word' => 'Kelime',
        'Ignore' => 'Yoksay',
        'replace with' => 'ile deitir',
        'There is no account with that login name.' => 'Bu kullanc adnda bir hesap yok.',
        'Login failed! Your username or password was entered incorrectly.' => 'Oturum alamad! Kullanc adnz veya parolanz yanl girildi.',
        'Please contact your admin' => 'Ltfen yneticiyle iletiime gein',
        'Logout successful. Thank you for using OTRS!' => 'Oturum kapatma baarl! OTRS\'yi kullandnz iin teekkr ederiz!',
        'Invalid SessionID!' => 'Geersiz oturum kimlii!',
        'Feature not active!' => 'zellik etkin deil!',
        'Login is needed!' => 'Oturum amanz gerekli!',
        'Password is needed!' => 'Parola gerekli!',
        'License' => 'Lisans',
        'Take this Customer' => 'Bu Mteriyi al',
        'Take this User' => 'Bu Kullancy al',
        'possible' => 'mmkn',
        'reject' => 'reddet',
        'reverse' => 'ters',
        'Facility' => 'Tesis',
        'Timeover' => 'Sre bitimi',
        'Pending till' => 'u zamana kadar askda',
        'Don\'t work with UserID 1 (System account)! Create new users!' => 'Kullanc kimlii 1 (Sistem hesab) ile almayn! Yeni kullanclar oluturun!',
        'Dispatching by email To: field.' => 'Elektronik posta Kime: alanna gre gnderiliyor.',
        'Dispatching by selected Queue.' => 'Seili Kuyrua gre gnderiliyor.',
        'No entry found!' => 'Kayt bulunamad!',
        'Session has timed out. Please log in again.' => 'Oturum sresi doldu. Ltfen tekrar oturum an.',
        'No Permission!' => 'zin yok!',
        'To: (%s) replaced with database email!' => 'Kime: (%s) veritaban elektronik postasyla deitirilir!',
        'Cc: (%s) added database email!' => 'Karbon kopya: (%s) veritaban elektronik postas eklendi!',
        '(Click here to add)' => '(Eklemek iin buraya tklayn)',
        'Preview' => 'nizleme',
        'Package not correctly deployed! You should reinstall the Package again!' => 'Paket doru ekilde yklenmemi! Paketi yeniden yklemelisiniz!',
        'Added User "%s"' => '"%s" kullancs eklendi.',
        'Contract' => 'Kontrat',
        'Online Customer: %s' => 'evrimii Mteri: %s',
        'Online Agent: %s' => 'evirimi Arac: %s',
        'Calendar' => 'Takvim',
        'File' => 'Dosya',
        'Filename' => 'Dosya ad',
        'Type' => 'Tip',
        'Size' => 'Boyut',
        'Upload' => 'Ykle',
        'Directory' => 'Dizin',
        'Signed' => 'mzal',
        'Sign' => 'mza',
        'Crypted' => 'ifrelenmi',
        'Crypt' => 'ifre',
        'Office' => 'Bro',
        'Phone' => 'Telefon',
        'Fax' => 'Faks',
        'Mobile' => 'Cep',
        'Zip' => 'PK',
        'City' => 'ehir',
        'Location' => '',
        'Street' => '',
        'Country' => 'lke',
        'installed' => 'yklenmi',
        'uninstalled' => 'kaldrlm',
        'Security Note: You should activate %s because application is already running!' => 'Gvenlik notu: %s etkinletirilmeli nk uygulama halihazrda alyor!',
        'Unable to parse Online Repository index document!' => 'evrimii Depo endeks belgesi ayrtrlamad!',
        'No Packages for requested Framework in this Online Repository, but Packages for other Frameworks!' => 'Bu evrimii Depoda stenen at iin Paket bulunamad, ama baka atlar iin var!',
        'No Packages or no new Packages in selected Online Repository!' => 'Seili evrimii Depoda hi Paket yok veya hi yeni Paket yok!',
        'printed at' => 'yazdrld',
        'Dear Mr. %s,' => '',
        'Dear Mrs. %s,' => '',
        'Dear %s,' => '',
        'Hello %s,' => '',
        'This account exists.' => '',
        'New account created. Sent Login-Account to %s.' => '',
        'Please press Back and try again.' => '',
        'Sent password token to: %s' => '',
        'Sent new password to: %s' => '',
        'Invalid Token!' => '',

        # Template: AAAMonth
        'Jan' => 'Oca',
        'Feb' => 'ub',
        'Mar' => 'Mar',
        'Apr' => 'Nis',
        'May' => 'May',
        'Jun' => 'Haz',
        'Jul' => 'Tem',
        'Aug' => 'Au',
        'Sep' => 'Eyl',
        'Oct' => 'Eki',
        'Nov' => 'Kas',
        'Dec' => 'Ara',
        'January' => 'Ocak',
        'February' => 'ubat',
        'March' => 'Mart',
        'April' => 'Nisan',
        'June' => 'Haziran',
        'July' => 'Temmuz',
        'August' => 'Austos',
        'September' => 'Eyll',
        'October' => 'Ekim',
        'November' => 'Kasm',
        'December' => 'Aralk',

        # Template: AAANavBar
        'Admin-Area' => 'Ynetim Alan',
        'Agent-Area' => 'Arac Alan',
        'Ticket-Area' => 'Bilet Alan',
        'Logout' => 'Oturumu kapat',
        'Agent Preferences' => 'Arac Tercihleri',
        'Preferences' => 'Tercihler',
        'Agent Mailbox' => 'Arac Posta Kutusu',
        'Stats' => 'statistikler',
        'Stats-Area' => 'statistikler Alan',
        'Admin' => 'Ynetici',
        'Customer Users' => 'Mteri Kullanclar',
        'Customer Users <-> Groups' => 'Mteri Kullanclar <-> Gruplar',
        'Users <-> Groups' => 'Kullanclar <-> Gruplar',
        'Roles' => 'Roller',
        'Roles <-> Users' => 'Roller <-> Kullanclar',
        'Roles <-> Groups' => 'Roller <-> Gruplar',
        'Salutations' => 'Selmlamalar',
        'Signatures' => 'mzalar',
        'Email Addresses' => 'E-Posta Adresleri',
        'Notifications' => 'Bildirimler',
        'Category Tree' => 'Kategori Aac',
        'Admin Notification' => 'Ynetim Bilgilendirme',

        # Template: AAAPreferences
        'Preferences updated successfully!' => 'Tercihler baarl bir ekilde gncellendi!',
        'Mail Management' => 'Posta Ynetimi',
        'Frontend' => 'nyz',
        'Other Options' => 'Dier Seenekler',
        'Change Password' => 'Parola Deitir',
        'New password' => 'Yeni parola',
        'New password again' => 'Yeni parola (tekrar)',
        'Select your QueueView refresh time.' => 'Kuyruk Grnm tazeleme skln sein.',
        'Select your frontend language.' => 'nyz Dilini sein.',
        'Select your frontend Charset.' => 'nyz Karakter Kmesini sein.',
        'Select your frontend Theme.' => 'nyz Temasn sein.',
        'Select your frontend QueueView.' => 'nyz Kuyruk Grnmnz sein.',
        'Spelling Dictionary' => 'Szdizim Szl',
        'Select your default spelling dictionary.' => 'ntanml szdizim szlnz sein.',
        'Max. shown Tickets a page in Overview.' => 'Genel bakta bir sayfada gsterilecek en fazla Bilet says.',
        'Can\'t update password, passwords doesn\'t match! Please try it again!' => 'Parola gncellenemiyor, parolalar birbirleriyle uyumuyor! Ltfen tekrar deneyin!',
        'Can\'t update password, invalid characters!' => 'Parola gncellenemiyor, geersiz karakterler var!',
        'Can\'t update password, need min. 8 characters!' => 'Parola gncellenemiyor, en az 8 karakter girmelisiniz!',
        'Can\'t update password, need 2 lower and 2 upper characters!' => 'Parola gncellenemiyor, 2 kk harf ve 2 byk harf girmelisiniz!',
        'Can\'t update password, need min. 1 digit!' => 'Parola gncellenemiyor, en az 1 say girmelisiniz!',
        'Can\'t update password, need min. 2 characters!' => 'Parola gncellenemiyor, en az 2 karakter girmelisiniz!',

        # Template: AAAStats
        'Stat' => 'statistikler',
        'Please fill out the required fields!' => 'Ltfen zorunlu alanlar doldurun!',
        'Please select a file!' => 'Ltfen bir dosya sein!',
        'Please select an object!' => 'Ltfen bir nesne sein!',
        'Please select a graph size!' => 'Ltfen bir grafik boyutu sein!',
        'Please select one element for the X-axis!' => 'Ltfen X ekseni iin bir eleman sein!',
        'You have to select two or more attributes from the select field!' => 'Seim alanndan iki veya daha fazla nitelik semelisiniz!',
        'Please select only one element or turn off the button \'Fixed\' where the select field is marked!' => 'Ltfen sadece bir eleman sein veya seim alannn iaretli olduu yerden \'Sabit\' dmesini kapatn!',
        'If you use a checkbox you have to select some attributes of the select field!' => 'Eer bir iaretleme kutusu kullanrsanz seim alanndan baz nitelikleri semelisiniz!',
        'Please insert a value in the selected input field or turn off the \'Fixed\' checkbox!' => 'Ltfen seili giri alanna bir deer girin veya \'Sabit\' iaretleme kutusunu kapatn!',
        'The selected end time is before the start time!' => 'Seilen biti zaman balama zamanndan nce!',
        'You have to select one or more attributes from the select field!' => 'Seim alanndan bir veya daha fazla nitelik semelisiniz!',
        'The selected Date isn\'t valid!' => 'Seilen Tarih geerli deil!',
        'Please select only one or two elements via the checkbox!' => 'Ltfen iaretleme kutusu vastasyla sadece bir veya iki eleman sein!',
        'If you use a time scale element you can only select one element!' => 'Eer bir zaman oran eleman kullanrsanz sadece bir eleman seebilirsiniz!',
        'You have an error in your time selection!' => 'Zaman seiminizde bir hata var!',
        'Your reporting time interval is too small, please use a larger time scale!' => 'Raporlama zaman sklnz ok kk, ltfen daha byk bir zaman oran sein!',
        'The selected start time is before the allowed start time!' => 'Seilen balang zaman izin verilen balang zamanndan nce!',
        'The selected end time is after the allowed end time!' => 'Seilen biti zaman izin verilen biti zamanndan sonra!',
        'The selected time period is larger than the allowed time period!' => 'Seilen zaman dnemi izin verilen zaman dneminden daha byk!',
        'Common Specification' => 'Genel Belirtim',
        'Xaxis' => 'X ekseni',
        'Value Series' => 'Deer Serileri',
        'Restrictions' => 'Kstlamalar',
        'graph-lines' => 'grafik-izgiler',
        'graph-bars' => 'grafik-ubuklar',
        'graph-hbars' => 'grafik-yatay ubuklar',
        'graph-points' => 'grafik-noktalar',
        'graph-lines-points' => 'grafik-izgiler-noktalar',
        'graph-area' => 'grafik-alan',
        'graph-pie' => 'grafik-pasta',
        'extended' => 'geniletilmi',
        'Agent/Owner' => 'Arac/Sahip',
        'Created by Agent/Owner' => 'Arac/Sahip Tarafndan Oluturulmu',
        'Created Priority' => 'Oluturulma ncelii',
        'Created State' => 'Oluturulma Durumu',
        'Create Time' => 'Oluturulma Zaman',
        'CustomerUserLogin' => 'Mteri Kullanc Oturumu',
        'Close Time' => 'Kapanma Zaman',

        # Template: AAATicket
        'Lock' => 'Kilitle',
        'Unlock' => 'Kilidi A',
        'History' => 'Gemi',
        'Zoom' => 'Yaknlama',
        'Age' => 'Ya',
        'Bounce' => 'Yanst',
        'Forward' => 'leri',
        'From' => 'Kimden',
        'To' => 'Kime',
        'Cc' => 'Karbon Kopya',
        'Bcc' => 'Gizli Karbon Kopya',
        'Subject' => 'Konu',
        'Move' => 'Ta',
        'Queue' => 'Kuyrua koy',
        'Priority' => 'ncelik',
        'Priority Update' => '',
        'State' => 'Durum',
        'Compose' => 'Yeni Olutur',
        'Pending' => 'Bekliyor',
        'Owner' => 'Sahip',
        'Owner Update' => 'Sahip Gncellemesi',
        'Responsible' => 'Sorumlu',
        'Responsible Update' => 'Sorumlu Gncellemesi',
        'Sender' => 'Gnderen',
        'Article' => 'Yaz',
        'Ticket' => 'Bilet',
        'Createtime' => 'Oluturulma zaman',
        'plain' => 'dz',
        'Email' => 'E-Posta',
        'email' => 'e-posta',
        'Close' => 'Kapat',
        'Action' => 'Eylem',
        'Attachment' => 'Ek',
        'Attachments' => 'Ekler',
        'This message was written in a character set other than your own.' => 'Bu mesaj sizinkinin dnda bir karakter kmesinde yazlm.',
        'If it is not displayed correctly,' => 'Eer doru grntlenmezse,',
        'This is a' => 'Bu bir',
        'to open it in a new window.' => 'yeni pencerede amak iin',
        'This is a HTML email. Click here to show it.' => 'Bu HTML biimli bir e-posta. Gstermek iin buraya tklayn.',
        'Free Fields' => 'Serbest Alanlar',
        'Merge' => 'birletir',
        'merged' => 'birletirildi',
        'closed successful' => 'kapatma baarl',
        'closed unsuccessful' => 'kapatma baarsz',
        'new' => 'yeni',
        'open' => 'a',
        'closed' => 'kapal',
        'removed' => 'kaldrld',
        'pending reminder' => 'bekleyen hatrlatc',
        'pending auto' => 'bekleyen otomatik',
        'pending auto close+' => 'bekleyen otomatik kapat+',
        'pending auto close-' => 'bekleyen otomatik kapat-',
        'email-external' => 'e-posta-haric',
        'email-internal' => 'e-posta-dahil',
        'note-external' => 'not-haric',
        'note-internal' => 'not-dahil',
        'note-report' => 'not-rapor',
        'phone' => 'telefon',
        'sms' => 'ksa mesaj',
        'webrequest' => 'web istei',
        'lock' => 'kilitle',
        'unlock' => 'kilidi a',
        'very low' => 'ok dk',
        'low' => 'dk',
        'normal' => 'normal',
        'high' => 'yksek',
        'very high' => 'ok yksek',
        '1 very low' => '1 ok dk',
        '2 low' => '2 dk',
        '3 normal' => '3 normal',
        '4 high' => '4 yksek',
        '5 very high' => '5 ok yksek',
        'Ticket "%s" created!' => '"%s" bileti oluturuldu!',
        'Ticket Number' => 'Bilet Numaras',
        'Ticket Object' => 'Bilet Nesnesi',
        'No such Ticket Number "%s"! Can\'t link it!' => '"%s" Bilet Numaras yok! Ona balanamaz!',
        'Don\'t show closed Tickets' => 'Kapal Biletleri gsterme',
        'Show closed Tickets' => 'Kapal Biletleri gster',
        'New Article' => 'Yeni Yaz',
        'Email-Ticket' => 'E-Posta-Bilet',
        'Create new Email Ticket' => 'Yeni E-Posta-Bilet olutur',
        'Phone-Ticket' => 'Telefon-Bilet',
        'Search Tickets' => 'Biletleri Ara',
        'Edit Customer Users' => 'Mteri Kullanclar Belirle',
        'Edit Customer Company' => '',
        'Bulk-Action' => 'Toplu lem',
        'Bulk Actions on Tickets' => 'Biletler zerinde Toplu lem',
        'Send Email and create a new Ticket' => 'E-Postay gnder ve yeni Bilet olutur',
        'Create new Email Ticket and send this out (Outbound)' => 'Yeni E-Posta-Bilet olutur ve bunu gnder (dar)',
        'Create new Phone Ticket (Inbound)' => 'Yeni Telefon-Bilet',
        'Overview of all open Tickets' => 'Tm ak Biletlere genel bak',
        'Locked Tickets' => 'Kilitli Biletler',
        'Watched Tickets' => 'zlenen Biletler',
        'Watched' => 'zlenen',
        'Subscribe' => 'Abone ol',
        'Unsubscribe' => 'Abonelikten k',
        'Lock it to work on it!' => 'zerinde almak iin kilitle!',
        'Unlock to give it back to the queue!' => 'Kilidini kaldr ve kuyrua geri ver!',
        'Shows the ticket history!' => 'Bilet gemiini gsterir!',
        'Print this ticket!' => 'Bu bileti yazdr!',
        'Change the ticket priority!' => 'Bilet nceliini deitir!',
        'Change the ticket free fields!' => 'Biletteki serbest alanlar deitir!',
        'Link this ticket to an other objects!' => 'Bu bileti baka nesnelere bala!',
        'Change the ticket owner!' => 'Bilet sahibini deitir!',
        'Change the ticket customer!' => 'Bilet mterisini deitir!',
        'Add a note to this ticket!' => 'Bu bilete bir not ekle!',
        'Merge this ticket!' => 'Bu bileti birletir!',
        'Set this ticket to pending!' => 'Bu bileti beklemeye al!',
        'Close this ticket!' => 'Bu bileti kapat!',
        'Look into a ticket!' => 'Bir bilete bak!',
        'Delete this ticket!' => 'Bu bileti sil!',
        'Mark as Spam!' => 'Spam (p) olarak iaretle!',
        'My Queues' => 'Kuyruklarm',
        'Shown Tickets' => 'Gsterilen Biletler',
        'Your email with ticket number "<OTRS_TICKET>" is merged to "<OTRS_MERGE_TO_TICKET>".' => '"<OTRS_TICKET>" bilet numaral e-postanz "<OTRS_MERGE_TO_TICKET>" ile birletirildi.',
        'Ticket %s: first response time is over (%s)!' => 'Bilet %s: ilk yant zaman ald (%s)!',
        'Ticket %s: first response time will be over in %s!' => 'Bilet %s: %s iinde ilk yant zaman alacak!',
        'Ticket %s: update time is over (%s)!' => 'Bilet %s: gncelleme zaman ald (%s)!',
        'Ticket %s: update time will be over in %s!' => 'Bilet %s: %s iinde gncelleme zaman alacak!',
        'Ticket %s: solution time is over (%s)!' => 'Bilet %s: zme zaman ald (%s)!',
        'Ticket %s: solution time will be over in %s!' => 'Bilet %s: %s iinde zme zaman alacak!',
        'There are more escalated tickets!' => 'Baka ykseltilmi biletler var!',
        'New ticket notification' => 'Yeni bilet bildirimi',
        'Send me a notification if there is a new ticket in "My Queues".' => '"Kuyruklarm"da yeni bir bilet olduunda bana bildirim gnder.',
        'Follow up notification' => 'Takip bildirimi',
        'Send me a notification if a customer sends a follow up and I\'m the owner of this ticket.' => 'Eer bu biletin sahibi bensem ve bir mteri takip eden mesaj gnderirse bana bildirim gnder.',
        'Ticket lock timeout notification' => 'Bilet kilidi zaman am bildirimi',
        'Send me a notification if a ticket is unlocked by the system.' => 'Bir biletin kilidi sistem tarafndan kaldrldnda bana bildirim gnder.',
        'Move notification' => 'Tama bildirimi',
        'Send me a notification if a ticket is moved into one of "My Queues".' => 'Bilet "Kuyruklarm"dan birine tandnda bana bildirim gnder',
        'Your queue selection of your favourite queues. You also get notified about those queues via email if enabled.' => 'Favori kuyruklarnzn seim kuyruu. Bu kuyruklar hakknda da e-posta yoluyla (eer aksa) bildirim alrsnz.',
        'Custom Queue' => 'zel Kuyruk',
        'QueueView refresh time' => 'Kuyruk Grnm tazeleme zaman',
        'Screen after new ticket' => 'Yeni Biletten sonraki ekran',
        'Select your screen after creating a new ticket.' => 'Yeni bir bilet oluturduktan sonra grmek istediiniz ekran sein.',
        'Closed Tickets' => 'Kapanm Biletler',
        'Show closed tickets.' => 'Kapanm biletleri gster.',
        'Max. shown Tickets a page in QueueView.' => 'Kuyruk Grnmnde bir sayfada gsterilecek en fazla Bilet says.',
        'CompanyTickets' => 'irket Biletleri',
        'MyTickets' => 'Biletlerim',
        'New Ticket' => 'Yeni Bilet',
        'Create new Ticket' => 'Yeni Bilet olutur',
        'Customer called' => 'Aranan mteri',
        'phone call' => 'telefon aramas',
        'Responses' => 'Yantlar',
        'Responses <-> Queue' => 'Yantlar <-> Kuyruk',
        'Auto Responses' => 'Otomatik Yantlar',
        'Auto Responses <-> Queue' => 'Otomatik Yantlar <-> Kuyruk',
        'Attachments <-> Responses' => 'Ekler <-> Yantlar',
        'History::Move' => 'Bilet "%s" (%s) kuyruuna tand, "%s" (%s) kuyruundan.',
        'History::TypeUpdate' => '"%s" (Kimlik=%s) tipi gncellendi.',
        'History::ServiceUpdate' => '"%s" (Kimlik=%s) servisi gncellendi.',
        'History::SLAUpdate' => '"%s" (Kimlik=%s) SLA gncellendi.',
        'History::NewTicket' => 'Yeni [%s] Bileti oluturuldu (Q=%s;P=%s;S=%s).',
        'History::FollowUp' => '[%s] iin takip. %s',
        'History::SendAutoReject' => '"%s" iin Otomatik Red gnderildi.',
        'History::SendAutoReply' => '"%s" iin Otomatik Yant gnderildi.',
        'History::SendAutoFollowUp' => '"%s" iin Otomatik Takip gnderildi.',
        'History::Forward' => '"%s" iletildi.',
        'History::Bounce' => '"%s" telendi.',
        'History::SendAnswer' => '"%s" iin e-posta gnderildi.',
        'History::SendAgentNotification' => '"%s"- "%s" iin aracya bildirim gnderildi.',
        'History::SendCustomerNotification' => '"%s" iin mteriye bildirim gnderildi .',
        'History::EmailAgent' => 'Aracya e-posta gnderildi.',
        'History::EmailCustomer' => 'Mteriye e-posta gnderildi. %s',
        'History::PhoneCallAgent' => 'Arac telefonla arand.',
        'History::PhoneCallCustomer' => 'Mteri telefonla arand.',
        'History::AddNote' => 'Not eklendi (%s)',
        'History::Lock' => 'Bilet kilitlendi.',
        'History::Unlock' => 'Bilet kilidi zld.',
        'History::TimeAccounting' => '%s zaman birimi hesapland. Toplam %s zaman birimi.',
        'History::Remove' => '%s',
        'History::CustomerUpdate' => 'Gncellendi: %s',
        'History::PriorityUpdate' => 'ncelik deitirildi. Eski: "%s" (%s), Yeni: "%s" (%s).',
        'History::OwnerUpdate' => 'Yeni sahip "%s" (Kimlik=%s).',
        'History::LoopProtection' => 'Dng Korumas! "%s" iin otomatik yant gnderilmedi.',
        'History::Misc' => '%s',
        'History::SetPendingTime' => 'Gncellendi: %s',
        'History::StateUpdate' => 'Eski: "%s" Yeni: "%s"',
        'History::TicketFreeTextUpdate' => 'Gncellendi: %s=%s;%s=%s;',
        'History::WebRequestCustomer' => 'Web zerinden Mteri stei.',
        'History::TicketLinkAdd' => '"%s" biletine kpr eklendi.',
        'History::TicketLinkDelete' => '"%s" biletine kpr silinde.',
        'History::Subscribe' => 'Added subscription for user "%s".',
        'History::Unsubscribe' => 'Removed subscription for user "%s".',

        # Template: AAAWeekDay
        'Sun' => 'Paz',
        'Mon' => 'Pzt',
        'Tue' => 'Sal',
        'Wed' => 'ar',
        'Thu' => 'Per',
        'Fri' => 'Cum',
        'Sat' => 'Cts',

        # Template: AdminAttachmentForm
        'Attachment Management' => 'Eklenti ynetimi',

        # Template: AdminAutoResponseForm
        'Auto Response Management' => 'Otomatik Yant Ynetimi',
        'Response' => 'Yant',
        'Auto Response From' => 'Otomatik Yantlayan',
        'Note' => 'Not',
        'Useable options' => 'Kullanlabilir seenekler',
        'To get the first 20 character of the subject.' => 'Konunun ilk 20 karakterini al',
        'To get the first 5 lines of the email.' => 'Elektronik postann ilk 5 satrn al',
        'To get the realname of the sender (if given).' => 'Gnderenin gerek adn al (verilmise)',
        'To get the article attribute (e. g. (<OTRS_CUSTOMER_From>, <OTRS_CUSTOMER_To>, <OTRS_CUSTOMER_Cc>, <OTRS_CUSTOMER_Subject> and <OTRS_CUSTOMER_Body>).' => 'Yaz niteliklerini al (rnein (<OTRS_CUSTOMER_From>, <OTRS_CUSTOMER_To>, <OTRS_CUSTOMER_Cc>, <OTRS_CUSTOMER_Subject> ve <OTRS_CUSTOMER_Body>).',
        'Options of the current customer user data (e. g. <OTRS_CUSTOMER_DATA_UserFirstname>).' => 'Mevcut mteri kullanc verisi seenekleri (rnein <OTRS_CUSTOMER_DATA_UserFirstname>).',
        'Ticket owner options (e. g. <OTRS_OWNER_UserFirstname>).' => 'Bilet sahibi seenekleri (rnein <OTRS_OWNER_UserFirstname>).',
        'Ticket responsible options (e. g. <OTRS_RESPONSIBLE_UserFirstname>).' => 'Bilet sorumlusu seenekleri (rnein <OTRS_RESPONSIBLE_UserFirstname>).',
        'Options of the current user who requested this action (e. g. <OTRS_CURRENT_UserFirstname>).' => 'Bu eyleme isteyen etkin kullanc seenekleri (rnein <OTRS_CURRENT_UserFirstname).',
        'Options of the ticket data (e. g. <OTRS_TICKET_TicketNumber>, <OTRS_TICKET_TicketID>, <OTRS_TICKET_Queue>, <OTRS_TICKET_State>).' => 'Bilet verisi seenekleri (rnein <OTRS_TICKET_TicketNumber>, <OTRS_TICKET_TicketID>, <OTRS_TICKET_Queue>, <OTRS_TICKET_State>).',
        'Config options (e. g. <OTRS_CONFIG_HttpType>).' => 'Yaplandrma seenekleri (rnein <OTRS_CONFIG_HttpType).',

        # Template: AdminCustomerCompanyForm
        'Customer Company Management' => 'Mteri irket Ynetimi',
        'Search for' => 'Ara',
        'Add Customer Company' => 'Mteri Sirket Ekle',
        'Add a new Customer Company.' => 'Yeni bir Mteri irket ekle.',
        'List' => 'Liste',
        'This values are required.' => 'Bu deerler gereklidir.',
        'This values are read only.' => 'Bu deerler salt-okunurdur.',

        # Template: AdminCustomerUserForm
        'Customer User Management' => 'Mteri Kullanc Ynetimi',
        'Add Customer User' => 'Mteri Kullanc Ekle',
        'Source' => 'Kaynak',
        'Create' => 'Olutur',
        'Customer user will be needed to have a customer history and to login via customer panel.' => 'Mteri kullanc bir mteri gemii ve mteri panelinden oturum amak iin gereklidir.',

        # Template: AdminCustomerUserGroupChangeForm
        'Customer Users <-> Groups Management' => 'Mteri Kullanclar <-> Grup Ynetimi',
        'Change %s settings' => '%s ayarlarn deitir',
        'Select the user:group permissions.' => 'Kullanc:grup izinlerini deitir.',
        'If nothing is selected, then there are no permissions in this group (tickets will not be available for the user).' => 'Eer hibirey seilmemise, bu grupta hi izin yoktu (biletler kullancya ak olmayacaktr).',
        'Permission' => 'zin',
        'ro' => 'so',
        'Read only access to the ticket in this group/queue.' => 'Bu grup/kuyruktaki bilete salt okunur eriim.',
        'rw' => 'oy',
        'Full read and write access to the tickets in this group/queue.' => 'Bu grup/kuyruktaki biletlere tam okuma ve yazma eriimi.',

        # Template: AdminCustomerUserGroupForm

        # Template: AdminCustomerUserService
        'Customer Users <-> Services Management' => 'Kullanc Mteriler <-> Servis Ynetimi',
        'CustomerUser' => 'MteriKullanc',
        'Service' => 'Servis',
        'Edit default services.' => 'Varsaylan servisleri belirle.',
        'Search Result' => 'Arama Sonu',
        'Allocate services to CustomerUser' => 'Servisleri MteriKullancya ata',
        'Active' => 'Etkin',
        'Allocate CustomerUser to service' => 'MteriKullancy servise ata',

        # Template: AdminEmail
        'Message sent to' => 'Mesaj gnderildi',
        'Recipents' => 'Alclar',
        'Body' => 'Gvde',
        'Send' => 'Gnder',

        # Template: AdminGenericAgent
        'GenericAgent' => 'GenelArac',
        'Job-List' => ' Listesi',
        'Last run' => 'Son altrma',
        'Run Now!' => 'imdi altr!',
        'x' => 'x',
        'Save Job as?' => 'i ne olarak kaydedeyim?',
        'Is Job Valid?' => ' geerli mi?',
        'Is Job Valid' => 'in geerli olup olmad',
        'Schedule' => 'Takvim',
        'Fulltext-Search in Article (e. g. "Mar*in" or "Baue*")' => 'Mesajda tam metin aramas (rnein "Ay*egl" veya "ak*r")',
        '(e. g. 10*5155 or 105658*)' => '(rnein 105155 veya 105658*)',
        '(e. g. 234321)' => '(rnein 234321)',
        'Customer User Login' => 'Mteri Kullanc Oturum Ama',
        '(e. g. U5150)' => '(rnein U5150)',
        'SLA' => 'SLA',
        'Agent' => 'Arac',
        'Ticket Lock' => 'Bilet Kilidi',
        'TicketFreeFields' => 'BiletSerbestAlanlar',
        'Create Times' => 'Oluturma Zamanlar',
        'No create time settings.' => 'Oluturma zaman ayar yok.',
        'Ticket created' => 'Bilet oluturuldu',
        'Ticket created between' => 'Bilet ikisi arasnda oluturuldu:',
        'Close Times' => '',
        'No close time settings.' => '',
        'Ticket closed' => '',
        'Ticket closed between' => '',
        'Pending Times' => 'Bekleme Zamanlar',
        'No pending time settings.' => 'Bekleme zaman ayar yok.',
        'Ticket pending time reached' => 'Bilet bekleme zamanna ulald',
        'Ticket pending time reached between' => 'Bilet bekleme zamanna ikisi arasnda ulald:',
        'New Service' => '',
        'New SLA' => '',
        'New Priority' => 'Yeni ncelik',
        'New Queue' => 'Yeni Kuyruk',
        'New State' => 'Yeni Durum',
        'New Agent' => 'Yeni Arac',
        'New Owner' => 'Yeni Sahip',
        'New Customer' => 'Yeni Mteri',
        'New Ticket Lock' => 'Yeni Bilet Kilidi',
        'New Type' => '',
        'New Title' => '',
        'New Type' => '',
        'New TicketFreeFields' => 'Yeni BiletSerbestAlanlar',
        'Add Note' => 'Not Ekle',
        'CMD' => 'Komut',
        'This command will be executed. ARG[0] will be the ticket number. ARG[1] the ticket id.' => 'Bu komut altrlacak. Par[0] bilet bilet numaras olacak. Par[1] bilet kimlii.',
        'Delete tickets' => 'Biletleri sil',
        'Warning! This tickets will be removed from the database! This tickets are lost!' => 'Uyar! Bu biletler veritabanndan silinecek! Geri dn yoktur!',
        'Send Notification' => 'Bildirim Gnder',
        'Param 1' => 'Param 1',
        'Param 2' => 'Param 2',
        'Param 3' => 'Param 3',
        'Param 4' => 'Param 4',
        'Param 5' => 'Param 5',
        'Param 6' => 'Param 6',
        'Send no notifications' => 'Bildirim gnderme',
        'Yes means, send no agent and customer notifications on changes.' => 'Evet, deiiklik durumunda araclar ve mterilere bildirim gnderme demektir.',
        'No means, send agent and customer notifications on changes.' => 'Hayr, deiikliklerde araclara ve mterilere bildirim gnder demektir.',
        'Save' => 'Kaydet',
        '%s Tickets affected! Do you really want to use this job?' => '%s Bilet etkilendi! Gerekten bu ii kullanmak istiyor musunuz?',
        '"}' => '',

        # Template: AdminGroupForm
        'Group Management' => 'Grup Ynetimi',
        'Add Group' => 'Grup Ekle',
        'Add a new Group.' => 'Yeni bir Grup ekle.',
        'The admin group is to get in the admin area and the stats group to get stats area.' => 'Ynetim grubu ynetim alanna ve istatistikler grubu istatistik alanna girmek iindir.',
        'Create new groups to handle access permissions for different groups of agent (e. g. purchasing department, support department, sales department, ...).' => 'Farkl arac gruplarnn (rnein satnalma blm, destek blm, sat blm, ...) eriim izinlerini dzenlemek iin yeni gruplar olutur.',
        'It\'s useful for ASP solutions.' => 'ASP zmleri iin kullanldr.',

        # Template: AdminLog
        'System Log' => 'Sistem Gnl',
        'Time' => 'Zaman',

        # Template: AdminMailAccount
        'Mail Account Management' => '',
        'Host' => 'Sunucu',
        'Trusted' => 'Gvenilir',
        'Dispatching' => 'Gnderiliyor',
        'All incoming emails with one account will be dispatched in the selected queue!' => 'Tek hesapl tm gelen elektronik postalar seili kuyrua gnderilecek!',
        'If your account is trusted, the already existing X-OTRS header at arrival time (for priority, ...) will be used! PostMaster filter will be used anyway.' => 'Eer hesap gvenilir ise, var zamannda (ncelik, ... iin) varolan X-OTRS bal kullanlacak! PostMaster szgeci her halkrda kullanlr.',

        # Template: AdminNavigationBar
        'Users' => 'Kullanclar',
        'Groups' => 'Gruplar',
        'Misc' => 'eitli',

        # Template: AdminNotificationForm
        'Notification Management' => 'Bildirim Ynetimi',
        'Notification' => 'Bildirimler',
        'Notifications are sent to an agent or a customer.' => 'Bildirimler bir aracya veya mteriye gnderilirler.',

        # Template: AdminPackageManager
        'Package Manager' => 'Paket Yneticisi',
        'Uninstall' => 'Kaldr',
        'Version' => 'Srm',
        'Do you really want to uninstall this package?' => 'Gerekten bu paketi kaldrmak istiyor musunuz?',
        'Reinstall' => 'Yeniden ykle',
        'Do you really want to reinstall this package (all manual changes get lost)?' => 'Gerekten bu paketi yeniden yklemek istiyor musunuz (elle yaptnz tm deiiklikler gider)?',
        'Continue' => 'Devam et',
        'Install' => 'Ykle',
        'Package' => 'Paket',
        'Online Repository' => 'evrimii Depo',
        'Vendor' => 'Salayc',
        'Upgrade' => 'Ykselt',
        'Local Repository' => 'Yerel Depo',
        'Status' => 'Durum',
        'Overview' => 'Genel Bak',
        'Download' => 'ndir',
        'Rebuild' => 'Yeniden na Et',
        'ChangeLog' => 'Deiiklik Gnl',
        'Date' => 'Tarih',
        'Filelist' => 'Dosya listesi',
        'Download file from package!' => 'Paketten dosya indir!',
        'Required' => 'Gerektirir',
        'PrimaryKey' => 'Ana Anahtar',
        'AutoIncrement' => 'Otomatik Arttr',
        'SQL' => 'SQL',
        'Diff' => 'Fark',

        # Template: AdminPerformanceLog
        'Performance Log' => 'Performans Gnl',
        'This feature is enabled!' => 'Bu zellik ak!',
        'Just use this feature if you want to log each request.' => 'Bu zellii sadece her istei gnle kaydetmek istiyorsanz kullann.',
        'Of couse this feature will take some system performance it self!' => 'Elbette bu zellik sistem performansndan biraz alr.',
        'Disable it here!' => 'Burada kapat!',
        'This feature is disabled!' => 'Bu zellik kapal!',
        'Enable it here!' => 'Burada a!',
        'Logfile too large!' => 'Gnlk dosyas ok byk!',
        'Logfile too large, you need to reset it!' => 'Gnlk dosyas ok byk, boaltmalsnz!',
        'Range' => 'Aralk',
        'Interface' => 'Arayz',
        'Requests' => 'stekler',
        'Min Response' => 'En Az Yant',
        'Max Response' => 'En ok Yant',
        'Average Response' => 'Ortalama Yant',
        'Period' => '',
        'Min' => '',
        'Max' => '',
        'Average' => '',

        # Template: AdminPGPForm
        'PGP Management' => 'PGP Ynetimi',
        'Result' => 'Sonu',
        'Identifier' => 'Tanmlayc',
        'Bit' => 'Bit',
        'Key' => 'Anahtar',
        'Fingerprint' => 'Parmak izi',
        'Expires' => 'Geerliliini yitirme zaman',
        'In this way you can directly edit the keyring configured in SysConfig.' => 'Bu ekilde Sistem Yaplandrmasnda yaplandrlm olan anahtar halkasn (keyring) direkt olarak dzenleyebilirsiniz.',

        # Template: AdminPostMasterFilter
        'PostMaster Filter Management' => 'PostMaster Szge Ynetimi',
        'Filtername' => 'Szge ad',
        'Match' => 'Eleen',
        'Header' => 'Balk',
        'Value' => 'Deer',
        'Set' => 'Kme',
        'Do dispatch or filter incoming emails based on email X-Headers! RegExp is also possible.' => 'Gelen elektronik postalar gnderme veya szme ilemini elektronik postadaki X-Balklarna gre yap! Dzenli ifadeler (RegExp) de kullanlabilir.',
        'If you want to match only the email address, use EMAILADDRESS:info@example.com in From, To or Cc.' => 'Sadece elektronik posta adresine gre eletirmek istiyorsanz Kimden, Kime veya Karbon Kopya alanlarnda EMAILADDRESS:bilgi@ornek.com kullann.',
        'If you use RegExp, you also can use the matched value in () as [***] in \'Set\'.' => 'Dzenli ifadeler (RegExp) kullanrsanz, \'Kme\' ksmnda eleen deer iin () yerine [***]da kullanabilirsiniz. ',

        # Template: AdminQueueAutoResponseForm
        'Queue <-> Auto Responses Management' => 'Kuyruk <-> Otomatik Yant Ynetimi',

        # Template: AdminQueueForm
        'Queue Management' => 'Kuyruk Ynetimi',
        'Sub-Queue of' => 'unun Alt Kuyruu:',
        'Unlock timeout' => 'Kilidi kaldrmak iin zaman am',
        '0 = no unlock' => '0 = kilit kaldrma yok',
        'Only business hours are counted.' => '',
        'Escalation - First Response Time' => 'Ykseltme - ilk Yant Zaman',
        '0 = no escalation' => '0 = ykseltme yok',
        'Only business hours are counted.' => '',
        'Notify by' => '',
        'Escalation - Update Time' => 'Ykseltme - Gncelleme Zaman',
        'Notify by' => '',
        'Escalation - Solution Time' => 'Ykseltme - zmleme Zaman',
        'Follow up Option' => 'Takip eden Seenei',
        'Ticket lock after a follow up' => 'Takip eden bir mesajdan sonra bileti kilitle',
        'Systemaddress' => 'Sistem adresi',
        'Customer Move Notify' => 'Mteri Tama Bildirimi',
        'Customer State Notify' => 'Mteri Durum Bildirimi',
        'Customer Owner Notify' => 'Mteri Sahip Bildirimi',
        'If an agent locks a ticket and he/she will not send an answer within this time, the ticket will be unlock automatically. So the ticket is viewable for all other agents.' => 'Eer bir arac bir bileti kilitler ve bu srede bir yant gndermezse, biletin kilidi otomatik olarak kaldrlr. Dolaysyla bilet dier tm araclara grnr hale gelir.',
        'Escalation time' => 'Ykseltme zaman',
        'If a ticket will not be answered in this time, just only this ticket will be shown.' => 'Eer bir bilet bu sre zarfnda yantlanmazsa, sadece bu bilet gsterilir.',
        'If a ticket is closed and the customer sends a follow up the ticket will be locked for the old owner.' => 'Eer bir bilet kapatlrsa ve ardndan mteri bir mesaj gnderirse, bilet eski sahibi iin kilitlenir.',
        'Will be the sender address of this queue for email answers.' => 'Elektronik posta yantlar iin bu kuyruun gnderen adresi olur.',
        'The salutation for email answers.' => 'Elektronik posta yantlar iin selamlama.',
        'The signature for email answers.' => 'Elektronik posta yantlar iin imza.',
        'OTRS sends an notification email to the customer if the ticket is moved.' => 'Eer bilet tanrsa OTRS mteriye bir bildirim e-postas gnderir.',
        'OTRS sends an notification email to the customer if the ticket state has changed.' => 'Eer bilet durumu deiirse OTRS mteriye bir bildirim e-postas gnderir.',
        'OTRS sends an notification email to the customer if the ticket owner has changed.' => 'Eer bilet sahibi deiirse OTRS mteriye bir bildirim e-postas gnderir.',

        # Template: AdminQueueResponsesChangeForm
        'Responses <-> Queue Management' => 'Yantlar <-> Kuyruk Ynetimi',

        # Template: AdminQueueResponsesForm
        'Answer' => 'Cevapla',

        # Template: AdminResponseAttachmentChangeForm
        'Responses <-> Attachments Management' => 'Yantlar <-> Ekler Ynetimi',

        # Template: AdminResponseAttachmentForm

        # Template: AdminResponseForm
        'Response Management' => 'Yant Ynetimi',
        'A response is default text to write faster answer (with default text) to customers.' => 'Bir yant, mterilere daha hzl cevap yazabilmek iin nceden hazrlanan metindir.',
        'Don\'t forget to add a new response a queue!' => 'Yeni bir yant bir kuyrua eklemeyi unutmayn!',
        'The current ticket state is' => 'Bilet durumu',
        'Your email address is new' => 'E-posta adresiniz yeni',

        # Template: AdminRoleForm
        'Role Management' => 'Rol Ynetimi',
        'Add Role' => 'Rol Ekle',
        'Add a new Role.' => 'Yeni bir Rol ekle.',
        'Create a role and put groups in it. Then add the role to the users.' => 'Bir rol oluturun ve iine gruplardan koyun. Sonra rolu kullanclara atayn.',
        'It\'s useful for a lot of users and groups.' => 'ok sayda kullanc ve grup iin kullanldr.',

        # Template: AdminRoleGroupChangeForm
        'Roles <-> Groups Management' => 'Roller <-> Gruplar Ynetimi',
        'move_into' => 'ta',
        'Permissions to move tickets into this group/queue.' => 'Biletleri bu gruba/kuyrua tama izni.',
        'create' => 'yarat',
        'Permissions to create tickets in this group/queue.' => 'Bu grupta/kuyrukta bilet oluturma izni.',
        'owner' => 'sahip',
        'Permissions to change the ticket owner in this group/queue.' => 'Bu grupta/kuyrukta bilet sahibini deitirme izni.',
        'priority' => 'ncelik',
        'Permissions to change the ticket priority in this group/queue.' => 'Bu grupta/kuyrukta bilet nceliini deitirme izni.',

        # Template: AdminRoleGroupForm
        'Role' => 'Rol',

        # Template: AdminRoleUserChangeForm
        'Roles <-> Users Management' => 'Roller <-> Kullanclar Ynetimi',
        'Select the role:user relations.' => 'Rol:kullanc ilikilerini sein.',

        # Template: AdminRoleUserForm

        # Template: AdminSalutationForm
        'Salutation Management' => 'Selamlama Ynetimi',
        'Add Salutation' => 'Selamlama Ekle',
        'Add a new Salutation.' => 'Yeni bir Selamlama ekle.',

        # Template: AdminSelectBoxForm
        'SQL Box' => '',
        'Limit' => 'Snr',
        'Go' => 'Devam',
        'Select Box Result' => 'Sein Kutusu Sonucu',

        # Template: AdminService
        'Service Management' => 'Servis Ynetimi',
        'Add Service' => 'Servis Ekle',
        'Add a new Service.' => 'Yeni bir Servis ekle.',
        'Sub-Service of' => 'unun Alt Servisi:',

        # Template: AdminSession
        'Session Management' => 'Oturum Ynetimi',
        'Sessions' => 'Oturumlar',
        'Uniq' => 'Tekil',
        'Kill all sessions' => 'Tm oturumlar ldr',
        'Session' => 'Oturum',
        'Content' => 'Ierik',
        'kill session' => 'oturumu ldr',

        # Template: AdminSignatureForm
        'Signature Management' => 'mza Ynetimi',
        'Add Signature' => 'mza Ekle',
        'Add a new Signature.' => 'Yeni bir mza ekle.',

        # Template: AdminSLA
        'SLA Management' => 'SLA Ynetimi',
        'Add SLA' => 'SLA ekle',
        'Add a new SLA.' => 'Yeni bir SLA ekle.',

        # Template: AdminSMIMEForm
        'S/MIME Management' => 'S/MIME Ynetimi',
        'Add Certificate' => 'Sertifika Ekle',
        'Add Private Key' => 'Kiisel Anahtar Ekle',
        'Secret' => 'Gizli',
        'Hash' => 'zel katar (hash)',
        'In this way you can directly edit the certification and private keys in file system.' => 'Buradan dosya sistemindeki sertifikalar ve kiisel anahtarlar uramadan dzenleyebilirsiniz.',

        # Template: AdminStateForm
        'State Management' => 'Durum Ynetimi',
        'Add State' => 'Durum Ekle',
        'Add a new State.' => 'Yeni bir Durum ekle.',
        'State Type' => 'Durum Tipi',
        'Take care that you also updated the default states in you Kernel/Config.pm!' => 'Kernel/Config.pm iindeki ntanml durumlar da deitirdiinizi unutmayn',
        'See also' => 'Ayrca baknz',

        # Template: AdminSysConfig
        'SysConfig' => 'Sistem Yaplandrmas',
        'Group selection' => 'Grup seimi',
        'Show' => 'Gster',
        'Download Settings' => 'ndirme Ayarlar',
        'Download all system config changes.' => 'Tm sistem yaplandrma deiikliklerini indir.',
        'Load Settings' => 'Ayarlar Ykle',
        'Subgroup' => 'Alt grup',
        'Elements' => 'eler',

        # Template: AdminSysConfigEdit
        'Config Options' => 'Yaplandrma Seenekleri',
        'Default' => 'ntanml',
        'New' => 'Yeni',
        'New Group' => 'Yeni Grup',
        'Group Ro' => 'Grup Ro',
        'New Group Ro' => 'Yeni Grup Ro',
        'NavBarName' => 'Dolama ubuu Ad',
        'NavBar' => 'Dolama ubuu',
        'Image' => 'Resim',
        'Prio' => 'ncelik',
        'Block' => 'Blok',
        'AccessKey' => 'Eriim Tuu',

        # Template: AdminSystemAddressForm
        'System Email Addresses Management' => 'Sistem E-Posta Adresleri Ynetimi',
        'Add System Address' => 'Sistem Adresi Ekle',
        'Add a new System Address.' => 'Yeni bir Sistem Adresi ekle.',
        'Realname' => 'Gerek ad',
        'All incoming emails with this "Email" (To:) will be dispatched in the selected queue!' => 'Bu e-posta adresinden gelen tm e-postalar seili kuyrua ynlendirilir.',

        # Template: AdminTypeForm
        'Type Management' => 'Tip Ynetimi',
        'Add Type' => 'Tip Ekle',
        'Add a new Type.' => 'Yeni bir Tip ekle.',

        # Template: AdminUserForm
        'User Management' => 'Kullanc Ynetimi',
        'Add User' => 'Kullanc Ekle',
        'Add a new Agent.' => 'Yeni bir Arac ekle.',
        'Login as' => 'Oturum ama kimlii',
        'Firstname' => 'Ad',
        'Lastname' => 'Soyad',
        'User will be needed to handle tickets.' => 'Biletlerle ilgilenmek iin kullanc gerekir.',
        'Don\'t forget to add a new user to groups and/or roles!' => 'Yeni kullanclar gruplara ve/veya rollere eklemeyi unutmayn!',

        # Template: AdminUserGroupChangeForm
        'Users <-> Groups Management' => 'Kullanclar <-> Gruplar Ynetimi',

        # Template: AdminUserGroupForm

        # Template: AgentBook
        'Address Book' => 'Adres Defteri',
        'Return to the compose screen' => 'Oluturma ekranna geri dn',
        'Discard all changes and return to the compose screen' => 'Tm deiiklikleri geri al ve oluturma ekranna geri dn',

        # Template: AgentCalendarSmall

        # Template: AgentCalendarSmallIcon

        # Template: AgentCustomerTableView

        # Template: AgentInfo
        'Info' => 'Bilgi',

        # Template: AgentLinkObject
        'Link Object' => 'Ba Nesnesi',
        'Select' => 'Se',
        'Results' => 'Sonular',
        'Total hits' => 'Toplam isabet',
        'Page' => 'Sayfa',
        'Detail' => 'Detay',

        # Template: AgentLookup
        'Lookup' => 'Ara',

        # Template: AgentNavigationBar

        # Template: AgentPreferencesForm

        # Template: AgentSpelling
        'Spell Checker' => 'Szdizim Denetleyicisi',
        'spelling error(s)' => 'szdizim hatas',
        'or' => 'veya',
        'Apply these changes' => 'Bu deiiklikleri uygula',

        # Template: AgentStatsDelete
        'Do you really want to delete this Object?' => 'Gerekten bu nesneyi silmek istiyor musunuz?',

        # Template: AgentStatsEditRestrictions
        'Select the restrictions to characterise the stat' => 'statistii kiiselletirmek iin kstlamalar sein',
        'Fixed' => 'Sabit',
        'Please select only one element or turn off the button \'Fixed\'.' => 'Ltfen sadece bir e sein veya \'Sabit\' dmesini kapatn.',
        'Absolut Period' => 'Belirli Sre',
        'Between' => 'Arasnda',
        'Relative Period' => 'Deiken Sre',
        'The last' => 'Son',
        'Finish' => 'Bitir',
        'Here you can make restrictions to your stat.' => 'Burada istatistiklerinize kstlamalar yapabilirsiniz.',
        'If you remove the hook in the "Fixed" checkbox, the agent generating the stat can change the attributes of the corresponding element.' => '"Sabit" kutusunun iaretini kaldrrsanz, istatistii oluturan arac karlk gelen enin niteliklerini deitirebilir.',

        # Template: AgentStatsEditSpecification
        'Insert of the common specifications' => 'Sadece ortak belirtimleri gir',
        'Permissions' => 'zinler',
        'Format' => 'Biim',
        'Graphsize' => 'Grafik boyutu',
        'Sum rows' => 'Toplam satrlar',
        'Sum columns' => 'Toplam stunlar',
        'Cache' => 'Tampon',
        'Required Field' => 'Gerekli alan',
        'Selection needed' => 'Seim gerekli',
        'Explanation' => 'Aklama',
        'In this form you can select the basic specifications.' => 'Bu formda temel belirtimleri seebilirsiniz.',
        'Attribute' => 'Nitelik',
        'Title of the stat.' => 'statistiin bal.',
        'Here you can insert a description of the stat.' => 'Buraya istatistie bir aklama girebilirsiniz.',
        'Dynamic-Object' => 'Dinamik Nesne',
        'Here you can select the dynamic object you want to use.' => 'Burada kullanmak istediiniz dinamik nesneyi seebilirsiniz.',
        '(Note: It depends on your installation how many dynamic objects you can use)' => '(Not: Ka dinamik nesne kullanabileceiniz kurulumunuza baldr)',
        'Static-File' => 'Sabit Dosya',
        'For very complex stats it is possible to include a hardcoded file.' => 'ok karmak istatistikler sz konusu olduunda nceden hazrlanm bir dosyay da dahil etmek mmkndr.',
        'If a new hardcoded file is available this attribute will be shown and you can select one.' => 'Eer nceden hazrlanm bir dosya bulunursa bu nitelik gsterilir ve birini seebilirsiniz.',
        'Permission settings. You can select one or more groups to make the configurated stat visible for different agents.' => 'zin ayarlar. Ayarlanan istatistiin farkl araclara grnr olmas iin bir veya daha fazla grup seebilirsiniz.',
        'Multiple selection of the output format.' => 'kt biimi iin birden fazla seim.',
        'If you use a graph as output format you have to select at least one graph size.' => 'Eer kt biimi olana bir grafik seerseniz en azndan bir grafik boyutu semelisiniz.',
        'If you need the sum of every row select yes' => 'Her satrn toplanmasn istiyorsanz \'Evet\'i sein',
        'If you need the sum of every column select yes.' => 'Her stunun toplanmasn istiyorsanz \'Evet\'i sein.',
        'Most of the stats can be cached. This will speed up the presentation of this stat.' => 'statistiklerin ounluu nbelleklenebilir. Bu, bu istatistiin sunulmasn hzlandrr.',
        '(Note: Useful for big databases and low performance server)' => '(Not: Byk veritaban ve dk performansl sunucularda kullanldr)',
        'With an invalid stat it isn\'t feasible to generate a stat.' => 'Geersiz bir istatistikle, istatistik oluturmak mmkn olmaz.',
        'This is useful if you want that no one can get the result of the stat or the stat isn\'t ready configurated.' => 'Eer istatistik sonularnn kimseye ak olmamasn veya istatistiin yaplandrlmam olmamasn istiyorsanz bu seenek kullanldr.',

        # Template: AgentStatsEditValueSeries
        'Select the elements for the value series' => 'Deer serileri iin eleri sein',
        'Scale' => 'lek',
        'minimal' => 'mmkn olan en dk',
        'Please remember, that the scale for value series has to be larger than the scale for the X-axis (e.g. X-Axis => Month, ValueSeries => Year).' => 'Unutmayn deer serilerinin lei X-ekseninin leinden daha yksek olmaldr (rnein X-ekseni => Ay, Deer Serileri => Yl).',
        'Here you can define the value series. You have the possibility to select one or two elements. Then you can select the attributes of elements. Each attribute will be shown as single value series. If you don\'t select any attribute all attributes of the element will be used if you generate a stat. As well a new attribute is added since the last configuration.' => 'Burada deer serilerini seebilirsiniz. Bir veya iki e seebilirsiniz. Sonra elerin niteliklerini seebilirsiniz. Her nitelik tek deer serileri olarak gsterilir. Eer herhangi bir nitelik semeden istatistik oluturursanz enin tm nitelikleri kullanlr.  Son yaplandrmadan sonra yeni bir nitelik eklendiinde de.',

        # Template: AgentStatsEditXaxis
        'Select the element, which will be used at the X-axis' => 'X-ekseni olarak kullanlacak eyi sein.',
        'maximal period' => 'en yksek sre',
        'minimal scale' => 'en dk lek',
        'Here you can define the x-axis. You can select one element via the radio button. Then you you have to select two or more attributes of the element. If you make no selection all attributes of the element will be used if you generate a stat. As well a new attribute is added since the last configuration.' => 'Burada X eksenini belirleyebilirsiniz. Radyo dmesiyle bir e seebilirsiniz. Sonra enin iki veya daha fazla niteliini semelisiniz. Herhangi bir seim yapmadan bir istatistik oluturursanz enin tm nitelikleri kullanlr. Son yaplandrmadan sonra bir nitelik eklendiinde de.',

        # Template: AgentStatsImport
        'Import' => 'eri aktar',
        'File is not a Stats config' => 'Dosya bir statistik yaplandrmas deil',
        'No File selected' => 'Dosya seilmedi',

        # Template: AgentStatsOverview
        'Object' => 'Nesne',

        # Template: AgentStatsPrint
        'Print' => 'Yazdr',
        'No Element selected.' => 'e seilmedi.',

        # Template: AgentStatsView
        'Export Config' => 'Yaplandrmay Dar Aktar',
        'Information about the Stat' => 'statistik hakknda bilgi',
        'Exchange Axis' => 'Eksenlerin Yerini Deitir',
        'Configurable params of static stat' => 'Deimez istatistiin ayarlanabilir parametreleri',
        'No element selected.' => 'e seilmedi.',
        'maximal period from' => 'en yksek sre undan:',
        'to' => 'una:',
        'Start' => 'Bala',
        'With the input and select fields you can configurate the stat at your needs. Which elements of a stat you can edit depends on your stats administrator who configurated the stat.' => 'Giri ve seme alanlaryla istatistii istediiniz gibi ayarlayabilirsiniz. statistiin hangi elerini deitrebileceiniz istatistii ayarlayan istatistik yneticisine baldr',

        # Template: AgentTicketBounce
        'Bounce ticket' => 'Bileti tele',
        'Ticket locked!' => 'Bilet kilitlendi!',
        'Ticket unlock!' => 'Biletin kilidi ald!',
        'Bounce to' => 'una tele:',
        'Next ticket state' => 'Biletin sonraki durumu',
        'Inform sender' => 'Gndereni bilgilendir',
        'Send mail!' => 'Postay gnder!',

        # Template: AgentTicketBulk
        'Ticket Bulk Action' => 'Bilet Toplu lemi',
        'Spell Check' => 'Szdizim Kontrol',
        'Note type' => 'Not tipi',
        'Unlock Tickets' => 'Biletlerin kilidini a',

        # Template: AgentTicketClose
        'Close ticket' => 'Bileti kapat',
        'Previous Owner' => 'nceki sahip',
        'Inform Agent' => 'Aracy bilgilendir',
        'Optional' => 'Seimlik',
        'Inform involved Agents' => 'lgili araclar bilgilendir',
        'Attach' => 'Ekle',
        'Next state' => 'Sonraki durum',
        'Pending date' => 'Bekleme tarihi',
        'Time units' => 'Zaman birimleri',

        # Template: AgentTicketCompose
        'Compose answer for ticket' => 'Bilete cevap yaz',
        'Pending Date' => 'Bekleme tarihi',
        'for pending* states' => 'Bekleme* durumlar iin',

        # Template: AgentTicketCustomer
        'Change customer of ticket' => 'Biletin mterisini deitir',
        'Set customer user and customer id of a ticket' => 'Bir biletin mteri kullancsn ve mteri kimliini belirle',
        'Customer User' => 'Mteri Kullanc',
        'Search Customer' => 'Kullanc Ara',
        'Customer Data' => 'Mteri Verisi',
        'Customer history' => 'Mteri tarihesi',
        'All customer tickets.' => 'Tm mteri biletleri.',

        # Template: AgentTicketCustomerMessage
        'Follow up' => 'Takip',

        # Template: AgentTicketEmail
        'Compose Email' => 'E-Posta Yaz',
        'new ticket' => 'yeni bilet',
        'Refresh' => 'Tazele',
        'Clear To' => 'Kime alann temizle',

        # Template: AgentTicketEscalationView
        'Ticket Escalation View' => '',
        'Escalation' => '',
        'Today' => '',
        'Tomorrow' => '',
        'Next Week' => '',
        'up' => 'yukar',
        'down' => 'aa',
        'Escalation' => '',
        'Locked' => 'Kilitli',

        # Template: AgentTicketForward
        'Article type' => 'Metin tipi',

        # Template: AgentTicketFreeText
        'Change free text of ticket' => 'Biletin serbest metnini deitir',

        # Template: AgentTicketHistory
        'History of' => 'unun tarihesi:',

        # Template: AgentTicketLocked

        # Template: AgentTicketMailbox
        'Mailbox' => 'Posta kutusu',
        'Tickets' => 'Biletler',
        'of' => '..nn',
        'Filter' => 'Szge',
        'New messages' => 'Yeni mesajlar',
        'Reminder' => 'Hatrlatc',
        'Sort by' => 'una gre srala:',
        'Order' => 'Sralama',

        # Template: AgentTicketMerge
        'Ticket Merge' => 'Bilet Birletir',
        'Merge to' => 'una birletir:',

        # Template: AgentTicketMove
        'Move Ticket' => 'Bileti Ta',

        # Template: AgentTicketNote
        'Add note to ticket' => 'Bilete not ekle',

        # Template: AgentTicketOwner
        'Change owner of ticket' => 'Biletin sahibini deitir',

        # Template: AgentTicketPending
        'Set Pending' => 'Beklemeyi Ayarla',

        # Template: AgentTicketPhone
        'Phone call' => 'Telefon aras',
        'Clear From' => 'Gnderen ksmn temizle',

        # Template: AgentTicketPhoneOutbound

        # Template: AgentTicketPlain
        'Plain' => 'Dz',

        # Template: AgentTicketPrint
        'Ticket-Info' => 'Bilet Bilgisi',
        'Accounted time' => 'Hesaplanan zaman',
        'First Response Time' => 'lk Yant Zaman',
        'Update Time' => 'Gncelleme Zaman',
        'Solution Time' => 'zm Zaman',
        'Linked-Object' => 'Bal Nesne',
        'Parent-Object' => 'Ebeveyn Nesne',
        'Child-Object' => 'Alt Nesne',
        'by' => 'tarafndan',

        # Template: AgentTicketPriority
        'Change priority of ticket' => 'Biletin nceliini deitir',

        # Template: AgentTicketQueue
        'Tickets shown' => 'Gsterilen biletler',
        'Tickets available' => 'Uygun biletler',
        'All tickets' => 'Tm biletler',
        'Queues' => 'Kuyruklar',
        'Ticket escalation!' => 'Bilet Ykseltme!',

        # Template: AgentTicketQueueTicketView
        'Service Time' => 'Servis Zaman',
        'Your own Ticket' => 'Kendi Biletiniz',
        'Compose Follow up' => 'Takip mesaj yaz',
        'Compose Answer' => 'Cevap yaz',
        'Contact customer' => 'Mteriyle balant kur',
        'Change queue' => 'Kuyruu deitir',

        # Template: AgentTicketQueueTicketViewLite

        # Template: AgentTicketResponsible
        'Change responsible of ticket' => 'Biletin sorumlusunu deitir',

        # Template: AgentTicketSearch
        'Ticket Search' => 'Bilet ara',
        'Profile' => 'Profil',
        'Search-Template' => 'Arama ablonu',
        'TicketFreeText' => 'BiletSerbestMetni',
        'Created in Queue' => 'Oluturuldu Kuyruk',
        'Close Times' => '',
        'No close time settings.' => '',
        'Ticket closed' => '',
        'Ticket closed between' => '',
        'Result Form' => 'Sonu Formu',
        'Save Search-Profile as Template?' => 'Arama Profili ablon olarak kaydedilsin mi?',
        'Yes, save it with name' => 'Evet, u adla kaydet',

        # Template: AgentTicketSearchOpenSearchDescription

        # Template: AgentTicketSearchResult
        'Change search options' => 'Arama seeneklerini deitir',

        # Template: AgentTicketSearchResultPrint
        '"}' => '',

        # Template: AgentTicketSearchResultShort

        # Template: AgentTicketStatusView
        'Ticket Status View' => 'Bilet Durumu Grnm',
        'Open Tickets' => 'Ak Biletler',

        # Template: AgentTicketZoom
        'Expand View' => '',
        'Collapse View' => '',

        # Template: AgentWindowTab

        # Template: AJAX

        # Template: Copyright

        # Template: css

        # Template: customer-css

        # Template: CustomerAccept

        # Template: CustomerCalendarSmallIcon

        # Template: CustomerError
        'Traceback' => 'Geriiz',

        # Template: CustomerFooter
        'Powered by' => '',

        # Template: CustomerFooterSmall

        # Template: CustomerHeader

        # Template: CustomerHeaderSmall

        # Template: CustomerLogin
        'Login' => 'Oturum a',
        'Lost your password?' => 'Parolanz m kaybettiniz?',
        'Request new password' => 'Yeni parola iste',
        'Create Account' => 'Hesap olutur',

        # Template: CustomerNavigationBar
        'Welcome %s' => 'Hogeldin %s',

        # Template: CustomerPreferencesForm

        # Template: CustomerStatusView

        # Template: CustomerTicketMessage

        # Template: CustomerTicketPrint

        # Template: CustomerTicketSearch
        'Times' => 'Zaman',
        'No time settings.' => 'Zaman ayar yok.',

        # Template: CustomerTicketSearchResultCSV

        # Template: CustomerTicketSearchResultPrint

        # Template: CustomerTicketSearchResultShort

        # Template: CustomerTicketZoom

        # Template: CustomerWarning

        # Template: Error
        'Click here to report a bug!' => 'Hata raporlamak iin buraya tklayn!',

        # Template: Footer
        'Top of Page' => 'Yukar',

        # Template: FooterSmall

        # Template: Header

        # Template: HeaderSmall

        # Template: Installer
        'Web-Installer' => 'Webden Ykleme',
        'Welcome to %s' => '%s sistemine hogeldiniz',
        'Accept license' => 'Lisans kabul et',
        'Don\'t accept license' => 'Lisans kabul etme',
        'Admin-User' => 'Ynetici Kullanc',
        'If you have set a root password for your database, it must be entered here. If not, leave this field empty. For security reasons we do recommend setting a root password. For more information please refer to your database documentation.' => '',
        'Admin-Password' => 'Ynetici Parolas',
        'Database-User' => 'Veritaban kullancs',
        'default \'hot\'' => 'varsaylan \'host\'',
        'DB connect host' => 'Veritabanna balanan sunucu',
        'Database' => 'Veritaban',
        'Default Charset' => 'ntanml karakter kmesi',
        'utf8' => '',
        'false' => 'false',
        'SystemID' => 'Sistem Kimlii',
        '(The identify of the system. Each ticket number and each http session id starts with this number)' => '(Sistemin kimlii. Her bilet numaras ve her http oturum kimlii bu numarayla balar)',
        'System FQDN' => 'Sistem tam adresi (FQDN)',
        '(Full qualified domain name of your system)' => '(Sisteminizin eksiksiz sunucu adresi (FQDN))',
        'AdminEmail' => 'Ynetici E-Posta Adresi',
        '(Email of the system admin)' => '(Sistem yneticisinin e-posta adresi)',
        'Organization' => 'Kurulu',
        'Log' => 'Gnlk',
        'LogModule' => 'Gnlk Bileeni',
        '(Used log backend)' => '(Kullanlan gnlk arkaucu)',
        'Logfile' => 'Gnlk dosyas',
        '(Logfile just needed for File-LogModule!)' => '(Gnlk dosyas sadece gnlk bileeni Dosya olduunda gereklidir!)',
        'Webfrontend' => 'Web nyz',
        'Use utf-8 it your database supports it!' => 'Eer veritabannz destekliyorsa utf-8 kullann!',
        'Default Language' => 'ntanml dil',
        '(Used default language)' => '(Kullanlan ntanml dil)',
        'CheckMXRecord' => 'MX Kaytlarn Kontrol Et',
        '(Checks MX recordes of used email addresses by composing an answer. Don\'t use CheckMXRecord if your OTRS machine is behinde a dial-up line $!)' => '(Kullanlan e-posta adreslerinin MX kaytlarn bir cevap yazarak kontrol eder. Eer OTRS sisteminiz evirmeli bir an arkasndaysa kullanmayn!)',
        'To be able to use OTRS you have to enter the following line in your command line (Terminal/Shell) as root.' => 'OTRS\'yi kullanabilmek iin komut satrnda (konsol/kabuk/terminal) root kullancs olarak u satr girmelisiniz.',
        'Restart your webserver' => 'Web sunucunuzu yeniden balatn.',
        'After doing so your OTRS is up and running.' => 'Bunu yaptktan sonra OTRS alyor olacak.',
        'Start page' => 'Balang sayfas',
        'Your OTRS Team' => 'OTRS Takmnz',

        # Template: Login

        # Template: Motd

        # Template: NoPermission
        'No Permission' => 'zin yok',

        # Template: Notify
        'Important' => 'nemli',

        # Template: PrintFooter
        'URL' => 'Adres (URL)',

        # Template: PrintHeader
        'printed by' => 'yazdran',

        # Template: Redirect

        # Template: Test
        'OTRS Test Page' => 'OTRS Test Sayfas',
        'Counter' => 'Saya',

        # Template: Warning
        # Misc
        'Create Database' => 'Veritabann Olutur',
        'verified' => 'onayland',
        'File-Name' => 'Dosya ad',
        'Ticket Number Generator' => 'Bilet Numaras reteci',
        '(Ticket identifier. Some people want toset this to e. g. \'Ticket#\', \'Call#\' or \'MyTicket#\')' => '(Bilet tanmlaycs. \'Bilet#\', \'Arama#\' oder \'Biletim#\' gibi olabilir)',
        'In this way you can directly edit the keyring configured in Kernel/Config.pm.' => 'Bu ekilde Kernel/Config.pm dosyasnda yaplandrlm olan anahtar halkasn (keyring) deitirebilirsiniz',
        'Create new Phone Ticket' => 'Yeni Telefon Bileti olutur',
        'U' => 'U',
        'A message should have a To: recipient!' => 'Bir mesajn alcs olmaldr!',
        'Site' => 'Site',
        'Customer history search (e. g. "ID342425").' => 'Mteri tarihe aramas (rn. "ID342425").',
        'your MySQL DB should have a root password! Default is empty!' => 'MySQL veritabannzn root kullancsnn bir parolas olmaldr. ntanml olarak botur!',
        'Close!' => 'Kapat!',
        'for agent firstname' => 'arac ad iin',
        'Reporter' => 'Bildiren',
        'The message being composed has been closed.  Exiting.' => 'Oluturulan mesaj kapatld. klyor.',
        'Process-Path' => 'lem Yolu',
        'to get the realname of the sender (if given)' => 'gndericinin gerek adn (eer verilmise) almak iin',
        'FAQ Search Result' => 'SSS Arama Sonucu',
        'Notification (Customer)' => 'Bildirim (mteri)',
        'CSV' => 'CSV',
        'Select Source (for add)' => 'Kayna Sein (eklemek iin)',
        'Node-Name' => 'Dm Ad',
        'Options of the ticket data (e. g. &lt;OTRS_TICKET_Number&gt;, &lt;OTRS_TICKET_ID&gt;, &lt;OTRS_TICKET_Queue&gt;, &lt;OTRS_TICKET_State&gt;)' => 'Bilet verisinin seenekleri (rn. &lt;OTRS_TICKET_Number&gt;, &lt;OTRS_TICKET_ID&gt;, &lt;OTRS_TICKET_Queue&gt;, &lt;OTRS_TICKET_State&gt;)',
        'Home' => 'Ana sayfa',
        'Workflow Groups' => 'alma ak Gruplar',
        'Current Impact Rating' => 'u Andaki Etki Oran',
        'Config options (e. g. <OTRS_CONFIG_HttpType>)' => 'Yaplandrma seenekleri (rn. <OTRS_CONFIG_HttpType>)',
        'FAQ System History' => 'SSS Sistemi Tarihesi',
        'customer realname' => 'mterinin gerek ad',
        'Pending messages' => 'Bekleyen mesajlar',
        'Modules' => 'Bileenler',
        'for agent login' => 'arac oturumu iin',
        'Keyword' => 'Anahtar kelime',
        'Reference' => 'Referans',
        'with' => 'ile',
        'Close type' => 'Tipi kapat',
        'DB Admin User' => 'Veritaban Yneticisi Kullanc',
        'for agent user id' => 'arac kullanc kimlii iin',
        'sort upward' => 'yukar doru srala',
        'Classification' => 'Sralama',
        'Change user <-> group settings' => 'Kullanc <-> grup seeneklerini deitir',
        'next step' => 'sonraki adm',
        'Customer history search' => 'Mteri tarihe aramas',
        'not verified' => 'onaylanmad',
        'Stat#' => 'statistik numaras',
        'Create new database' => 'Yeni veritaban olutur',
        'Year' => 'Yl',
        'A message must be spell checked!' => 'Mesajn szyazm kontrolnden gemesi gereki!',
        'X-axis' => 'X-Ekseni',
        'Your email with ticket number "<OTRS_TICKET>" is bounced to "<OTRS_BOUNCE_TO>". Contact this address for further information.' => '"<OTRS_TICKET>" bilet numaral e-postanz "<OTRS_BOUNCE_TO>" adresine gnderildi. Daha fazla bilgi iin bu adresle balantya gein.',
        'A message should have a body!' => 'Mesajn bir gvdesi olmaldr!',
        'All Agents' => 'Tm Araclar',
        'Keywords' => 'Anahtar Kelimeler',
        'No * possible!' => '"*" kullanlamaz!',
        'Load' => 'Ykle',
        'Change Time' => 'Deiiklik Zaman',
        'Options of the current user who requested this action (e. g. &lt;OTRS_CURRENT_USERFIRSTNAME&gt;)' => 'Bu eylemi isteyen kulancnn (rn. &lt;OTRS_CURRENT_USERFIRSTNAME&gt;) seenekleri',
        'Message for new Owner' => 'Yeni Sahibine mesaj',
        'to get the first 5 lines of the email' => 'e-postann ilk be satrn almak iin',
        'OTRS DB Password' => 'OTRS Veritaban Parolas',
        'Last update' => 'Son gncelleme',
        'not rated' => 'puan verilmedi',
        'to get the first 20 character of the subject' => 'konunun ilk 20 karakterini almak iin',
        'Select the customeruser:service relations.' => 'Mterikullanc:servis ilikilerini belirle.',
        'DB Admin Password' => 'Veritaban Yneticisi Parolas',
        'Drop Database' => 'Veritabann Sil',
        'Options of the current customer user data (e. g. <OTRS_CUSTOMER_DATA_UserFirstname>)' => 'Mevcut mteri kullanc verileri (rn. <OTRS_CUSTOMER_DATA_UserFirstname>) seenekleri',
        'Pending type' => 'Bekleme tipi',
        'Comment (internal)' => 'Yorum (i)',
        'Ticket owner options (e. g. &lt;OTRS_OWNER_USERFIRSTNAME&gt;)' => 'Bilet sahibi seenekleri (rn. &lt;OTRS_OWNER_USERFIRSTNAME&gt;)',
        'This window must be called from compose window' => 'Bu pencere \'yeni mesaj\' penceresinden almaldr',
        'User-Number' => 'Kullanc Numaras',
        'You need min. one selected Ticket!' => 'En az bir Bilet seili olmaldr!',
        'Options of the ticket data (e. g. <OTRS_TICKET_Number>, <OTRS_TICKET_ID>, <OTRS_TICKET_Queue>, <OTRS_TICKET_State>)' => 'Bilet verisi seenekleri (rn. <OTRS_TICKET_Number>, <OTRS_TICKET_ID>, <OTRS_TICKET_Queue>, <OTRS_TICKET_State>)',
        '(Used ticket number format)' => '(Kullanlan bilet numaras biimi)',
        'Fulltext' => 'Tmmetin',
        'Month' => 'Ay',
        'Node-Address' => 'Dm Adresi',
        'All Agent variables.' => 'Tm Arac deikenleri',
        ' (work units)' => ' (i birimi)',
        'You use the DELETE option! Take care, all deleted Tickets are lost!!!' => 'SL seeneini kullandnz! Silinen Biletlerin kurtarlamayacan unutmayn!!!',
        'All Customer variables like defined in config option CustomerUser.' => 'Mteri Kullanc yaplandrma seeneinde tanmland ekliyle tm Mteri deikenleri.',
        'for agent lastname' => 'arac soyad iin',
        'Options of the current user who requested this action (e. g. <OTRS_CURRENT_UserFirstname>)' => 'Bu eylem iin istekte bulunan kullancnn seenekleri (rn. <OTRS_CURRENT_UserFirstname>)',
        'Reminder messages' => 'Hatrlatc mesajlar',
        'A message should have a subject!' => 'Bir mesajn bir konusu olmaldr!',
        'TicketZoom' => 'Bilet Detaylar',
        'Don\'t forget to add a new user to groups!' => 'Yeni kullancy gruplara atamay unutmayn!',
        'You need a email address (e. g. customer@example.com) in To:!' => 'Kime ksmnda bir e-posta adresi (rn. musteri@ornek.com) olmaldr!',
        'CreateTicket' => 'Bilet Olutur',
        'unknown' => 'bilinmiyor',
        'You need to account time!' => 'Zaman hesaba katmalsnz!',
        'System Settings' => 'Sistem Ayarlar',
        'Finished' => 'Tamamland',
        'Imported' => 'eri aktarld',
        'unread' => 'okunmad',
        'Split' => 'Ayr',
        'D' => 'D',
        'System Status' => 'Sistem Durumu',
        'All messages' => 'Tm mesajlar',
        'Options of the ticket data (e. g. <OTRS_TICKET_TicketNumber>, <OTRS_TICKET_ID>, <OTRS_TICKET_Queue>, <OTRS_TICKET_State>)' => 'Bilet verisi seenekleri (rn. <OTRS_TICKET_TicketNumber>, <OTRS_TICKET_ID>, <OTRS_TICKET_Queue>, <OTRS_TICKET_State>)',
        'A article should have a title!' => 'Metnin bir bal olmaldr!',
        'Customer Users <-> Services' => 'Mteri Kullanclar <-> Servisler',
        'This account exists' => 'Bu hesap zaten var',
        'Config options (e. g. &lt;OTRS_CONFIG_HttpType&gt;)' => 'Yaplandrma seenekleri (rn. &lt;OTRS_CONFIG_HttpType&gt;)',
        'Event' => 'Olay',
        'Imported by' => 'eri aktaran',
        'Ticket owner options (e. g. <OTRS_OWNER_UserFirstname>)' => 'Bilet sahibi seenekleri (rn. <OTRS_OWNER_UserFirstname>)',
        'read' => 'okunmu',
        'Product' => 'rn',
        'Name is required!' => 'Ad gerekli!',
        'kill all sessions' => 'tm oturumlar sonlandr',
        'to get the from line of the email' => 'e-postann \'kime\' alann almak iin',
        'Solution' => 'zm',
        'QueueView' => 'Kuyruk Grnm',
        'My Queue' => 'Kuyruun',
        'Select Box' => 'Seim Kutusu',
        'Instance' => 'Kopya',
        'Day' => 'Gn',
        'Service-Name' => 'Servis Ad',
        'Welcome to OTRS' => 'OTRS\'ye hogeldiniz',
        'tmp_lock' => 'geici kilit',
        'modified' => 'deitirilmi',
        'Escalation in' => 'Ykselme',
        'Delete old database' => 'Eski veritabann sil',
        'sort downward' => 'aaya doru srala',
        'You need to use a ticket number!' => 'Bilet numaras kullanmalsnz!',
        'Watcher' => 'zleyici',
        'Have a lot of fun!' => 'yi elenceler!',
        'send' => 'gnder',
        'Note Text' => 'Not Metni',
        'POP3 Account Management' => 'POP3 Hesap Ynetimi',
        'Options of the current customer user data (e. g. &lt;OTRS_CUSTOMER_DATA_USERFIRSTNAME&gt;)' => 'Muteri kullanc verisi seenekleri (rn. &lt;OTRS_CUSTOMER_DATA_USERFIRSTNAME&gt;).',
        'System State Management' => 'Sistem Durumu Ynetimi',
        'PhoneView' => 'Telefon Grn',
        'User-Name' => 'Kullanc Ad',
        'File-Path' => 'Dosya Yolu',
        'Modified' => 'Deitirildi',
        'Ticket selected for bulk action!' => 'Bilet toplu ilem iin seildi',

        'Link Object: %s' => '',
        'Unlink Object: %s' => '',
        'Linked as' => '',
        'Can not create link with %s!' => '',
        'Can not delete link with %s!' => '',
        'Object already linked as %s.' => '',
        'Priority Management' => '',
        'Add a new Priority.' => '',
        'Add Priority' => '',
        'Ticket Type is required!' => '',
        'Module documentation' => '',
        'Added!' => '',
        'Updated!' => '',
    };
    # $$STOP$$
    return;
}

1;
