/*
 * Copyright (c) 1997-2001 The University of Utah and the Flux Group.
 * 
 * This file is part of the OSKit Linux Glue Libraries, which are free
 * software, also known as "open source;" you can redistribute them and/or
 * modify them under the terms of the GNU General Public License (GPL),
 * version 2, as published by the Free Software Foundation (FSF).
 * 
 * The OSKit is distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GPL for more details.  You should have
 * received a copy of the GPL along with the OSKit; see the file COPYING.  If
 * not, write to the FSF, 59 Temple Place #330, Boston, MA 02111-1307, USA.
 */
/*
 * Global symbol definitions to be included in all Linux dev code.
 * These defines add FDEV_LINUX_ prefixes to global Linux symbols
 * to ensure namespace cleanliness and prevent linking conflicts.
 * The Linux drivers themselves and the Linux glue code
 * should still continue to use the unprefixed names.
 */
/*
 * This was generated via:
 *

i486-linux-nm liboskit_linux_dev.a | grep ' [TDRC] ' | egrep -vi ' (oskit_|fdev_)' | awk '{ printf "#define "$3" FDEV_LINUX_"$3"\n" }' | sort > ! ~/oskit/linux/dev/global.h

 *
 * Note that if the .a file is a.out then you will need to remove leading
 * underscores.
 */
#ifndef _LINUX_DEV_GLOBAL_H_
#define _LINUX_DEV_GLOBAL_H_

#ifdef OSKIT_ARM32_SHARK
#define strnlen FDEV_LINUX_strnlen
#define memzero bzero
#else
#define disable_irq_nosync FDEV_LINUX_disable_irq_nosync
#define EISA_bus FDEV_LINUX_EISA_bus
#endif

#define el1_probe FDEV_LINUX_el1_probe
#define el2_pio_probe FDEV_LINUX_el2_pio_probe
#define el2_probe FDEV_LINUX_el2_probe
#define el2_probe1 FDEV_LINUX_el2_probe1
#define elplus_probe FDEV_LINUX_elplus_probe
#define el16_probe FDEV_LINUX_el16_probe
#define el3_debug FDEV_LINUX_el3_debug
#define el3_probe FDEV_LINUX_el3_probe
#define tc59x_probe FDEV_LINUX_tc59x_probe
#define A_NCR53c7xx_msg_abort_used FDEV_LINUX_A_NCR53c7xx_msg_abort_used
#define A_NCR53c7xx_msg_reject_used FDEV_LINUX_A_NCR53c7xx_msg_reject_used
#define A_NCR53c7xx_sink_used FDEV_LINUX_A_NCR53c7xx_sink_used
#define A_NCR53c7xx_zero_used FDEV_LINUX_A_NCR53c7xx_zero_used
#define A_NOP_insn_used FDEV_LINUX_A_NOP_insn_used
#define A_addr_reconnect_dsa_head_used FDEV_LINUX_A_addr_reconnect_dsa_head_used
#define A_addr_scratch_used FDEV_LINUX_A_addr_scratch_used
#define A_addr_temp_used FDEV_LINUX_A_addr_temp_used
#define A_dmode_memory_to_memory_used FDEV_LINUX_A_dmode_memory_to_memory_used
#define A_dmode_memory_to_ncr_used FDEV_LINUX_A_dmode_memory_to_ncr_used
#define A_dmode_ncr_to_memory_used FDEV_LINUX_A_dmode_ncr_to_memory_used
#define A_dsa_check_reselect_used FDEV_LINUX_A_dsa_check_reselect_used
#define A_dsa_cmdout_used FDEV_LINUX_A_dsa_cmdout_used
#define A_dsa_cmnd_used FDEV_LINUX_A_dsa_cmnd_used
#define A_dsa_datain_used FDEV_LINUX_A_dsa_datain_used
#define A_dsa_dataout_used FDEV_LINUX_A_dsa_dataout_used
#define A_dsa_end_used FDEV_LINUX_A_dsa_end_used
#define A_dsa_fields_start_used FDEV_LINUX_A_dsa_fields_start_used
#define A_dsa_msgin_used FDEV_LINUX_A_dsa_msgin_used
#define A_dsa_msgout_other_used FDEV_LINUX_A_dsa_msgout_other_used
#define A_dsa_msgout_used FDEV_LINUX_A_dsa_msgout_used
#define A_dsa_next_used FDEV_LINUX_A_dsa_next_used
#define A_dsa_restore_pointers_used FDEV_LINUX_A_dsa_restore_pointers_used
#define A_dsa_save_data_pointer_used FDEV_LINUX_A_dsa_save_data_pointer_used
#define A_dsa_select_used FDEV_LINUX_A_dsa_select_used
#define A_dsa_status_used FDEV_LINUX_A_dsa_status_used
#define A_dsa_temp_addr_array_value_used FDEV_LINUX_A_dsa_temp_addr_array_value_used
#define A_dsa_temp_addr_dsa_value_used FDEV_LINUX_A_dsa_temp_addr_dsa_value_used
#define A_dsa_temp_addr_new_value_used FDEV_LINUX_A_dsa_temp_addr_new_value_used
#define A_dsa_temp_addr_next_used FDEV_LINUX_A_dsa_temp_addr_next_used
#define A_dsa_temp_addr_residual_used FDEV_LINUX_A_dsa_temp_addr_residual_used
#define A_dsa_temp_addr_saved_pointer_used FDEV_LINUX_A_dsa_temp_addr_saved_pointer_used
#define A_dsa_temp_addr_saved_residual_used FDEV_LINUX_A_dsa_temp_addr_saved_residual_used
#define A_dsa_temp_lun_used FDEV_LINUX_A_dsa_temp_lun_used
#define A_dsa_temp_next_used FDEV_LINUX_A_dsa_temp_next_used
#define A_dsa_temp_sync_used FDEV_LINUX_A_dsa_temp_sync_used
#define A_dsa_temp_target_used FDEV_LINUX_A_dsa_temp_target_used
#define A_int_debug_break_used FDEV_LINUX_A_int_debug_break_used
#define A_int_debug_panic_used FDEV_LINUX_A_int_debug_panic_used
#define A_int_err_check_condition_used FDEV_LINUX_A_int_err_check_condition_used
#define A_int_err_no_phase_used FDEV_LINUX_A_int_err_no_phase_used
#define A_int_err_selected_used FDEV_LINUX_A_int_err_selected_used
#define A_int_err_unexpected_phase_used FDEV_LINUX_A_int_err_unexpected_phase_used
#define A_int_err_unexpected_reselect_used FDEV_LINUX_A_int_err_unexpected_reselect_used
#define A_int_msg_1_used FDEV_LINUX_A_int_msg_1_used
#define A_int_msg_sdtr_used FDEV_LINUX_A_int_msg_sdtr_used
#define A_int_msg_wdtr_used FDEV_LINUX_A_int_msg_wdtr_used
#define A_int_norm_aborted_used FDEV_LINUX_A_int_norm_aborted_used
#define A_int_norm_command_complete_used FDEV_LINUX_A_int_norm_command_complete_used
#define A_int_norm_disconnected_used FDEV_LINUX_A_int_norm_disconnected_used
#define A_int_norm_reselect_complete_used FDEV_LINUX_A_int_norm_reselect_complete_used
#define A_int_norm_reset_used FDEV_LINUX_A_int_norm_reset_used
#define A_int_norm_select_complete_used FDEV_LINUX_A_int_norm_select_complete_used
#define A_int_test_1_used FDEV_LINUX_A_int_test_1_used
#define A_int_test_2_used FDEV_LINUX_A_int_test_2_used
#define A_int_test_3_used FDEV_LINUX_A_int_test_3_used
#define A_msg_buf_used FDEV_LINUX_A_msg_buf_used
#define A_reconnect_dsa_head_used FDEV_LINUX_A_reconnect_dsa_head_used
#define A_reselected_identify_used FDEV_LINUX_A_reselected_identify_used
#define A_reselected_tag_used FDEV_LINUX_A_reselected_tag_used
#define A_schedule_used FDEV_LINUX_A_schedule_used
#define A_test_dest_used FDEV_LINUX_A_test_dest_used
#define A_test_src_used FDEV_LINUX_A_test_src_used
#define EXTERNAL_PATCHES FDEV_LINUX_EXTERNAL_PATCHES
#define EXTERNAL_PATCHES_LEN FDEV_LINUX_EXTERNAL_PATCHES_LEN
#define INSTRUCTIONS FDEV_LINUX_INSTRUCTIONS
#define LABELPATCHES FDEV_LINUX_LABELPATCHES
#define NCR53c7xx_abort FDEV_LINUX_NCR53c7xx_abort
#define NCR53c7xx_detect FDEV_LINUX_NCR53c7xx_detect
#define NCR53c7xx_queue_command FDEV_LINUX_NCR53c7xx_queue_command
#define NCR53c7xx_reset FDEV_LINUX_NCR53c7xx_reset
#define PATCHES FDEV_LINUX_PATCHES
#define SCRIPT FDEV_LINUX_SCRIPT
#define ncr53c70066_setup FDEV_LINUX_ncr53c70066_setup
#define ncr53c700_setup FDEV_LINUX_ncr53c700_setup
#define ncr53c710_setup FDEV_LINUX_ncr53c710_setup
#define ncr53c720_setup FDEV_LINUX_ncr53c720_setup
#define ncr53c810_setup FDEV_LINUX_ncr53c810_setup
#define ncr53c815_setup FDEV_LINUX_ncr53c815_setup
#define ncr53c820_setup FDEV_LINUX_ncr53c820_setup
#define ncr53c825_setup FDEV_LINUX_ncr53c825_setup
#define proc_scsi_ncr53c7xx FDEV_LINUX_proc_scsi_ncr53c7xx
#define NS8390_init FDEV_LINUX_NS8390_init
#define ei_close FDEV_LINUX_ei_close
#define ei_interrupt FDEV_LINUX_ei_interrupt
#define ei_open FDEV_LINUX_ei_open
#define ethdev_init FDEV_LINUX_ethdev_init
#define AM53C974_abort FDEV_LINUX_AM53C974_abort
#define AM53C974_command FDEV_LINUX_AM53C974_command
#define AM53C974_detect FDEV_LINUX_AM53C974_detect
#define AM53C974_info FDEV_LINUX_AM53C974_info
#define AM53C974_queue_command FDEV_LINUX_AM53C974_queue_command
#define AM53C974_release FDEV_LINUX_AM53C974_release
#define AM53C974_reset FDEV_LINUX_AM53C974_reset
#define AM53C974_setup FDEV_LINUX_AM53C974_setup
#define overrides FDEV_LINUX_overrides
#define proc_scsi_am53c974 FDEV_LINUX_proc_scsi_am53c974
#define BusLogic_AbortCommand FDEV_LINUX_BusLogic_AbortCommand
#define BusLogic_BIOSDiskParameters FDEV_LINUX_BusLogic_BIOSDiskParameters
#define BusLogic_DetectHostAdapter FDEV_LINUX_BusLogic_DetectHostAdapter
#define BusLogic_DriverInfo FDEV_LINUX_BusLogic_DriverInfo
#define BusLogic_ProcDirectoryEntry FDEV_LINUX_BusLogic_ProcDirectoryEntry
#define BusLogic_ProcDirectoryInfo FDEV_LINUX_BusLogic_ProcDirectoryInfo
#define BusLogic_QueueCommand FDEV_LINUX_BusLogic_QueueCommand
#define BusLogic_ReleaseHostAdapter FDEV_LINUX_BusLogic_ReleaseHostAdapter
#define BusLogic_ResetCommand FDEV_LINUX_BusLogic_ResetCommand
#define BusLogic_Setup FDEV_LINUX_BusLogic_Setup
#define FPT_BL_Card FDEV_LINUX_FPT_BL_Card
#define FPT_BusMasterInit FDEV_LINUX_FPT_BusMasterInit
#define FPT_CalcCrc16 FDEV_LINUX_FPT_CalcCrc16
#define FPT_CalcLrc FDEV_LINUX_FPT_CalcLrc
#define FPT_ChkIfChipInitialized FDEV_LINUX_FPT_ChkIfChipInitialized
#define FPT_DiagBusMaster FDEV_LINUX_FPT_DiagBusMaster
#define FPT_DiagEEPROM FDEV_LINUX_FPT_DiagEEPROM
#define FPT_DiagXbow FDEV_LINUX_FPT_DiagXbow
#define FPT_RNVRamData FDEV_LINUX_FPT_RNVRamData
#define FPT_RdStack FDEV_LINUX_FPT_RdStack
#define FPT_SccbMgrTableInitAll FDEV_LINUX_FPT_SccbMgrTableInitAll
#define FPT_SccbMgrTableInitCard FDEV_LINUX_FPT_SccbMgrTableInitCard
#define FPT_SccbMgrTableInitTarget FDEV_LINUX_FPT_SccbMgrTableInitTarget
#define FPT_SccbMgr_bad_isr FDEV_LINUX_FPT_SccbMgr_bad_isr
#define FPT_SccbMgr_scsi_reset FDEV_LINUX_FPT_SccbMgr_scsi_reset
#define FPT_SccbMgr_timer_expired FDEV_LINUX_FPT_SccbMgr_timer_expired
#define FPT_SendMsg FDEV_LINUX_FPT_SendMsg
#define FPT_Wait FDEV_LINUX_FPT_Wait
#define FPT_Wait1Second FDEV_LINUX_FPT_Wait1Second
#define FPT_WrStack FDEV_LINUX_FPT_WrStack
#define FPT_XbowInit FDEV_LINUX_FPT_XbowInit
#define FPT_autoCmdCmplt FDEV_LINUX_FPT_autoCmdCmplt
#define FPT_autoLoadDefaultMap FDEV_LINUX_FPT_autoLoadDefaultMap
#define FPT_busMstrDataXferStart FDEV_LINUX_FPT_busMstrDataXferStart
#define FPT_busMstrSGDataXferStart FDEV_LINUX_FPT_busMstrSGDataXferStart
#define FPT_busMstrTimeOut FDEV_LINUX_FPT_busMstrTimeOut
#define FPT_dataXferProcessor FDEV_LINUX_FPT_dataXferProcessor
#define FPT_default_intena FDEV_LINUX_FPT_default_intena
#define FPT_hostDataXferAbort FDEV_LINUX_FPT_hostDataXferAbort
#define FPT_hostDataXferRestart FDEV_LINUX_FPT_hostDataXferRestart
#define FPT_inisci FDEV_LINUX_FPT_inisci
#define FPT_mbCards FDEV_LINUX_FPT_mbCards
#define FPT_nvRamInfo FDEV_LINUX_FPT_nvRamInfo
#define FPT_phaseBusFree FDEV_LINUX_FPT_phaseBusFree
#define FPT_phaseChkFifo FDEV_LINUX_FPT_phaseChkFifo
#define FPT_phaseCommand FDEV_LINUX_FPT_phaseCommand
#define FPT_phaseDataIn FDEV_LINUX_FPT_phaseDataIn
#define FPT_phaseDataOut FDEV_LINUX_FPT_phaseDataOut
#define FPT_phaseDecode FDEV_LINUX_FPT_phaseDecode
#define FPT_phaseIllegal FDEV_LINUX_FPT_phaseIllegal
#define FPT_phaseMsgIn FDEV_LINUX_FPT_phaseMsgIn
#define FPT_phaseMsgOut FDEV_LINUX_FPT_phaseMsgOut
#define FPT_phaseStatus FDEV_LINUX_FPT_phaseStatus
#define FPT_queueAddSccb FDEV_LINUX_FPT_queueAddSccb
#define FPT_queueCmdComplete FDEV_LINUX_FPT_queueCmdComplete
#define FPT_queueDisconnect FDEV_LINUX_FPT_queueDisconnect
#define FPT_queueFindSccb FDEV_LINUX_FPT_queueFindSccb
#define FPT_queueFlushSccb FDEV_LINUX_FPT_queueFlushSccb
#define FPT_queueFlushTargSccb FDEV_LINUX_FPT_queueFlushTargSccb
#define FPT_queueSearchSelect FDEV_LINUX_FPT_queueSearchSelect
#define FPT_queueSelectFail FDEV_LINUX_FPT_queueSelectFail
#define FPT_s_PhaseTbl FDEV_LINUX_FPT_s_PhaseTbl
#define FPT_scamHAString FDEV_LINUX_FPT_scamHAString
#define FPT_scamInfo FDEV_LINUX_FPT_scamInfo
#define FPT_scarb FDEV_LINUX_FPT_scarb
#define FPT_scasid FDEV_LINUX_FPT_scasid
#define FPT_scbusf FDEV_LINUX_FPT_scbusf
#define FPT_sccbMgrTbl FDEV_LINUX_FPT_sccbMgrTbl
#define FPT_schkdd FDEV_LINUX_FPT_schkdd
#define FPT_scini FDEV_LINUX_FPT_scini
#define FPT_sciso FDEV_LINUX_FPT_sciso
#define FPT_scmachid FDEV_LINUX_FPT_scmachid
#define FPT_scsavdi FDEV_LINUX_FPT_scsavdi
#define FPT_scsel FDEV_LINUX_FPT_scsel
#define FPT_scsell FDEV_LINUX_FPT_scsell
#define FPT_scsendi FDEV_LINUX_FPT_scsendi
#define FPT_scvalq FDEV_LINUX_FPT_scvalq
#define FPT_scwirod FDEV_LINUX_FPT_scwirod
#define FPT_scwiros FDEV_LINUX_FPT_scwiros
#define FPT_scwtsel FDEV_LINUX_FPT_scwtsel
#define FPT_scxferc FDEV_LINUX_FPT_scxferc
#define FPT_sdecm FDEV_LINUX_FPT_sdecm
#define FPT_sfm FDEV_LINUX_FPT_sfm
#define FPT_shandem FDEV_LINUX_FPT_shandem
#define FPT_sinits FDEV_LINUX_FPT_sinits
#define FPT_sisyncn FDEV_LINUX_FPT_sisyncn
#define FPT_sisyncr FDEV_LINUX_FPT_sisyncr
#define FPT_siwidn FDEV_LINUX_FPT_siwidn
#define FPT_siwidr FDEV_LINUX_FPT_siwidr
#define FPT_sres FDEV_LINUX_FPT_sres
#define FPT_sresb FDEV_LINUX_FPT_sresb
#define FPT_ssel FDEV_LINUX_FPT_ssel
#define FPT_ssenss FDEV_LINUX_FPT_ssenss
#define FPT_sssyncv FDEV_LINUX_FPT_sssyncv
#define FPT_stsyncn FDEV_LINUX_FPT_stsyncn
#define FPT_stwidn FDEV_LINUX_FPT_stwidn
#define FPT_sxfrp FDEV_LINUX_FPT_sxfrp
#define FPT_utilEERead FDEV_LINUX_FPT_utilEERead
#define FPT_utilEEReadOrg FDEV_LINUX_FPT_utilEEReadOrg
#define FPT_utilEESendCmdAddr FDEV_LINUX_FPT_utilEESendCmdAddr
#define FPT_utilEEWrite FDEV_LINUX_FPT_utilEEWrite
#define FPT_utilEEWriteOnOff FDEV_LINUX_FPT_utilEEWriteOnOff
#define FPT_utilUpdateResidual FDEV_LINUX_FPT_utilUpdateResidual
#define FlashPoint__AbortCCB FDEV_LINUX_FlashPoint__AbortCCB
#define FlashPoint__HandleInterrupt FDEV_LINUX_FlashPoint__HandleInterrupt
#define FlashPoint__HardwareResetHostAdapter FDEV_LINUX_FlashPoint__HardwareResetHostAdapter
#define FlashPoint__InquireTargetInfo FDEV_LINUX_FlashPoint__InquireTargetInfo
#define FlashPoint__InterruptPending FDEV_LINUX_FlashPoint__InterruptPending
#define FlashPoint__ProbeHostAdapter FDEV_LINUX_FlashPoint__ProbeHostAdapter
#define FlashPoint__ReleaseHostAdapter FDEV_LINUX_FlashPoint__ReleaseHostAdapter
#define FlashPoint__StartCCB FDEV_LINUX_FlashPoint_StartCCB
#define NCR53c406a_abort FDEV_LINUX_NCR53c406a_abort
#define NCR53c406a_biosparm FDEV_LINUX_NCR53c406a_biosparm
#define NCR53c406a_command FDEV_LINUX_NCR53c406a_command
#define NCR53c406a_detect FDEV_LINUX_NCR53c406a_detect
#define NCR53c406a_info FDEV_LINUX_NCR53c406a_info
#define NCR53c406a_queue FDEV_LINUX_NCR53c406a_queue
#define NCR53c406a_reset FDEV_LINUX_NCR53c406a_reset
#define NCR53c406a_setup FDEV_LINUX_NCR53c406a_setup
#define proc_scsi_NCR53c406a FDEV_LINUX_proc_scsi_NCR53c406a
#define ac3200_probe FDEV_LINUX_ac3200_probe
#define _adv_mcode_chksum FDEV_LINUX__adv_mcode_chksum
#define _adv_mcode_size FDEV_LINUX__adv_mcode_size
#define advansys_abort FDEV_LINUX_advansys_abort
#define advansys_biosparam FDEV_LINUX_advansys_biosparam
#define advansys_command FDEV_LINUX_advansys_command
#define advansys_detect FDEV_LINUX_advansys_detect
#define advansys_info FDEV_LINUX_advansys_info
#ifdef CONFIG_PROC_FS /* See advansys.h, new from Linux 2.2.20 <joachim@vmlinux.org> */
#define advansys_proc_info FDEV_LINUX_advansys_proc_info
#endif
#define advansys_queuecommand FDEV_LINUX_advansys_queuecommand
#define advansys_release FDEV_LINUX_advansys_release
#define advansys_reset FDEV_LINUX_advansys_reset
#define advansys_setup FDEV_LINUX_advansys_setup
#define proc_scsi_advansys FDEV_LINUX_proc_scsi_advansys
#define aha152x_abort FDEV_LINUX_aha152x_abort
#define aha152x_biosparam FDEV_LINUX_aha152x_biosparam
#define aha152x_checksetup FDEV_LINUX_aha152x_checksetup
#define aha152x_command FDEV_LINUX_aha152x_command
#define aha152x_detect FDEV_LINUX_aha152x_detect
#define aha152x_done FDEV_LINUX_aha152x_done
#define aha152x_proc_info FDEV_LINUX_aha152x_proc_info
#define aha152x_queue FDEV_LINUX_aha152x_queue
#define aha152x_release FDEV_LINUX_aha152x_release
#define aha152x_reset FDEV_LINUX_aha152x_reset
#define aha152x_set_info FDEV_LINUX_aha152x_set_info
#define aha152x_setup FDEV_LINUX_aha152x_setup
#define aha152x_swintr FDEV_LINUX_aha152x_swintr
#define proc_scsi_aha152x FDEV_LINUX_proc_scsi_aha152x
#define aha1542_abort FDEV_LINUX_aha1542_abort
#define aha1542_biosparam FDEV_LINUX_aha1542_biosparam
#define aha1542_bus_reset FDEV_LINUX_aha1542_bus_reset
#define aha1542_command FDEV_LINUX_aha1542_command
#define aha1542_detect FDEV_LINUX_aha1542_detect
#define aha1542_dev_reset FDEV_LINUX_aha1542_dev_reset
#define aha1542_host_reset FDEV_LINUX_aha1542_host_reset
#define aha1542_old_abort FDEV_LINUX_aha1542_old_abort
#define aha1542_old_reset FDEV_LINUX_aha1542_old_reset
#define aha1542_queuecommand FDEV_LINUX_aha1542_queuecommand
#define aha1542_setup FDEV_LINUX_aha1542_setup
#define proc_scsi_aha1542 FDEV_LINUX_proc_scsi_aha1542
#define aha1740_abort FDEV_LINUX_aha1740_abort
#define aha1740_biosparam FDEV_LINUX_aha1740_biosparam
#define aha1740_command FDEV_LINUX_aha1740_command
#define aha1740_detect FDEV_LINUX_aha1740_detect
#define aha1740_getconfig FDEV_LINUX_aha1740_getconfig
#define aha1740_intr_handle FDEV_LINUX_aha1740_intr_handle
#define aha1740_makecode FDEV_LINUX_aha1740_makecode
#define aha1740_proc_info FDEV_LINUX_aha1740_proc_info
#define aha1740_queuecommand FDEV_LINUX_aha1740_queuecommand
#define aha1740_reset FDEV_LINUX_aha1740_reset
#define aha1740_test_port FDEV_LINUX_aha1740_test_port
#define proc_scsi_aha1740 FDEV_LINUX_proc_scsi_aha1740
#define aic7xxx_abort FDEV_LINUX_aic7xxx_abort
#define aic7xxx_biosparam FDEV_LINUX_aic7xxx_biosparam
#define aic7xxx_chip_reset FDEV_LINUX_aic7xxx_chip_reset
#define aic7xxx_detect FDEV_LINUX_aic7xxx_detect
#define aic7xxx_info FDEV_LINUX_aic7xxx_info
#define aic7xxx_proc_info FDEV_LINUX_aic7xxx_proc_info
#define aic7xxx_queue FDEV_LINUX_aic7xxx_queue
#define aic7xxx_release FDEV_LINUX_aic7xxx_release
#define aic7xxx_reset FDEV_LINUX_aic7xxx_reset
#define aic7xxx_set_info FDEV_LINUX_aic7xxx_set_info
#define aic7xxx_setup FDEV_LINUX_aic7xxx_setup
#define proc_scsi_aic7xxx FDEV_LINUX_proc_scsi_aic7xxx
#define sequencer_patches FDEV_LINUX_sequencer_patches
#define at1700_probe FDEV_LINUX_at1700_probe
#define autoirq_report FDEV_LINUX_autoirq_report
#define autoirq_setup FDEV_LINUX_autoirq_setup
#define irqs_busy FDEV_LINUX_irqs_busy
#define pcibios_find_class FDEV_LINUX_pcibios_find_class
#define pcibios_find_device FDEV_LINUX_pcibios_find_device
#define pcibios_fixup FDEV_LINUX_pcibios_fixup
#define pcibios_fixup_bus FDEV_LINUX_pcibios_fixup_bus
#define pcibios_init FDEV_LINUX_pcibios_init
#define pcibios_present FDEV_LINUX_pcibios_present
#define pcibios_read_config_dword FDEV_LINUX_pcibios_read_config_dword
#define pcibios_read_config_word FDEV_LINUX_pcibios_read_config_word
#define pcibios_setup FDEV_LINUX_pcibios_setup
#define pcibios_strerror FDEV_LINUX_pcibios_strerror
#define pcibios_write_config_byte FDEV_LINUX_pcibios_write_config_byte
#define pcibios_write_config_dword FDEV_LINUX_pcibios_write_config_dword
#define pcibios_write_config_word FDEV_LINUX_pcibios_write_config_word
#define __brelse FDEV_LINUX___brelse
#define blk_dev FDEV_LINUX_blk_dev
#define blk_dev_init FDEV_LINUX_blk_dev_init
#define blk_size FDEV_LINUX_blk_size
#define blkdevs FDEV_LINUX_blkdevs
#define blksize_size FDEV_LINUX_blksize_size
#define block_read FDEV_LINUX_block_read
#define block_write FDEV_LINUX_block_write
#define bread FDEV_LINUX_bread
#define check_disk_change FDEV_LINUX_check_disk_change
#define chr_dev_init FDEV_LINUX_chr_dev_init
#define console_map_init FDEV_LINUX_console_map_init
#define cs89x0_probe FDEV_LINUX_cs89x0_probe
#define end_that_request_first FDEV_LINUX_end_that_request_first
#define end_that_request_last FDEV_LINUX_end_that_request_last
#define getblk FDEV_LINUX_getblk
#define hardsect_size FDEV_LINUX_hardsect_size
#define is_read_only FDEV_LINUX_is_read_only
#define blkelv_ioctl FDEV_LINUX_blkelv_ioctl
#define ll_rw_block FDEV_LINUX_ll_rw_block
#define max_readahead FDEV_LINUX_max_readahead
#define max_sectors FDEV_LINUX_max_sectors
#define net_dev_init FDEV_LINUX_net_dev_init
#define read_ahead FDEV_LINUX_read_ahead
#define register_blkdev FDEV_LINUX_register_blkdev
#define set_device_ro FDEV_LINUX_set_device_ro
#define unplug_device FDEV_LINUX_unplug_device
#define unregister_blkdev FDEV_LINUX_unregister_blkdev
#define wait_for_request FDEV_LINUX_wait_for_request
#define cdrom_count_tracks FDEV_LINUX_cdrom_count_tracks
#define cdrom_fops FDEV_LINUX_cdrom_fops
#define register_cdrom FDEV_LINUX_register_cdrom
#define unregister_cdrom FDEV_LINUX_unregister_cdrom
#define cmd640_vlb FDEV_LINUX_cmd640_vlb
#define ide_probe_for_cmd640x FDEV_LINUX_ide_probe_for_cmd640x
#define print_Scsi_Cmnd FDEV_LINUX_print_Scsi_Cmnd
#define print_command FDEV_LINUX_print_command
#define print_driverbyte FDEV_LINUX_print_driverbyte
#define print_hostbyte FDEV_LINUX_print_hostbyte
#define print_msg FDEV_LINUX_print_msg
#define print_sense FDEV_LINUX_print_sense
#define print_status FDEV_LINUX_print_status
#define de4x5_probe FDEV_LINUX_de4x5_probe
#define __const_udelay FDEV_LINUX___const_udelay
#define __delay FDEV_LINUX___delay
#define __udelay FDEV_LINUX___udelay
#define free_dma FDEV_LINUX_free_dma
#define request_dma FDEV_LINUX_request_dma
#define dtc_abort FDEV_LINUX_dtc_abort
#define dtc_biosparam FDEV_LINUX_dtc_biosparam
#define dtc_detect FDEV_LINUX_dtc_detect
#define dtc_proc_info FDEV_LINUX_dtc_proc_info
#define dtc_queue_command FDEV_LINUX_dtc_queue_command
#define dtc_reset FDEV_LINUX_dtc_reset
#define dtc_setup FDEV_LINUX_dtc_setup
#define proc_scsi_dtc FDEV_LINUX_proc_scsi_dtc
#define e2100_probe FDEV_LINUX_e2100_probe
#define e21_probe1 FDEV_LINUX_e21_probe1
#define eata2x_abort FDEV_LINUX_eata2x_abort
#define eata2x_biosparam FDEV_LINUX_eata2x_biosparam
#define eata2x_detect FDEV_LINUX_eata2x_detect
#define eata2x_old_abort FDEV_LINUX_eata2x_old_abort
#define eata2x_old_reset FDEV_LINUX_eata2x_old_reset
#define eata2x_queuecommand FDEV_LINUX_eata2x_queuecommand
#define eata2x_release FDEV_LINUX_eata2x_release
#define eata2x_reset FDEV_LINUX_eata2x_reset
#define eata2x_setup FDEV_LINUX_eata2x_setup
#define proc_scsi_eata2x FDEV_LINUX_proc_scsi_eata2x
#define check_blink_state FDEV_LINUX_check_blink_state
#define do_eata_int_handler FDEV_LINUX_do_eata_int_handler
#define eata_abort FDEV_LINUX_eata_abort
#define eata_detect FDEV_LINUX_eata_detect
#define eata_fake_int_handler FDEV_LINUX_eata_fake_int_handler
#define eata_int_handler FDEV_LINUX_eata_int_handler
#define eata_latency_in FDEV_LINUX_eata_latency_in
#define eata_latency_out FDEV_LINUX_eata_latency_out
#define eata_proc_info FDEV_LINUX_eata_proc_info
#define eata_queue FDEV_LINUX_eata_queue
#define eata_reset FDEV_LINUX_eata_reset
#define eata_scsi_done FDEV_LINUX_eata_scsi_done
#define eata_send_command FDEV_LINUX_eata_send_command
#define eata_send_immediate FDEV_LINUX_eata_send_immediate
#define eata_set_info FDEV_LINUX_eata_set_info
#define epic100_probe FDEV_LINUX_epic100_probe
#define chip_tbl FDEV_LINUX_chip_tbl
#define find_EISA FDEV_LINUX_find_EISA
#define find_ISA FDEV_LINUX_find_ISA
#define find_PCI FDEV_LINUX_find_PCI
#define get_board_data FDEV_LINUX_get_board_data
#define get_conf_PIO FDEV_LINUX_get_conf_PIO
#define print_config FDEV_LINUX_print_config
#define proc_scsi_eata_dma FDEV_LINUX_proc_scsi_eata_dma
#define register_HBA FDEV_LINUX_register_HBA
#define swap_statistics FDEV_LINUX_swap_statistics
#define IncStat FDEV_LINUX_IncStat
#define do_eata_pio_int_handler FDEV_LINUX_do_eata_pio_int_handler
#define eata_pio_abort FDEV_LINUX_eata_pio_abort
#define eata_pio_detect FDEV_LINUX_eata_pio_detect
#define eata_pio_int_handler FDEV_LINUX_eata_pio_int_handler
#define eata_pio_proc_info FDEV_LINUX_eata_pio_proc_info
#define eata_pio_queue FDEV_LINUX_eata_pio_queue
#define eata_pio_reset FDEV_LINUX_eata_pio_reset
#define eata_pio_send_command FDEV_LINUX_eata_pio_send_command
#define eata_pio_set_info FDEV_LINUX_eata_pio_set_info
#define find_pio_EISA FDEV_LINUX_find_pio_EISA
#define find_pio_ISA FDEV_LINUX_find_pio_ISA
#define find_pio_PCI FDEV_LINUX_find_pio_PCI
#define get_pio_board_data FDEV_LINUX_get_pio_board_data
#define get_pio_conf_PIO FDEV_LINUX_get_pio_conf_PIO
#define print_pio_config FDEV_LINUX_print_pio_config
#define proc_scsi_eata_pio FDEV_LINUX_proc_scsi_eata_pio
#define register_pio_HBA FDEV_LINUX_register_pio_HBA
#define eepro_probe FDEV_LINUX_eepro_probe
#define printEEPROMInfo FDEV_LINUX_printEEPROMInfo
#define eepro100_init FDEV_LINUX_eepro100_init
#define eepro100_probe FDEV_LINUX_eepro100_probe
#define i82557_config_cmd FDEV_LINUX_i82557_config_cmd
#define i82558_config_cmd FDEV_LINUX_i82558_config_cmd
#define speedo_debug FDEV_LINUX_speedo_debug
#define express_probe FDEV_LINUX_express_probe
#define eth16i_probe FDEV_LINUX_eth16i_probe
#define ewrk3_probe FDEV_LINUX_ewrk3_probe
#define do_fdomain_16x0_intr FDEV_LINUX_do_fdomain_16x0_intr
#define fdomain_16x0_abort FDEV_LINUX_fdomain_16x0_abort
#define fdomain_16x0_biosparam FDEV_LINUX_fdomain_16x0_biosparam
#define fdomain_16x0_command FDEV_LINUX_fdomain_16x0_command
#define fdomain_16x0_detect FDEV_LINUX_fdomain_16x0_detect
#define fdomain_16x0_info FDEV_LINUX_fdomain_16x0_info
#define fdomain_16x0_proc_info FDEV_LINUX_fdomain_16x0_proc_info
#define fdomain_16x0_queue FDEV_LINUX_fdomain_16x0_queue
#define fdomain_16x0_reset FDEV_LINUX_fdomain_16x0_reset
#define fdomain_setup FDEV_LINUX_fdomain_setup
#define my_done FDEV_LINUX_my_done
#define print_info FDEV_LINUX_print_info
#define proc_scsi_fdomain FDEV_LINUX_proc_scsi_fdomain
#define signatures FDEV_LINUX_signatures
#define fmv18x_probe FDEV_LINUX_fmv18x_probe
#define device_setup FDEV_LINUX_device_setup
#define disk_name FDEV_LINUX_disk_name
#define gendisk_head FDEV_LINUX_gendisk_head
#define resetup_one_dev FDEV_LINUX_resetup_one_dev
#define max_scsi_hosts FDEV_LINUX_max_scsi_hosts
#define next_scsi_host FDEV_LINUX_next_scsi_host
#define scsi_devicelist FDEV_LINUX_scsi_devicelist
#define scsi_hostlist FDEV_LINUX_scsi_hostlist
#define scsi_hosts FDEV_LINUX_scsi_hosts
#define scsi_init FDEV_LINUX_scsi_init
#define scsi_register FDEV_LINUX_scsi_register
#define scsi_register_device FDEV_LINUX_scsi_register_device
#define scsi_unregister FDEV_LINUX_scsi_unregister
#define hp_plus_probe FDEV_LINUX_hp_plus_probe
#define hpp_probe1 FDEV_LINUX_hpp_probe1
#define hp_probe FDEV_LINUX_hp_probe
#define hp_probe1 FDEV_LINUX_hp_probe1
#define hp100_build_rx_pdl FDEV_LINUX_hp100_build_rx_pdl
#define hp100_probe FDEV_LINUX_hp100_probe
#define ide_cdrom_init FDEV_LINUX_ide_cdrom_init
#define ignore FDEV_LINUX_ignore
#define packet_command_texts FDEV_LINUX_packet_command_texts
#define sense_data_texts FDEV_LINUX_sense_data_texts
#define sense_key_texts FDEV_LINUX_sense_key_texts
#define ide_multwrite FDEV_LINUX_ide_multwrite
#define idedisk_init FDEV_LINUX_idedisk_init
#define bad_dma_drives FDEV_LINUX_bad_dma_drives
#define check_drive_lists FDEV_LINUX_check_drive_lists
#define good_dma_drives FDEV_LINUX_good_dma_drives
#define ide_build_dmatable FDEV_LINUX_ide_build_dmatable
#define ide_dma_intr FDEV_LINUX_ide_dma_intr
#define ide_dmaproc FDEV_LINUX_ide_dmaproc
#define ide_get_or_set_dma_base FDEV_LINUX_ide_get_or_set_dma_base
#define ide_release_dma FDEV_LINUX_ide_release_dma
#define ide_setup_dma FDEV_LINUX_ide_setup_dma
#define idefloppy_init FDEV_LINUX_idefloppy_init
#define ideprobe_init FDEV_LINUX_ideprobe_init
#define atapi_input_bytes FDEV_LINUX_atapi_input_bytes
#define atapi_output_bytes FDEV_LINUX_atapi_output_bytes
#define do_ide0_request FDEV_LINUX_do_ide0_request
#define do_ide1_request FDEV_LINUX_do_ide1_request
#define do_ide2_request FDEV_LINUX_do_ide2_request
#define do_ide3_request FDEV_LINUX_do_ide3_request
#define do_ide4_request FDEV_LINUX_do_ide4_request
#define do_ide5_request FDEV_LINUX_do_ide5_request
#define drive_is_flashcard FDEV_LINUX_drive_is_flashcard
#define ide_add_generic_settings FDEV_LINUX_ide_add_generic_settings
#define ide_add_setting FDEV_LINUX_ide_add_setting
#define ide_cmd FDEV_LINUX_ide_cmd
#define ide_do_drive_cmd FDEV_LINUX_ide_do_drive_cmd
#define ide_do_reset FDEV_LINUX_ide_do_reset
#define ide_dump_status FDEV_LINUX_ide_dump_status
#define ide_end_drive_cmd FDEV_LINUX_ide_end_drive_cmd
#define ide_end_request FDEV_LINUX_ide_end_request
#define ide_error FDEV_LINUX_ide_error
#define ide_find_setting_by_name FDEV_LINUX_ide_find_setting_by_name
#define ide_fixstring FDEV_LINUX_ide_fixstring
#define ide_fops FDEV_LINUX_ide_fops
#define ide_geninit FDEV_LINUX_ide_geninit
#define ide_get_best_pio_mode FDEV_LINUX_ide_get_best_pio_mode
#define ide_get_queue FDEV_LINUX_ide_get_queue
#define ide_hwifs FDEV_LINUX_ide_hwifs
#define ide_init FDEV_LINUX_ide_init
#define ide_init_builtin_drivers FDEV_LINUX_ide_init_builtin_drivers
#define ide_init_drive_cmd FDEV_LINUX_ide_init_drive_cmd
#define ide_init_rz1000 FDEV_LINUX_ide_init_rz1000
#define ide_input_data FDEV_LINUX_ide_input_data
#define ide_intr FDEV_LINUX_ide_intr
#define ide_modules FDEV_LINUX_ide_modules
#define ide_output_data FDEV_LINUX_ide_output_data
#define ide_pio_timings FDEV_LINUX_ide_pio_timings
#define ide_read_setting FDEV_LINUX_ide_read_setting
#define ide_register FDEV_LINUX_ide_register
#define ide_register_module FDEV_LINUX_ide_register_module
#define ide_register_subdriver FDEV_LINUX_ide_register_subdriver
#define ide_remove_setting FDEV_LINUX_ide_remove_setting
#define ide_replace_subdriver FDEV_LINUX_ide_replace_subdriver
#define ide_revalidate_disk FDEV_LINUX_ide_revalidate_disk
#define ide_scan_devices FDEV_LINUX_ide_scan_devices
#define ide_scan_pcibus FDEV_LINUX_ide_scan_pcibus
#define ide_scan_pio_blacklist FDEV_LINUX_ide_scan_pio_blacklist
#define ide_set_handler FDEV_LINUX_ide_set_handler
#define ide_setup FDEV_LINUX_ide_setup
#define ide_spin_wait_hwgroup FDEV_LINUX_ide_spin_wait_hwgroup
#define ide_stall_queue FDEV_LINUX_ide_stall_queue
#define ide_system_bus_speed FDEV_LINUX_ide_system_bus_speed
#define ide_timer_expiry FDEV_LINUX_ide_timer_expiry
#define ide_unregister FDEV_LINUX_ide_unregister
#define ide_unregister_module FDEV_LINUX_ide_unregister_module
#define ide_unregister_subdriver FDEV_LINUX_ide_unregister_subdriver
#define ide_wait_cmd FDEV_LINUX_ide_wait_cmd
#define ide_wait_stat FDEV_LINUX_ide_wait_stat
#define ide_write_setting FDEV_LINUX_ide_write_setting
#define ide_xlate_1024 FDEV_LINUX_ide_xlate_1024
#define in2000_abort FDEV_LINUX_in2000_abort
#define in2000_biosparam FDEV_LINUX_in2000_biosparam
#define in2000_detect FDEV_LINUX_in2000_detect
#define in2000_proc_info FDEV_LINUX_in2000_proc_info
#define in2000_queuecommand FDEV_LINUX_in2000_queuecommand
#define in2000_reset FDEV_LINUX_in2000_reset
#define in2000_setup FDEV_LINUX_in2000_setup
#define proc_scsi_in2000 FDEV_LINUX_proc_scsi_in2000
#define proc_scsi_in2000 FDEV_LINUX_proc_scsi_in2000
#define drive_info FDEV_LINUX_drive_info
#define disable_irq FDEV_LINUX_disable_irq
#define enable_irq FDEV_LINUX_enable_irq
#define free_irq FDEV_LINUX_free_irq
#define linux_intr_init FDEV_LINUX_linux_intr_init
#define local_irq_count FDEV_LINUX_local_irq_count
#define probe_irq_off FDEV_LINUX_probe_irq_off
#define probe_irq_on FDEV_LINUX_probe_irq_on
#define request_irq FDEV_LINUX_request_irq
#define lance_debug FDEV_LINUX_lance_debug
#define lance_probe FDEV_LINUX_lance_probe
#define lance_probe1 FDEV_LINUX_lance_probe1
#define add_blkdev_randomness FDEV_LINUX_add_blkdev_randomness
#define block_fsync FDEV_LINUX_block_fsync
#define dev_get_info FDEV_LINUX_dev_get_info
#define dispatch_scsi_info_ptr FDEV_LINUX_dispatch_scsi_info_ptr
#define do_gettimeofday FDEV_LINUX_do_gettimeofday
#define iounmap FDEV_LINUX_iounmap
#define kstat FDEV_LINUX_kstat
#define linux_to_oskit_error FDEV_LINUX_linux_to_oskit_error
#define phys_to_virt FDEV_LINUX_phys_to_virt
#define proc_net FDEV_LINUX_proc_net
#define proc_net_inode_operations FDEV_LINUX_proc_net_inode_operations
#define proc_register FDEV_LINUX_proc_register
#define proc_scsi FDEV_LINUX_proc_scsi
#define proc_scsi_inode_operations FDEV_LINUX_proc_scsi_inode_operations
#define proc_unregister FDEV_LINUX_proc_unregister
#define virt_to_phys FDEV_LINUX_virt_to_phys
#define ncr53c8xx_abort FDEV_LINUX_ncr53c8xx_abort
#define ncr53c8xx_detect FDEV_LINUX_ncr53c8xx_detect
#define ncr53c8xx_info FDEV_LINUX_ncr53c8xx_info
#define ncr53c8xx_queue_command FDEV_LINUX_ncr53c8xx_queue_command
#define ncr53c8xx_reset FDEV_LINUX_ncr53c8xx_reset
#define ncr53c8xx_setup FDEV_LINUX_ncr53c8xx_setup
#define ne_probe FDEV_LINUX_ne_probe
#define dev_base FDEV_LINUX_dev_base
#define net_debug_mode FDEV_LINUX_net_debug_mode
#define __kfree_skb FDEV_LINUX___kfree_skb
#define alloc_skb FDEV_LINUX_alloc_skb
#define backlog_max FDEV_LINUX_backlog_max
#define dev_alloc_skb FDEV_LINUX_dev_alloc_skb
#define dev_close FDEV_LINUX_dev_close
#define net_bh FDEV_LINUX_net_bh
#define netif_rx FDEV_LINUX_netif_rx
#define register_netdevice FDEV_LINUX_register_netdevice
#define rtnl_lock FDEV_LINUX_rtnl_lock
#define rtnl_rlockct FDEV_LINUX_rtnl_rlockct
#define rtnl_unlock FDEV_LINUX_rtnl_unlock
#define rtnl_wait FDEV_LINUX_rtnl_wait
#define skb_over_panic FDEV_LINUX_skb_over_panic
#define skb_put FDEV_LINUX_skb_put
#define skb_reserve FDEV_LINUX_skb_reserve
#define unregister_netdevice FDEV_LINUX_unregister_netdevice
#define ether_config FDEV_LINUX_ether_config
#define ether_setup FDEV_LINUX_ether_setup
#define init_etherdev FDEV_LINUX_init_etherdev
#define register_netdev FDEV_LINUX_register_netdev
#define unregister_netdev FDEV_LINUX_unregister_netdev
#define ni52_probe FDEV_LINUX_ni52_probe
#define ni65_probe FDEV_LINUX_ni65_probe
#define default_irqs FDEV_LINUX_default_irqs
#define pas16_abort FDEV_LINUX_pas16_abort
#define pas16_biosparam FDEV_LINUX_pas16_biosparam
#define pas16_detect FDEV_LINUX_pas16_detect
#define pas16_offset FDEV_LINUX_pas16_offset
#define pas16_proc_info FDEV_LINUX_pas16_proc_info
#define pas16_queue_command FDEV_LINUX_pas16_queue_command
#define pas16_reset FDEV_LINUX_pas16_reset
#define pas16_setup FDEV_LINUX_pas16_setup
#define proc_scsi_pas16 FDEV_LINUX_proc_scsi_pas16
#define scsi_irq_translate FDEV_LINUX_scsi_irq_translate
#define pci_devices FDEV_LINUX_pci_devices
#define pci_find_class FDEV_LINUX_pci_find_class
#define pci_find_device FDEV_LINUX_pci_find_device
#define pci_find_slot FDEV_LINUX_pci_find_slot
#define pci_init FDEV_LINUX_pci_init
#define pci_read_bases FDEV_LINUX_pci_read_bases
#define pci_read_config_byte FDEV_LINUX_pci_read_config_byte
#define pci_read_config_dword FDEV_LINUX_pci_read_config_dword
#define pci_read_config_word FDEV_LINUX_pci_read_config_word
#define pci_root FDEV_LINUX_pci_root
#define pci_scan_bus FDEV_LINUX_pci_scan_bus
#define pci_scan_peer_bridge FDEV_LINUX_pci_scan_peer_bridge
#define pci_set_master FDEV_LINUX_pci_set_master
#define pci_setup FDEV_LINUX_pci_setup
#define pci_write_config_byte FDEV_LINUX_pci_write_config_byte
#define pci_write_config_dword FDEV_LINUX_pci_write_config_dword
#define pci_write_config_word FDEV_LINUX_pci_write_config_word
#define check_region FDEV_LINUX_check_region
#define release_region FDEV_LINUX_release_region
#define request_region FDEV_LINUX_request_region
#define qlogicfas_abort FDEV_LINUX_qlogicfas_abort
#define qlogicfas_biosparam FDEV_LINUX_qlogicfas_biosparam
#define qlogicfas_command FDEV_LINUX_qlogicfas_command
#define qlogicfas_detect FDEV_LINUX_qlogicfas_detect
#define qlogicfas_info FDEV_LINUX_qlogicfas_info
#define qlogicfas_queuecommand FDEV_LINUX_qlogicfas_queuecommand
#define qlogicfas_reset FDEV_LINUX_qlogicfas_reset
#define isp1020_abort FDEV_LINUX_isp1020_abort
#define isp1020_biosparam FDEV_LINUX_isp1020_biosparam
#define isp1020_detect FDEV_LINUX_isp1020_detect
#define isp1020_info FDEV_LINUX_isp1020_info
#define isp1020_queuecommand FDEV_LINUX_isp1020_queuecommand
#define isp1020_release FDEV_LINUX_isp1020_release
#define isp1020_reset FDEV_LINUX_isp1020_reset
#define ide_probe_for_rz100x FDEV_LINUX_ide_probe_for_rz100x
#define immediate_bh FDEV_LINUX_immediate_bh
#define tq_immediate FDEV_LINUX_tq_immediate
#define tq_timer FDEV_LINUX_tq_timer
#define tqueue_bh FDEV_LINUX_tqueue_bh
#define host_active FDEV_LINUX_host_active
#define internal_cmnd FDEV_LINUX_internal_cmnd
#define last_cmnd FDEV_LINUX_last_cmnd
#define scsi_allocate_device FDEV_LINUX_scsi_allocate_device
#define scsi_bottom_half_handler FDEV_LINUX_scsi_bottom_half_handler
#define scsi_build_commandblocks FDEV_LINUX_scsi_build_commandblocks
#define scsi_command_size FDEV_LINUX_scsi_command_size
#define scsi_dev_init FDEV_LINUX_scsi_dev_init
#define scsi_device_types FDEV_LINUX_scsi_device_types
#define scsi_dma_free_sectors FDEV_LINUX_scsi_dma_free_sectors
#define scsi_do_cmd FDEV_LINUX_scsi_do_cmd
#define scsi_done FDEV_LINUX_scsi_done
#define scsi_finish_command FDEV_LINUX_scsi_finish_command
#define scsi_free FDEV_LINUX_scsi_free
#define scsi_init_free FDEV_LINUX_scsi_init_free
#define scsi_init_malloc FDEV_LINUX_scsi_init_malloc
#define scsi_loadable_module_flag FDEV_LINUX_scsi_loadable_module_flag
#define scsi_logging_level FDEV_LINUX_scsi_logging_level
#define scsi_logging_setup FDEV_LINUX_scsi_logging_setup
#define scsi_luns_setup FDEV_LINUX_scsi_luns_setup
#define scsi_make_blocked_list FDEV_LINUX_scsi_make_blocked_list
#define scsi_malloc FDEV_LINUX_scsi_malloc
#define scsi_need_isa_buffer FDEV_LINUX_scsi_need_isa_buffer
#define scsi_pid FDEV_LINUX_scsi_pid
#define scsi_register_module FDEV_LINUX_scsi_register_module
#define scsi_release_command FDEV_LINUX_scsi_release_command
#define scsi_request_queueable FDEV_LINUX_scsi_request_queueable
#define scsi_retry_command FDEV_LINUX_scsi_retry_command
#define scsi_unregister_module FDEV_LINUX_scsi_unregister_module
#define SCint FDEV_LINUX_SCint
#define proc_scsi_scsi_debug FDEV_LINUX_proc_scsi_scsi_debug
#define scsi_debug_abort FDEV_LINUX_scsi_debug_abort
#define scsi_debug_biosparam FDEV_LINUX_scsi_debug_biosparam
#define scsi_debug_command FDEV_LINUX_scsi_debug_command
#define scsi_debug_detect FDEV_LINUX_scsi_debug_detect
#define scsi_debug_info FDEV_LINUX_scsi_debug_info
#define scsi_debug_proc_info FDEV_LINUX_scsi_debug_proc_info
#define scsi_debug_queuecommand FDEV_LINUX_scsi_debug_queuecommand
#define scsi_debug_reset FDEV_LINUX_scsi_debug_reset
#define scsi_add_timer FDEV_LINUX_scsi_add_timer
#define scsi_block_when_processing_errors FDEV_LINUX_scsi_block_when_processing_errors
#define scsi_check_sense FDEV_LINUX_scsi_check_sense
#define scsi_decide_disposition FDEV_LINUX_scsi_decide_disposition
#define scsi_delete_timer FDEV_LINUX_scsi_delete_timer
#define scsi_eh_action_done FDEV_LINUX_scsi_eh_action_done
#define scsi_eh_completed_normally FDEV_LINUX_scsi_eh_completed_normally
#define scsi_eh_done FDEV_LINUX_scsi_eh_done
#define scsi_eh_finish_command FDEV_LINUX_scsi_eh_finish_command
#define scsi_eh_retry_command FDEV_LINUX_scsi_eh_retry_command
#define scsi_eh_times_out FDEV_LINUX_scsi_eh_times_out
#define scsi_request_sense FDEV_LINUX_scsi_request_sense
#define scsi_restart_operations FDEV_LINUX_scsi_restart_operations
#define scsi_send_eh_cmnd FDEV_LINUX_scsi_send_eh_cmnd
#define scsi_sense_valid FDEV_LINUX_scsi_sense_valid
#define scsi_sleep FDEV_LINUX_scsi_sleep
#define scsi_sleep_done FDEV_LINUX_scsi_sleep_done
#define scsi_test_unit_ready FDEV_LINUX_scsi_test_unit_ready
#define scsi_times_out FDEV_LINUX_scsi_times_out
#define scsi_try_bus_device_reset FDEV_LINUX_scsi_try_bus_device_reset
#define scsi_try_bus_reset FDEV_LINUX_scsi_try_bus_reset
#define scsi_try_host_reset FDEV_LINUX_scsi_try_host_reset
#define scsi_try_to_abort_command FDEV_LINUX_scsi_try_to_abort_command
#define scsi_unit_is_ready FDEV_LINUX_scsi_unit_is_ready
#define scsi_unjam_host FDEV_LINUX_scsi_unjam_host
#define proc_print_scsidevice FDEV_LINUX_proc_print_scsidevice
#define kernel_scsi_ioctl FDEV_LINUX_kernel_scsi_ioctl
#define scsi_ioctl FDEV_LINUX_scsi_ioctl
#define scsi_ioctl_send_command FDEV_LINUX_scsi_ioctl_send_command
#define scsi_mark_host_reset FDEV_LINUX_scsi_mark_host_reset
#define scsi_old_done FDEV_LINUX_scsi_old_done
#define scsi_old_times_out FDEV_LINUX_scsi_old_times_out
#define update_timeout FDEV_LINUX_update_timeout
#define scsi_mlqueue_finish FDEV_LINUX_scsi_mlqueue_finish
#define scsi_mlqueue_insert FDEV_LINUX_scsi_mlqueue_insert
#define scsi_mlqueue_lock FDEV_LINUX_scsi_mlqueue_lock
#define scsi_mlqueue_remove_lock FDEV_LINUX_scsi_mlqueue_remove_lock
#define scsi_partsize FDEV_LINUX_scsi_partsize
#define scsicam_bios_param FDEV_LINUX_scsicam_bios_param
#define revalidate_scsidisk FDEV_LINUX_revalidate_scsidisk
#define rscsi_disks FDEV_LINUX_rscsi_disks
#define sd FDEV_LINUX_sd
#define sd_template FDEV_LINUX_sd_template
#define sd_ioctl FDEV_LINUX_sd_ioctl
#define seagate_st0x_abort FDEV_LINUX_seagate_st0x_abort
#define seagate_st0x_biosparam FDEV_LINUX_seagate_st0x_biosparam
#define seagate_st0x_command FDEV_LINUX_seagate_st0x_command
#define seagate_st0x_detect FDEV_LINUX_seagate_st0x_detect
#define seagate_st0x_info FDEV_LINUX_seagate_st0x_info
#define seagate_st0x_queue_command FDEV_LINUX_seagate_st0x_queue_command
#define seagate_st0x_reset FDEV_LINUX_seagate_st0x_reset
#define st0x_setup FDEV_LINUX_st0x_setup
#define tmc8xx_setup FDEV_LINUX_tmc8xx_setup
#define seeq8005_init FDEV_LINUX_seeq8005_init
#define seeq8005_probe FDEV_LINUX_seeq8005_probe
#define SK_init FDEV_LINUX_SK_init
#define SK_print_dev FDEV_LINUX_SK_print_dev
#define SK_print_pos FDEV_LINUX_SK_print_pos
#define SK_print_ram FDEV_LINUX_SK_print_ram
#define SK_read_reg FDEV_LINUX_SK_read_reg
#define SK_reset_board FDEV_LINUX_SK_reset_board
#define SK_rom_addr FDEV_LINUX_SK_rom_addr
#define SK_rread_reg FDEV_LINUX_SK_rread_reg
#define SK_set_RAP FDEV_LINUX_SK_set_RAP
#define SK_write_reg FDEV_LINUX_SK_write_reg
#define ultra_probe FDEV_LINUX_ultra_probe
#define ultra_probe1 FDEV_LINUX_ultra_probe1
#define smc_init FDEV_LINUX_smc_init
#define bh_active FDEV_LINUX_bh_active
#define bh_base FDEV_LINUX_bh_base
#define bh_mask FDEV_LINUX_bh_mask
#define bh_mask_count FDEV_LINUX_bh_mask_count
#define do_bottom_half FDEV_LINUX_do_bottom_half
#define local_bh_count FDEV_LINUX_local_bh_count
#define proc_scsi_t128 FDEV_LINUX_proc_scsi_t128
#define t128_abort FDEV_LINUX_t128_abort
#define t128_biosparam FDEV_LINUX_t128_biosparam
#define t128_detect FDEV_LINUX_t128_detect
#define t128_proc_info FDEV_LINUX_t128_proc_info
#define t128_queue_command FDEV_LINUX_t128_queue_command
#define t128_reset FDEV_LINUX_t128_reset
#define t128_setup FDEV_LINUX_t128_setup
#define add_timer FDEV_LINUX_add_timer
#define del_timer FDEV_LINUX_del_timer
#define linux_timer_intr FDEV_LINUX_linux_timer_intr
#define mod_timer FDEV_LINUX_mod_timer
#define timer_active FDEV_LINUX_timer_active
#define timer_bh FDEV_LINUX_timer_bh
#define timer_table FDEV_LINUX_timer_table
#define tulip_probe FDEV_LINUX_tulip_probe
#define proc_scsi_u14_34f FDEV_LINUX_proc_scsi_u14_34f
#define u14_34f_abort FDEV_LINUX_u14_34f_abort
#define u14_34f_biosparam FDEV_LINUX_u14_34f_biosparam
#define u14_34f_detect FDEV_LINUX_u14_34f_detect
#define u14_34f_old_abort FDEV_LINUX_u14_34f_old_abort
#define u14_34f_old_reset FDEV_LINUX_u14_34f_old_reset
#define u14_34f_queuecommand FDEV_LINUX_u14_34f_queuecommand
#define u14_34f_release FDEV_LINUX_u14_34f_release
#define u14_34f_reset FDEV_LINUX_u14_34f_reset
#define u14_34f_setup FDEV_LINUX_u14_34f_setup
#define proc_scsi_ultrastor FDEV_LINUX_proc_scsi_ultrastor
#define ultrastor_abort FDEV_LINUX_ultrastor_abort
#define ultrastor_biosparam FDEV_LINUX_ultrastor_biosparam
#define ultrastor_bus_reset FDEV_LINUX_ultrastor_bus_reset
#define ultrastor_detect FDEV_LINUX_ultrastor_detect
#define ultrastor_info FDEV_LINUX_ultrastor_info
#define ultrastor_queuecommand FDEV_LINUX_ultrastor_queuecommand
#define ultrastor_reset FDEV_LINUX_ultrastor_reset
#define wd_probe FDEV_LINUX_wd_probe
#define wd_probe1 FDEV_LINUX_wd_probe1
#define do_wd7000_intr_handle FDEV_LINUX_do_wd7000_intr_handle
#define make_code FDEV_LINUX_make_code
#define proc_scsi_wd7000 FDEV_LINUX_proc_scsi_wd7000
#define wd7000_abort FDEV_LINUX_wd7000_abort
#define wd7000_biosparam FDEV_LINUX_wd7000_biosparam
#define wd7000_command FDEV_LINUX_wd7000_command
#define wd7000_detect FDEV_LINUX_wd7000_detect
#define wd7000_diagnostics FDEV_LINUX_wd7000_diagnostics
#define wd7000_init FDEV_LINUX_wd7000_init
#define wd7000_intr_handle FDEV_LINUX_wd7000_intr_handle
#define wd7000_proc_info FDEV_LINUX_wd7000_proc_info
#define wd7000_queuecommand FDEV_LINUX_wd7000_queuecommand
#define wd7000_reset FDEV_LINUX_wd7000_reset
#define wd7000_revision FDEV_LINUX_wd7000_revision
#define wd7000_set_info FDEV_LINUX_wd7000_set_info
#define wd7000_setup FDEV_LINUX_wd7000_setup
#define show_dma FDEV_LINUX_show_dma
#define znet_probe FDEV_LINUX_znet_probe
#define floppy_init FDEV_LINUX_floppy_init
#define floppy_eject FDEV_LINUX_floppy_eject
#define floppy_interrupt FDEV_LINUX_floppy_interrupt
#define floppy_setup FDEV_LINUX_floppy_setup
#define fd_routine FDEV_LINUX_fd_routine
#define linux_softintr_init FDEV_LINUX_linux_softintr_init
#define softintr_vector FDEV_LINUX_softintr_vector
#define rand_initialize FDEV_LINUX_rand_initialize

#define signal_pending(current)	0

#endif /* _LINUX_DEV_GLOBAL_H_ */
